/*---------------------------------------------------------------------------*/
/* EWDLL.CPP - Borland C++ 4.0 - 256 Color BMP DLL for WinHelp 3.1           */
/* Copyright (C) 1994 by R&R Engineering - All Rights Reserved               */
/*                                                                           */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*                                                                           */
/*  This library is free software; you can redistribute it and/or modify it  */
/*  under the terms of the GNU Library General Public License as published   */
/*  by the Free Software Foundation; either version 2 of the License, or     */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This library is distributed in the hope that it will be useful, but      */
/*  WITHOUT ANY WARRANTY; without even the implied warranty of               */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        */
/*  Library General Public License for more details.                         */
/*                                                                           */
/*  You should have received a copy of the GNU Library General Public        */
/*  License along with this library; if not, write to the Free Software      */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                */
/*                                                                           */
/*---------------------------------------------------------------------------*/

#define STRICT

#include <stdlib.h>
#include <windowsx.h>
#include "ewdll.h"

/* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */

// Define the default window procedure
#define EWBMP_DefProc DefWindowProc

// Window class name
static char ClassName[] = "ewBitmap";

// Define a structure for storing bitmap information for a window
typedef struct {
   HBITMAP hbmp;
   HPALETTE hpal;
   int width, height;
} EWBMPINFO;

/* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */

LONG _lsize( HFILE hFile ) {

   /*---------------------------------------------------------------------*/
   /*  Return the length (in bytes) of an open file.                      */
   /*---------------------------------------------------------------------*/

   LONG p = _llseek( hFile, 0, 1 );  // Save position in the file
   LONG s = _llseek( hFile, 0, 2 );  // Get the length
   _llseek( hFile, p, 0 );           // Restore original position
   return s;                         // Return length
}

/* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */

HBITMAP LoadDIBitmap( char *filespec, HPALETTE *palette ) {

   /*---------------------------------------------------------------------*/
   /*  Load a Windows 3.x device independent BMP file.  The return value  */
   /*  is a handle to the logical bitmap if successful, or zero if an     */
   /*  error occurred.  For all besides 24-bit bitmaps, the palette       */
   /*  parameter is a handle to the palette required to properly display  */
   /*  the bitmap.  For 24-bit bitmaps palette is set to zero.            */
   /*---------------------------------------------------------------------*/

   BITMAPFILEHEADER bmfh;
   BITMAPINFO *bmi;
   BITMAPINFOHEADER *bmih;
   LOGPALETTE *lp;
   unsigned colors;
   HBITMAP ldib;

   // Open the bitmap file for read-only access
   HFILE hFile = _lopen( filespec, READ );
   if (hFile == HFILE_ERROR) return 0;

   // Read the file header
   if (_lread( hFile, &bmfh, sizeof( bmfh ) ) != sizeof( bmfh )) {
      _lclose( hFile );
      return 0;
   }

   // Check for the Windows 3 bitmap file signature
   if (bmfh.bfType != 0x4D42) {
      _lclose( hFile );
      return 0;
   }

   // Allocate a buffer to contain the bitmap data
   LONG bufsize = _lsize( hFile ) - sizeof( bmfh );
   HGLOBAL buffer = GlobalAlloc( GMEM_MOVEABLE, bufsize );
   if (buffer == 0) {
      _lclose( hFile );
      return 0;
   }

   // Lock the buffer and read the bitmap data
   bmi = (BITMAPINFO*)GlobalLock( buffer );
   if (_hread( hFile, bmi, bufsize ) == bufsize) {

      // Check validity of BITMAPINFOHEADER structure
      bmih = &bmi->bmiHeader;
      if (bmih->biSize == sizeof( BITMAPINFOHEADER )) {

         // If this is not a 24-bit bitmap then create a palette
         if (bmih->biPlanes * bmih->biBitCount != 24) {

            // Determine the number of colors used
            if (bmih->biClrUsed != 0)
               colors = (unsigned)bmih->biClrUsed;
            else
               colors = 1 << (bmih->biPlanes * bmih->biBitCount);

            // Allocate memory for a logical palette
            lp = (LOGPALETTE*)malloc( sizeof( LOGPALETTE ) +
               colors * sizeof( PALETTEENTRY ) );

            // Fill in the logical palette
            lp->palVersion = 0x0300;
            lp->palNumEntries = colors;

            // Copy the colors from the bitmap to the palette
            for (int i = 0; i < colors; i++) {
               lp->palPalEntry[ i ].peRed   = bmi->bmiColors[ i ].rgbRed;
               lp->palPalEntry[ i ].peGreen = bmi->bmiColors[ i ].rgbGreen;
               lp->palPalEntry[ i ].peBlue  = bmi->bmiColors[ i ].rgbBlue;
               lp->palPalEntry[ i ].peFlags = 0;
            }

            // Create the palette and free the logical palette
            *palette = CreatePalette( lp );
            free( lp );
         }

         else

            // Set the palette handle to zero for 24-bit bitmaps
            *palette = 0;

         // Create the bitmap
         HDC DC = GetDC( 0 );
         *palette = SelectPalette( DC, *palette, FALSE );
         RealizePalette( DC );
         ldib = CreateDIBitmap( DC, bmih, CBM_INIT,
            ((LPSTR)(bmih + 1)) + (colors * sizeof( RGBQUAD )),
            bmi, DIB_RGB_COLORS );
         *palette = SelectPalette( DC, *palette, FALSE );
         RealizePalette( DC );
         ReleaseDC( 0, DC );
      }
   }

   // Close the file, release the global memory block, and return
   _lclose( hFile );
   GlobalUnlock( buffer );
   GlobalFree( buffer );
   return ldib;
}

/* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */

HPALETTE EWBMP_OnAskPalette( HWND hWnd ) {

   EWBMPINFO *hbi;

   // Get the palette from the bitmap info stored with the window
   hbi = (EWBMPINFO*)GetWindowLong( hWnd, 0 );
   return hbi->hpal;
}

/* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */

BOOL EWBMP_OnQuerySize( HWND hWnd, HDC DC, POINT *size ) {

   EWBMPINFO *hbi;

   // Get the size from the bitmap info stored with the window
   hbi = (EWBMPINFO*)GetWindowLong( hWnd, 0 );
   size->x = hbi->width;
   size->y = hbi->height;
   return TRUE;
}

/* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */

BOOL EWBMP_OnCreate( HWND hWnd, CREATESTRUCT *lpCreateStruct ) {

   CREATEINFO *ci;
   EWBMPINFO *hbi;
   BITMAP bmp;

   // Add a border to the window
   SetWindowLong( hWnd, GWL_STYLE, GetWindowLong( hWnd, GWL_STYLE ) | WS_BORDER );

   // Allocate structure for window bitmap information and save
   hbi = (EWBMPINFO*)malloc( sizeof( EWBMPINFO ) );
   SetWindowLong( hWnd, 0, (LONG)hbi );

   // Read the bitmap file
   ci = (CREATEINFO*)lpCreateStruct->lpCreateParams;
   hbi->hbmp = LoadDIBitmap( ci->lpstrAuthorData, &hbi->hpal );

   // If a bitmap was read then determine its size
   if (hbi->hbmp != 0) {
      GetObject( hbi->hbmp, sizeof( BITMAP ), &bmp );
      hbi->width = bmp.bmWidth;
      hbi->height = bmp.bmHeight;
   }
   else {
      hbi->width = 0;
      hbi->height = 0;
   }
   return TRUE;
}

/* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */

void EWBMP_OnDestroy( HWND hWnd ) {

   EWBMPINFO *hbi;

   // Retrieve the structure allocated for storing bitmap information
   hbi = (EWBMPINFO*)GetWindowLong( hWnd, 0 );

   // Delete the bitmap and palette objects
   DeleteObject( hbi->hbmp );
   DeleteObject( hbi->hpal );

   // Free the structure used to store bitmap info with the window
   free( hbi );
}

/* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */

BOOL EWBMP_OnPaint( HWND hWnd ) {

   PAINTSTRUCT ps;
   EWBMPINFO *hbi;
   HDC memDC;

   // Get the bitmap information structure
   hbi = (EWBMPINFO*)GetWindowLong( hWnd, 0 );

   // Paint the bitmap
   BeginPaint( hWnd, &ps );
   memDC = CreateCompatibleDC( ps.hdc );
   SelectObject( memDC, hbi->hbmp );
   BitBlt( ps.hdc, 0, 0, hbi->width, hbi->height, memDC, 0, 0, SRCCOPY );
   DeleteDC( memDC );
   EndPaint( hWnd, &ps );

   return 0;
}

/* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */

LRESULT CALLBACK _export WndProc( HWND hWnd, UINT Message, WPARAM wParam,
                                  LPARAM lParam ) {

   switch( Message ) {
      HANDLE_MSG( hWnd, EWM_ASKPALETTE, EWBMP_OnAskPalette );
      HANDLE_MSG( hWnd, EWM_QUERYSIZE, EWBMP_OnQuerySize );
      HANDLE_MSG( hWnd, WM_CREATE, EWBMP_OnCreate );
      HANDLE_MSG( hWnd, WM_DESTROY, EWBMP_OnDestroy );
      HANDLE_MSG( hWnd, WM_PAINT, EWBMP_OnPaint );
      default : return EWBMP_DefProc( hWnd, Message, wParam, lParam );
   }
}

/* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */

BOOL Register( HINSTANCE hInst ) {

   WNDCLASS WindowClass;

   WindowClass.style         = CS_GLOBALCLASS;
   WindowClass.lpfnWndProc   = WndProc;
   WindowClass.cbClsExtra    = 0;
   WindowClass.cbWndExtra    = 4;
   WindowClass.hInstance     = hInst;
   WindowClass.hIcon         = NULL;
   WindowClass.hCursor       = LoadCursor( NULL, IDC_ARROW );
   WindowClass.hbrBackground = GetStockBrush( WHITE_BRUSH );
   WindowClass.lpszMenuName  = NULL;
   WindowClass.lpszClassName = ClassName;

   return RegisterClass( &WindowClass );
}

/* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */

int CALLBACK LibMain( HINSTANCE hInst, WORD wDataSeg, WORD wHeapSize,
                              LPSTR lpszCmdLine ) {

   // Register the window class
   if (!Register( hInst )) return 0;

   // Unlock the data segment
   if (wHeapSize > 0) UnlockData( 0 );

   return TRUE;
}

/* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */

int CALLBACK WEP( UINT nParam ) {

   return TRUE;
}
