#if !defined(__stprfrnc_h)              // Sentry, use file only if it's not already included.
#define __stprfrnc_h

/*  Project filesrch

	 Copyright  1993. All Rights Reserved.

	 SUBSYSTEM:    filesrch.exe Application
	 FILE:         stprfrnc.h
	 AUTHOR:       Earl Bennett


	 OVERVIEW
	 ========
	 Class definition for SetPreferences (TFileOpenDialog).
*/

#include <owl\owlpch.h>
#include <owl\radiobut.h>
#pragma hdrstop

#include <owl\opensave.h>

#include "flsrchap.rh"            // Definition of all resources.
#include "setfilnm.h"
#include "ticnlstb.h"

//	Define the transfer buffer structure

struct SetPrefTransferBuf {
	UINT		Case;
	UINT		RegExp;
	char		*szIconSourceFile;
	int		iSelectedIcon;
};

//{{TFileOpenDialog = SetPreferences}}
class SetPreferences : public TFileOpenDialog {
private:
	TIconListBox  *PTListBox_Icon;

	int cIconsInFile;

	HDC hMemDC;
	HBITMAP hOldBMP, hMyBMP;
	DWORD HIGHLIGHTCOLOR, WINDOWCOLOR;
	HBRUSH hWindowBrush, hHighlightBrush;

	int  IconsInFile(LPSTR szTestFile);
	int  FillIconList();
	void ClearIconList();
	int  ResetIconList(LPSTR szNewFileName);

public:
	 SetPreferences (TWindow* parent, TData& data, SetPrefTransferBuf *tb = 0,
			TResId templateId = 0, const char far* title = 0, TModule* module = 0);
	 virtual ~SetPreferences ();

//{{SetPreferencesVIRTUAL_BEGIN}}
public:
    virtual LRESULT EvCommand (UINT id, HWND hWndCtl, UINT notifyCode);
    virtual void SetupWindow ();
//{{SetPreferencesVIRTUAL_END}}

//{{SetPreferencesRSP_TBL_BEGIN}}
protected:
    void EvMeasureItem (UINT ctrlId, MEASUREITEMSTRUCT far& measureInfo);
    void EvDrawItem (UINT ctrlId, DRAWITEMSTRUCT far& drawInfo);
    HBRUSH EvCtlColor (HDC hDC, HWND hWndChild, UINT ctlType);
//{{SetPreferencesRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(SetPreferences);
};    //{{SetPreferences}}


#endif                                      // __stprfrnc_h sentry.

