/*
Filename auswahl.c

Interaktive Auswahl eines der BGI-Treiber fr die Testprogramme

(C) Raimund Nisius
    Goethepark  13
    1000 Berlin 12

*/

#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>
#include "inventar.h"
#include "BGIALLOC.H"
#define AUSWAHLFILE     /* fr "auswahl.h"*/
#include "auswahl.h"


void Nadeldrucker_waehlen(void);


char getonly(char *erlaubte_zeichen )
{
char c;
do {} while (strchr(erlaubte_zeichen,(c = getch()) ) == NULL);
return(c);
}

#ifdef NADELDRUCKER
char *Nadelnamen[] =
{
" A  Epson 240 * 72",
" B  Epson 120 * 72 schnell",
" C  Epson 120 * 72 schn",
" D  Epson 60  * 72",
" E  Epson 240 * 216",
" F  Epson 80  * 72",
" G  Epson 72  * 72",
" H  Epson 90  * 72",
" I  Epson 144 * 72",
" J  Epson 60  * 180",
" K  Epson 120 * 180",
" L  Epson 90  * 180",
" M  Epson 180 * 180",
" N  Epson 360 * 180",
" O  NEC   360 * 360",
" P  Epson 360 * 360"
};

void Nadeldrucker_waehlen(void)
{
int     i;
char    choice,
        *erlaubtstring = "ABCDEFGHIJKLMNOPabcdefghijklmnop";

clrscr();
for (i = 0; i < sizeof(Nadelnamen) / sizeof (char *); i++ )
   printf("%s\r\n",Nadelnamen[i]);
printf(" A .. I sind Modi fr 9-Nadler\r\n");
printf(" F .. I sind nicht auf jedem Drucker verfgbar\r\n");
printf(" J .. P sind Modi fr 24-Nadler\r\n\r\n");
printf("Bitte whlen Sie einen Druckermodus aus.\r\n");
choice = getonly(erlaubtstring);
choice = toupper(choice);
Treiber_konfiguration.nadeldrucker->printermode = choice - 'A';
printf("\r\nFarbdrucker (J/N)?\r\n");
choice = getonly("jJnN");
choice = toupper(choice);
if (choice == 'J')
	{
	Treiber_konfiguration.nadeldrucker->stiftzahl = 16;
	Treiber_konfiguration.nadeldrucker->printermode += 128;
	}
}
#endif


void waehle_treiber(void)       /* Ausgabegert bestimmen */
{
char erlaubtstring[10];
char choice, *st_ende;

st_ende = stpcpy(erlaubtstring,"1");        /* Monitor immer*/

#ifdef HPGLPLOTTER
st_ende = stpcpy(st_ende,"2");
#endif

#ifdef LASERDRUCKER
st_ende = stpcpy(st_ende,"3");
#endif

#ifdef NADELDRUCKER
st_ende = stpcpy(st_ende,"4");
#endif

#ifdef DESKJETDRUCKER
st_ende = stpcpy(st_ende,"5");
#endif

#ifdef PAINTJETDRUCKER
st_ende = stpcpy(st_ende,"6");
#endif

#ifdef DXFPLOTTER
st_ende = stpcpy(st_ende,"7");
#endif



clrscr();
printf("             Auswahl der Graphikausgabe     \r\n\r\n");

printf("Copyright an den Treibern fr Plotter und Drucker bei\r\n");
printf("      Raimund Nisius\r\n");
printf("      SoftwareEntwicklung\r\n");
printf("      Goethepark 13\r\n");
printf("      10627 Berlin\r\n");
printf("      Tel./FAX  312 50 74 \r\n\r\n\r\n");


printf("Wo soll die folgende Graphik erzeugt werden ?\r\n\r\n");

printf("   1  Monitor  mit dem Default-Monitortreiber\r\n");
#ifdef HPGLPLOTTER
   printf("   2  HPGL-Plotter  ber die schon gewhlte Schnittstelle\r\n");
#endif
#ifdef LASERDRUCKER
   printf("   3  LASER-Drucker ber die schon gewhlte Schnittstelle\r\n");
#endif
#ifdef NADELDRUCKER
   printf("   4  NADEL-Drucker ber die schon gewhlte Schnittstelle\r\n");
#endif
#ifdef DESKJETDRUCKER
   printf("   5  DeskJet 500 C ber die schon gewhlte Schnittstelle\r\n");
#endif
#ifdef PAINTJETDRUCKER
   printf("   6  Paintjet XL   ber die schon gewhlte Schnittstelle\r\n");
#endif
#ifdef DXFPLOTTER
   printf("   7  DXF-File\r\n");
#endif
printf("\r\n");
printf("Whlen Sie bitte durch Drcken der entsprechenden Taste !\r\n");
choice = getonly(erlaubtstring);
switch(choice) {
   case '1' :   treibertyp  = monitortreiber;
				treibermode = monitormode;
				break;
#ifdef HPGLPLOTTER
   case '2' :
		 treibertyp  = plottertreiber;
		 treibermode = plottermode;
		 break;
#endif
#ifdef LASERDRUCKER
   case '3' :
		 treibertyp  = lasertreiber;
		 treibermode = lasermode;
		 break;
#endif
#ifdef NADELDRUCKER
   case '4' :
		 treibertyp  = nadeltreiber;
		 treibermode = nadelmode;
		 Nadeldrucker_waehlen();
		 break;
#endif
#ifdef DESKJETDRUCKER
   case '5' :
		 treibertyp  = deskjettreiber;
		 treibermode = deskjetmode;
		 break;
#endif
#ifdef PAINTJETDRUCKER
   case '6' :
		 treibertyp  = paintjettreiber;
		 treibermode = paintjetmode;
		 break;
#endif
#ifdef DXFPLOTTER
   case '7' :
		 treibertyp  = dxftreiber;
		 treibermode = dxfmode;
		 break;
#endif
   } /* switch */
} /* waehle_treiber */

