/* File BGIDEMO.C */
/*

(C)opyright
Raimund Nisius
SoftwareEntwicklung
Goethepark  13
1000 Berlin 12

Dieses Programm dient zur Demonstration der Graphiktreiber *.BGI
und diente mir bei der Entwicklung zum Testen der Treiber -> die
Zeichnungen sind nicht schn, aber vielfltig.

Alles, was mit Turbo-C und den BGI-Treibern machbar ist, wird
vorgefhrt. ber die Graphikbefehle an sich erfahren Sie nichts neues.
    (
    Ausnahme "sector" u.. Prozeduren machen einen Fehler,
    den meine Treiber auskorrigieren :
           sector(x,y,startwinkel, stop       ,rx,ry);
		   sector(x,y, stop      , startwinkel,rx,ry);
    erzeugen auf dem Monitor meistens(!) die gleiche Figur.
    Vergleichen Sie hierzu die druckerausgabe.
    )
Zum Projekt gehren die Dateien
"bgialloc.c","bgialloc.h","auswahl.c","auswahl.h","inventar.h" und
"goth.chr". Und natrlich die BGI-Treiber, die in inventar.h angegeben sind.
*/


#include <graphics.h>
#include <stdlib.h>
#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>
#include <math.h>
#include "inventar.h"   /* welche Treiber werden benutzt ? */
#include "bgialloc.h"   /* Reservierung von Speicherplatz fr */
                        /* Bildaufbereitung */
#include "auswahl.h"    /* Auswahl des Ausgabemediums */

int error;
char    bgipfad[80];

#define MaxPoints   18
#define boolean     int
#define true        -1
#define false       0
typedef
        struct {int x1, y1, x2, y2;} windowtype;



struct pointtype    polygon[5+MaxPoints];
unsigned int    polysize,
                MaxX,
                MaxY,     /* The maximum resolution of the screen */
                testfill,
                width,
                xoffs,
                yoffs,
                texth;
int             ErrorCode;  /* Reports any graphics errors */
boolean         InGraphicsMode; /* Flags initialization of graphics mode */
windowtype      fenster;
char            modename[256];
void     far    *BitMap;



void waitkey(void)
{
char c;
c = getch();
if (c == '\0' )
   c = getch();
}


void setwhitepaper(void)
{
if (getmaxcolor() > 1)
	setbkcolor(15);		// EGAWHITE fuer colordrucker
else
	setbkcolor(0);		// Transparent fuer monodrucker

}

void kreise(void)
{
struct pointtype    m;
unsigned int i     ,
			 j     ,
			 start ,
			 stop  ,
			 max_r ,
			 r     ,
			 xasp  ,
			 yasp;



m.x   = getmaxx()/4;
m.y   = 3*(getmaxy()/4);
max_r = getmaxy()/4;
start = 270;
stop  = 180;

getaspectratio((int far *)&xasp,(int far *)&yasp);
setaspectratio(xasp / 2,yasp);
for (i = 0; i <= 18; i++)
    {
    start = i * 30;
    r     = (max_r/40 ) + (((3*i) * max_r)/42);
    setlinestyle(CENTER_LINE,2, THICK_WIDTH );
    arc(m.x,m.y,start,stop,r);
    };
setlinestyle(CENTER_LINE,2, NORM_WIDTH);
m.x = getmaxx() - m.x;
m.y   = 4*(getmaxy()/5);
for (i = 0; i <= 18; i++)
    {
    start = i * 30;
    r     = (max_r/40 ) + (unsigned int)(((1.7*(float)i) * (float)max_r)/42.0);
    arc(m.x,m.y,start,stop,r);
	};
setaspectratio(xasp,yasp);
circle(getmaxx()/2,m.y, getmaxy()/15);
ellipse(getmaxx()/2,4*(getmaxy()/10),0,270,getmaxx()/4, getmaxy()/14);
m.y = (getmaxy()/5);
setfillstyle(LTBKSLASH_FILL,1);
for (j = 0; j <= 10; j++)
	{
	m.x = (1+j)*(getmaxx()/12);
	start = j * 36;
	stop  = (j+1) * 36;
	sector(  m.x,  m.y,start, stop ,getmaxx()/26,getmaxx()/26);
	sector(  m.x,3*m.y, stop, start,getmaxx()/26,getmaxx()/26);
	};

setfillstyle(XHATCH_FILL,1);
setlinestyle(CENTER_LINE,2, NORM_WIDTH);
m.x   = getmaxx()/7;
m.y   = 5*(getmaxy()/11);
max_r = min(getmaxx(),getmaxy())/8;
sector(  m.x,  m.y, 30, 60, max_r, max_r);

setlinestyle(CENTER_LINE,2, NORM_WIDTH);
setfillstyle(LINE_FILL,1);
m.x   = 6*(getmaxx()/7);
fillellipse ( m.x,m.y,max_r,max_r/2);
}; /*kreise*/


void Initialize(void)
{
getcwd(bgipfad ,sizeof(bgipfad));   /* Aktueller Pfad soll BGI-Dateien enthalten */
InGraphicsMode = false;
}; /* Initialize */


char numberstring[256];

char *Int2Str(long L)
/* Converts an integer to a string for use with OutText, OutTextXY */
{
char * erg;
erg = ltoa(L,numberstring,10);
return(erg);
}; /* Int2Str */


void stern_punkte(void)
{
int i;

 i = 0;
 while (i < MaxPoints)
   {
   polygon[i].x = xoffs+2+(xoffs*cos((i*2.0*M_PI) / MaxPoints));
   polygon[i].y = yoffs+2+(yoffs*sin((i*2.0*M_PI) / MaxPoints));
   i++;
   polygon[i].x = xoffs+2+(xoffs/4.0*cos((i*2.0*M_PI) / MaxPoints));
   polygon[i].y = yoffs+2+(yoffs/4.0*sin((i*2.0*M_PI) / MaxPoints));
   i++;
   polygon[MaxPoints] = polygon[0];
   polysize = MaxPoints+1;
   };
};

void verschiebe(unsigned x)

{
int i;
unsigned int dx, dy;

dy = (2 * yoffs) * (x/4);
dx = (5 * xoffs * (x % 4))/3;
for (i = 0; i <= MaxPoints; i++)
   {
   polygon[i].x += dx;
   polygon[i].y += dy;
   };
};

void test1(void)  /* bei erffnetem Graphikmode */
{
hpgl_struct             far *hpgl_parameter;
struct REGPACK          reg;
struct viewporttype     vp;
struct linesettingstype li;
struct fillsettingstype FillInfo;
char                    FillPattern;
struct palettetype       pal;
struct palettetype far   *palptr;
char                     outstring[256];

  MaxX = getmaxx();
  MaxY = getmaxy();
  xoffs = getmaxx()/10;   /*ok*/
  yoffs = getmaxy()/7;    /*ok*/

settextjustify(LEFT_TEXT ,CENTER_TEXT);      /*ok*/
sprintf(outstring, "Treiber fr %s   %d Farben im drucker.",
                    getdrivername(),getmaxcolor());
outtextxy(MaxX/20,MaxY-MaxY/100,outstring);
sprintf(outstring, "Hchster Mode %d = %s",
                    getmaxmode(),getmodename(getgraphmode())); /*ok*/
outtextxy(MaxX/20,MaxY-MaxY/25,outstring);
moveto(10,100);
width = getx();      /*ok*/
width = gety();      /*ok*/
cleardevice();         /*ok*/
putpixel(100,100,1); /*ok*/
line   (0,       0, MaxX/2, MaxY/2);
moveto (MaxX, MaxY );
lineto (MaxX/2, 0);
moverel(0, MaxY/4);
linerel(MaxX/3, MaxY/3);
graphdefaults();

width = getpixel(100,100);
texth = imagesize(0,0,100,100);
BitMap = malloc (texth);
getimage( 0,0,100,100,BitMap);      /*Normaler Gebrauch von PutImage,GetImage*/
putimage(100,100,BitMap, NOT_PUT);   /*wird vom druckertreiber ignoriert.*/
free((void *)BitMap);
setwritemode(4);
getlinesettings(&li);
getfillsettings(&FillInfo );      /*ok*/
getfillpattern(&FillPattern );    /*!ok*/
setfillpattern(&FillPattern ,1);  /*!ok*/
floodfill(0,0,1);                /*!ok*/
setbkcolor(1);                   /*!ok*/
setcolor(3);                     /*ok*/
texth = getbkcolor();             /*!ok*/
texth = getcolor();               /*ok*/
setrgbpalette(3, 200, 200, 200); /*!ok*/
setpalette(3, 12);               /*ok*/
getpalette(&pal);                 /*ok*/
setallpalette(&pal);              /*ok*/
texth = getpalettesize();         /*ok*/
palptr = getdefaultpalette();          /*ok*/
setallpalette(palptr);              /*ok*/

setwhitepaper();

  for (testfill = SOLID_LINE; testfill <=  DASHED_LINE; testfill++ )
    {
    setlinestyle(testfill,0,NORM_WIDTH);
    line(0, (MaxY/20)*(2*testfill), MaxX/2, (MaxY/20)*(1+2*testfill));
    setlinestyle(testfill,0,THICK_WIDTH);
    line(0, (MaxY/20)*(1+2*testfill), MaxX/2, (MaxY/20)*(2+2*testfill));
    };
  testfill = USERBIT_LINE;
  setlinestyle(testfill,0XFCCF,NORM_WIDTH);
  line(0, (MaxY/20)*(2*testfill), MaxX/2, (MaxY/20)*(1+2*testfill));
  setlinestyle(testfill,0xFCCF,THICK_WIDTH);
  line(0, (MaxY/20)*(1+2*testfill), MaxX/2, (MaxY/20)*(2+2*testfill));

  testfill = 4;
  setlinestyle(testfill,0xFCCF,NORM_WIDTH);
  setfillstyle(LTSLASH_FILL,2);

  rectangle(MaxX - MaxX/8,MaxY/3,MaxX - MaxX/10,MaxY/2);
  bar3d( MaxX - MaxX/10,MaxY/20,
         MaxX - MaxX/20,MaxY/8,
         MaxX/50,1);

  setfillstyle(testfill,1);
  bar3d(MaxX - MaxX/10,MaxY/8,
        MaxX - MaxX/20,MaxY/4,
        MaxX/50,0);


  polygon[1].x = MaxX -MaxX/4;
  polygon[1].y = MaxY -MaxY/6;

  polygon[2].x = MaxX -MaxX/8;
  polygon[2].y = MaxY -MaxY/6;

  polygon[3].x = MaxX -MaxX/8;
  polygon[3].y = MaxY -MaxY/9;

  polygon[4].x = MaxX -MaxX/8;
  polygon[4].y = MaxY -MaxY/6;

  polygon[5].x = MaxX -MaxX/16;
  polygon[5].y = MaxY -MaxY/6;

  polygon[6].x = MaxX -MaxX/16;
  polygon[6].y = MaxY -MaxY/4;

  polygon[7].x = MaxX - MaxX/4;
  polygon[7].y = MaxY -MaxY/4;

  setlinestyle(2,0,THICK_WIDTH);
  setfillstyle(0,1);
  fillpoly(3,(int far *) &polygon[1]);


  setlinestyle(2,0,NORM_WIDTH);
  polygon[1].x -= MaxX/4;
  polygon[2].x -= MaxX/4;
  polygon[3].x -= MaxX/4;
  polygon[1].y += MaxY/20;
  polygon[2].y += MaxY/20;
  polygon[3].y += MaxY/20;
  fillpoly(3, (int far *)&polygon[1]);

  fenster.x1 = MaxX - MaxX/10;
  fenster.y1 = MaxY/2;
  fenster.x2 = MaxX - MaxX/20;
  fenster.y2 = MaxY - MaxY/3;
  setlinestyle(2,0,THICK_WIDTH);
  setfillstyle(4,1);
  bar (fenster.x1,
       fenster.y1,
       fenster.x2,
       fenster.y2);
  setviewport(fenster.x1,
              fenster.y1,
              fenster.x2,
              fenster.y2,
              true);

  line(0,0,fenster.x2-fenster.x1,fenster.y2-fenster.y1);
  getviewsettings(&vp);

  setviewport(0,0,getmaxx(),getmaxy(),true);

#ifdef HPGLPLOTTER
hpgl_parameter = Treiber_konfiguration.plotter;

if (hpgl_parameter->filehandle) /* Plotterfile ist geoeffnet */
    {
    strcpy(outstring, "PU1000,1000;LBDirekter Befehl\03");
    reg.r_cx = (int)strlen(outstring);         /* Stringlnge */
    reg.r_dx = FP_OFF(outstring);           /* Stringadresse Offset  */
    reg.r_ds = FP_SEG(outstring);
    reg.r_bx = (int)hpgl_parameter->filehandle;  /* handle */
    reg.r_ax = 0x4000;             /* DOS Funktion write to file or device */
    intr(0x21, &reg);
    if (reg.r_flags & 1)     /* carry Flag gesetzt -> Fehler */
        {
        printf("Direkter Befehl an Plotter hat nicht geklappt!\r\n");
        exit(0);
        }
    }
#endif



  outtextxy(MaxX/2,MaxY-MaxY/40,"Programmende mit Tastendruck.");
  texth = graphresult();
  settextstyle(4, VERT_DIR, 4);
  texth = graphresult();
  if (texth)
     printf("%s\r\n",grapherrormsg(texth));
  texth = textheight("How nice !");
  setusercharsize(MaxX/20,texth,MaxX/15,texth);
  texth = textheight("How nice !");
  settextjustify(2,0);
  outtextxy(MaxX,MaxY,"How nice !");


  settextjustify(0,2);
  settextstyle(0, VERT_DIR,4);
  texth = textheight("How nice !");
  setusercharsize(MaxX/20,texth,MaxX/15,texth);
  outtextxy((MaxX*0.9),(MaxY*0.1),Int2Str(MaxX));

  settextjustify(0,0);
  settextstyle(0, HORIZ_DIR, 4);
  texth = textheight("How nice !");
/*
  GetTextSettings(TextInfo );
*/
  setusercharsize(MaxX/20,texth,MaxX/15,texth);
  outtextxy(0,MaxY,Int2Str(MaxY));
};/* test1 */

void testzeichnung(void)  /* bei erffnetem Graphikmode */
{
    for (testfill = EMPTY_FILL;testfill <= CLOSE_DOT_FILL; testfill++)
      {
      width = testfill/5;
      if (width < 1)
         width = 1;
      else
         width = 3;
      setlinestyle(testfill % 5,0xFFCC,width);
      stern_punkte();
      verschiebe(testfill);
      setfillstyle(testfill , 1 + (testfill % getmaxcolor()));
      fillpoly(polysize, (int far *)polygon);
      };

setfillstyle(LTSLASH_FILL, 1 + (testfill % getmaxcolor()));
sector(MaxX - MaxX/8,2*(MaxY/3),345,15,MaxX/8,MaxY/10);
sector(MaxX - MaxX/8,MaxY/3,15,345,MaxX/8,MaxY/10);
};


unsigned _stklen = 20000;

void main(void)
{
char extension[4];
char far *ext_pos;

Initialize();
do
  {
  waehle_treiber();

    #ifdef HPGLPLOTTER
      if (treibertyp == plottertreiber)
         {
         Treiber_konfiguration.plotter->rotate = 0;  /* Querformat */
         strcpy(extension,"PLT");
         }
    #endif
    #ifdef LASERDRUCKER
      if (treibertyp == lasertreiber)
         {
         Treiber_konfiguration.laserjet->rotate = 1;  /* Querformat */
         strcpy(extension,"LAS");
         }
    #endif
    #ifdef NADELDRUCKER
      if (treibertyp == nadeltreiber)
         {
         Treiber_konfiguration.nadeldrucker->rotate = 1;  /* Querformat */
         strcpy(extension,"PRN");
         }
    #endif
    #ifdef DESKJETDRUCKER
      if (treibertyp == deskjettreiber)
         {
         Treiber_konfiguration.deskjet_c->rotate = 1;  /* Querformat */
         strcpy(extension,"djc");
         }
    #endif

  printf("Test 1\r\n");
  ext_pos = stpcpy( Treiber_konfiguration.umgebung.dateiname , "Test1.");
  strcpy(ext_pos,extension);
  Treiber_konfiguration.umgebung.namelength =
              strlen(Treiber_konfiguration.umgebung.dateiname);

  initgraph(&treibertyp,&treibermode, bgipfad);
  InGraphicsMode = true;
  test1();
  restorecrtmode();

  printf("Kreise\r\n");
  ext_pos = stpcpy( Treiber_konfiguration.umgebung.dateiname , "kreise.");
  strcpy(ext_pos,extension);
  Treiber_konfiguration.umgebung.namelength =
              strlen(Treiber_konfiguration.umgebung.dateiname);

  setgraphmode(treibermode);
  setwhitepaper();
  kreise();
  restorecrtmode();

  printf("Sterne\r\n");
  ext_pos = stpcpy( Treiber_konfiguration.umgebung.dateiname , "sterne.");
  strcpy(ext_pos,extension);
  Treiber_konfiguration.umgebung.namelength =
			  strlen(Treiber_konfiguration.umgebung.dateiname);

  setgraphmode(treibermode);
  setwhitepaper();
  testzeichnung();
  closegraph();
  InGraphicsMode = false;
  printf("Weiter mit bel. Taste,  Ende mit <ESC>\r\n");
  }while (getch() != '\x1b');
printf("fertig\r\n");
}
