{$A-,B+,D+,E+,F-,I+,L+,N+,O-,R+,S+,V+}
{$M 16384,30000,655360}
program BGIdemo;
{

(C)opyright   1991
Raimund Nisius
SoftwareEntwicklung
Goethepark  13
10627  Berlin

Dieses Programm dient zur Demonstration der Graphiktreiber *.BGI
und diente mir bei der Entwicklung zum Testen der Treiber -> die
Zeichnung sind nicht schn, aber vielfltig.

Alles, was mit Turbo-Pascal und den BGI-Treibern machbar ist, wird
vorgefhrt. ber die Graphikbefehle an sich erfahren Sie nichts neues.
    (
    Ausnahme "sector" u.. Prozeduren machen einen Fehler,
    den meine Treiber auskorrigieren :
           sector(x,y,startwinkel, stop       ,rx,ry);
           sector(x,y, stop      , startwinkel,rx,ry);
    erzeugen auf dem Monitor meistens(!) die gleiche Figur.
    Vergleichen Sie hierzu die Plotterausgabe.
    )
Zum bersetzen brauchen Sie die Dateien
"alloc.pas","params.pas","auswahl.pas","inventar.inc" und "goth.chr".
und natrlich die BGI-Treiber, die in inventar.inc angegeben sind.
}



uses
  Crt,
  Dos,
  auswahl,
  params,
  alloc,
  Graph;

{$define STERNE }
const
  MaxPoints     = 18;

type
  PolygonType = array[1..MaxPoints+5] of PointType;
  windowtype  = record
                x1 ,
                y1 ,
                x2 ,
                y2 : integer;
                end;



var
  hpgl_parameter : HPGL_Konfig_ptr;
  Poly           : PolygonType;
  polysize       : word;
  MaxX, MaxY     : word;     { The maximum resolution of the screen }
  ErrorCode      : integer;  { Reports any graphics errors }
  OldExitProc    : Pointer;  { Saves exit procedure address }
  PathToDriver   : string;   { Stores the DOS path to *.BGI & *.CHR }
  InGraphicsMode : boolean; { Flags initialization of graphics mode }
  testfill       : word;
  width          ,
  xoffs          ,
  yoffs          : word;
  texth          : word;
  gr_error       : integer;
  fenster        : windowtype;
  modename       : string;
  BitMap         : pointer;
  extension      : string[3]; {Ausgabefile je nach Gerteart}

{$I inventar.inc}  { hier sind die vorhanden Nisius-BGI-Treiber gelistet }

procedure waitkey;
var c:char;
begin
c:=readkey;
if c = #0 then
   c:=readkey;
end;

function min(a,b : integer) : integer;
begin
if a<b then
   min := a
else
   min := b;
end;
function Int2Str(L : LongInt) : string;
{ Converts an integer to a string for use with OutText, OutTextXY }
var
  S : string;
begin
  Str(L, S);
  Int2Str := S;
end; { Int2Str }


procedure schreibeTreiberVersion;
begin
setcolor(2);
setwritemode(copyput);
SetTextStyle(3, HorizDir, 1);
texth := textheight('H');
setusercharsize(Maxx div 60,texth,Maxx div 60,texth);
texth := textheight('H');
settextjustify(lefttext,Bottomtext);
outtextxy(MaxX div 20,MaxY-texth,
'Treiber '+TreiberName(treibertyp) +',   '+int2str(getmaxcolor) +' Farben.');
end;


procedure kreise;
var
   m     : pointtype;
   i     ,
   j     ,
   start ,
   stop  ,
   max_r ,
   r     ,
   xasp  ,
   yasp  : word;
   st_str: string;
   AC    : ArcCoordsType;

begin
m.x   := Getmaxx div 4;
m.y   := 3*(Getmaxy div 4);
max_r := min(Getmaxy,Getmaxx) div 4;
start := 270;
stop  := 180;


getaspectratio(xasp,yasp);
setaspectratio(xasp div 2,yasp);

for i := 0 to 18 do
    begin
    start := i * 30;
    r     := (max_r div 40 ) + round(((3.0*i) * max_r)/42.0);
    setlinestyle(CenterLn,2, Thickwidth );
    arc(m.x,m.y,start,stop,r);
    end;
setlinestyle(CenterLn,2, normwidth);
m.x := GetMaxx - m.x;
m.y   := 4*(Getmaxy div 5);
for i := 0 to 18 do
    begin
    start := i * 30;
    r     := (max_r div 40 ) + round(((1.7*i) * max_r)/42.0);
    arc(m.x,m.y,start,stop,r);
    end;

setaspectratio(xasp,yasp);

circle(GetmaxX div 2,m.y, GetmaxY div 15);
ellipse(GetmaxX div 2,4*(GetmaxY div 10),0,270,GetmaxX div 4, GetmaxY div 14);
m.y := (GetMaxY div 5);
setfillstyle(LtBkSlashFill,1);
for j := 0 to 10 do
    begin
    m.x := (1+j)*(GetMaxx div 12);
    start := j * 36;
    stop  := (j+1) * 36;
    sector(  m.x,  m.y,start, stop ,GetMaxx div 26,GetMaxy div 26);
    sector(  m.x,3*m.y, stop, start,GetMaxx div 26,GetMaxy div 26);
    end;

setfillstyle(XHatchFill,1);
setlinestyle(CenterLn,2, Normwidth );
m.x   := Getmaxx div 7;
m.y   := 5*(Getmaxy div 11);
max_r := min( Getmaxx,Getmaxy) div 8;
sector(  m.x,  m.y, 30, 60, max_r, max_r);

setlinestyle(CenterLn,2, Normwidth);
setfillstyle(LineFill,1);
m.x   := 6*(Getmaxx div 7);
fillellipse ( m.x,m.y,max_r,max_r div 2);
schreibeTreiberVersion;

end; {kreise}

{$F+}   { !!!!! Far Function sehr wichtig }

procedure MyExitProc;
begin
  ExitProc := OldExitProc; { Restore exit procedure address }
  if InGraphicsMode then
     CloseGraph;
end; { MyExitProc }

{$F-}


procedure Initialize;
{ Initialize graphics and report any errors that may occur }

begin
  DirectVideo := False;
  OldExitProc := ExitProc;                { save previous exit proc }
  ExitProc := @MyExitProc;                { insert our exit proc in chain }
  PathToDriver := '';
end; { Initialize }

{$ifdef STERNE }

procedure stern_punkte;
var
   i : integer;

begin
 i := 1;
 while i <= MaxPoints do
   begin
   Poly[i].x := xoffs+2+round(xoffs*cos((i*2.0*PI) / MaxPoints));
   Poly[i].y := yoffs+2+round(yoffs*sin((i*2.0*PI) / MaxPoints));
   inc(i);
   Poly[i].x := xoffs+2+round(xoffs/4.0*cos((i*2.0*PI) / MaxPoints));
   Poly[i].y := yoffs+2+round(yoffs/4.0*sin((i*2.0*PI) / MaxPoints));
   inc(i);
   Poly[MaxPoints+1] := Poly[1];
   polysize := MaxPoints+1;
   end;
end;
{$else}

procedure stern_punkte;
var
   i : integer;

begin
   i := 1;
   Poly[i].x  := 0;
   Poly[i].y  := 0;
inc(i);
   Poly[i].x  := xoffs div 3;
   Poly[i].y  := 0;
inc(i);
   Poly[i].x  := xoffs div 2;
   Poly[i].y  := yoffs div 10;
inc(i);


   Poly[i].x  := xoffs div 2;
   Poly[i].y  := yoffs div 2;
inc(i);
   Poly[i].x  := xoffs div 2;
   Poly[i].y  := yoffs div 10;
inc(i);


   Poly[i].x  := xoffs div 3;
   Poly[i].y  := yoffs div 5;
inc(i);
   Poly[i].x  := xoffs div 8;
   Poly[i].y  := yoffs div 5;
inc(i);
   Poly[i].x  := xoffs div 8;
   Poly[i].y  := (3*yoffs) div 4;
inc(i);
   Poly[i].x  := (7*xoffs) div 8;
   Poly[i].y  := (3*yoffs) div 4;
inc(i);
   Poly[i].x := (7*xoffs) div 8;
   Poly[i].y := yoffs div 5;
inc(i);
   Poly[i].x := (2*xoffs) div 3;
   Poly[i].y := yoffs div 5;
inc(i);
   Poly[i].x := xoffs div 2;
   Poly[i].y := yoffs div 10;
inc(i);
   Poly[i].x := (2*xoffs) div 3;
   Poly[i].y := 0;
inc(i);
   Poly[i].x := xoffs;
   Poly[i].y := 0;
inc(i);
   Poly[i].x := xoffs;
   Poly[i].y := yoffs;
inc(i);
   Poly[i].x := 0;
   Poly[i].y := yoffs;
inc(i);
   Poly[i] := Poly[1];
polysize := i;
end;
{$endif}

procedure verschiebe(x : word);
var
   i  : integer;
   dx ,
   dy : word;

begin
dy := (2 * yoffs) * (x div 4);
dx := (5 * xoffs * (x mod 4)) div 3;
for i := 1 to MaxPoints+1 do
   begin
   inc(Poly[i].x,dx);
   inc(Poly[i].y,dy);
   end;
end;



procedure test1;  (* bei erffnetem Graphikmode *)
var
   vp : ViewPortType;
   li : Linesettingstype;
   FillInfo    : FillSettingsType;
   FillPattern : FillPatternType;
   TextInfo    : TextSettingsType;
   pal         : PaletteType;
   regs        : registers;
   Direktes_Kommando : string;

begin
  MaxX := getmaxx;
  MaxY := getmaxy;
  xoffs := getmaxx div 10;   {ok}
  yoffs := getmaxy div 7;    {ok}
moveto(10,100);
width := getx;      {ok}
width := gety;      {ok}
ClearDevice;         {ok}
PutPixel(100,100,1); {ok}
Line   (0,       0, MaxX div 2, MaxY div 2);
MoveTo (MaxX, MaxY );
LineTo (MaxX div 2, 0);
MoveRel(0, MaxY div 4);
LineRel(MaxX div 3, MaxY div 3);
{GraphDefaults; setzt BKcolor auf 0 !}

width := GetPixel(100,100);
texth := ImageSize(0,0,100,100);
getmem(BitMap,texth);
GetImage( 0,0,100,100,BitMap^);      {Normaler Gebrauch von PutImage,GetImage}
PutImage(100,100,BitMap^, NotPut);   {wird vom treibertyp ignoriert.}
freemem(BitMap,texth);
SetWriteMode(4);
getlinesettings(li);
GetFillSettings(FillInfo );      {ok}
GetFillPattern(FillPattern );    {!ok}
SetFillPattern(FillPattern ,1);  {!ok}
FloodFill(0,0,1);                {!ok}
setcolor(RED);                   {ok}
texth := getbkcolor;             {ok}
texth := getcolor;               {ok}
SetRGBPalette(3, 200, 200, 200); {ok}
SetPalette(3, 12);               {ok}
GetPalette(pal);                 {ok}
SetAllPalette(pal);              {ok}
texth := GetPaletteSize;         {ok}
GetDefaultPalette(pal);          {ok}
SetAllPalette(pal);              {ok}


for testfill := Solidln to Dashedln do
    begin
    setlinestyle(testfill,0,normwidth);
    line(0, (MaxY div 20)*(2*testfill), MaxX div 2, (MaxY div 20)*(1+2*testfill));
    setlinestyle(testfill,0,thickwidth);
    line(0, (MaxY div 20)*(1+2*testfill), MaxX div 2, (MaxY div 20)*(2+2*testfill));
    end;
testfill := UserBitLn;
setlinestyle(testfill,$FCCF,normwidth);
line(0, (MaxY div 20)*(2*testfill), MaxX div 2, (MaxY div 20)*(1+2*testfill));
setlinestyle(testfill,$FCCF,thickwidth);
line(0, (MaxY div 20)*(1+2*testfill), MaxX div 2, (MaxY div 20)*(2+2*testfill));

testfill := 4;
setlinestyle(testfill,$FCCF,normwidth);
setfillstyle(LTSlashFill,2);

rectangle(MaxX - MaxX div 8,MaxY div 3,MaxX - MaxX div 10,MaxY div 2);
bar3d( MaxX - MaxX div 10,MaxY div 20,
       MaxX - MaxX div 20,MaxY div 8,
       MaxX div 50,TopOn);

setfillstyle(testfill,1);
bar3d(MaxX - MaxX div 10,MaxY div 8,
      MaxX - MaxX div 20,MaxY div 4,
      MaxX div 50,TopOff);


Poly[1].X := MaxX -MaxX div 4;
Poly[1].Y := MaxY -MaxY div 6;

Poly[2].X := MaxX -MaxX div 8;
Poly[2].Y := MaxY -MaxY div 6;

Poly[3].X := MaxX -MaxX div 8;
Poly[3].Y := MaxY -MaxY div 9;

Poly[4].X := MaxX -MaxX div 8;
Poly[4].Y := MaxY -MaxY div 6;

Poly[5].X := MaxX -MaxX div 16;
Poly[5].Y := MaxY -MaxY div 6;

Poly[6].X := MaxX -MaxX div 16;
Poly[6].Y := MaxY -MaxY div 4;

Poly[7].X := MaxX - MaxX div 4;
Poly[7].Y := MaxY -MaxY div 4;

setlinestyle(2,0,thickwidth);
setfillstyle(0,1);
FillPoly(3, Poly);


setlinestyle(2,0,normwidth);
dec(Poly[1].x,MaxX div 4);
dec(Poly[2].x,MaxX div 4);
dec(Poly[3].x,MaxX div 4);
inc(Poly[1].y,MaxY div 20);
inc(Poly[2].y,MaxY div 20);
inc(Poly[3].y,MaxY div 20);
FillPoly(3, Poly);

fenster.x1 := MaxX - MaxX div 10;
fenster.y1 := MaxY div 2;
fenster.x2 := MaxX - MaxX div 20;
fenster.y2 := MaxY - MaxY div 3;
setlinestyle(2,0,thickwidth);
setfillstyle(4,1);

with fenster do
  begin

  bar (x1,
       y1,
       x2,
       y2);
  setviewport(x1,
              y1,
              x2,
              y2,
              true);

  line(0,0,2*(x2-x1),2*(y2-y1));
  getviewsettings(vp);
  end;

setviewport(0,0,getmaxx,getmaxy,true);

{$IFDEF HPGLPLOTTER}
if treibertyp = plottertreiber then
    begin
    hpgl_parameter := Treiber_konfiguration.plotter;

    if hpgl_parameter^.filehandle <> 0 then { HPGL.BGI hat eine Ausgabe erffnet.}
       begin
       Direktes_Kommando := 'PU1000,1000;LBDies ist ein direkter Plotterbefehl'#3 ;
       regs.CX := length(Direktes_Kommando);    { Stringlnge }
       regs.DX := ofs(Direktes_Kommando[1]);    { Stringadresse Offset  }
       regs.DS := seg(Direktes_Kommando[1]);    { Stringadresse Offset  }
       regs.BX := hpgl_parameter^.filehandle;   { handle }
       regs.AH := $40;                          { DOS Funktion write to file or device }
       msdos(regs);                             { Enter DOS }
       if (regs.Flags and 1) <> 0 then          { Carry Flag gesetzt -> Fehler }
          begin
          writeln('Direkter Befehl an Plotter ber Handle #',
                   hpgl_parameter^.filehandle,
                   ' hat nicht geklappt!');
          writeln('DOS-Fehler ',regs.AX);
          writeln('Taste !');
          while readkey = #0 do { warten };
          halt;
          end;
       end;
    end;
{$ENDIF}

schreibeTreiberVersion;
outtextxy(MaxX div 2,MaxY-MaxY Div 40,'Programmende mit Tastendruck.');
gr_error := graphresult;
SetTextStyle(4, VertDir, 4);
gr_error := graphresult;
if gr_error <> 0 then
   writeln(grapherrormsg(gr_error));
texth := textheight('How nice !');
setusercharsize(Maxx div 20,texth,Maxx div 15,texth);
texth := textheight('How nice !');
settextjustify(2,0);
outtextxy(MaxX,MaxY,'How nice !');


settextjustify(0,2);
SetTextStyle(0, VertDir,4);
texth := textheight('How nice !');
setusercharsize(Maxx div 20,texth,Maxx div 15,texth);
outtextxy(round(MaxX*0.9),round(maxy*0.1),Int2Str(MaxX));

settextjustify(0,0);
SetTextStyle(0, HorizDir, 4);
texth := textheight('How nice !');
(*
GetTextSettings(TextInfo );
*)
setusercharsize(Maxx div 20,texth,Maxx div 15,texth);
outtextxy(0,MaxY,Int2Str(MaxY));
end;

procedure testzeichnung;  (* bei erffnetem Graphikmode *)


begin

    for testfill := emptyfill to closedotfill do
      begin
      width := testfill div 5;
      if width < 1 then
         width := 1
      else
         width := 3;
      setlinestyle(testfill mod 5,$FFCC,width);
      stern_punkte;
      verschiebe(testfill);
      SetFillStyle(testfill , 1 + (testfill mod getmaxcolor));
      FillPoly(polysize, Poly);
      end;

SetFillStyle(LtSlashFill , 1 + (testfill mod getmaxcolor));
sector(MaxX - MaxX div 8,2*(MaxY div 3),345,15,MaxX div 8,MaxY div 10);
sector(MaxX - MaxX div 8,MaxY div 3,15,345,MaxX div 8,MaxY div 10);
schreibeTreiberVersion;
end;

procedure setbackground;
begin
if getmaxcolor > 1 then
    begin
    setcolor(8);           { dunkelgraue Flche = Scharze Linien }
    setbkcolor(15);        { wei fr Farbversion }
    end
else
    begin
    setcolor(1);           { schwarz }
    setbkcolor(0);         { unbedruckt fr Mono }
    end;
end;


begin { program body }
  Initialize;
  repeat
      waehle_treiber;                        { Ausgabegert bestimmen }
      {$IFDEF HPGLPLOTTER}
      if treibertyp = plottertreiber then
         begin
         Treiber_konfiguration.plotter^.rotate := false;  { Querformat }
         extension := 'PLT';
         end;
      {$ENDIF}
      {$IFDEF LASERDRUCKER}
      if treibertyp = lasertreiber then
         begin
         Treiber_konfiguration.laserjet^.rotate := true;  { Querformat }
         Treiber_konfiguration.laserjet^.resolution := 4;
         Treiber_konfiguration.laserjet^.size.x     := 2400 div 4;
         Treiber_konfiguration.laserjet^.size.y     := 3300 div 4;
         extension := 'LAS';
         end;
      {$ENDIF}
      {$IFDEF NADELDRUCKER}
      if treibertyp = nadeltreiber then
         begin
         Treiber_konfiguration.nadeldrucker^.rotate := true;  { Querformat }
         extension := 'PRN';
         end;
      {$ENDIF}

      {$IFDEF DESKJETDRUCKER}
      if treibertyp = deskjettreiber then
         begin
         Treiber_konfiguration.deskjet_c^.rotate := true;  { Querformat }
         Treiber_konfiguration.deskjet_c^.resolution := 4;
         Treiber_konfiguration.deskjet_c^.size.x     := 2400 div 4;
         Treiber_konfiguration.deskjet_c^.size.y     := 3100 div 4;
         extension := 'DJC';
         end;
      {$ENDIF}
      {$IFDEF paintjetDRUCKER}
      if treibertyp = paintjettreiber then
         begin
         Treiber_konfiguration.paintjet^.rotate     := true;  { Querformat }
         Treiber_konfiguration.paintjet^.resolution := 4;
         extension := 'PJ';
         end;
      {$ENDIF}

      {$IFDEF DXFDRUCKER}
      if treibertyp = DXFtreiber then
         begin
         Treiber_konfiguration.DXF^.resolution := -1;   {1/10 mm }
         Treiber_konfiguration.DXF^.size.x := 2900;     { ca. DIN A 4}
         Treiber_konfiguration.DXF^.size.y := 2100;     { ca. DIN A 4}
         extension := 'DXF';
         end;
      {$ENDIF}

      Treiber_konfiguration.umgebung.dateiname := 'Test1.'+extension;  { fr Mode 8  }
      InitGraph(treibertyp,treibermode, PathToDriver);
      InGraphicsMode := true;
      writeln(getmaxcolor,' Farben');
      writeln('Allgemeiner Test');
      writeln(Treiber_konfiguration.umgebung.dateiname);
      setbackground;
      test1;
      if treibertyp = monitortreiber then
         while readkey = #0 do;      { warten }
      restorecrtmode;

      Treiber_konfiguration.umgebung.dateiname := 'kreise.'+extension;
      setgraphmode(treibermode);
      writeln('Kreise');
      writeln(Treiber_konfiguration.umgebung.dateiname);
      setbackground;
      kreise;
      if treibertyp = monitortreiber then
         while readkey = #0 do;      { warten }
      restorecrtmode;

      Treiber_konfiguration.umgebung.dateiname := 'sterne.'+extension;
      setgraphmode(treibermode);
      writeln('Sterne');
      writeln(Treiber_konfiguration.umgebung.dateiname);
      setbackground;
      testzeichnung;


      if treibertyp = monitortreiber then
         while readkey = #0 do;      { warten }
      CloseGraph;
      InGraphicsMode := false;
      writeln('Weiter mit Tastendruck,   Abbruch mit <ESC>');
  until readkey = #27;
end.
