unit hpglutil;

{                       }
{ Copyright (C)   1990  }
{ Raimund Nisius        }
{ SoftwareEntwicklung  }
{ Goethepark  13        }
{ 10627  Berlin         }
{                       }
{ Diese Unit drfen Sie Ihren eigenen Bedrfnissen anpassen. Sie drfen }
{ den Quellcode nicht weitergeben!           }


interface

uses
    crt,
    dos,
    alloc,
    params,
    graph;


procedure Plotter_Command(c : string);
{
  bergibt den String c direkt an den Plotter.
  Der String wird nicht interpretiert ! Sie sollten nur Befehle geben,
  die mit den Turbo Graphikbefehlen nicht realisierbar sind. (z.B. 45
  Schrift)
}

procedure serinit(comnr : integer); { Interaktiv die serielle Schnitstelle }
                                    { initialisieren                       }


implementation

procedure Plotter_Command(c : string);
{ bergibt den String c direkt an den Plotter. Funktioniert nur wenn   }
{ die aktuelle Konfiguration.filehandle einen Wert > 0 hat! (d.h. der  }
{ HPGL-Treiber hat die Plotterausgabe erffnet.)                       }
{ Der String wird nicht interpretiert ! Sie sollten nur Befehle geben, }
{ die mit den Turbo Graphikbefehlen nicht realisierbar sind. (z.B. 45 }
{ Schrift)                                                             }

var
   regs :registers;
var
   hpgl_parameter : HPGL_Konfig_ptr;

begin
hpgl_parameter := Treiber_konfiguration.plotter;

if hpgl_parameter^.filehandle <> 0 then { HPGL.BGI hat eine Ausgabe erffnet.}
   begin
   regs.CX := length(c);                  { Stringlnge }
   regs.DX := ofs(c[1]);                  { Stringadresse Offset  }
   regs.DS := seg(c[1]);                  { Stringadresse Offset  }
   regs.BX := hpgl_parameter^.filehandle;  { handle }
   regs.AH := $40;                        { DOS Funktion write to file or device }
   msdos(regs);                           { Enter DOS }
   if (regs.Flags and 1) <> 0 then        { Carry Flag gesetzt -> Fehler }
      begin
      writeln('Direkter Befehl an Plotter hat nicht geklappt!');
      writeln('DOS-Fehler ',regs.AX);
      halt;
      end;
   end;
end;

procedure serinit(comnr : integer); { Interaktiv die serielle Schnitstelle }
                                    { initialisieren                       }
var
   regs      : registers;
   baud      ,
   parity    ,
   stopbits  ,
   datenbits ,
   serkonfig : byte;
   c         : char;
   ypos      : byte;

type
    string4 = string[4];
const
     baudname : array[1..8] of string4 = (
                              ' 110',
                              ' 150',
                              ' 300',
                              ' 600',
                              '1200',
                              '2400',
                              '4800',
                              '9600'
                              );
     pariname : array[0..3] of string4 = (
                              'keine',
                              ' Odd',
                              'keine',
                              'Even'
                              );
begin
baud      := 8;
parity    := 0;
stopbits  := 1;
datenbits := 8;
ypos := wherey;

repeat
   gotoxy(1,ypos);
   clreol;
   writeln('<B>audrate  ',baudname[baud]);
   writeln('<P>arity    ',pariname[parity]);
   writeln('<S>topbits  ',stopbits);
   writeln('<D>atenbits ',datenbits);
   writeln;
   writeln('<O>k,  Schnittstelle initialisieren');
   writeln('<Q>uit,Schnittstelle nicht initialisieren');
   writeln;
   writeln;
   write('Bitte Tasten B,P,S,D,O oder Q drcken! ');
   c := upcase(readkey);
   case c of
      'B' : begin
            baud := 1 + baud mod 8;
            end;
      'P' : begin
            parity := (1 + parity) mod 4;
            end;
      'S' : begin
            stopbits := 1 + stopbits mod 2;
            end;
      'D' : begin
            if datenbits = 7 then
               datenbits := 8
            else
               datenbits := 7;
            end;
   end;  {case}
until (c = 'O') or (c = 'Q');
if c = 'O' then
   begin
   serkonfig := ((baud-1)     shl 5) +  { Konfigurationsbyte zusammenstellen }
                (parity       shl 3) +
                ((stopbits-1) shl 2) +
                2                    +
                ( (datenbits+1) and $1);
   regs.ah := 0;           { INIT V24      }
   regs.al := serkonfig;   { Initwerte     }
   regs.dx := comnr-1;     { Schnittst. Nr.}
   intr($14,regs);         { Interrupt     }
   end;
writeln;
end;
end.
