#include "ftmenuto.ch"

clear

centre( 6,"Equipment Database Program V4.0h")
centre( 8,"Written for")
centre(10,"Cardiology Department")
centre(12,"Royal Melbourne Hospital")
centre(14,"by")
centre(16,"Peter Summers")
centre(18,"July 1988")
#ifdef demo
  centre(20,"Evaluation Version")
  centre(22,"(Fifty item limit applies).")
#endif
centre(24,"(C) Cardiology Department, Royal Melbourne Hospital, Australia ")

do start

do while .T.

  clear
  @ 0,27 say "EEEEE   QQQ   PPPP   TTTTT"
  @ 1,27 say "E      Q   Q  P   P    T"
  @ 2,27 say "EEE    Q   Q  PPPP     T"
  @ 3,27 say "E      Q  QQ  P        T"
  @ 4,27 say "EEEEE   QQQQ  P        T"
  @ 0,78 say access
  @ 6,30 prompt "(Equipment Database)" message;
    "Type the letter of your choice or use the arrow keys to select."
  @ 9,10 say "Options:"
  @ 9,33 prompt "Alter an item " message iif(access="RO";
    ,"You're not allowed to do that.";
    ,"Press the `Enter' key to change an existing record.");
    triggercolor "g+/n,g+/r"
  @ 11,33 prompt "Enter an item " message iif(access="RO";
    ,"You're not allowed to do that.";
    ,"Press the `Enter' key to type in a new record.");
    triggercolor "g+/n,g+/r"
  @ 13,33 prompt "Print an item " message;
    "Press the `Enter' key to print an existing record.";
    triggercolor "g+/n,g+/r"
  @ 15,33 prompt "View an item  " message;
    "Press the `Enter' key to display an existing record.";
    triggercolor "g+/n,g+/r"
  @ 17,33 prompt "Summaries menu" message;
    "Press the `Enter' key for listings of records.";
    triggercolor "g+/n,g+/r"
  @ 19,33 prompt "eXtra features " message iif(access="RO";
    ,"You're not allowed to do that.","Press `Enter' for other options.");
    trigger 2 triggercolor "g+/n,g+/r"
  @ 21,32 prompt "Quit the program" message;
    "Press the `Enter' key to leave this program";
    triggercolor "g+/n,g+/r"
  choice=0
  menu to choice timeout 600
  do case

    case choice=2
      if access="RO"
        do finger
      else
        do getcat
        if lastkey()<>27
          do alter
        endif
      endif

    case choice=3
      if access="RO"
        do finger
      else
        do enter
      endif

    case choice=4
      do getcat
      if lastkey()<>27
        do print
      endif

    case choice=5
      do getcat
      if lastkey()<>27
        do view
      endif

    case choice=6
      do summ

    case choice=7
      if access="RO"
        do finger
      else
        do xtra
      endif

    case choice=8.or.choice<=0
      do finish

  endcase
enddo



procedure start

*       initialise the program.

  startime=seconds()
  do initvar
  do setup
  do getdata
  do while abs(seconds()-startime)<2.and.nextkey()=0
  enddo  



procedure getcat

*       prompt for a catalog number and locate the entry (calls
*       getnumb and getone if more than one entry exists with the given
*       catalog number).

  if eof()
    skip -1
  endif
  catn=cat
  @ 24,0 clear
  @ 24,24 say "Enter catalog number ..." get catn picture "@K!"
  read
  if updated()
    seek alltrim(catn)
    if !(cat==catn)
      @  8,0 clear
      keyboard " "
      @ 24,6 say "Use arrow keys, PgUp, PgDn to move, `Enter' to select, `Esc' to quit."
      dbedit(8,0,22,79,sfields)
    endif
  endif



procedure alter

*       alter a record.

  do while .not.rlock()
    clear
    @ 11,10 say "Someone else is altering this record, please try again later."
    if inkey(5)<>0
      return
    endif
  enddo
  clear
  @ 1,0 to 23,79
  @ 4,15 say "CATALOG NUMBER...." get cat picture "@!"
  @ 6,15 say "MANUFACTURER ....." get manuf picture "@!"
  @ 8,15 say "ITEM DESRIPTION .." get item picture "@!"
  @ 10,15 say "SERIAL NUMBER ...." get serial picture "@!"
  @ 12,15 say "SUPPLIER ........." get suppl picture "@!"
  @ 14,15 say "ORDER NUMBER ....." get order picture "@!"
  @ 16,15 say "PURCHASED ........" get purch
  @ 18,15 say "PRICE .......... "+curncybk get price picture "@Z";
    valid(inrange(0,999999999))
  @ 21,15 say "PgDn to edit comments, F1 for help, Esc aborts."
  read
  commit
  if lastkey()<>27
    clear
    @ 1,0 to 23,79
    @ 24,0 say "F10 saves comments, F1 for help, Esc aborts"
    set key 28 to helpmemo
    replace comments with memoedit(comments,2,2,22,77,.T.,"myedit")
    set key 28 to help
  endif
  if empty(cat)
    delete
    skip -1
  else
    replace cat with ltrim(cat)
  endif
  commit
  unlock



procedure enter

*       enter a new item (calls alter).

#ifdef demo
  if reccount() >= 50
    clear
    centre(10,"The fifty item limit for this demonstration version has been reached.")
    centre(12,"Please read the accompanying .DOC file for details of how")
    centre(14,"to obtain an unlimited version.")
    centre(24,"Press any key to continue... ")
    inkey(0)
    return
  endif
#endif
  catn=space(8)
  @ 24,0
  @ 24,24 say "Enter the catalog number ..." get catn picture "@!"
  read
  if .not.empty(catn)
    catn=ltrim(catn)  
    seek catn
    if found()
      @ 23,0
      wait "     Warning, an entry with this catalog number exists;";
        +" Continue (Y/N) ? " to answer
      if .not.answer$"TtYyUu&7^6%5"
        return
      endif
    endif
    append blank
    do while neterr()
      clear
      @ 11,12 say "Someone else is adding a record, please try again later."
      @ 13,28 say "Press any key to return ..."
      if inkey(1)<>0
        return
      endif
      append blank
    enddo
    replace cat with catn
    do alter
  endif



procedure print

*       print the item details.

  clear
  if .not.ft_isprint(printdbk)
    @ 12,8 say "The printer is not connected properly,";
      +" press any key to return..."
    ?? bel
    do while .not.ft_isprint(printdbk)
      if inkey()<>0
        return
      endif
    enddo
    clear
  endif
  set printer to (printdbk)
  set print on
  begin sequence
    ?? expansion(presetbk)
    ?? expansion(prrepobk)
    ? "CATALOG NUMBER.... " + cat
    ?
    ? "MANUFACTURER ..... " + manuf
    ?
    ? "ITEM DESRIPTION .. " + item
    ?
    ? "SERIAL NUMBER .... " + serial
    ?
    ? "SUPPLIER ......... " + suppl
    ?
    ? "ORDER NUMBER ..... " + order
    ?
    ? "PURCHASED ........ " + dtoc(purch)
    ?
    ? "PRICE .......... "+curncybk+" "+transform(price,"@Z")
    ?
    ? hardcr(comments)
    ?? expansion(presetbk)
    end sequence
    set print off
    set printer to



procedure view

*       view an entry (calls showtop).

  clear
  @ 1,0 to 23,79
  @ 4,20 say "CATALOG NUMBER.... " + cat
  @ 6,20 say "MANUFACTURER ..... " + manuf
  @ 8,20 say "ITEM DESRIPTION .. " + item
  @ 10,20 say "SERIAL NUMBER .... " + serial
  @ 12,20 say "SUPPLIER ......... " + suppl
  @ 14,20 say "ORDER NUMBER ..... " + order
  @ 16,20 say "PURCHASED ........ " + dtoc(purch)
  @ 18,20 say "PRICE .......... "+curncybk+" "+ltrim(transform(price,"@Z"))
  @ 21,14 say "Press Esc to return, any other key to view comments"
  wait ""
  if lastkey()<>27
    clear
    @ 0,0 to 23,79
    @ 24,0 say "Home, End, PgDn, PgUp, Arrow keys move, Esc or Enter exits"
    keyboard " "                                    && Makes lastkey<>13
    set key 28 to helpview
    memoedit(comments,1,2,22,77,.F.,"exit_on_enter")
    set key 28 to help
  endif


function exit_on_enter
  parameters mode
  if mode=0.and.lastkey()=13
*   Put the exit key in the keyboard buffer.
    keyboard chr(23)
  endif
  return 0



procedure summ

*       secondary menu: print orders, list details of items.

  @ 6,0 clear
  @ 6,32 prompt "(Summaries Menu)" message;
    "Type the letter of your choice or use the arrow keys to select."
  @ 9,10 say "Options:"
  @  9,33 prompt "Find item     " message;
    "Press the `Enter' key to find items from one manufacturer.";
    triggercolor "g+/n,g+/r"
  @ 11,33 prompt "Item details  " message;
    "Press the `Enter' key to find items of any particular type.";
    triggercolor "g+/n,g+/r"
  @ 13,33 prompt "Supply details" message;
    "Press the `Enter' key to list supplier, purchase date, order no. and price.";
    triggercolor "g+/n,g+/r"
  @ 15,33 prompt "Query Builder " message;
    "Press the `Enter' key to build a custom query.";
    triggercolor "g+/n,g+/r"
  choice=0
  menu to choice timeout 600
  @ 24,0
  do case
    case choice=2
      fitem=space(len(item))
      @ 24,18 say "Enter item .." get fitem picture "@!"
      read
      fitem=alltrim(fitem)
      do listitems with "Cat no.  Manufacturer              Item";
        +"                    Serial no.","cat+' '+manuf+' '+item+' '+serial";
        ,"fitem$item"
    case choice=3
      fmanuf=space(len(manuf))
      @ 24,22 say "Enter manufacturer .." get fmanuf picture "@!"
      read
      fmanuf=alltrim(fmanuf)
      do listitems with "Cat no.  Manufacturer              Item";
        +"                    Serial no.","cat+' '+manuf+' '+item+' '+serial";
        ,"manuf=fmanuf"
    case choice=4
      fmanuf=space(20)
      @ 24,22 say "Enter manufacturer .." get fmanuf picture "@!"
      read
      fmanuf=alltrim(fmanuf)
      do listitems with "Cat no.  Manufacturer              Item";
        +"                    Serial no.           Supplier              ";
        +"     Date   Order no.  Price","cat+' '+manuf+' '+item+' '+serial";
        +"+'     '+suppl+' '+dtoc(purch)+' '+order+' '+curncybk+' '";
        +"+ltrim(transform(price,'@Z'))","manuf=fmanuf"
    case choice=5
      do listitems with "Cat no.  Manufacturer              Item";
        +"                    Serial no.","cat+' '+manuf+' '+item+' '+serial";
        ,bldquery()
  endcase



procedure xtra

*       secondary menu: define function keys, pack, reindex, set printer codes.

  @ 6,0 clear
  @ 6,33 prompt "(Xtra features)" message;
    "Type the letter of your choice or use the arrow keys to select."
  @ 9,10 say "Options:"
  @ 9,32 prompt "Define F keys   " message;
    "Press the `Enter' key to change the strings assigned to the function keys.";
    triggercolor "g+/n,g+/r"
  @ 11,32 prompt "Pack           " message;
    "Press the `Enter' key to remove deleted records from the database.";
    triggercolor "g+/n,g+/r"
  @ 13,32 prompt "Reindex        " message;
    "Press the `Enter' key to rebuild the index files.";
    triggercolor "g+/n,g+/r"
  @ 15,32 prompt "Setup stuff    " message;
    "Press the `Enter' key to set up the printer, backup status and date type.";
    triggercolor "g+/n,g+/r"
  @ 17,32 prompt "eXamine database" message;
    "Press the `Enter' key to examine the database.";
    trigger 2 triggercolor "g+/n,g+/r"
  @ 20,32 prompt "Q)uit this menu " message;
    "Press the `Enter' key to leave this menu.";
    triggercolor "g+/n,g+/r"
  choice=0
  menu to choice timeout 600
  clear
  do case
    case choice=2
      do deffunc
    case choice=3
      do pack
    case choice=4
      do reindex
    case choice=5
      do setstuff
    case choice=6
      dbedit()
  endcase



procedure finish

*       do a backup if required and exit the program.

  clear
  if backupbk
    @ 11,26 say "Do you want to do a backup ?"
    @ 13,30 say "Y)es, N)o or R)eturn"
    wait space(39) to answer
    clear
    if answer$"YyTtGgHhJjUu&7^6%5"
      do backquit
    elseif answer$"NnMmBb"
      quit
    endif
  else
    quit
  endif



procedure initvar

*       initialise all variables.

  public answer,num,bel,lf,cr,ff,sr,esc,access
  public prwidebk,presetbk,prrepobk,printdbk,backupbk,datetybk,curncybk
  public func02bk,func03bk,func04bk,func05bk,func06bk,func07bk,func08bk,func09bk
  public objerror,defaulthandler,sfields[4]
  answer=" "
  sfields[1]="cat"
  sfields[2]="manuf"
  sfields[3]="item"
  func02bk=space(70)
  func03bk=space(70)
  func04bk=space(70)
  func05bk=space(70)
  func06bk=space(70)
  func07bk=space(70)
  func08bk=space(70)
  func09bk=space(70)
  prwidebk=space(30)
  presetbk=space(30)
  prrepobk=space(30)
  printdbk="LPT1"
  backupbk=.F.
  datetybk="B"
  curncybk="$"
  bel=chr(7)
  lf=chr(10)
  ff=chr(12)
  cr=chr(13)
  sr=chr(141)+lf
  esc=chr(27)
  begin sequence
    defaulthandler:=errorblock({ |objerr| breakonerror(objerr, .T.)})
    restore from eqptback additive
    errorblock(defaulthandler)
  recover using objerror
    errorblock(defaulthandler)
  end



procedure setup

*       set up the environment

  if iscolor()
    set color to g/n,g/r,n,n,g/b
    nosnow(.T.)
  else
    set color to w/n,n/w,n,n,u/n
  endif
  set confirm on
  if datetybk="A"
    set date american
  else
    set date british
  endif
  set deleted on
  set exclusive off
  set function 2 to expansion(func02bk)
  set function 3 to expansion(func03bk)
  set function 4 to expansion(func04bk)
  set function 5 to expansion(func05bk)
  set function 6 to expansion(func06bk)
  set function 7 to expansion(func07bk)
  set function 8 to expansion(func08bk)
  set function 9 to expansion(func09bk)
  set function 10 to chr(23)
  set message to 24 centre
  set path to (getenv("path"))
  set softseek on
  set wrap on
  readinsert(.T.)



procedure getdata

*       get the database and indexes.

  begin sequence
    access="RW"
    defaulthandler:=errorblock({ |objerr| breakonerror(objerr, .T.)})
    use eqptdata
    errorblock(defaulthandler)
  recover using objerror
    access="RO"
    errorblock(defaulthandler)
    use eqptdata readonly
  end
  do while neterr()
    clear
    @ 11,12 say "This database is not available now, please try again later."
    @ 13,29 say "Press any key to quit ..."
    if inkey(5)<>0
      clear
      errorlevel(1)
      quit
    endif
    begin sequence
      access="RW"
      defaulthandler:=errorblock({ |objerr| breakonerror(objerr, .T.)})
      use eqptdata
      errorblock(defaulthandler)
    recover using objerror
      access="RO"
      errorblock(defaulthandler)
      use eqptdata readonly
    end
  enddo
  begin sequence
    defaulthandler:=errorblock({ |objerr| breakonerror(objerr, .T.)})
    set index to eqptcat
    errorblock(defaulthandler)
  recover using objerror
    errorblock(defaulthandler)
    ?? bel
    clear
    @ 11,18 say "One or more index files could not be found."
    if access="RO"
      @ 13,23 say "Press any key to quit the program..."
    else
      @ 13,11 say "Press Esc to quit the program, any other key to reindex..."
    endif
    wait space(39)
    clear
    if lastkey()=27.or.access="RO"
      errorlevel(2)
      quit
    else
      do reindex
      clear
    endif
  end
  goto bottom



function breakonerror(objerror,localhandler)
  if localhandler
    break objerror
  endif
  return NIL



procedure finger

*       Deny access to a user who doesn't have the privledges to do something.

  clear
  @  7,33 say "      _"
  @  8,33 say "     { }"
  @  9,33 say "     | |"
  @ 10,33 say "     | |"
  @ 11,33 say "  .-.| |.-."
  @ 12,33 say ".-|  | |  |.-."
  @ 13,33 say "| |       |  |"
  @ 14,33 say "\            |"
  @ 15,33 say " \          /"
  @ 16,33 say "  |       |"
  @ 17,33 say "  |       |"
  @ 18,33 say "  |       |"
  @ 20,25 say "You're not allowed to do that."
  ?
  tone(100,18)
  wait space(32)+"Press any key... "



procedure deffunc

*       define the function keys.

  begin sequence
    defaulthandler:=errorblock({ |objerr| breakonerror(objerr, .T.)})
    restore from eqptback additive
    errorblock(defaulthandler)
  recover using objerror
    errorblock(defaulthandler)
  end
  @ 8,0 clear
  @ 8,30 say "Define function keys"
  @ 10,0 say "F2 = " get func02bk;
    valid empty(func02bk).or..not.empty(expansion(func02bk))
  @ 12,0 say "F3 = " get func03bk;
    valid empty(func03bk).or..not.empty(expansion(func03bk))
  @ 14,0 say "F4 = " get func04bk;                     
    valid empty(func04bk).or..not.empty(expansion(func04bk))
  @ 16,0 say "F5 = " get func05bk;
    valid empty(func05bk).or..not.empty(expansion(func05bk))
  @ 18,0 say "F6 = " get func06bk;
    valid empty(func06bk).or..not.empty(expansion(func06bk))
  @ 20,0 say "F7 = " get func07bk;
    valid empty(func07bk).or..not.empty(expansion(func07bk))
  @ 22,0 say "F8 = " get func08bk;
    valid empty(func08bk).or..not.empty(expansion(func08bk))
  @ 24,0 say "F9 = " get func09bk;
    valid empty(func09bk).or..not.empty(expansion(func09bk))
  read
  if updated()
    set function 2 to expansion(func02bk)
    set function 3 to expansion(func03bk)
    set function 4 to expansion(func04bk)
    set function 5 to expansion(func05bk)
    set function 6 to expansion(func06bk)
    set function 7 to expansion(func07bk)
    set function 8 to expansion(func08bk)
    set function 9 to expansion(func09bk)
    begin sequence
      defaulthandler:=errorblock({ |objerr| breakonerror(objerr, .T.)})
      save to eqptback all like ??????bk
      errorblock(defaulthandler)
    recover using objerror
      errorblock(defaulthandler)
      @ 23,0 clear
      wait space(8)+bel;
        +"ERROR: Can't write to settings file, Press any key to continue..."
    end
  endif



procedure pack

*       pack the database.

  use eqptdata exclusive
  do while neterr()
    clear
    @ 11,14 say "Another user is using this database, try again later."
    @ 13,27 say "Press any key to return ..."
    if inkey(5)<>0
      use eqptdata index eqptcat
      return
    endif
    use eqptdata exclusive
  enddo
  @ 12,24 say "Packing database, please wait ..."
  copy to eqptback for !(deleted().or.empty(cat)) while diskspace()>16384
  if eof()
    set index to eqptcat
    zap
    append from eqptback
  else
    @ 12,21 say "Packing process failed, press any key ..."
    inkey(0)
  endif
  delete file eqptback.dbf
  delete file eqptback.dbt
  use eqptdata index eqptcat



procedure reindex

*       reindex the database.

  use eqptdata exclusive
  do while neterr()
    clear
    @ 11,14 say "Another user is using this database, try again later."
    @ 13,27 say "Press any key to return ..."
    if inkey(5)<>0
      use eqptdata index eqptcat
      return
    endif
    use eqptdata exclusive
  enddo
  @ 12,22 say "Reindexing database, please wait ..."
  use eqptdata
  index on cat to eqptcat
  use eqptdata index eqptcat



procedure setstuff

*       set the printer control codes.

  begin sequence
    defaulthandler:=errorblock({ |objerr| breakonerror(objerr, .T.)})
    restore from eqptback additive
    errorblock(defaulthandler)
  recover using objerror
    errorblock(defaulthandler)
  end
  @ 8,34 say "Printer Codes"
  @ 12,10 say "Reset printer ..........." get presetbk;
    valid empty(presetbk).or..not.empty(expansion(presetbk))
  @ 14,10 say "Setup for reports ......." get prrepobk;
    valid empty(prrepobk).or..not.empty(expansion(prrepobk))
  @ 16,10 say "Set for 132 characters .." get prwidebk;
    valid empty(prwidebk).or..not.empty(expansion(prwidebk))
  @ 18,30 say "Printer device ..." get printdbk picture "@!";
    valid(oneof("LPT1","LPT2","LPT3","COM1","COM2","NUL "))
  @ 20,30 say "Automatic backups .." get backupbk picture "Y"
  @ 22,30 say "Date type .........." get datetybk picture "@!";
    valid(datetybk$"AB")
  @ 24,30 say "Currency ..........." get curncybk
  read
  if updated()
    begin sequence
      defaulthandler:=errorblock({ |objerr| breakonerror(objerr, .T.)})
      save to eqptback all like ??????bk
      errorblock(defaulthandler)
    recover using objerror
      errorblock(defaulthandler)
      @ 23,0 clear
      wait space(8)+bel;
        +"ERROR, Can't write to settings file, Press any key to continue..."
    end
    if datetybk="A"
       set date american
     else
       set date british
     endif
  endif


function expansion

*       expand a string

parameter string

  string=strtran(alltrim(string),"[",chr(255))
  string=strtran(string,"]","+[")
  string="["+strtran(string,chr(255),"]+")+"]"
  if type(string)="C" 
    return(&string)
  else
    return("")
  endif



procedure backquit

*       do a backup and quit the program.

  @ 11,15 say "Please insert the disk marked `"+cdow(date())+"' in drive A."
  @ 13,30 say "(and shut the drive)"
  @ 20,24 say "Press any key when disc inserted."
  wait space(39)
  if lastkey()<>27
    clear
    @ 10,20 say "Backup in progress, please wait......"
    close
    @ 20,0
    copy file eqptdata.dbf to eqptdata.bak
    copy file eqptdata.dbt to eqptdata.tbk
    copy file eqptdata.dbf to a:eqptdata.dbf
    copy file eqptdata.dbt to a:eqptdata.dbt
    clear
    ? bel
    quit
  endif



function oneof

*       check that the input is one of the values given, invoking
*       the help function if it isn't.

parameters p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13,p14,p15,p16,p17,p18;
  ,p19,p20,p21,p22,p23,p24,p25,p26,p27,p28,p29,p30,p31,p32,p33,p34,p35,p36

  var=readvar()
  for i=1 to min(36,pcount())
    p="p"+ltrim(str(i))
    if &var==&p
      return(.T.)
    endif
  next
  do help with procname(),procline(),var
  return(.F.)



function inrange

*       -       check that a value is in range.

parameter lowest,highest

  var=readvar()
  good=(&var>=lowest.and.&var<=highest)
  if .not.good
    do help with procname(),procline(),var
  endif
  return(good)



function myedit(mode,row,col)

static lastcol

  if mode>0
    if mode=2.and.lastkey()=27
      @ 0,60 say "Abort edit? (Y/N)"
      if !chr(inkey(0))$"Yy"
        @ 0,60 say iif(readinsert(),"<insert>             ",space(20))
        return 32                                       && Ignore
      endif
    elseif lastkey()=20                                 && Ctrl-T
      keyboard chr(2)
    endif
  elseif col=0.and.lastcol=0.and.row>1;
    .and.(lastkey()=8.or.lastkey()=26.or.lastkey()=19)  && BS, [Ctrl] Left Arrow
      keyboard chr(5)+chr(6)
  elseif lastkey()=7.or.lastkey()=8                     && BS, Del
    keyboard chr(2)
  elseif col=lastcol.and.(lastkey()=2.or.lastkey()=4)   && [Ctrl] Right Arrow
    keyboard chr(1)+chr(24)
  endif
  lastcol=col
  return 0



procedure listitems

*       list all items meeting a specific condition

  parameter heading,vars,condition

  condition=iif(condition=NIL,".T.",condition)
  if lastkey()<>27
    @ 24,0
    centre(24,"(B)rowse, (C)ount, (L)ist, (P)rint, (T)abulate ? ")
    goto top
    answer=" "
    do while !(answer$"BCLPT"+chr(27))
      answer=upper(chr(inkey(0)))
    enddo
    do case
      case answer="B"
        locate for &condition
        if found()
          set filter to &condition
          do while .T.
            dbedit()
            if lastkey()=27
              set filter to
              return
            endif
            do view
          enddo
        else
          @ 24,0
          centre(24,"No records found, press any key...")
          inkey(0)
        endif
      case answer="C"
        @ 23,0 clear
        @ 24,35 say "Counting .."
        count for &condition while !eof().and.inkey()<>27 to i
        if lastkey()<>27
          @ 24,20 say ltrim(str(i)) + " items found, press any key to return..."
          inkey(0)
        endif
      case answer="L"
        clear
        ?? heading
        i=0
        do while !eof()
          if &condition
            if row()+mlcount(&vars,80)>=24
              @ 23,79 say ""
              wait "Press Esc to quit, any other key to continue..."
              if lastkey()=27
                return
              endif
              clear
              ?? heading
            endif
            ? &vars
            i=i+1
            if inkey()=27
              return
            endif
          endif
          skip
        enddo
        wait ltrim(str(i));
          + " items found, press P to print or any other key to return...";
          to answer
        if answer$"Pp"
          goto top
          do printlist
        endif
      case answer="P"
        do printlist
      case answer="T"
        do tabulate with condition
    endcase
  endif



procedure printlist

*       -       print a list of items.

  @ 20,0
  if .not.ft_isprint(printdbk)
    @ 24,0 clear
    @ 24,8 say "The printer is not connected properly,";
      +" press any key to return..."
    ?? bel
    do while .not.ft_isprint(printdbk)
      if inkey()<>0
        return
      endif
    enddo
    @ 24,0 clear
  endif
  set printer to (printdbk)
  set printer on
  set device to printer
  ?? expansion(presetbk)
  if len(heading)>80.and.(at(cr,heading)=0.or.at(cr,heading)>=80)
    ?? expansion(prwidebk)
  endif
  clear
  ?? heading
  ?
  i=0
  do while !eof()
    if &condition
      ? &vars
      i=i+1
      if inkey()=27
        return
      endif
    endif
    skip
  enddo
  ?
  ? ltrim(str(i)) + " item reports printed."
  eject
  set printer off
  set device to screen
  set printer to



procedure tabulate

  parameter condition

  declare fields[fcount()],strings[0],numbers[0]

  condition=iif(condition=NIL,".T.",condition)
  total=0
  nstring=0
  maxlen=0
  clear
  afields(fields)
  aadd(fields,"expression")
  centre(0,"Choose a field")
  @ 2,33 to 22,46
  centre(24,"Arrow keys, PgDn, PgUp move, Enter selects, Esc quits.")
  string=fieldname(achoice(3,35,21,44,fields))
  if empty(string)
    string=space(255)
    do while !(type(string)$"CNDLM").and.lastkey()<>27
      @ 24,0 clear
      @ 24,0 say "Enter an expression .." get string picture "@S60"
      read
    enddo
    string=alltrim(string)
  endif
  if lastkey()<>27
    clear
    @ 12,0 say "Tabulating "+string+" "
    do while !eof().and.inkey()<>27
      if &condition
        value=iif(type(string)$"CNDLM";
          ,left(memotran(transform(&string,"@!")," "," "),60),"<no value>")
        i=ascan(strings,value)
        if i=0
          aadd(strings,value)
          aadd(numbers,0)
          nstring=nstring+1
          i=nstring
        endif
        numbers[i]=numbers[i]+1
        total=total+1
        maxlen=max(maxlen,len(value))
        ?? "*"
      else
        ?? "."
      endif
      skip
    enddo
    if total=0
      clear
      centre(12,"No items found, press any key...")
      inkey(0)
      return
    endif
    for i=1 to nstring
      strings[i]=padr(strings[i],maxlen)+" "+str(numbers[i],7)+"  ";
        +str(100*numbers[i]/total,5,1)+"%"
      numbers[i]=""
    next i
    asort(strings,1,nstring)
    aadd(strings," ")
    aadd(strings,padr("TOTAL:",maxlen)+" "+str(total,7)+"  100.0%")
    clear
    maxlen=len(strings[1])
    centre(0,"Values of "+string+".")
    centre(24,"Arrow keys, PgDn, PgUp move, Enter continues, Esc quits.")
    @ 1,38-(maxlen/2) to 23,41+(maxlen/2)
    achoice(2,40-(maxlen/2),22,39+(maxlen/2),strings)
    if lastkey()<>27
      @ 24,0 clear
      centre(24,"Print this listing (Y/N) ? .. ")
      if chr(inkey(0))$"Yy"
        if .not.ft_isprint(printdbk)
          @ 24,0 clear
          @ 24,8 say "The printer is not connected properly,";
            +" press any key to return..."
          ?? bel
          do while .not.ft_isprint(printdbk)
            if inkey()<>0
              return
            endif
          enddo
          @ 24,0 clear
        endif
        set printer to (printdbk)
        set printer on
        ?? expansion(presetbk)
        clear
        ? "Values of "+string+" from "+prog+"data.dbf."
        ?
        for j=1 to nstring+2
          ? strings[j]
        next j
        clear
        eject
        set printer off
        set printer to
      endif
    endif
  endif



FUNCTION BldQuery

*       Guide the user through building a condition.
*       Based on code by Ed Phillips

  STATIC i := 1, nSel := 1, connector, working:=.T.
  PRIVATE cond:="", lFirst:=.T., cLastChr:="", ok:=.T.
  PRIVATE xValue, op, fname[fcount()], ftype[fcount()], flength[fcount()]

  afields(fname,ftype,flength)

  clear

  @ 0,0 TO 23,79 DOUBLE
  @ 0,32 say " Query Builder "

  ok = .t.
  working := .t.
  @ 17,8 TO 22,71
  @ 17,31 SAY ' Query Definition '

  WHILE working
    connector := xValue := ''

    *---------------------
    * Get the "field name"
    *---------------------

    @ 1,1 clear to 16,78
    @ 2,34 to min(15,3+len(fname)),45
    nSel = achoice(3,35,14,44,fname,.T.,,nSel)

    IF nSel = 0
      EXIT
    ENDIF                                         && IF nSel = 0

    BEGIN SEQUENCE

      *-------------------
      * Get the "operator"
      *-------------------
      op = OpBox(fname[nSel])

      IF Empty(op)
        ok = .f.
        working = .f.
        BREAK
      ENDIF                                      && IF Empty(op)

      *-----------------------------
      * Get the "value" of the field
      *-----------------------------
      ValInit('xValue', ftype[nSel], flength[nSel])

      IF ftype[nSel] <> 'L'
        @ 1,1 clear to 16,78
        @ 8,34-len(transform(xValue,"@!"))/2;
          to 10,45+len(transform(xValue,"@!"))/2
        @ 9,36-len(transform(xValue,"@!"))/2;
          SAY 'Value =' GET xValue picture "@!"
        READ
      ENDIF

      IF lastkey()=27
        ok = .f.
        working := .f.
        BREAK
      ENDIF

      *----------------
      * Build condition
      *----------------
      cond += Condition(op, fname[nSel], xValue, ftype[nSel])
      Saymemo(cond,18,10,59,4)

      *----------------------------
      * Get the logical "connector"
      *----------------------------
      connector = AndOrExit(6,34)

      IF alltrim(upper(connector)) = 'DONE'
        working = .f.
        BREAK
      ENDIF                                   && IF Upper(connector) = 'DONE'

      cond += connector                       && add connector to condition
      Saymemo(cond,18,10,59,4)
    END
  ENDDO                                       && DO WHILE .T.

  IF !Empty(cond)
    cond += cLastChr
    cond := Trim(cond)

    i := At( '.OR. (  )', cond )
    IF i > 0
      cond := Subs(cond, 1, i-1 )
    ENDIF                                      && IF i > 0

    i := At( '.AND. (  )', cond )
    IF i > 0
      cond := Subs(cond, 1, i-1 )
    ENDIF                                      && IF i > 0

    IF Right(cond, 1) == '.'
      cond := Subs(cond, 1, Len(cond)-5)
    ENDIF
  ENDIF                                         && IF !Empty(cond)

  Saymemo(cond,18,10,59,4)

RETURN (cond)



FUNCTION OpBox(cFname)
  LOCAL ret_val := Space(3), nSel := 0, cFtype
  LOCAL aOpList := {}, nWinWidth := 24, aOperator := {}

  cFtype := type(cFname)

  DO CASE

    CASE cFtype = 'L'
      Aadd( aOpList, 'True    ' ); Aadd( aOperator, '='   )
      Aadd( aOpList, 'Not True' ); Aadd( aOperator, 'NOT' )
      nWinWidth := 18

    CASE cFtype $ 'N'
      Aadd( aOpList, 'Equal to                ' ); Aadd( aOperator, '='  )
      Aadd( aOpList, 'Less than               ' ); Aadd( aOperator, '<'  )
      Aadd( aOpList, 'Greater than            ' ); Aadd( aOperator, '>'  )
      Aadd( aOpList, 'Less than or equal to   ' ); Aadd( aOperator, '<=' )
      Aadd( aOpList, 'Greater than or equal to' ); Aadd( aOperator, '>=' )
      Aadd( aOpList, 'Not equal to            ' ); Aadd( aOperator, '#'  )

    CASE cFtype $ 'D'
      Aadd( aOpList, 'Equal to    ' ); Aadd( aOperator, '='  )
      Aadd( aOpList, 'Before      ' ); Aadd( aOperator, '<'  )
      Aadd( aOpList, 'After       ' ); Aadd( aOperator, '>'  )
      Aadd( aOpList, 'Before or on' ); Aadd( aOperator, '<=' )
      Aadd( aOpList, 'After or on ' ); Aadd( aOperator, '>=' )
      Aadd( aOpList, 'Not equal to' ); Aadd( aOperator, '#'  )

    CASE cFtype $ 'CM'
      Aadd( aOpList, 'Equal to          ' ); Aadd( aOperator, '='  )
      Aadd( aOpList, 'Before            ' ); Aadd( aOperator, '<'  )
      Aadd( aOpList, 'After             ' ); Aadd( aOperator, '>'  )
      Aadd( aOpList, 'Before or equal to' ); Aadd( aOperator, '<=' )
      Aadd( aOpList, 'After or equal to ' ); Aadd( aOperator, '>=' )
      Aadd( aOpList, 'Not equal to      ' ); Aadd( aOperator, '#'  )
      Aadd( aOpList, 'Contains          ' ); Aadd( aOperator, '$'  )
      Aadd( aOpList, 'Does not contain  ' ); Aadd( aOperator, '!$' )

   ENDCASE                                 && DO CASE

   @ 1,1 clear to 16,78
   @ 4,39-len(aOplist[1])/2 to 5+len(aOpList),41+len(aOplist[1])/2
   nSel = achoice(5,40-len(aOplist[1])/2,15,40+len(aOplist[1])/2,aOpList,.T.)
   IF nSel != 0
     ret_val := aOperator[nSel]
   ENDIF                                   && IF nSel != 0
RETURN (ret_val)



PROCEDURE ValInit(var,type,len)
  LOCAL work

  DO CASE
    CASE type = 'D'
      &var = CTOD([])

    CASE type = 'C'
      &var = Space(min(len,60))

    CASE type = 'M'
      &var = Space(60)

    CASE type = 'N'
      &var = 0

    CASE type = 'L'
      &var = If( M->op == 'NOT', 'False', 'True' )

  ENDCASE
RETURN



FUNCTION Condition(op, cField, cVal, cType)
  LOCAL ret_val

  DO CASE

    CASE op == '$'
      if cType=='M'
        ret_val := "'"+Trim(cVal)+"'"+'$strtran(upper('+Trim(cField)+'),sr)'
      else
        ret_val := "'" + Trim(cVal) + "'" + '$upper(' + Trim(cField) +')'
      endif

    CASE op == '!$'
      if cType='M'
        ret_val := "!('"+Trim(cVal)+"'"+'$strtran(upper('+Trim(cField)+'),sr))'
      else
        ret_val := "!('" + Trim(cVal) + "'" + '$upper(' + Trim(cField) + '))'
      endif

    CASE cType == 'D'
      ret_val := Trim(cField) + op + 'Ctod("' + Dtoc(cVal) + '")'

    CASE cType == 'N'
      ret_val := Trim(cField) + op + Ltrim(Str(cVal))

    CASE cType == 'C' .OR. cType == 'M'
      ret_val := 'upper(' + Trim(cField) + ')' + op + '"' + Trim(cVal) + '"'

    CASE cType == 'L'
      IF op == 'NOT'
        ret_val := '.NOT.' + Trim(cField)
      ELSE
        ret_val := Trim(cField)
      ENDIF

    OTHERWISE
      ret_val := ''

  ENDCASE
RETURN ( ret_val )



FUNCTION AndOrExit(nRow, nCol)

  STATIC menuSet

  LOCAL ret_val := 'Done', item := 0, aMenuItems := {}, savscrn, nBot

  IF lFirst
    menuSet := 1
    lFirst := .f.
  ENDIF

  nBot := nRow + 5

  Aadd( aMenuItems, '  Done' )
  Aadd( aMenuItems, ' .AND. ' )
  Aadd( aMenuItems, ' .OR. ' )
  IF menuSet == 1
    Aadd( aMenuItems, ' .AND. (' )
    Aadd( aMenuItems, ' .OR. (' )
  ELSE
    Aadd( aMenuItems, ') .AND. ' )
    Aadd( aMenuItems, ') .OR. ' )
  ENDIF                                         && IF menuSet == 1

  @ 1,1 clear to 16,78
  @ nRow-1, nCol to nBot, nCol+11

  item := Achoice( nRow, nCol+2, nBot, nCol+9, aMenuItems, .t.)
  @ nRow-1,nCol clear to nBot,nCol+11
  IF item != 0
    ret_val = aMenuItems[item]

    IF item > 3
      cLastChr := If( Right(ret_val, 1) == "(", ")", " " )
      menuSet++
      menuSet := If( menuSet > 2, 1, menuSet )
    ENDIF

  ENDIF                                        && IF item != 0

RETURN (ret_val)



FUNCTION SayMemo(cstring, t, l, w, num_ln)
   LOCAL x := 1, i

   t = Max(0, t-1)
   FOR i = 1 TO num_ln
      @ t+x, l SAY Memoline(cstring,w,i)
      x++
   NEXT                                          && FOR i = 1 TO num_ln
RETURN (NIL)



procedure centre

parameters line,string

  @ line,40-(len(string)/2) say string



procedure help

*       help    -   called by pressing F1, gives help during input.

  parameters cproc,line,var
  if cproc="HELP".or.cproc=="EQPTPROG".or.cproc=="SUMM".or.cproc=="XTRA"
    return
  endif
  if !var==""
    do helpread
  endif



procedure helpmemo

*       provide help at the memo editing screen.

  parameters cproc,line,var

  if !cproc=="HELPMEMO"
    save screen
    @ 0,0 clear
    centre(4,"Press the space bar to return, then")
    centre(6,"type your comments on the report")
    @ 9,15 say "Use"
    @  9,25 say "   Up arrow  to   Move up"
    @ 10,25 say " Down arrow  to   Move down"
    @ 11,25 say " Left arrow  to   Move left"
    @ 12,25 say "Right arrow  to   Move right"
    @ 13,25 say "        Del  to   Delete"
    @ 14,25 say "       Home  for  Start of line"
    @ 15,25 say "        End  for  End of line"
    @ 16,25 say "        Ins  for  Insert mode"
    @ 17,25 say "     Cntl-T  to   Delete a word"
    @ 18,25 say "     Cntl-Y  to   Delete a line"
    @ 19,25 say "        F10  to   Save changes"
    @ 20,25 say "        Esc  to   Scrap changes"
    wait space(39)
    restore screen
  endif



procedure helpview

*       provide help at the memo editing screen in view mode.

  parameters cproc,line,var

  if !cproc=="HELPVIEW"
    save screen
    @ 0,0 clear
    centre(4,"Press the space bar to return, then")
    @  7,15 say "Use"
    @  7,25 say "   Up arrow  to   Move up"
    @  9,25 say " Down arrow  to   Move down"
    @ 11,25 say "       PgDn  to   Page down"
    @ 13,25 say "       PgUp  to   Page up"
    @ 15,25 say "  Cntl-PgDn  to   Go to end"
    @ 17,25 say "  Cntl-PgUp  to   Go to start"
    @ 19,25 say "      Enter  to   Exit"
    wait space(39)
    restore screen
  endif



procedure helpread

*       provide help from any get.

    save screen
    @ 0,0 clear
    centre(6,"Press the space bar to return, then")
    do case
      case var=="CAT"
        centre(12,"type the catalog number")
      case var=="ITEM"
        centre(12,"type the item description")
      case var=="PURCH"
        centre(12,"type the date this item was purchased")
      case var=="PRICE"
        centre(12,"type the purchase price of this item")
      case var=="MANUF"
        centre(12,"type the name of the manufacturer")
      case var=="SUPPL"
        centre(12,"type the name of the supplier")
      case var=="ORDER"
        centre(12,"type the order number for this item")
      case var=="SERIAL"
        centre(12,"type the serial number of this item")
      case var=="NUM"
        centre(12,"type the record number for the desired item")
      case var=="CATN"
        centre(12,"type the catalog number of the desired item")
      case var=="FMANUF"
        centre(11,"type the maunfacture to search for")
        centre("(or press Enter to see all items)")
      case var="FUNC"
        centre(12,"type the string for that function key")
      case var=="AC"
        centre(12,"type the string for this account")
      case var=="PRESETBK"
        centre(10,"type the escape sequence to eject and reset the printer")
        centre(12,'eg. [esc]E     for HP laserjet')
        centre(14,'    [ff][esc]@ for Epson LX')
      case var=="PRREPOBK"
        centre(12,"type the escape sequence to set up the printer for item details")
      case var=="PRWIDEBK"
        centre(10,"type the escape sequence to give 132 character width")
        centre(12,'eg. [esc]&l1O[esc]&k10H      for HP laserjet')
        centre(14,'    [chr(15)]                for Epson LX')
      case var=="PRINTDBK"
        centre(12,"enter the device to print to (one of LPT1, LPT2, LPT3, COM1, COM2 or NUL)")
      case var=="BACKUPBK"
        centre(4,"Do you want automatic backups?")
        @ 11,30 say "type  Y  for  Yes"
        @ 13,30 say "  or  N  for  No"
      case var=="DATETYBK"
        centre(4,"What date format do you want?")
        @ 11,28 say "type  A  for  American"
        @ 13,28 say "  or  B  for  British"
      case var=="CURNCYBK"
        centre(12,"type the currency symbol to use ($, , , etc.)")
      case var=="XVALUE"
        centre(12,"type the value to compare with")
    endcase
    centre(18,"and press the Enter key.")
    wait space(39)
    restore screen
