#ifndef YAKLIST.H
#define YAKLIST.H

#include <stddef.h>
#include "stddefs.h"

class pyListNode
{
public:
	pyListNode * pnNext;
	pyListNode * pnPrev;
	yakObject * pyData;
	pyListNode(yakObject * pyThisData, pyListNode * pnNextNode);//inserts before nextNode
	pyListNode();
	virtual ~pyListNode(void);
};

class pyList
{
public:
	pyListNode nHead;
	pyListNode nTail;
	int iNumberInList;
	pyList();
	virtual ~pyList(void);
	yakObject * pyHeadData();
	yakObject * pyTailData();
	void addHead(yakObject * pyNewData);
	void addTail(yakObject * pyNewData);
	void addNode(pyListNode * pnNextNode);
	void removeTail();
	void removeHead();
	void remove(yakObject * pyOldData, int iTemporary = 0);
	void emptyList(int iTemporary = 0);
	int iIsEmpty(void);
};

class pyListIterator
{
public:
	pyList * pLMyList;
	pyListNode * pnThisNode;
	int iLooped;
	void initialize(pyList & rLFromList);
	pyListIterator(pyList & rLFromList);
	pyListIterator() {pLMyList = NULL; pnThisNode = NULL; iLooped = 0;}
	inline operator int();
	inline operator char();
	inline yakObject * pyCurrent();
	yakObject * operator ++();
	yakObject * operator --();
	void setToHead();
	void setToTail();
};

template <class T> class ptListIterator : public pyListIterator
{
public:
	T * ptCurrent() {return (T *)(pnThisNode->pyData);};
	ptListIterator(pyList & rLFromList) : pyListIterator(rLFromList) {};
};

#endif