
/* IPAS 3 Test Program		*/
/* New PXP Functionality	*/
/* by Tom Hudson 9/19/93	*/

/* PXP process raw client routine core code */

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "pxp.h"

extern char gp_buffer[];

/* Variable definitions */

/************************/

/* Dialog description */

DlgEntry cdialog[]={
	0,"TITLE=\"Autodesk 3D Studio IPAS 3 Test PXP\"",
	0,"TITLE=\"Demonstrates new PXP Database Functionality\"",
	0,"TITLE=\"by Tom Hudson, Version 0.2\"",
	0,"TITLE=\"\"",
	0,NULL
	};

/* Version test value */

#define VERSION 0x4273
	
typedef struct {
	ulong version;
	} State;

/* the "state" struct MUST start with a "ulong" which is the version#,
	to prevent using data from old versions of this program.
	This verification is performed automatically. */

static State init_state = { VERSION };
static State state = { VERSION };

int objects;

typedef struct
	{
	char name[11];
	void *next;
	} Namelist;

typedef struct
	{
	ItemData data;
	XVData *verts;
	XFData *faces;
	Namelist *names;
	void *next;
	} Items;
Items *itemlist=NULL;

typedef struct
{char *text;
int length;
int bufsize;
int cursor;
} Document;

static Document doc1={NULL,0,0,0};
static TextEd DocIO=
	{(char _far *)NULL,0,0,0,0,(void _far *)NULL,0,(void _far *)NULL};

/*----------------------------------------------------------------*/

int ClientUsesInitDialog(void) {
	return(1);
	}

void ClientSetStateVar(int id, void *ptr) {
	OVL o;
	ulong *ul;
	char *s;

	ul=(ulong *)ptr;
	s=(char *)ptr;
	o.ul = *ul;
	switch(id) {
		}
	}

ulong ClientGetStateVar(int id) {
	OVL o;
	switch(id) {
		}
	return(o.ul);
	}

int ClientVarSize(int id)
	{
	switch(id)
		{
		default:
			return(1);
		}
	}

char  *ClientGetState(int *size) {
	*size = sizeof(State);
	return((char *)&state);
	}

void ClientResetState() {	
	state = init_state;	
	}

void ClientStartup(EXPbuf *buf) {
	int version=studio_version();

	/* Patch 3DS 3.00 for light local shadow flag */
	if(version==300)
		patch_light_shadow_flags();

	sprintf(buf->data.string,"Detected 3DS version %d.%d",
		version/100,version-(version/100)*100);
	buf->opcode=EXP_CONTINUE;
	if(version<300)
		buf->usercode=EXP_TERMINATE;
	else
		buf->usercode=0x0200;
	}

/* User routines -- use user codes to process your data */

void ClientUserCode(EXPbuf *buf)
	{
	switch(buf->usercode)
		{
		case 0x0200:
			if(grab_editor_data()==1)
				{
				generate_report();
				delete_all_objects();
				reload_editor_data();
				}
			free_editor_data();
			buf->opcode=EXP_TERMINATE;
			buf->usercode=EXP_TERMINATE;
			break;
		default:
			terminate:
			buf->opcode=buf->usercode=EXP_TERMINATE;
			buf->status=0;
			break;
		}
	}

void ClientTerminate(void) { 
	/* free any data structures, etc. */
	}

DlgEntry *ClientDialog(int n) {	
	return(&cdialog[n]); 
	}

/* Format your floating-point strings */

void
ClientFormatString(int id,float value,char *string)
{
switch(id)
 {
 }
}

int
ClientIsUniversal()
{
return(0);
}

Items *
alloc_new_item(void)
{
Items *i;
if((i=malloc(sizeof(Items)))==NULL)
 return(NULL);
i->verts=NULL;
i->faces=NULL;
i->names=NULL;
i->next=itemlist;
itemlist=i;
return(i);
}

grab_editor_data()
{
int ix,status;
Items *i;

pxp_get_item_count(objects);
if(objects<0)
	return(-1);
for(ix=0; ix<objects; ++ix)
	{
	if((i=alloc_new_item())==NULL)
		{
		gfx_continu_line("Not enough memory for all items");
		return(0);
		}
	pxp_get_item(ix,&i->data,status);
	if(status!=1)
		{
		gfx_continu_line("Error getting item");
		return(0);
		}
	}
return(1);
}

generate_report()
{
int mix;
char mtlname[17];
Items *i=itemlist;
init_document(&doc1);
sprintf(gp_buffer,"%d Items in 3DS Editor:",objects);
add_document_line(&doc1,gp_buffer);
gfx_stand_by("Downloading Editor Database");

/* Report on materials used */

add_document_line(&doc1,"3DS Materials list:");
mix=0;

mtl_loop:
gfx_mtl_name(mix,mtlname);
if(strlen(mtlname))
 {
 sprintf(gp_buffer,"	%d:[%s]",mix,mtlname);
 add_document_line(&doc1,gp_buffer);
 mix++;
 goto mtl_loop;
 }
if(mix==0)
 add_document_line(&doc1,"No materials in use");

while(i)
	{
	ItemData *id = &i->data;
	sprintf(gp_buffer,"Item: [%s], Type:",id->name);
	switch(id->type)
		{
		case PXPMESH:
			strcat(gp_buffer,"Mesh");
			add_document_line(&doc1,gp_buffer);
#define msh id->item.m
			sprintf(gp_buffer,"	Flags:%X",msh.flags);
			add_document_line(&doc1,gp_buffer);
			if(build_mesh_data(id)==1)
				{
				int ix;
				sprintf(gp_buffer,"	Verts:%d Tverts:%d Faces:%d Color:%d",
					msh.verts,msh.tverts,msh.faces,msh.color);
				add_document_line(&doc1,gp_buffer);
				add_document_line(&doc1,"	Matrix:");
#define mm msh.matrix
				for(ix=0; ix<4; ++ix)
					{
					sprintf(gp_buffer,"		%.2f %.2f %.2f",
						mm[ix][0],mm[ix][1],mm[ix][2]);
					add_document_line(&doc1,gp_buffer);
					}
#undef mm
				sprintf(gp_buffer,"	Mins: %.2f %.2f %.2f",
					msh.mins[0],msh.mins[1],msh.mins[2]);
				add_document_line(&doc1,gp_buffer);
				sprintf(gp_buffer,"	Maxs: %.2f %.2f %.2f",
					msh.maxs[0],msh.maxs[1],msh.maxs[2]);
				add_document_line(&doc1,gp_buffer);
				}
			else
				add_document_line(&doc1,"*** Error getting mesh geometry data ***");
#undef msh
			break;
		case PXPAMBIENT:
			strcat(gp_buffer,"Ambient");
			add_document_line(&doc1,gp_buffer);
#define amb id->item.a
			sprintf(gp_buffer,"	Color:%.2f %.2f %.2f",
				amb.color.r,amb.color.g,amb.color.b);
			add_document_line(&doc1,gp_buffer);
#undef amb
			break;
		case PXPLIGHT:
			strcat(gp_buffer,"Light");
			add_document_line(&doc1,gp_buffer);
			if(build_light_exclusion(i)==1)
				{
				Namelist *n=i->names;
#define lt id->item.l
				sprintf(gp_buffer,"	Flags:%X",lt.flags);
				add_document_line(&doc1,gp_buffer);
				if(lt.hotsize<180.0)
					{
					add_document_line(&doc1,"	Spotlight");
					sprintf(gp_buffer,"	Pos:%.2f %.2f %.2f  Target:%.2f %.2f %.2f",
						lt.x,lt.y,lt.z,lt.tx,lt.ty,lt.tz);
					add_document_line(&doc1,gp_buffer);
					sprintf(gp_buffer,"	Hotspot:%.2f Falloff:%.2f Bank:%.2f Aspect:%.2f",
						lt.hotsize,lt.fallsize,lt.bank,lt.aspect);
					add_document_line(&doc1,gp_buffer);
					sprintf(gp_buffer,"	Color:%.2f %.2f %.2f Multiplier:%.2f",
						lt.color.r,lt.color.g,lt.color.b,lt.mult);
					add_document_line(&doc1,gp_buffer);
					sprintf(gp_buffer,"	Near:%.2f  Far:%.2f",
						lt.in_range,lt.out_range);
					add_document_line(&doc1,gp_buffer);
					sprintf(gp_buffer,"	Bias:%.2f Shadfilter:%.2f Shadsize:%d",
						lt.bias,lt.shadfilter,lt.shadsize);
					add_document_line(&doc1,gp_buffer);
					sprintf(gp_buffer,"	Ray Bias:%.2f",lt.ray_bias);
					add_document_line(&doc1,gp_buffer);
					sprintf(gp_buffer,"	Projected image:[%s]",lt.imgfile);
					add_document_line(&doc1,gp_buffer);
					}
				else
					{
					add_document_line(&doc1,"	Omnilight");
					sprintf(gp_buffer,"	Pos:%.2f %.2f %.2f",lt.x,lt.y,lt.z);
					add_document_line(&doc1,gp_buffer);
					sprintf(gp_buffer,"	Color:%.2f %.2f %.2f Multiplier:%.2f",
						lt.color.r,lt.color.g,lt.color.b,lt.mult);
					add_document_line(&doc1,gp_buffer);
					sprintf(gp_buffer,"	Near:%.2f  Far:%.2f",
						lt.in_range,lt.out_range);
					add_document_line(&doc1,gp_buffer);
					}
				if(n)
					{
					while(n)
						{
						sprintf(gp_buffer,"	Excluded:[%s]",n->name);
						add_document_line(&doc1,gp_buffer);
						n=n->next;
						}
					}
				else
					add_document_line(&doc1,"	No objects excluded");
					
				}
			else
				add_document_line(&doc1,"*** Error getting light exclusion data ***");
#undef lt
			break;
		case PXPCAMERA:
			strcat(gp_buffer,"Camera");
			add_document_line(&doc1,gp_buffer);
#define cam id->item.c
			sprintf(gp_buffer,"	Flags:%X",cam.flags);
			add_document_line(&doc1,gp_buffer);
			sprintf(gp_buffer,"	Pos:%.2f %.2f %.2f  Target:%.2f %.2f %.2f",
				cam.x,cam.y,cam.z,cam.tx,cam.ty,cam.tz);
			add_document_line(&doc1,gp_buffer);
			sprintf(gp_buffer,"	Focal:%.2f  Bank:%.2f",cam.focal,cam.bank);
			add_document_line(&doc1,gp_buffer);
			sprintf(gp_buffer,"	Near:%.2f  Far:%.2f",
				cam.nearplane,cam.farplane);
			add_document_line(&doc1,gp_buffer);
#undef cam
			break;
		}
	i=i->next;
	}
add_document_line(&doc1,"End of Report");
gfx_put_hole();
edit_document(&doc1);
free_document(&doc1);
}

init_document(Document *d)
{
d->text=malloc(50000);
strcpy(d->text,"\r\n");
d->length=2;
d->bufsize=50000;
d->cursor=0;
}

add_document_line(Document *d,char *text)
{
strcat(d->text,text);
strcat(d->text,"\r\n");
d->length+=(strlen(text)+2);
}

free_document(Document *d)
{
if(d->text)
 free(d->text);
d->length=0;
d->bufsize=0;
d->cursor=0;
}

edit_document(Document *d)
{
int result,start_code;
TextEd _far *docout;
char *newtext;

start_code=TEX_STARTUP;

DocIO.text=(char _far *)d->text;
DocIO.length=d->length;
DocIO.bufsize=d->bufsize;
DocIO.cursor=d->cursor;
DocIO.dropct=0;
DocIO.toolct=0;

gfx_text_editor(&DocIO,docout,start_code,result);
switch(result)
 {
 case TEX_FAILED:
  gfx_continu_line("Text editor failed");
  return;
 case TEX_CLOSED:
  if((newtext=malloc(50000))==NULL)
   {
   gfx_continu_line("No RAM for revised document");
   }
  else
   {
   if(d->text)
    free(d->text);
   d->text=newtext;
   far_to_near(d->text,docout->text,docout->length);
   d->length=docout->length;
   d->bufsize=50000;
   d->cursor=docout->cursor;
   }
  break;
 default:
  gfx_continu_line("Error, got editor callback");
  break;
 }
}

delete_all_objects()
{
int status;
Items *i=itemlist;
gfx_stand_by("Deleting all objects");
while(i)
	{
	ItemData *id = &i->data;
	pxp_delete_item(id->name,status);
	i=i->next;
	}
gfx_put_hole();
gfx_redraw();
}

reload_editor_data()
{
int status;
Items *i=itemlist;
gfx_stand_by("Reloading all objects");
while(i)
	{
	ItemData *id = &i->data;
	pxp_create_item(id,status);
	if(status==1)
		{
		switch(id->type)
			{
			case PXPMESH:
				/* Send the mesh geometry data */
#define msh id->item.m
				pxp_set_verts(id->name,msh.verts,msh.tverts,status)
				if(status!=1)
					{
					cant_make_geometry:
					sprintf(gp_buffer,"Can't create geometry for [%s]",id->name);
					gfx_continu_line(gp_buffer);
					break;
					}
				pxp_set_faces(id->name,msh.faces,status)
				if(status!=1)
					goto cant_make_geometry;
				pxp_put_verts(id->name,0,msh.verts,i->verts,status);
				if(status!=1)
					{
					geometry_error:
					sprintf(gp_buffer,"Can't put geometry for [%s]",id->name);
					gfx_continu_line(gp_buffer);
					break;
					}
				pxp_put_faces(id->name,0,msh.faces,i->faces,status);
				if(status!=1)
					goto geometry_error;
#undef msh
				break;
			case PXPLIGHT:

				/* TEST -- Force light to local control, these settings */
				id->item.l.flags |= LIGHT_LOCAL;
				id->item.l.shadsize=400;
				id->item.l.ray_bias=4.44;
				id->item.l.shadfilter=3.33;
				id->item.l.bias=2.22;
				pxp_change_item(id,status);
				/* END OF TEST */

				pxp_clear_excluded(id->name,status);
				if(status!=1)
					{
					sprintf(gp_buffer,"Error clearing exclusion for [%s]",id->name);
					gfx_continu_line(gp_buffer);
					break;
					}
				if(i->names)
					{
					Namelist *n=i->names;
					while(n)
						{
						pxp_add_excluded(id->name,n->name,status)
						if(status!=1)
							{
							sprintf(gp_buffer,"Error adding exclusion for [%s]/[%s]",id->name,n->name);
							gfx_continu_line(gp_buffer);
							break;
							}
						n=n->next;
						}
					}
#undef lt
				break;
			}
		}
	else
		{
		sprintf(gp_buffer,"Failed to create [%s], code:%d",id->name,status);
		gfx_continu_line(gp_buffer);
		}
	i=i->next;
	}
gfx_put_hole();
gfx_redraw();
}

free_editor_data()
{
Items *i=itemlist,*ni;
while(i)
	{
  if(i->verts)
   free(i->verts);
  if(i->faces)
   free(i->faces);
  free_name_list(i->names);
	ni=i->next;
	free(i);
	i=ni;
	}
itemlist=NULL;
}

int
build_light_exclusion(Items *i)
{
int ix,count,status;
Namelist *n;
char ename[11];
ItemData *id = &i->data;

if(id->type!=PXPLIGHT)
 return(0);
pxp_get_exclude_count(id->name,count);
for(ix=0; ix<count; ++ix)
 {
 pxp_get_excluded(id->name,ix,ename,status);
 if(status!=1)
  return(-1);
 if((n=malloc(sizeof(Namelist)))==NULL)
  return(-2);
 strcpy(n->name,ename);
 n->next=i->names;
 i->names=n;
 }
return(1);
}

int
build_mesh_data(Items *i)
{
int status;
ItemData *id = &i->data;

if(id->type!=PXPMESH)
 return(0);

#define msh id->item.m
if((i->verts=malloc(msh.verts*sizeof(XVData)))==NULL)
 return(-1);
pxp_get_verts(id->name,0,msh.verts,i->verts,status);
if(status!=1)
 return(-2);
if((i->faces=malloc(msh.faces*sizeof(XFData)))==NULL)
 return(-1);
pxp_get_faces(id->name,0,msh.faces,i->faces,status);
if(status!=1)
 return(-3);
#undef msh

return(1);
}

free_name_list(Namelist *n)
{
Namelist *nn;
while(n)
 {
 nn=n->next;
 free(n);
 n=nn;
 }
}

/************************************************************************/
/************************************************************************/
/************************************************************************/

/*
        Register Structure
*/

#define ULONG unsigned long
#define USHORT unsigned short
typedef struct
{
    ULONG eax;
    ULONG ebx;
    ULONG ecx;
    ULONG edx;
    ULONG esi;
    ULONG edi;
    ULONG ebp;
    ULONG esp;
    USHORT cs;
    USHORT ds;
    USHORT es;
    USHORT fs;
    USHORT gs;
    USHORT ss;
    ULONG eip;
    ULONG eflags;
} REGS;

struct overlay { int offset; short seg; };

patch_light_shadow_flags()
{
short _far *flag1;
short _far *flag2;
short _far *flag3;
((struct overlay *)&flag1)->seg=((REGS _far *)GI->regs)->ds;
((struct overlay *)&flag1)->offset=0x13c091;
((struct overlay *)&flag2)->seg=((REGS _far *)GI->regs)->ds;
((struct overlay *)&flag2)->offset=0x13c476;
((struct overlay *)&flag3)->seg=((REGS _far *)GI->regs)->ds;
((struct overlay *)&flag3)->offset=0x13c7a5;
*flag1= *flag2= *flag3=
	(LIGHT_ON|LIGHT_SHAD|LIGHT_LOCAL|LIGHT_CONE|LIGHT_RECT|LIGHT_PROJ|LIGHT_OVER|LIGHT_ATTEN|LIGHT_RAYTR);
}

/************************************************************************/
/************************************************************************/
/************************************************************************/

