#include <stdlib.h>;
#include <stdio.h>;
#include "vga18.h";

#define uchar unsigned char
#define VGA256 19
#define VGA18 18
#define TEXTMODE 3

FILE *FP;
int *AUTOMATON;              /* Pointer on buffer for automaton */
char *BLOCKSAVE;             /* Pointer on buffer for screen block */
int AUTMAX;                  /* Number of entries in automaton */
int SPRMAX;                  /* Number of sprites in table */

/*
  you don't need to have the three following lines if
  you include MCGALIB.OBJ into the project...
*/

unsigned long *SPVECTOR;
char  *SPCODE;
unsigned int VGASCREEN=0xA000;


void changext(char *name,char *ext);
void putsxyf(int x,int y,char *fmt, ... );
int bload(char *fname,char *adr,int siz);
int getcode(int n);
void putpic(int num,int x,int y);
void putscenery(int num,int x,int y);
int autload(char *name);
int sprload(char *name);
int spralloc();

/* Function to add or replace extension of filenames */

void changext(char *name,char *ext)
{
int l;

l=min( strcspn(name,".") , 8);
*(name+l)=0;
strcat(name,ext);
}

/* Displays a formatted text string */

void putsxyf(int x,int y,char *fmt, ... )
{
 char STRBUF19[81];

 va_list  argptr;
 va_start( argptr, format );
 vsprintf(STRBUF19, fmt, argptr );
 putsxy(x,y,STRBUF19);
 va_end( argptr );
}

/* Function to read the graph of an automaton */

int autread(int i)
{
return ( *(AUTOMATON+i));
}

/* Function to get a sprite type code */

int getcode(int n)
{
char *adr=getspadr18(n);  return((int)*(adr+4));
}

/* Error message for loading function */

int puterr(char *name)
{
putsxyf(5,5,">>> Disk error #:%d, File %s",ferror(FP),name);
return(0);
}

/* Function for loading any binary file */

int bload(char *fname,char *adr,int siz)
{
 if((FP=fopen(fname,"rb"))==0L) return( puterr(fname)) ;
 fread((char *)adr,siz,1,FP);
 fclose(FP);
 return(1);
}

/* Function for loading an automaton */

int autload(char *aname)
{
int ret;
char name[80];

strcpy(name,aname);changext(name,".AUT");
ret=bload(name,(char *) AUTOMATON,2048);
AUTMAX=*AUTOMATON;

return(ret);
}


/* Function for loading a file of sprites into memory.
   This unregistered version allows only 64Kb data  */

int sprload(char *spname)
{
int i,res;
unsigned long lvar;
char name[80];

strcpy(name,spname);changext(name,".spr");

res=bload(name,(char *) SPVECTOR,65520);
if(!res) return(0);

SPRMAX=(int) *SPVECTOR;

lvar =  (unsigned long) SPVECTOR + SPRMAX * 4 + 8;
SPCODE = (char *) lvar;

/* Convert relative addresses to absolute ones */

for(i = 1; i <= SPRMAX; i++)
{
 lvar=  *(SPVECTOR+i) + (unsigned long) SPCODE;
 *(SPVECTOR+i)= lvar;
}

fclose(FP);
return(1);
}

/* Allocate memory for all buffers */

int spralloc()
{
unsigned long allowed=0;
unsigned long tobe=2048+6406+65000;

AUTOMATON = (int *)   malloc(2048);
 if(AUTOMATON) allowed+=2048;
BLOCKSAVE = (char *)  malloc(6406);
 if(BLOCKSAVE) allowed+=6406;
SPVECTOR  = (unsigned long *) malloc(65000);
 if(SPVECTOR) allowed+=65000;

if(allowed == tobe) return;

printf("Not enough memory...%lu of %lu",allowed,tobe);
exit(0);
}



void main()
{
int i,j,num,x,y,yold;

/* First, allocation of memory buffer */

spralloc();

/* Loading sprites  */

printf("Loading sprites...");
sprload("spdemo1");

/* loading automaton */

printf("Loading automaton...");
autload("spdemo1");

 /* Setting VGA 256 colors screen */

setscreen2(VGA18);

/* Full screen window for the red background */

cls18(4);

/* Now, setting window's limits left, top, right, bottom */

window18(48,48,591,431);

/* Black background inside the windows */

cls18(0);

/* Animation example */

putsxy(2,2,"Testing windows, cls18, sprites and automaton...");

i=1;
x=300;
y=20;

while(y < 460)
{
 num=autread(i);
 i++;
 if(i > AUTMAX) i=1;

 waitrefresh();
 csp256c(x, y, getspadr18(num));

 delay(40);        /* to slow down and set all computers same speed */
 if(kbhit()) goto bye;
 y++;

}

/* Restores DOS text screen and exits */

bye:
setscreen2(TEXTMODE);
exit(0);
}
