#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <math.h>
#include <graphics.h>
#include <time.h>
#include <alloc.h>
#include "svga16.h"

#define DEF_INTERVAL 1.5e1 /* default simulation interval (hours) */
#define TEXTCOLOR YELLOW
#define TENTHofYEAR 876.6 /* hours in tenth of year */
#define GMe 1.5444e-12 /* a.u.^ 3 / hour ^ 2 */
#define GMs 5.1395e-7  /*         "          */
#define GMm 1.8982e-14 /*         "          */
#define Ve  7.1519e-4  /* a.u./hour, Earth's avg orbital velocity */
#define maxBods 15

/* semi-constant graphics variables */
unsigned MAX_X,MAX_Y,MAXX2,MAXY2,MAX_COL;

/* location, acceleration and velocity in x,y directions */
double x[maxBods], Ax[maxBods], Vx[maxBods];
double oldx[maxBods], oldy[maxBods];
double y[maxBods], Ay[maxBods], Vy[maxBods];
double  Gm[maxBods];                /* masses*Gravitational constant */
unsigned int col[maxBods], objects; /* color of each object, # of obj */
// int class[maxBods];
/* save initial parameters */
double xinit[maxBods],yinit[maxBods],Vxinit[maxBods],Vyinit[maxBods];
/* save */

int  vx,vy; /* flags for relative velocity changes */
double vrelx,vrely,relativespeed,etime,viewscale;
double dt;   /* hours */

void show_info(void);
void cm(void);
void init1(void);
void _Cdecl SVGA256_driver();

int huge DetectVGA16()
{
/*
  int Vid;


  printf("Which video mode would you like to use? \n");
  printf("  0) 320x200x16\n");
  printf("  1) 640x200x16\n");
  printf("  2) 640x350x16\n");
  printf("  3) 640x480x256\n");
  printf("  4) 800x600x16\n");
  printf("  5) 1024x768x16\n\n>");
  scanf("%d",&Vid);
  return Vid;
*/
  return 4;  
}

void show_elapsed(void){
	static char oldmsg[25];
	char msg[25];

	sprintf(msg,"%4.1lf yrs",etime/(24.0*365.25));
	setcolor(0);
	outtextxy(10,MAX_Y-9,oldmsg);
	setcolor(TEXTCOLOR);
	outtextxy(10,MAX_Y-9,msg);
	strcpy(oldmsg,msg);
}/* show_elapsed */

void clr_infoline(void){
	setviewport(10,MAX_Y-9,MAX_X,MAX_Y,1);
	clearviewport();
	setviewport(0,0,MAX_X,MAX_Y,1);
} //clr_infoline

void elapsed(void){/* increment elapsed time counter, update time display */

	static double next_elapsed;

	if(etime == 0.0){
        next_elapsed = TENTHofYEAR;
        if (dt < 0.0) next_elapsed = -next_elapsed;
		show_elapsed();
    }
    if (dt > 0){
        if (etime >= next_elapsed){
            next_elapsed += TENTHofYEAR;
			show_elapsed();
        }
    }
    else{
        if(etime <= next_elapsed){
            next_elapsed -= TENTHofYEAR;
			show_elapsed();
        }
    }

    etime += dt;

} /* elapsed */

void propagate(void){
        int i,j;
        double dx,dy;
		double dist,Fx,Fy;

        for (i=0; i<objects; i++){
            Vx[i] += Ax[i]*dt; Vy[i] += Ay[i]*dt;
             x[i] += Vx[i]*dt;  y[i] += Vy[i]*dt;
            Ax[i]  = Ay[i] = 0.0;
        }

        for (i=0;i<objects-1;i++){
            for (j=i+1;j<objects;j++){
                // if (class[i] == 1 && Gm[j] == 1) continue;
				// ignore the effects of Earth-size masses on each other
                dx = x[j]-x[i]; dy = y[j]-y[i];
				dist = (dx*dx+dy*dy);
				dist *= sqrt(dist);
				Fx=dx/dist; Fy=dy/dist;

                Ax[i] += Fx*Gm[j]; Ay[i] += Fy*Gm[j];
                Ax[j] -= Fx*Gm[i]; Ay[j] -= Fy*Gm[i];
            }
        }
        elapsed();

	/***********************************************
	 *            relative velocity code           *
	 ***********************************************/
	if (vx){
	   for (i=0;i<objects;i++)
	       Vx[i]+=vrelx;
	       vx=0;
	   }
	if (vy){
	   for (i=0;i<objects;i++)
	       Vy[i]+=vrely;
               vy=0;
	}
} /*propagate*/

void savefile(void){
	int i;
	char filename[82], *name, *msg =
    {"Enter name of file in which to save these initial parameters: "};
	FILE *out;

	filename[0] = 80;
	outtextxy(10,10,msg);
	name = cgets(filename);
	out = fopen(name,"w");
	while (out == NULL){
		clearviewport();
		outtextxy(10,10,"Unable to open file, please reenter: ");
		name = cgets(filename); out = fopen(name,"w");
	}
    fprintf(out,"%u %.18lg\n",objects,dt);
    for(i=0;i<objects;i++)
        fprintf(out,"%.18lg %.18lg %.18lg %.18lg %.18lg %u\n",
	    xinit[i],yinit[i],Vxinit[i],Vyinit[i],Gm[i],col[i]);
    fclose(out);
	show_info();
}/* savefile */


void restorefile(void){
	int i;
	char filename[82], *name;
	FILE *in;

	filename[0] = 80;
	outtextxy(10,10,"Enter file to read in: ");
	name = cgets(filename);
	in = fopen(name,"r");
	if (in == NULL){
		printf("Unable to open %s",name);
		clearviewport();
		return;
	}
    fscanf(in,"%u %lf\n",&objects,&dt);
    for(i=0;i<objects;i++){
        fscanf(in,"%lf %lf %lf %lf %lf %u\n",x+i,y+i,Vx+i,Vy+i,Gm+i,col+i);
		xinit[i]=x[i]; yinit[i]=y[i]; Vxinit[i]=Vx[i]; Vyinit[i]=Vy[i];
        Ax[i]=Ay[i]=0.0;
	}
	init1();
    cm();
}/* restorefile */

void center(){
	int max= -1, i;

	/* find most massive object on the screen */
	for (i=0;i<objects;i++)
	// if(     fabs(x[i]/viewscale) <= MAXX2)
	//    &&  fabs(y[i]/viewscale) <= MAXY2))
	if(     MAXX2 >= ((int) fabs(x[i]/viewscale))
		&&  MAXY2 >= ((int) fabs(y[i]/viewscale)) )

			if (max == -1) max=i; /* first on screen */
			else if(Gm[max] <= Gm[i]) max=i;

	if (max == -1) return; /* exit if nothing on screen */

	/* center it on the screen, and zero its velocity */
	for (i=0;i<objects;i++)
		if (i != max){
			Vx[i]-=Vx[max]; x[i]-=x[max];
			Vy[i]-=Vy[max]; y[i]-=y[max];
		}
	show_info();
	Vx[max]=Vy[max]=x[max]=y[max]=0.0;
} //center

void cm(void){
	int i;
	double cmVx, cmVy, cmx, cmy, cmMass;

	cmVx=cmVy=cmx=cmy=cmMass=0.0;
	/* find the center of mass of the system ON the screen */
	for (i=0;i<objects;i++)
	if( (fabs(x[i]/viewscale) <= MAXX2) && (fabs(y[i]/viewscale) <= MAXY2)){
				cmVx+=Vx[i]*Gm[i]; cmVy+=Vy[i]*Gm[i];
				 cmx+=x[i]*Gm[i];   cmy+=y[i]*Gm[i];
						   cmMass+=Gm[i];
	}
	if (cmMass == 0.0) return; /* exit if nothing on screen */
	else {
			cmVx/=cmMass;
			cmVy/=cmMass;
			cmx /=cmMass;
			cmy /=cmMass;
	}

	/* center it on the screen, and zero its velocity */
	for (i=0;i<objects;i++){
			Vx[i]-=cmVx; x[i]-=cmx;
			Vy[i]-=cmVy; y[i]-=cmy;
	}
	show_info();
}/* cm */

void plotBodies(void){
      int  i;
	  double rx, ry;

	  for (i=0; i<objects; i++){
			rx=x[i]/viewscale+(MAXX2);
			ry=y[i]/viewscale+(MAXY2);
            putpixel(oldx[i],oldy[i],col[i]);
            putpixel(rx,ry,YELLOW);
            oldx[i]=rx;
            oldy[i]=ry;
	  }
} /*plotBodies*/

char show_masses(void){
		int i, width;
		char info[82];

		for (i=0;i<objects;i++)
		if( (fabs(x[i]/viewscale) <= MAXX2) && (fabs(y[i]/viewscale) <= MAXY2)){
			sprintf(info,"%5.3g Suns, %.4g mi/s",Gm[i]/GMs,25833.3333*sqrt(Vx[i]*Vx[i]+Vy[i]*Vy[i]));
			width = textwidth(info)/2;
			setcolor(col[i]);
			setfillstyle(SOLID_FILL,col[i]);
			fillellipse(x[i]/viewscale+MAXX2,y[i]/viewscale+MAXY2,3,3 );
			if(x[i]/viewscale-width+MAXX2 >= 0 &&
			   x[i]/viewscale+width+MAXX2 <= MAX_X)
				outtextxy(x[i]/viewscale+MAXX2-width,y[i]/viewscale+MAXY2,info);
			else if (x[i] < 0)
				outtextxy(0,y[i]/viewscale+MAXY2,info);
			else
				outtextxy(x[i]/viewscale+MAXX2-2*width,y[i]/viewscale+MAXY2,info);
		}
		setcolor(TEXTCOLOR);
		clr_infoline();
		outtextxy(10,MAX_Y-9,"Press any key to continue");
        return(getch());
} /* show_masses */

void show_area(void){
   /* write size of screen (in AUs) on lower right */
    char scal[80];

    if (viewscale*MAX_Y < 10.0)
        sprintf(scal,"%u objects, %2.1e x %2.1e AU",objects,viewscale*MAX_X,viewscale*MAX_Y);
    else sprintf(scal,"%u objects, %.0fx%.0f AU",objects,viewscale*MAX_X,viewscale*MAX_Y);
    outtextxy(MAX_X-textwidth(scal)-9,MAX_Y-9,scal);
} //show_area

void show_interval(void){
    char interval[30];
    int halflen;

    sprintf(interval,"%4.2g hrs",dt);
    halflen=textwidth(interval);
    setviewport(MAXX2-halflen,MAX_Y-9,MAXX2+halflen,MAX_Y,1);
    clearviewport();
    setviewport(0,0,MAX_X,MAX_Y,1);
    outtextxy(MAXX2-halflen,MAX_Y-9,interval);
} //show_interval

void show_info(void){
    clearviewport();
    show_elapsed();
    show_interval();
    show_area();
} //show_info


void restart(void){
        int i;

        for(i=0;i<objects;i++){
            Vx[i]=Vxinit[i]; Vy[i]=Vyinit[i];
            x[i]=xinit[i]; y[i]=yinit[i];
            Ax[i]=Ay[i]=0.0;
        }
		init1(); cm();
} //restart

void init1(void){
	etime=0.0; /* elapsed time */

	vrelx=vrely=0.0;
	relativespeed=0.25*Ve;
    show_info();
	viewscale=(25.0/MAX_Y); /* vert. screen = 25 AU */
} //init1

void init(void){
	int   i,mass,direction, maxsave=0;
	double rx,ry,cmx,cmy,cm,theta,magV[maxBods], maxmass=0.0, dist;

	randomize();
	objects = random(maxBods-3) + 4;
	init1();
	dt=DEF_INTERVAL;  /* time increment */
	cmx=cmy=cm=0.0;

	for (i = 0;i<objects;i++){
		if (i == 0) mass=0;   /* at least one "star" */
		else mass = random(10);
        // class[i] = 0;
		if (mass < 2){
			Gm[i] = GMs*(random(1000)+1.0);/* 1-1000x Solar mass */
            if (Gm[i] < 500.0*GMs) col[i]=YELLOW/2;
            else col[i]=LIGHTBLUE/2;
            if(Gm[i] > maxmass){
				maxmass=Gm[i];
				maxsave=i;
			}
		}
		else if (mass < 4){
			Gm[i] = GMm*(random(20000)+1.0)*1e3*random(50);/* large planet */
            if (Gm[i] > 10.0*GMs) col[i]=YELLOW/2;
            else col[i]=WHITE/2;
			if(Gm[i] > maxmass){
				maxmass=Gm[i];
				maxsave=i;
			}
		}
		else{
			do {
                col[i]=random(MAX_COL/2-1)+1;
            } while( (col[i] == YELLOW/2) || (col[i] == LIGHTBLUE/2) || (col[i] == LIGHTRED/2) );
			Gm[i] = GMe*(random(1000)+1); /* Earth */
            // class[i] = 1;
		}
													  cm+=Gm[i];
		xinit[i] = x[i] = (random(2001)-1000.0)/100.0;cmx+=Gm[i]*xinit[i];
		yinit[i] = y[i] = (random(2001)-1000.0)/100.0;cmy+=Gm[i]*yinit[i];
		magV[i]=(random(301)+random(300))*Ve/100.0+2*Ve;
		Ax[i] = Ay[i] = 0.0;
	}
	cmx/=cm;
	cmy/=cm;    direction=random(2);

			rx=x[maxsave]-cmx; ry=y[maxsave]-cmy;
			theta=atan2(ry,rx);
			if (direction){
				Vxinit[maxsave]=Vx[maxsave]=(-magV[maxsave])*sin(theta);
				Vyinit[maxsave]=Vy[maxsave]=(magV[maxsave])*cos(theta);
			}
			else{
				Vxinit[maxsave]=Vx[maxsave]=(magV[maxsave])*sin(theta);
				Vyinit[maxsave]=Vy[maxsave]=(-magV[maxsave])*cos(theta);
			}
	for (i=0;i<objects;i++){
		if(i != maxsave){
			rx=x[i]-x[maxsave]; ry=y[i]-y[maxsave];
			dist=sqrt(rx*rx+ry*ry);
			magV[i] = sqrt(Gm[maxsave]/dist);
			theta=atan2(ry,rx);
			if (direction){
				Vxinit[i]=Vx[i]=(-magV[i])*sin(theta)+Vxinit[maxsave];
				Vyinit[i]=Vy[i]=(magV[i])*cos(theta)+Vyinit[maxsave];
			}
			else{
				Vxinit[i]=Vx[i]=(magV[i])*sin(theta)+Vxinit[maxsave];
				Vyinit[i]=Vy[i]=(-magV[i])*cos(theta)+Vyinit[maxsave];
			}
		}

	}
} /*init*/

void help(void){
	char *msgs[]={
        "Welcome to Sol3, a multi-star orbital dynamics simulation by",
        "                Jeff Elam and Tony Acero",
        "          Copyright 1990, 1993  Anibal A. Acero",
        " ",
        " Comments, bugs, praise, postcards and/or donations always welcome!",
        " email: ace3@midway.uchicago.edu  phone: (312) 702-8214",
        " US mail: 5640 S. Ellis Ave., JFI 340",
        "          University of Chicago",
        "          Chicago, IL 60637",
        " ",
        "Usage: watch screen -- if you see something interesting try to capture it on ",
        "the screen using the commands below.  If the initial configuration is 'boring'",
        "hit the space bar and try again. Practice makes perfect!",
        " ",
        "h         : this help screen.",
        "x or Esc  : eXit the program.",
        "Space bar : Start a new system.",
        "a         : Restart the current system. (do it Again)",
        "m         : Center the center of Mass of objects onscreen.",
        "c         : Center the HEAVIEST object currently on the screen.",
        "i         : Information on each object's mass and velocity.",
        "Ins       : Zoom out. Doubles the area displayed.",
        "Del       : Zoom in.  Halves the area displayed.",
        "Home/End  : Clear screen, but continue w/ current system",
        "s         : Save the parameters which yielded the current",
        "            system into a file for later retrieval.",
        "r         : Load system parameters from a file. (Retrieve)",
        "t         : REVERSE TIME! Run the simulation backwards.",
        "            A good check of the accuracy of the calculations.",
        "+ or =    : Increase the interval between calcs. Runs faster.",
        "-         : Decrease the interval between calcs. More accurate.",
        "* (/)     : Double (halve) interval between calcs",
        "Arrow keys: Increase the viewer's speed in the appropriate",
        "            direction by the current value of the relative",
        "            speed variable.  Note: it's probably better to use c or m",
        "PgUp      : Double the relative speed variable",
        "PgDn      : Halve  the relative speed variable",
        " ",
        "AAA's Comments",
        " ",
        "Using this program, you should be able to see many of the patterns",
        "mentioned in the 930828 Science News: \"Three's Company -- Probing the",
        "dynamics of multistar systems\", Vol. 144, No. 9, p. 136,  by Ron Cowen.",
        "You might also begin to understand why the planets orbit the Sun in nearly",
        "circular orbits, and why there are no massive planets in the inner solar",
        "system.  You will see many examples of unstable orbits, slingshots and partner",
        "swapping!  This implementation is probably not anywhere near as accurate as the",
        "work referenced above, but is interesting in that many of the same patterns",
        "recur.  In order to speed up the 'time evolution' of the simulation, ",
        "unrealistically large solar masses are used.  As a visual aid, white and red",
        "objects tend to be the most massive.  The initial state is COMPLETELY random:",
        "random initial positions, masses, and trajectories.  Please pass along any",
        "interesting initial configurations!  Some are included in the sol3\saved directory.",
        " ",
        "The numbers at the bottom of the screen are as follows:",
        "Left: elapsed time; Center: time increment (affected by +,=,/,*,- and t)",
        "Right: # of objects, dimensions of screen in Astronomical Units",
        "(1AU = earth->sun distance, ~93 million miles)",
        " ",
        "Credits",
        " ",
        "Jeff came up with the original idea and programmed it in Pascal on",
        "a Macintosh (in 1988!).  I  ported the program to C/MSDOS, optimized the",
        "equations and added alot of bells and whistles.  This program was finished",
        "in 1990 and has languished on my hard drive ever since.  Enjoy! -- AAA",
        " ",
        "Bugs",
        " ",
        "When you're using the save/restore commands you have to type blindly.",
        "The name -- why the heck is it called sol3??",
        " ",
        "Press any key to continue...",
        "\0"
    };
    
    int i=0,j=0,len,height,startx,starty,maxlen=-1,longest,lines=0;

    while (strcmp(*(msgs+i),"\0") != 0){
        lines++;
        len=strlen(*(msgs+i));
        if (len > maxlen){
            maxlen=len;
            longest=lines-1;
        }
        i++;
    }

    height=textheight("Z");
    starty= (MAX_Y - 2*lines*height)/2;
    if (starty < 0 || starty>MAX_Y) starty=0;
    startx= (MAX_X-textwidth(*(msgs+longest)))/2;
    if (startx < 0 || startx > MAX_X) startx=0;
    clearviewport();

    for(i=0;i<lines;i++){
        if ( (starty + j*height) > MAX_Y-2*height){
            outtextxy(startx,starty + j*height,"Press any key for more help, Esc to return...");
            if (getch() == 27){show_info(); return;}
            clearviewport();
            j=0;
        }
        outtextxy(startx,starty+j*height,*(msgs+i));
        j+=2;
    }
    if (getch() == 'h'){
        help();
        return;
    }
    show_info();
}/* help */

void dokey(char c){
   if (!c){ /* extended scan code is true */
       switch(getch()){
       case 'I': relativespeed*=2; return;       /* pgup */
       case 'Q': relativespeed/=2; return;       /* pgdn */
       case 'H': vrely=relativespeed; vy=1; return; /* up arrow */
       case 'P': vrely=-relativespeed; vy=1; return; /* dn arrow */
       case 'K': vrelx=relativespeed; vx=1; return; /* lf arrow */
       case 'M': vrelx=-relativespeed; vx=1; return; /* rt arrow */
       case 'R': viewscale*=1.414213562; break;   /* ins, zoom out */
       case 'S': viewscale/=1.414213562; break;   /* del, zoom in  */
       case 'O': show_info(); return; /* end */
       case 'G':; /* home */
       }
       show_info();
    }
    else if (c == '0'){viewscale*=1.414213562;show_info();}
    else if (c == '.'){viewscale/=1.414213562;show_info();}
	else if (c == 'a' || c == 'A'){
		double tmp;
		tmp = viewscale;//save zoom value
		restart();
		if (c=='A') dt=DEF_INTERVAL;
		viewscale=tmp;//restore zoom value
        show_info();
    }
    else if (c == 'c' || c == 'C'){
        center();
        if (c == 'c') show_info();
        else show_info();
    }
    else if (c == 'i'){
        c=show_masses();
        if (c== ' ')
            show_info();
        else
            show_info();
    }
	else if (c == 'm' || c == 'M'){
        cm();
        if (c == 'm') show_info();
        else show_info();
    }
    else if (c == 't'){
        dt = -dt;
      // show_info();
    } /* time reverse JWE */

    else if (c == 's') savefile();
    else if (c == 'r') restorefile();

    /* Note: wraparound is possible if dt is small */
    else if (c == '+' || c == '='){ dt += 1.0; show_interval();}
    else if (c == '*') {dt *= 2.0; show_interval();}
    else if (c == '-'){dt -= 1.0; show_interval();}
    else if (c == '/') {dt /= 2.0; show_interval();}
	else if (c == ' '){init(); cm();}
    else if (c == 'h') help();
    else if (c == 'x' || c == 27){restorecrtmode(); exit(0);}
    /* ignore any other keypress  */

} //dokey


void parse_cmd(int argc, char *argv[]){
	int GraphDrv=DETECT, GraphMod;

    if((argc==2) && (strcmp(argv[1],"svga")==0)){
        installuserdriver("Svga16m",DetectVGA16);
        registerfarbgidriver(Svga16m_fdriver); 
        initgraph(&GraphDrv,&GraphMod,"");
    }
    else{
        registerfarbgidriver(EGAVGA_driver_far);
        detectgraph(&GraphDrv,&GraphMod);
        if (GraphDrv == CGA)
            GraphMod=CGAC0;
        if (GraphDrv == MCGA)
            GraphMod=MCGAC0;
        initgraph(&GraphDrv,&GraphMod,"");
    }
    if (graphresult() != 0){
        printf("Unable to initialize graphics.\n");
        exit(graphresult());
    }
} //parse_cmd

void main(int argc, char *argv[]){

    parse_cmd(argc,argv);// and init graphics

    MAX_X=getmaxx(); MAXX2=MAX_X/2;
    MAX_Y=getmaxy(); MAXY2=MAX_Y/2;
    MAX_COL=getmaxcolor();

    init();
    cm();
    if (!kbhit()) dokey('h');
    else getch();

    do{
        do {
            propagate();
            plotBodies();
        } while (!kbhit());
        dokey(getch());
    } while (1); /* program termination is in dokey() under 'x' */
} //main
