/* xlisp.c - a small implementation of lisp with object-oriented programming */
/*      Copyright (c) 1987, by David Michael Betz
	All Rights Reserved
	Permission is granted for unrestricted non-commercial use       */

/* For full credits see file xlisp.h */

#include "xlisp.h"

/* global variables */
#ifdef SAVERESTORE
jmp_buf top_level;
#endif

/* external variables */
extern LVAL s_stdin,s_stdout,s_evalhook,s_applyhook;
extern LVAL s_1plus,s_2plus,s_3plus,s_1star,s_2star,s_3star,s_minus;
extern int xltrcindent;
extern int xldebug;
extern LVAL true;
extern FILEP tfp;

static char	string[96];
static int	verbose;
static char     resfile[96] = "xlisp.wks";

/* Functions from winstuff.c */
void	EnableMenuCommands();
void	DisableMenuCommands();

extern long FAR PASCAL WndProc( HWND , WORD , WORD , LONG );

/* Processes the command line. Gets a pointer to the command
   line and a flag which shows the processing pass. The switches
   (beginning with '-') are processed before the main window is
   created , then LispFlag is FALSE. LispFlag is TRUE , when
   the Lisp sources are loaded after the initialization of the
   system */
void ProcessCommandLine( LPSTR CmdLine , int LispFlag )
{
  char		*p1;
  char		s[100];
  CONTEXT       cntxt;

  while( *CmdLine )
  {
    while( *CmdLine == ' ' )
		++CmdLine;
    p1 = string;
    while( *CmdLine && *CmdLine != ' ' )
		*( p1++ ) = *( CmdLine++ );
    *p1 = 0;
    if( *string )
    {
      if( *string != '-' )	/* load Lisp source if in the
				   second pass*/
      {
	if (setjmp(cntxt.c_jmpbuf) == 0 && LispFlag )
	  if( !xlload( string ,TRUE,verbose))
	  {
	    sprintf( s , "Can't load file : %s", string );
	    MessageBox( NULL , s , "XLisp" , MB_OK );
	  }
      }
      else
      if( !LispFlag )
	switch( string[1] )	/* else process switches */
	{
	  case 'v':
		verbose = TRUE;
		break;

	  case 'w':
		strcpy( resfile , &string[2] );
		break;

	  case 's':
		ServerTask = TRUE;
		break;

	  default:
		sprintf( s , "Invalid switch : %s" , string );
		MessageBox( NULL , s , "XLisp" , MB_OK );
		break;
	}		/* switch */
    }			/* if( *string ) */
  }			/* while */
}

int PASCAL WinMain( HANDLE hInstance , HANDLE hPrevInstance ,
		    LPSTR lpCmdLine , int nCmdShow )
{
  static char	szAppName[] = "XLisp";
  static char	szAppCapt[] = "XLisp";

  FARPROC	DlgProc;
  WNDCLASS	WndClass;
  CONTEXT	cntxt;
  int		i;
  char		far *ReplyBuf;
  DWORD		Style;
  LVAL		expr;

  ServerTask = FALSE;
  ProcessCommandLine( lpCmdLine , FALSE );
  hInst = hInstance;
  if( !hPrevInstance )
  {
    WndClass.style = CS_HREDRAW | CS_VREDRAW;
    WndClass.lpfnWndProc = WndProc;
    WndClass.cbClsExtra = 0;
    WndClass.cbWndExtra = 0;
    WndClass.hInstance = hInst;
    WndClass.hIcon = LoadIcon( hInst,szAppName );
    WndClass.hCursor = LoadCursor( NULL, IDC_ARROW );
    WndClass.hbrBackground = COLOR_WINDOW + 1;
    WndClass.lpszMenuName = szAppName;
    WndClass.lpszClassName = szAppName;
    RegisterClass( &WndClass );
  }

  strcpy( string , szAppCapt );
/* Adds "server" to the caption string if server */
  if( ServerTask )
	strcat( string , " server" );
  MainWindow = CreateWindow( szAppName ,
		       string ,
		       WS_OVERLAPPEDWINDOW,
		       CW_USEDEFAULT ,
		       CW_USEDEFAULT ,
		       CW_USEDEFAULT ,
		       CW_USEDEFAULT ,
		       NULL ,
		       NULL ,
		       hInst ,
		       NULL );

/* initialize */
  osinit();
/* start minimized anyway if server task */
  if( ServerTask )
	nCmdShow = SW_MINIMIZE;
  ShowWindow( MainWindow , nCmdShow );
  InvalidateRect( MainWindow , NULL , TRUE );
  UpdateWindow( MainWindow );
  hAccel = LoadAccelerators( hInst , szAppName );

    /* setup default argument values */
    verbose = FALSE;

    /* setup initialization error handler */
    xlbegin(&cntxt,CF_TOPLEVEL|CF_CLEANUP|CF_BRKLEVEL,(LVAL)1);
    if (setjmp(cntxt.c_jmpbuf))
	xlfatal("fatal initialization error");
#ifdef SAVERESTORE
    if (setjmp(top_level))
	xlfatal("RESTORE not allowed during initialization");
#endif

    /* initialize xlisp */
#ifdef SAVERESTORE
    i = xlinit(resfile);
#else
    i = xlinit(NULL);
#endif

    /* reset the error handler, since we know what "true" is */
    xlend(&cntxt);
    xlbegin(&cntxt,CF_TOPLEVEL|CF_CLEANUP|CF_BRKLEVEL,true);

    /* load "init.lsp" */
    if (i && (setjmp(cntxt.c_jmpbuf) == 0))
	xlload("init.lsp",TRUE,FALSE);

/* Process Lisp sources in the command line now */
    ProcessCommandLine( lpCmdLine , TRUE );

    /* target for restore */
#ifdef SAVERESTORE
    if (setjmp(top_level))
	xlbegin(&cntxt,CF_TOPLEVEL|CF_CLEANUP|CF_BRKLEVEL,true);
#endif

    /* protect some pointers */
    xlsave1(expr);


    /* main command processing loop */
    for (;;) {

	/* setup the error return */
	if (setjmp(cntxt.c_jmpbuf)) {
	    setvalue(s_evalhook,NIL);
	    setvalue(s_applyhook,NIL);
	    xltrcindent = 0;
	    xldebug = 0;
	    xlflush();
	}

/* Sending reply packet to the XServer DLL */
	if( ServerPacket )
	{
	  ReplyBuf = GlobalLock( ReplyBlock );
	  ReplyBuf[ ReplyIndex ] = 0;
	  XDSendReply( ReplyBuf );
	  GlobalUnlock( ReplyBlock );
	  GlobalFree( ReplyBlock );
	  ServerPacket = FALSE;
	}

	stdputstr("> ");

	/* Enabling popup menu commands */
	EnableMenuCommands();

	/* read an expression */
	if (!xlread(getvalue(s_stdin),&expr))
	  if( MenuCommand == FUNC_EOF )
		break;
	  else
	  if( MenuCommand == FUNC_LLSP )
	  {
	    xlload( szFileName , TRUE , FALSE );
	    continue;
	  }
	  else
	  if( MenuCommand == FUNC_LWKS )
	  {
	    sprintf( string , "; Loading %s\n" , szFileName );
	    stdputstr( string );
	    xlirestore( szFileName );
	    dbgputstr( "[ returning to the top level ]\n" );
	    longjmp( top_level,1 );
	  }

/* Begin processing a client packet */
	if( ServerReady )
	{
	  ServerReady = FALSE;
	  ServerPacket = ( ReplyBlock = GlobalAlloc( GMEM_MOVEABLE ,
			  RBLOCK_SIZE ) ) != NULL;
	  ReplyIndex = 0;
	}

	/* Disabling popup menu commands */
	DisableMenuCommands();

	/* save the input expression */
	xlrdsave(expr);

	/* evaluate the expression */
	expr = xleval(expr);

	/* save the result */
	xlevsave(expr);

	/* Show result on a new line -- TAA MOD to improve display */
	xlfreshline(getvalue(s_stdout));

	/* print it */
	stdprint(expr);

    }
    xlend(&cntxt);

    /* clean up */
    wrapup();

    return 0;
}

/* xlrdsave - save the last expression returned by the reader */
VOID xlrdsave(expr)
  LVAL expr;
{
    setvalue(s_3plus,getvalue(s_2plus));
    setvalue(s_2plus,getvalue(s_1plus));
    setvalue(s_1plus,getvalue(s_minus));
    setvalue(s_minus,expr);
}

/* xlevsave - save the last expression returned by the evaluator */
VOID xlevsave(expr)
  LVAL expr;
{
    setvalue(s_3star,getvalue(s_2star));
    setvalue(s_2star,getvalue(s_1star));
    setvalue(s_1star,expr);
}

/* xlfatal - print a fatal error message and exit */
VOID xlfatal(msg)
  char *msg;
{
    xoserror(msg);
    wrapup();
}

/* wrapup - clean up and exit to the operating system */
VOID wrapup()
{
    /* $putpatch.c$: "MODULE_XLISP_C_WRAPUP" */
    if (tfp != CLOSED)
        OSCLOSE(tfp);
    osfinish();
    exit(0);
}
