/****************************************************************************
                               Public Domain
 ----------------------------------------------------------------------------
   System   	  : IBM PC/AT and compatibles
   Programm-Modul : OS9 Format
 ----------------------------------------------------------------------------
   file-name	  : disk_con.c
   date     	  : 04.11.1990
   last change	  : 20.11.1993
   version   	  : 1.00
   authors  	  : Wilfried Weigelt
   last author	  : Wilfried Weigelt

   description	  : This function checks the configuration of the PC for
                    later use. To checkout the drives int13's function 8
                    is used.
                    The drive type is stored like in the AT CMOS RAM.
                    0 - drive not installed
                    1 - 360k drive
                    2 - 1,2MB drive
                    3 - 720k drive
                    4 - 1,44MB drive
   This information is used to check whether a 1.2 MB HD Drive is in use.
   In that case the double step Bit in the Bios drive status bit has to be
   switched off. Drive A: 40:90, Drive B: 40:91. This value should be set
   explicitly with every Disk access because the BIOS resets this value to
   BIOS default when disk is changed.

   inputs         : ----
   outputs        : ----
   return value   : ---- 

   history:		  : 
   Initial Version                                             04.11.90 WEW
   Adapted to Format Program                                   20.11.93 WEW
*****************************************************************************/
#include <dos.h>
#include "mdos.h"

drv_typ drv;          /* Structure with drivetypes */

#define CF 1            /* mask for Carry Flag */



void disk_conf()
{
    struct REGPACK p_reg;


    p_reg.r_ax = 0x0800;           /* function 8 of int13 */
    p_reg.r_dx = 0x0;               /* drive a: */
    intr ( 0x13 , &p_reg );             /* get configuration */

    if ( (p_reg.r_flags & CF)!= 0)
    {
        if ( (p_reg.r_ax >> 8) == 1 )
        {
            drv.lwa = 1;  /* Bad Command: it is assumed that this is a  */
                          /* 360k drive, because old XT Type don't know */
                          /* function 8 */
        }
        else
        {
            drv.lwa = 0;           /* drive doesn't exist */
        }
    }
    else 
    {
        switch(p_reg.r_cx)
        {
            case 0x2709:
                 drv.lwa=1;     /* 360k */
                 break;
            case 0x4f09:
                 drv.lwa=3;     /* 720k */
                 break;
            case 0x4f0f:
                 drv.lwa=2;     /* 1.2MB */
                 break;
            case 0x4f12:
                 drv.lwa=4;     /* 1,44MB */
                 break;
            default:
                 drv.lwa=0;     /* not installed or unknown */
                 break;
        }
    }
        
        
    p_reg.r_ax=0x0800;        /* function 8 ... */
    p_reg.r_dx=0x1;           /* drive B: */
    intr(0x13,&p_reg);
    if ((p_reg.r_flags&CF)!=0)
    {
        if ((p_reg.r_ax>>8)==1)
        {
            drv.lwb=1;
        }
        else
        {
            drv.lwb=0;
        }
    }
    else 
    {
        switch(p_reg.r_cx)
        {
            case 0x2709:
                 drv.lwb=1;   /* 360k */
                 break;
            case 0x4f09:
                 drv.lwb=3;   /* 720k */
                 break;
            case 0x4f0f:
                 drv.lwb=2;   /* 1.2MB */
                 break;
            case 0x4f12:
                 drv.lwb=4;   /* 1.44 MB */
                 break;
            default:
                 drv.lwb=0;   /* not installed or unknown */
                 break;
        }
    }
        
}