/* ----------------------------------------------------------------------- */
/* -----  Set include file list                                      ----- */
/* ----------------------------------------------------------------------- */
#include<graph.h>
#include<malloc.h>
#include<stdlib.h>
#include<errno.h>

/* ----------------------------------------------------------------------- */
/* ----------------------------------------------------------------------- */
/* -----                       SUBROUTINES                           ----- */
/* ----------------------------------------------------------------------- */
/* ----------------------------------------------------------------------- */


int changek(int k,int flag)
/* ----------------------------------------------------------------------- */
/* -----  This subroutine changes the value of k according to the    ----- */
/* -----  value of FLAG (1 = up, 2 = down).  k is incremented in     ----- */
/* -----  steps which increase as k increases.                       ----- */
/* -----                                                             ----- */
/* -----  INT k    = The value of k to be increased of decreased     ----- */
/* -----  INT flag = Indicates whether to raise (1) or lower (2) the ----- */
/* -----             k value                                         ----- */
/* -----                                                             ----- */
/* -----  The program passes back the new value of k.                ----- */
/* ----------------------------------------------------------------------- */
{
     if (flag == 1) {
	  k++;
	  if (k >= 21) k++;
	  if (k >= 52) k+= 3;
	  if (k >= 105) k+=20;
	  if (k >= 1025) k+=75;
	  if (k >= 3100) k+=400;
	  if (k >= 10500) k+=500;
     }
     if (flag == 2) {
	  k--;
	  if (k >= 21) k--;
	  if (k >= 53) k-=3;
	  if (k >= 120) k-=20;
	  if (k >= 1075) k-=75;
	  if (k >= 3400) k-=400;
	  if (k >= 10500) k-=500;
     }
     if (k > 31000) k = 31000;
     if (k < 0) k = 0;
     dispk(k);
     return(k);
}


int changecolor(int color)
/* ----------------------------------------------------------------------- */
/* -----  This subroutine changes the color mode of the display.     ----- */
/* -----  If needed, this routine will also remap the color pallet   ----- */
/* -----  to suit the new display mode.                              ----- */
/* -----                                                             ----- */
/* -----  INT color = The current display color mode                 ----- */
/* -----                                                             ----- */
/* -----  The program passes back the new value of color             ----- */
/* ----------------------------------------------------------------------- */
{
     long _far *shades;
     color++;
     if (color == 5) {
	  if ( (shades = (long _far *)_fmalloc(sizeof(long)*16)) == NULL) {
	       color = 1;
	  }
	  else {
	       *(shades+ 0) = 0x000000L;
	       *(shades+ 1) = 0x040404L;
	       *(shades+ 2) = 0x080808L;
	       *(shades+ 3) = 0x0c0c0cL;
	       *(shades+ 4) = 0x101010L;
	       *(shades+ 5) = 0x141414L;
	       *(shades+ 6) = 0x181818L;
	       *(shades+ 7) = 0x1c1c1cL;
	       *(shades+ 8) = 0x202020L;
	       *(shades+ 9) = 0x242424L;
	       *(shades+10) = 0x282828L;
	       *(shades+11) = 0x2c2c2cL;
	       *(shades+12) = 0x303030L;
	       *(shades+13) = 0x343434L;
	       *(shades+14) = 0x383838L;
	       *(shades+15) = 0x3c3c3cL;
	       _remapallpalette(shades);
	       _ffree(shades);
	  }
     }
     if (color == 7) {
	  if ( (shades = (long _far *)_fmalloc(sizeof(long)*16)) == NULL) {
	       color = 1;
	  }
	  else {
	       *(shades+ 0) = 0x000000L;
	       *(shades+ 1) = 0x010101L;
	       *(shades+ 2) = 0x020202L;
	       *(shades+ 3) = 0x040404L;
	       *(shades+ 4) = 0x060606L;
	       *(shades+ 5) = 0x090909L;
	       *(shades+ 6) = 0x0c0c0cL;
	       *(shades+ 7) = 0x101010L;
	       *(shades+ 8) = 0x141414L;
	       *(shades+ 9) = 0x191919L;
	       *(shades+10) = 0x1e1e1eL;
	       *(shades+11) = 0x242424L;
	       *(shades+12) = 0x2a2a2aL;
	       *(shades+13) = 0x313131L;
	       *(shades+14) = 0x383838L;
	       *(shades+15) = 0x3f3f3fL;
	       _remapallpalette(shades);
	       _ffree(shades);
	  }
     }
     if (color == 9) {
	  if ( (shades = (long _far *)_fmalloc(sizeof(long)*16)) == NULL) {
	       color = 1;
	  }
	  else {
	       *(shades+ 0) = 0x000000L;
	       *(shades+ 1) = 0x2a0000L;
	       *(shades+ 2) = 0x002a00L;
	       *(shades+ 3) = 0x2a2a00L;
	       *(shades+ 4) = 0x00002aL;
	       *(shades+ 5) = 0x2a002aL;
	       *(shades+ 6) = 0x00152aL;
	       *(shades+ 7) = 0x2a2a2aL;
	       *(shades+ 8) = 0x151515L;
	       *(shades+ 9) = 0x3f1515L;
	       *(shades+10) = 0x153f15L;
	       *(shades+11) = 0x3f3f15L;
	       *(shades+12) = 0x15153fL;
	       *(shades+13) = 0x3f153fL;
	       *(shades+14) = 0x153f3fL;
	       *(shades+15) = 0x3f3f3fL;
	       _remapallpalette(shades);
	       _ffree(shades);
	       color = 1;
	  }
     }
     dispcolor(color);
     return(color);
}


int changeprec(int prec)
/* ----------------------------------------------------------------------- */
/* -----  This subroutine toggles the precision of the computations  ----- */
/* -----  between single-precision and double-precision.             ----- */
/* -----                                                             ----- */
/* -----  INT prec = Current precision (1 = single, 2 = double)      ----- */
/* -----                                                             ----- */
/* -----  Program passes back the new value of prec.                 ----- */
/* ----------------------------------------------------------------------- */
{
     if (prec == 1) {
	  prec = 2;
     }
     else {
	  prec = 1;
     }
     dispprec(prec);
     return(prec);
}



