/*--------------------------------------------------------------------------+
| Module: EMSTEST                                                           |
| Project: TOOLS                                                            |
| Author: Paul A. Penrose                                                   |
|         (c) 1992, 4D Interactive Systems, Inc.  All rights reserved.      |
| Start Date: 01 Nov 92                                                     |
| Last Revised: 29 Nov 92                                                   |
| Purpose:                                                                  |
|   This module contains code to test the EMS support in a DOS environment. |
+--------------------------------------------------------------------------*/

#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <alloc.h>
#include "ems.h"

char copyright[] = "(c) 1992 4D Interactive Systems, Inc.  All rights reserved.";

int memverify(char *mem, int val, unsigned int len);

int main()
{
   int ret_value = 1;
   int handle, x, num_physical, i, num_handles;
   unsigned int free_pages;
   char *memptr;
   handle_directory_struct *hdir;

   printf("+---------------------------------------+\n");
   printf("| EMS Test Program  Ver 1.0             |\n");
   printf("| (c) 1992 4D Interactive Systems, Inc. |\n");
   printf("+---------------------------------------+\n");
   if (ems_init()) {
      printf("An EMS Version %i.%i driver has been detected.\n",ems_version/16,ems_version & 15);
      num_physical = ems_num_physical_pages();
      if (ems_errnum != 0) {
         printf("ERROR Getting number of physical pages, error number = %X\n",ems_errnum);
         num_physical = 1;
      }
      printf("Page Frame = %X, consisting of %i pages.\n",ems_pageframe,num_physical);
      free_pages = ems_num_free_pages(0);
      if (ems_errnum != 0) {
         printf("ERROR Getting EMS Number of fee pages, error number = %X.\n",ems_errnum);
         ret_value = 0;
      }
      else {
         printf("Number of apparent Free Pages = %u.\n",free_pages);
         free_pages = ems_num_free_pages(1);
         printf("Number of actual Free Pages = %u.\n",free_pages);
         if (free_pages > 0) {
            handle = ems_alloc(1,"EMSTEST");
            if (handle < 0) {
               printf("ERROR Allocating 1 page, error number = %X\n",ems_errnum);
               ret_value = 0;
            }
            else {
               printf("Sucessfully allocated 1 page.\n");
               if (ems_save_mapping_context(handle) != 0) {
                  printf("ERROR Saving the mapping context, error number = %X\n",ems_errnum);
               }
               else {
                  printf("Sucessfully saved the mapping context.\n");
                  for (i=0; i<num_physical; i++) {
                     if (ems_map_page(handle,0,i) != 0) {
                        printf("ERROR Mapping page %i, error number = %X\n",i,ems_errnum);
                        ret_value = 0;
                     }
                     else {
                        printf("Sucessfully mapped to physical page %i, testing memory now...",i);
                        memptr = MK_FP(ems_pageframe+i*0x400,0);
                        memset(memptr,0,0x4000);
                        x = memverify(memptr,0,0x4000);
                        if (x != 0) {
                           memset(memptr,0xFF,0x4000);
                           x = memverify(memptr,0,0x4000);
                        }
                        if (x != 0) {
                           memset(memptr,0x55,0x4000);
                           x = memverify(memptr,0x55,0x4000);
                        }
                        if (x != 0) {
                           printf("FAILED!\n");
                           ret_value = 0;
                        }
                        else {
                           printf("Good.\n");
                        }
                        ems_unmap_page(handle,i);
                        if (ems_errnum != 0) {
                           printf("ERROR Unmaping page %i, error number = %X\n",i,ems_errnum);
                           ret_value = 0;
                        }
                     }
                  }
                  if (ems_restore_mapping_context(handle) != 0) {
                     printf("ERROR Restoring the mapping context, error number = %X\n",ems_errnum);
                  }
                  else {
                     printf("Sucessfully restored the mapping context.\n");
                  }
               }
               num_handles = ems_num_open_handles();
               if (ems_errnum != 0) {
                  printf("ERROR Getting number of open handles, error number = %X\n",ems_errnum);
                  ret_value = 0;
               }
               else {
                  printf("Number of EMS open handles = %i\n",num_handles);
                  hdir = (handle_directory_struct *) malloc(num_handles * sizeof(handle_directory_struct));
                  if (ems_get_handle_directory(hdir) != 0) {
                     printf("ERROR Getting handle directory, function = %X, error number = %X\n",ems_function,ems_errnum);
                     ret_value = 0;
                  }
                  else {
                     printf("EMS Handle Directory:\n    Handle Size Name\n");
                     for (i=0; i<num_handles; i++) {
                        printf("    %6u %4u %s\n",(hdir+i)->handle,(hdir+i)->num_pages,(hdir+i)->handle_name);
                     }
                  }
                  free(hdir);
               }
               if (ems_free(handle) != 0) {
                  printf("ERROR Freeing 1 page, error number = %X\n",ems_errnum);
                  ret_value = 0;
               }
               else {
                  printf("Sucessfully freed 1 page.\n");
               }
            }
         }
      }
   }
   else {
      ret_value = 0;
      if (ems_function < 3) {
         printf("No EMS driver detected.\n");
      }
      else {
         printf("EMS Error %X calling function %X\n",ems_errnum,ems_function);
      }
   }
   return ret_value;
}

int memverify(char *mem, int val, unsigned int len)
{
   do {
      if (*(mem++) != val) {
         break;
      }
   } while (--len > 0);
   return len;
}
