Comment
==========================================================

Menu support routines.

==========================================================
EndComment


;----- Support routines for conditional menus

Var
  VertLine = "³"
  VertLine2 = ""
  VertLine3 = "Ŀ"
  VertLine4 = ""
  IndexString
  MyGroups


;----- Init Code

OnScreenOnly ;limits choices to those on the screen only.
AllowEsc
AllowAbort Off
UseArrows Off
LookSetup

;----- Code for Group Conditionals

if NetworkVersion
   if NovConnection > 0
      NovReadGroups(NovLoginName,MyGroups)    ;Read Groups user is in.
      SortArray(MyGroups)
   endif
endif

;----- Adds a choice to list

Procedure AddChoice (Prompt,TaskNum)
   if TaskNum <> 0
      IndexString[CurrentWindow + 1] = Left(IndexString[CurrentWindow + 1],NumberOfElements(Choices)) + Char(TaskNum + 64)
   endif
   AppendArray(Choices,Prompt)
EndProc

;----- Compares TaskNum to Choice

Procedure Task (TaskNum)
   if Mid(IndexString[CurrentWindow],Ord(LastKey) - 64,1) = Char(TaskNum + 64)
      Return LastKey
   else
      Return ""
   endif
EndProc

;----- Returns True if in list

Procedure InGroup (Group)
   Return PosInSortedList(UpperCase(Group),MyGroups) > 0
EndProc

;----- Windowing Support

Procedure CenterStretchBox (Header,Col,Row)
   MakeBox(Header,Col,Row,True)
EndProc


Procedure CornerStretchBox (Header,Col,Row)
   if Row = 0 then Row = 5
   if Col = 0 then Col = 8 + (CurrentWindow - 3 * 4)
   MakeBox(Header,Col,Row,False)
EndProc


;------ MenuExit Procedure

Procedure LeaveMenu
   DrawTheBox (ScreenWidth / 2 - 4,ScreenHeight / 2 - 1,13,HeightDifference + 2,'Exit Menu')
   Writeln " Yes"
   Write   " No"

   OnKey "Y"
      |ExitMenu

   OnKey "N"
      |LastKey = Esc

EndProc

;------ Read a Text Line Procedure

Procedure ReadTextLine(St,Header,Col,Row)
var AnswerLine
   Choices[1] = ""
   CenterStretchBox(Header,Col,Row)
   Write " " St " "
   TextColor(MenuCapColorFG,MenuBG)
   AnswerLine = Readln
   EraseTopWindow
   Dispose Choices
   Return AnswerLine
EndProc

;----- View a File

Procedure ViewFile (Name)
   if Name = '' then Return
   BoxHeader = ' Viewing ' + Name + ' '
   Shadow Off
   DrawBox 1 4 80 21
   ClearKeyEvents
   TextColor MenuHeaderFG MenuBG
   ViewTextFile Name
EndProc

;----- Display Greek Columns

Procedure GreekColumns
   TextColor GreekFG GreekBG
   GotoXY 4,4
   WriteVertical VertLine2
   GotoXY 5,4
   WriteVertical VertLine2
   GotoXY 6,4
   WriteVertical VertLine2
   GotoXY 7,4
   WriteVertical VertLine2
   GotoXY ScreenWidth - 6,4
   WriteVertical VertLine2
   GotoXY ScreenWidth - 5,4
   WriteVertical VertLine2
   GotoXY ScreenWidth - 4,4
   WriteVertical VertLine2
   GotoXY ScreenWidth - 3,4
   WriteVertical VertLine2
   GotoXY 2,4
   Write VertLine4
   GotoXY ScreenWidth - 8,4
   Write VertLine4
   GotoXY 2,ScreenHeight - 1
   Write VertLine3
   GotoXY ScreenWidth - 8,ScreenHeight - 1
   Write VertLine3
EndProc

;----- Show Item for Debugging

Procedure ShowMe (Item)
   DrawBox 1 23 80 3
   Write ' '
   TextColor Yellow Cyan
   Write Item
   Wait 300
   EraseTopWindow
EndProc

