/*
 * New editor name:  TDE, the Thomson-Davis Editor.
 * Author:           Frank Davis
 * Date:             June 5, 1992
 *
 * This file contains all user prompts in TDE.  Prompts were gathered into
 *  one file to make the job of translating English into other languages
 *  as easy as possible.
 */


char *cb      = "Control-Break pressed";


/*
 * block.c
 */
char *block1  = "a block is already defined in another file";

char *ltol    = "Error: line would be too long.";
char *block2  = "can only fill box blocks";
char *block3a = "can only number box blocks";
char *block3b = "can only swap box blocks";
char *block4  = "not enough memory for block";
char *block5  = "can only overlay box blocks";

char *block6  = "File name: ";
char *block7  = "File exists. Overwrite or Append? (o/a): ";
char *block8  = "writing block to '";
char *block9  = "could not write block";
char *block10 = "appending block to '";
char *block11 = "could not append block";
char *block12 = "writing block to '";

char *block13 = "Print file or block? (f/b): ";
char *block14 = "Printing line         of         Press Control-Break to cancel.";

char *block15 = "Enter character to fill block (ESC to exit): ";

char *block16 = "Enter starting number: ";
char *block17 = "Enter increment: ";
char *block18 = "Left or Right justify numbers in block (l/r)? ";

char *block20 = "can only expand tabs in line blocks";
char *block26 = "can only expand tabs in line blocks";

char *block21 = "can only trim trailing space in line blocks";

char *block22a = "Phase 1) Quicksort";
char *block22b = "Phase 2) Insertion sort";
char *block23 = "Can only sort Box blocks";
char *block24 = "Box block not marked";

char *block25 = "can only e-mail reply in line blocks";


/*
 * console.c
 */
char *console1 = "Next Key..";


/*
 * critical error handler
 */
char *critt1  = "N/A";


/*
 * diff
 */
char *diff_prompt1 = "DIFF:  Enter first window number and letter (e.g. 1a) : ";
char *diff_prompt2 = "DIFF:  Enter next window number and letter (e.g. 2a) : ";
char *diff_prompt3 = "DIFF:  Start diff at (B)eginning of file or (C)urrent position? (b/c) ";
char *diff_prompt4 = "DIFF:  Diffed until EOF(s).  No diff's were found.  Press a key.";
char *diff_prompt5 = "DIFF windows not defined:  ";
char *diff_prompt6a = "window '";
char *diff_prompt6b = "' not visible or does not exist  ";
char *diff_prompt7a = "DIFF:  Ignore leading spaces (y/n)?  ";
char *diff_prompt7b = "DIFF:  Ignore all space (y/n)?  ";
char *diff_prompt7c = "DIFF:  Ignore blank lines (y/n)?  ";
char *diff_prompt7d = "DIFF:  Ignore end of line (useful with reformatted paragraphs) (y/n)?  ";

char *diff_message = "diffing...";
char *diff_blank   = "          ";


/*
 * dir list
 */
#if defined( __UNIX__ )
char *dir1 = "Directory name : ";
#else
char *dir1 = "Search path or pattern : ";
#endif
char *dir2 = "Invalid path or file name";
char *stardotstar = "*.*";
char *dir3 = "Out of memory";

char *dir4 = "Selected file : ";
char *dir5 = "    File size : ";
char *dir6 = "File count : ";

char *dir7 = "Cursor keys move.   Enter selects file or new directory";

/*
 * ed.c
 */
char *ed1  = "line too long to add";
char *ed2  = "cannot insert more characters";
char *ed3  = "no more room to add";

char *ed4  = "cannot combine lines";

char *ed5  = "cannot duplicate line";

char *ed7a = "Logical tab interval: ";
char *ed7b = "Physical (file) tab interval: ";
char *ed8  = "tab size too long";

char *ed9  = "Enter new left margin (must be less than right margin) : ";
char *ed10 = "Left margin out of range.";

char *ed11a = "Justify right margin?  (y/n): ";
char *ed11 = "Enter new right margin (must be greater than left margin) : ";
char *ed12 = "Right margin out of range.";

char *ed13 = "Enter paragraph margin (must be less than right margin) : ";
char *ed14 = "Paragraph margin out of range.";

char *ed15 = "File name to edit : ";

char *ed16 = "Macro execution halted:  Internal stack overflow.";
char *ed17 = "Macro execution halted:  Internal stack underflow.";

char *paused1 = "Paused:";
char *paused2 = "  Press ESC to halt macro   ";

/*
 * findrep.c
 */
char *find1  = "Options:  (P)rompt before replace   (N)o prompt (p/n): ";
char *find2  = "(R)eplace  (S)kip  (E)xit  (r/s/e)";
char *find3  = "Search has wrapped.  (C)ontinue or (Q)uit? (c/q): ";

char *find4  = "String to find: ";
char *find5a = "string \"";
char *find5b = "\" not found ";
char *find6  = "find pattern not defined";


char *find7[] = { "          ",
                  "wrapped...",
                  "searching ",
                  "replacing ",
                  "nfa choked"  };


char *find8  = "string not found";
char *find9  = "String to find: ";
char *find10 = "Replacement:    ";

char *find11 = "Line number: ";
char *find12 = "must be in the range 1 - ";


/*
 * hwind.c
 */
char *smart   = "S";
char *fixed   = "F";
char *intab   = "I";
char *outtab  = "D";
char *tabs    = "Tabs=";

char *indent  = "Indent";
char *blank   = "      ";

char *ignore = "Ignore";
char *match  = "Match ";

char *sync_off = "    ";
char *sync_on  = "Sync";

char *ww_mode[]  = { "  ",
                     "FW",
                     "DW" };

char *eol_mode[] = { "Native",
                     "CRLF  ",
                     "LF    ",
                     "Binary" };


/*
 * Incidentally, these need to be 4 characters wide.  The previous file mode
 * should leave no residue in the lite bar, when toggling thru the modes.
 */
char *mode_lf   = "lf  ";
char *mode_crlf = "crlf";
char *mode_bin  = "BIN ";



/*
 * main.c
 */
char *main1   = "Fatal error: ";
char *main2   = "Warning: ";
char *main3   = ": press a key";

char *main4   = "out of memory";

char *main5   = "negative move - contact Frank Davis";

char *main6   = "File is write protected.  Overwrite anyway? (y/n): ";

char *main7a  = "File '";
char *main7b  = "'not found or error loading file";

char *main8a  = "file '";
char *main8b  = "'too big.  FILE WILL BE TRUNCATED IF SAVED!";

char *main9   = "error reading file '";

char *main9a = "FRANK: error reading file!";    /* devas neniam okazi? */

char *file_win_mem = "F=   W=    m=";

char *main10a = "file '";
char *main10b = "'too big";

char *main11  = "Press the key that will play back this recording : ";
char *main12  = "Cannot assign a recording to this key";
char *main13  = "No more room in recording buffer";
char *main14  = "Overwrite recording assigned to this key? (y/n) : ";

char *main15  = "Recording";

char *main18  = "  Avail strokes = ";

char *main19  = "Name for macro file name: ";
char *main20  = "Overwrite existing file? (y/n): ";

char *main21  = "Search path or file name for macro file : ";
char *main22  = "Invalid path or file name";


/*
 * regx.c
 */
char *reg1   = "Regular expression search (F1 = help): ";
char *reg2   = "unmatched open paren ";
char *reg3   = "unmatched close paren ";
char *reg4   = "char \'\\\' at end of string is not escaped";
char *reg5   = "class is not defined properly";
char *reg6   = "unmatched open bracket";
char *reg7   = "out of heap for class definition";
char *reg8   = "operator *, + , or ? error";
char *reg9   = "unmatched close bracket ";
char *reg10  = "incomplete range in character class ";
char *reg11  = "Can't parse two operators in a row ";


#if defined( __UNIX__ )

char *regx_help[] = {
"+------------------------------------------------------+",
"   c = char    x = string    r,s = regular expression |",
"+---------+------------------------------+-------------+",
"|  c      |  any non-operator character  |  Felis      |",
"|  \\c     |  c literally and C escapes   |  catus\\.    |",
"|  \\:c    |  predefined macro            |  \\:a+.?\\(   |",
"|  .      |  any character but newline   |  c.t        |",
"|  <      |  beginning of word           |  <cat       |",
"|  >      |  end of word                 |  <cat>      |",
"|  ^      |  beginning of line           |  ^cat>      |",
"|  $      |  end of line                 |  cat$       |",
"|  [x]    |  any character in x          |  [a-z0-9]   |",
"|  [^x]   |  any character not in x      |  [^AEIOU]   |",
"|  r*     |  zero or more r's            |  ca*t       |",
"|  r+     |  one or more r's             |  ca[b-t]+   |",
"|  r?     |  zero or one r               |  c.?t       |",
"|  rs     |  r followed by s             |  ^$         |",
"|  r|s    |  either r or s               |  kitty|cat  |",
"|  (r)    |  r                           |  (c)?(a+)t  |",
"+---------+------------------------------+-------------+",
NULL
};

#else

char *regx_help[] = {
"Ŀ",
"   c = char    x = string    r,s = regular expression ",
"Ĵ",
"  c        any non-operator character    Felis      ",
"  \\c       c literally and C escapes     catus\\.    ",
"  \\:c      predefined macro              \\:a+.?\\(   ",
"  .        any character but newline     c.t        ",
"  <        beginning of word             <cat       ",
"  >        end of word                   <cat>      ",
"  ^        beginning of line             ^cat>      ",
"  $        end of line                   cat$       ",
"  [x]      any character in x            [a-z0-9]   ",
"  [^x]     any character not in x        [^AEIOU]   ",
"  r*       zero or more r's              ca*t       ",
"  r+       one or more r's               ca[b-t]+   ",
"  r?       zero or one r                 c.?t       ",
"  rs       r followed by s               ^$         ",
"  r|s      either r or s                 kitty|cat  ",
"  (r)      r                             (c)?(a+)t  ",
"",
NULL
};

#endif

/*
 * utils.c
 */
char *utils1  = "line buffer overflow - rest of line ignored";
char *utils3  = "buffer full, part line truncated";

char *utils4  = "Sort (A)scending or (D)escending (a/d)? : ";

char *utils5  = "Replace (F)orward or (B)ackward (f/b)? : ";

char *utils6  = "Saving '";
char *utils7a = "file  '";
char *utils7b = "' is Read Only";
char *utils8  = "cannot write to '";

char *utils9  = "New file name: ";

char *utils10 = "Overwrite existing file? (y/n): ";

char *utils11 = "Error writing file or disk full";

char *utils12 = "Abandon changes? (y/n): ";

char *utils13 = "Marker   not set in this file";

#if defined( __UNIX__ )
char *utils14 = "Enter new file attributes, \"RrWwXx\" : ";
char *utils15 = "New file attributes not set.  Wrong owner, perhaps";
#else
char *utils14 = "Enter new file attributes, \"AaSsHhRr\" : ";
char *utils15 = "New file attributes not set";
#endif

char *utils16 = "No dirty lines found";

char *time_am = "am";
char *time_pm = "pm";


/*
 * window.c
 */
char *win1 = "move cursor up first";

char *win2 = "move cursor right first";
char *win3 = "move cursor left first";

char *win4 = "Press Up or Down to change window size.  Press Return when done.";
char *win5 = "can not resize vertical window";
char *win6 = "can not resize top window";

char *win7 = "cannot close current window";

char *win8 = "Invalid path or file name ";
char *win9 = "No more files to load ";

char *win16a = "Enter search string:  ";
char *win16b = "Enter regular expression search string:  ";
char *win17 = "Enter file names to search:  ";

char *win18 = "Press the <Grep> key for more files or any key to quit (Ctrl \\ = menu):  ";

char *win19 = "Searching:  ";

/*
 * wordwrap.c
 */
char *ww1  = "line would be too long.";


/*
 * simple pull-down menu stuff
 *
 * pull.c auto calculates the number of selections under each menu choice.
 *  end the selections with a NULL string and ERROR in the function list.
 *  pull.c also calculates the width of the pull menu.
 */

#if defined( __UNIX__ )

MINOR_STR file_opts[] = {
   { "+---------+", ERROR },
   { "|Dir      |", DirList },
   { "|Load     |", EditFile },
   { "|Save     |", Save },
   { "|Save as  |", SaveAs },
   { "|Save+Quit|", File },
   { "|File attr|", SetFileAttributes },
   { "+---------+", ERROR },
   { "|Load Next|", EditNextFile },
   { "+---------+", ERROR },
   { "|File Find|", DefineGrep },
   { "|Next Find|", RepeatGrep },
   { "|File Grep|", DefineRegXGrep },
   { "|Next Grep|", RepeatGrep },
   { "+---------+", ERROR },
   { "|Exit     |", Quit },
   { "+---------+", ERROR },
   { NULL, ERROR }
};

MINOR_STR search_opts[] = {
   { "+----------+", ERROR },
   { "|Find fwd  |", FindForward },
   { "|Find bckwd|", FindBackward },
   { "|Repeat >  |", RepeatFindForward1 },
   { "|Repeat <  |", RepeatFindForward1 },
   { "+----------+", ERROR },
   { "|Find regx |", FindRegX },
   { "|Next regx |", RepeatFindRegX },
   { "|Prev regx |", RepeatFindRegXBackward },
   { "+----------+", ERROR },
   { "|Tog Case  |", ToggleSearchCase },
   { "+----------+", ERROR },
   { "|Begin Diff|", DefineDiff },
   { "|Next Diff |", RepeatDiff },
   { "+----------+", ERROR },
   { NULL, ERROR }
};

MINOR_STR block_opts[] = {
   { "+------------+", ERROR },
   { "|Copy Block  |", CopyBlock },
   { "|Kopy Block  |", KopyBlock },
   { "|Delete Block|", DeleteBlock },
   { "|Move Block  |", MoveBlock },
   { "|Unmark Block|", UnMarkBlock },
   { "+--Box only--+", ERROR },
   { "|Fill Box    |", FillBlock },
   { "|Number Box  |", NumberBlock },
   { "|Overlay Box |", OverlayBlock },
   { "|Swap Box    |", SwapBlock },
   { "|Sort Box    |", SortBoxBlock },
   { "+------------+", ERROR },
   { "|Expand Tabs |", BlockExpandTabs },
   { "|Compress Tab|", BlockCompressTabs },
   { "|Indent Tabs |", BlockIndentTabs },
   { "|Trim Trail  |", BlockTrimTrailing },
   { "|Upper Case  |", BlockUpperCase },
   { "|Lower Case  |", BlockLowerCase },
   { "|Strip hi bit|", BlockStripHiBit },
   { "|Rot13       |", BlockRot13 },
   { "|Fix UUE prob|", BlockFixUUE },
   { "|E-mail '>'  |", BlockEmailReply },
   { "+------------+", ERROR },
   { NULL, ERROR }
};

MINOR_STR toggle_opts[] = {
   { "+-----------+", ERROR },
   { "|Insert     |", ToggleOverWrite },
   { "|Indent     |", ToggleIndent },
   { "|Word wrap  |", ToggleWordWrap },
   { "|crlf/lf/bin|", ToggleCRLF },
   { "|Trim trail |", ToggleTrailing },
   { "|Control Z  |", ToggleZ },
   { "|EOL display|", ToggleEol },
   { "|Cursor sync|", ToggleSync },
   { "|Ruler      |", ToggleRuler },
   { "|Set tabs   |", SetTabs },
   { "|Smart tabs |", ToggleSmartTabs },
   { "+-----------+", ERROR },
   { NULL, ERROR }
};

MINOR_STR other_opts[] = {
   { "+-------------+", ERROR },
   { "|Add Line     |", AddLine },
   { "|Split Line   |", SplitLine },
   { "|Join Line    |", JoinLine },
   { "|Dup Line     |", DuplicateLine },
   { "|Delete Line  |", DeleteLine },
   { "|Undelete Line|", UndoDelete },
   { "|Undo Line    |", UndoLine },
   { "+-------------+", ERROR },
   { "|Next Dirty L |", NextDirtyLine },
   { "|Prev Dirty L |", PrevDirtyLine },
   { "+-------------+", ERROR },
   { "|Top of File  |", TopOfFile },
   { "|End of File  |", EndOfFile },
   { "|Goto Line    |", JumpToLine },
   { "+-------------+", ERROR },
   { "|Date Stamp   |", DateTimeStamp },
   { "|Redraw Screen|", RedrawScreen },
   { "+-------------+", ERROR },
   { "|Macro Record |", RecordMacro },
   { "+-------------+", ERROR },
   { NULL, ERROR }
};

MINOR_STR word_opts[] = {
   { "+-------------+", ERROR },
   { "|Left Margin  |", SetLeftMargin },
   { "|Right Margin |", SetRightMargin },
   { "|Pargrh Margin|", SetParagraphMargin },
   { "+-------------+", ERROR },
   { "|Format Pargrh|", FormatParagraph },
   { "|Format fwrd  |", FormatText },
   { "+-------------+", ERROR },
   { "|Left Justify |", LeftJustify },
   { "|Right Justify|", RightJustify },
   { "|Center Just  |", CenterJustify },
   { "+-------------+", ERROR },
   { NULL, ERROR }
};

MINOR_STR window_opts[] = {
   { "+--------------+", ERROR },
   { "|Split horzntal|", SplitHorizontal },
   { "|Split vertical|", SplitVertical },
   { "+--------------+", ERROR },
   { "|Next Window   |", NextWindow },
   { "|Prev Window   |", PreviousWindow },
   { "+--------------+", ERROR },
   { "|Zoom Window   |", ZoomWindow },
   { "|Size Window   |", SizeWindow },
   { "|Next Hidn Win |", NextHiddenWindow },
   { "|Close Window  |", Quit },
   { "+--------------+", ERROR },
   {  NULL, ERROR }
};

#else

MINOR_STR file_opts[] = {
   { "Ŀ", ERROR },
   { "Dir      ", DirList },
   { "Load     ", EditFile },
   { "Save     ", Save },
   { "Save as  ", SaveAs },
   { "Save+Quit", File },
   { "File attr", SetFileAttributes },
   { "Ĵ", ERROR },
   { "Load Next", EditNextFile },
   { "Ĵ", ERROR },
   { "File Find", DefineGrep },
   { "Next Find", RepeatGrep },
   { "File Grep", DefineRegXGrep },
   { "Next Grep", RepeatGrep },
   { "Ĵ", ERROR },
   { "Exit     ", Quit },
   { "", ERROR },
   { NULL, ERROR }
};

MINOR_STR search_opts[] = {
   { "Ŀ", ERROR },
   { "Find fwd  ", FindForward },
   { "Find bckwd", FindBackward },
   { "Repeat >  ", RepeatFindForward1 },
   { "Repeat <  ", RepeatFindForward1 },
   { "Ĵ", ERROR },
   { "Find regx ", FindRegX },
   { "Next regx ", RepeatFindRegX },
   { "Prev regx ", RepeatFindRegXBackward },
   { "Ĵ", ERROR },
   { "Tog Case  ", ToggleSearchCase },
   { "Ĵ", ERROR },
   { "Begin Diff", DefineDiff },
   { "Next Diff ", RepeatDiff },
   { "", ERROR },
   { NULL, ERROR }
};

MINOR_STR block_opts[] = {
   { "Ŀ", ERROR },
   { "Copy Block  ", CopyBlock },
   { "Kopy Block  ", KopyBlock },
   { "Delete Block", DeleteBlock },
   { "Move Block  ", MoveBlock },
   { "Unmark Block", UnMarkBlock },
   { "Box onlyĴ", ERROR },
   { "Fill Box    ", FillBlock },
   { "Number Box  ", NumberBlock },
   { "Overlay Box ", OverlayBlock },
   { "Swap Box    ", SwapBlock },
   { "Sort Box    ", SortBoxBlock },
   { "Ĵ", ERROR },
   { "Expand Tabs ", BlockExpandTabs },
   { "Compress Tab", BlockCompressTabs },
   { "Indent Tabs ", BlockIndentTabs },
   { "Trim Trail  ", BlockTrimTrailing },
   { "Upper Case  ", BlockUpperCase },
   { "Lower Case  ", BlockLowerCase },
   { "Strip hi bit", BlockStripHiBit },
   { "Rot13       ", BlockRot13 },
   { "Fix UUE prob", BlockFixUUE },
   { "E-mail '>'  ", BlockEmailReply },
   { "", ERROR },
   { NULL, ERROR }
};

MINOR_STR toggle_opts[] = {
   { "Ŀ", ERROR },
   { "Insert     ", ToggleOverWrite },
   { "Indent     ", ToggleIndent },
   { "Word wrap  ", ToggleWordWrap },
   { "crlf/lf/bin", ToggleCRLF },
   { "Trim trail ", ToggleTrailing },
   { "Control Z  ", ToggleZ },
   { "EOL display", ToggleEol },
   { "Cursor sync", ToggleSync },
   { "Ruler      ", ToggleRuler },
   { "Set tabs   ", SetTabs },
   { "Smart tabs ", ToggleSmartTabs },
   { "", ERROR },
   { NULL, ERROR }
};

MINOR_STR other_opts[] = {
   { "Ŀ", ERROR },
   { "Add Line     ", AddLine },
   { "Split Line   ", SplitLine },
   { "Join Line    ", JoinLine },
   { "Dup Line     ", DuplicateLine },
   { "Delete Line  ", DeleteLine },
   { "Undelete Line", UndoDelete },
   { "Undo Line    ", UndoLine },
   { "Ĵ", ERROR },
   { "Next Dirty L ", NextDirtyLine },
   { "Prev Dirty L ", PrevDirtyLine },
   { "Ĵ", ERROR },
   { "Top of File  ", TopOfFile },
   { "End of File  ", EndOfFile },
   { "Goto Line    ", JumpToLine },
   { "Ĵ", ERROR },
   { "Date Stamp   ", DateTimeStamp },
   { "Redraw Screen", RedrawScreen },
   { "Ĵ", ERROR },
   { "Macro Record ", RecordMacro },
   { "", ERROR },
   { NULL, ERROR }
};

MINOR_STR word_opts[] = {
   { "Ŀ", ERROR },
   { "Left Margin  ", SetLeftMargin },
   { "Right Margin ", SetRightMargin },
   { "Pargrh Margin", SetParagraphMargin },
   { "Ĵ", ERROR },
   { "Format Pargrh", FormatParagraph },
   { "Format fwrd  ", FormatText },
   { "Ĵ", ERROR },
   { "Left Justify ", LeftJustify },
   { "Right Justify", RightJustify },
   { "Center Just  ", CenterJustify },
   { "", ERROR },
   { NULL, ERROR }
};

MINOR_STR window_opts[] = {
   { "Ŀ", ERROR },
   { "Split horzntal", SplitHorizontal },
   { "Split vertical", SplitVertical },
   { "Ĵ", ERROR },
   { "Next Window   ", NextWindow },
   { "Prev Window   ", PreviousWindow },
   { "Ĵ", ERROR },
   { "Zoom Window   ", ZoomWindow },
   { "Size Window   ", SizeWindow },
   { "Next Hidn Win ", NextHiddenWindow },
   { "Close Window  ", Quit },
   { "", ERROR },
   {  NULL, ERROR }
};

#endif


/*
 * here's the main headings in the pull-down menu.  in TDESTR.H the number
 *  of headings is defined as MAJOR or 7.
 */
MENU_STR menu = {
   { "File",    0,   file_opts },
   { "Search",  0, search_opts },
   { "Block",   0,  block_opts },
   { "Toggles", 0, toggle_opts },
   { "Other",   0,  other_opts },
   { "Word",    0,   word_opts },
   { "Window",  0, window_opts }
};


/************************************************************************/
/* Editor:      TDE, the Thomson-Davis Editor
 * Filename:    prompts2.h
 * Compiled by: Byrial Jensen
 *
 * This file contains various prompts and other strings, collected to
 * to ease making versions for other languages.
 * Here is: What is "forgotten" in prompts.h
 *          A string with the alphabet used for window names
 *          Tables used by functions in myctype.c and macros in myctype.h
 * It is used with changed versions of several of the TDE source files
 */


/*
 * These letters are used to differentiate windows in the same file.
 *  Some users may prefer the sequence of their alphabet, instead of
 *  this English sequence.
 */
char *windowletters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";


/*
 * First some defines which only purpose is to make the next table
 * more compact and easy to see, Byrial.
 */
#define  S   BJ_space
#define  D   (BJ_digit | BJ_xdigit)     /* bit mask for digit */
#define  U   BJ_upper
#define  L   BJ_lower
#define  H   (BJ_xdigit | U)            /* bit mask for uppercase hex digit */
#define  h   (BJ_xdigit | L)            /* bit mask for lowercase hex digit */
#define  C   BJ_cntrl
#define  P   BJ_punct
#define  s   (S | C)                    /* counts both for space and control */


/*
 * I'll give the English ASCII and Extended-ASCII keyboards a try, Frank.
 */
#define CHAR_SET   LATIN_3
#define CHAR_SET   ENGLISH

#if CHAR_SET==ENGLISH
char bj_ctype[257] = {
    0,                        /* EOF returns 0, I am assumimg EOF == -1 */
    C,C,C,C, C,C,C,C,  C,s,s,s, s,s,C,C,  /* 00h-0Fh    0- 15 */
    C,C,C,C, C,C,C,C,  C,C,C,C, C,C,C,C,  /* 10h-1Fh   16- 31 */
    S,P,P,P, P,P,P,P,  P,P,P,P, P,P,P,P,  /* 20h-2Fh   32- 47 */
    D,D,D,D, D,D,D,D,  D,D,P,P, P,P,P,P,  /* 30h-2Fh   48- 63 */

    P,H,H,H, H,H,H,U,  U,U,U,U, U,U,U,U,  /* 40h-4Fh   64- 79 */
    U,U,U,U, U,U,U,U,  U,U,U,P, P,P,P,P,  /* 50h-5Fh   80- 95 */
    P,h,h,h, h,h,h,L,  L,L,L,L, L,L,L,L,  /* 60h-6Fh   96-111 */
    L,L,L,L, L,L,L,L,  L,L,L,P, P,P,P,C,  /* 70h-7Fh  112-127 */

    U,L,L,L, L,L,L,L,  L,L,L,L, L,L,U,U,  /* 80h-8Fh  128-143 */
    U,L,U,L, L,L,L,L,  U,L,U,P, P,P,P,P,  /* 90h-9Fh  144-159 */
    L,L,L,L, L,U,P,P,  P,P,P,P, P,P,P,P,  /* A0h-AFh  160-175 */
    P,P,P,P, P,P,P,P,  P,P,P,P, P,P,P,P,  /* B0H-BFh  176-191 */

    P,P,P,P, P,P,P,P,  P,P,P,P, P,P,P,P,  /* C0h-CFh  192-207 */
    P,P,P,P, P,P,P,P,  P,P,P,P, P,P,P,P,  /* D0h-DFh  208-223 */
    L,L,L,U, L,L,L,L,  L,L,L,L, L,L,P,P,  /* E0h-EFh  224-239 */
    P,P,P,P, P,P,P,P,  P,P,P,P, P,P,P,0   /* F0h-FFh  240-255 */
};
#else
/*
 * This is Byrial's definition for ISO 8859-3 (Latin 3) added with
 * normal ASCII control characters.
 */
char bj_ctype[257] = {
    0,                        /* EOF returns 0, I am assumimg EOF == -1 */
    C,C,C,C, C,C,C,C,  C,s,s,s, s,s,C,C,  /* 00h-0Fh    0- 15 */
    C,C,C,C, C,C,C,C,  C,C,C,C, C,C,C,C,  /* 10h-1Fh   16- 31 */
    S,P,P,P, P,P,P,P,  P,P,P,P, P,P,P,P,  /* 20h-2Fh   32- 47 */
    D,D,D,D, D,D,D,D,  D,D,P,P, P,P,P,P,  /* 30h-2Fh   48- 63 */

    P,H,H,H, H,H,H,U,  U,U,U,U, U,U,U,U,  /* 40h-4Fh   64- 79 */
    U,U,U,U, U,U,U,U,  U,U,U,P, P,P,P,P,  /* 50h-5Fh   80- 95 */
    P,h,h,h, h,h,h,L,  L,L,L,L, L,L,L,L,  /* 60h-6Fh   96-111 */
    L,L,L,L, L,L,L,L,  L,L,L,P, P,P,P,C,  /* 70h-7Fh  112-127 */

    0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0,  /* 80h-8Fh  128-143 */
    0,0,0,0, 0,0,0,0,  0,0,0,0, 0,0,0,0,  /* 90h-9Fh  144-159 */
    s,U,P,P, P,0,U,P,  P,U,U,U, U,C,0,U,  /* A0h-AFh  160-175 */
    P,L,P,P, P,P,L,P,  P,L,L,L, L,P,0,L,  /* B0H-BFh  176-191 */

    U,U,U,0, U,U,U,U,  U,U,U,U, U,U,U,U,  /* C0h-CFh  192-207 */
    0,U,U,U, U,U,U,P,  U,U,U,U, U,U,U,U,  /* D0h-DFh  208-223 */
    L,L,L,0, L,L,L,L,  L,L,L,L, L,L,L,L,  /* E0h-EFh  224-239 */
    0,L,L,L, L,L,L,P,  L,L,L,L, L,L,L,P   /* F0h-FFh  240-255 */
};
#endif

#undef S        /* These letters where only defined to make the */
#undef D        /* above table as compact as possible.          */
#undef U        /* Now they can be undef'ed, Byrial             */
#undef L
#undef H
#undef h
#undef C
#undef P
#undef s


/*
 * State corresponding uppercase letter for each lowercase letter,
 * and corresponding lowercase letter for each uppercase letter.
 * If the right corresponding letter does not exist in the character set
 * state best replacement, possible the letter self in wrong case.
 * Byrial Jensen.
 */

#if CHAR_SET==ENGLISH
/*
 * Thought I would give code page 437 (English) a try, Frank.
 */
char upper_lower[256] = {

     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,

     0 ,'a','b','c', 'd','e','f','g',  'h','i','j','k', 'l','m','n','o',
    'p','q','r','s', 't','u','v','w',  'x','y','z', 0 ,  0 , 0 , 0 , 0 ,
     0 ,'A','B','C', 'D','E','F','G',  'H','I','J','K', 'L','M','N','O',
    'P','Q','R','S', 'T','U','V','W',  'X','Y','Z', 0 ,  0 , 0 , 0 , 0 ,

    '','','','A', '','A','','',  'E','E','E','I', 'I','I','','',
    '','','','O', '','O','U','U',  'y','','', 0 ,  0 , 0 , 0 , 0 ,
    'A','I','O','U', '','', 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,

     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
    '','','','', '','','','',  '','','','', '','', 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0
};
#else
/*
 * This is a definition valid for ISO 8859-3 (Latin 3), Byrial:
 */
char upper_lower[256] = {

     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,

     0 ,'a','b','c', 'd','e','f','g',  'h','i','j','k', 'l','m','n','o',
    'p','q','r','s', 't','u','v','w',  'x','y','z', 0 ,  0 , 0 , 0 , 0 ,
     0 ,'A','B','C', 'D','E','F','G',  'H','I','J','K', 'L','M','N','O',
    'P','Q','R','S', 'T','U','V','W',  'X','Y','Z', 0 ,  0 , 0 , 0 , 0 ,

     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,   0 , 0 , 0 , 0 ,  0 , 0 , 0 , 0 ,
     0 ,'', 0 , 0 ,  0 , 0 ,'', 0 ,   0 ,'','','', '', 0 , 0 ,'',
     0 ,'', 0 , 0 ,  0 , 0 ,'', 0 ,   0 ,'','','', '', 0 , 0 ,'',

    '','','', 0 , '','','','',  '','','','', '','','','',
     0 ,'','','', '','','', 0 ,  '','','','', '','','','',
    '','','', 0 , '','','','',  '','','','', '','','','',
     0 ,'','','', '','','', 0 ,  '','','','', '','','', 0
};
#endif
