/* hpcdtoppm (Hadmut's pcdtoppm) v0.6.beta
*  Copyright (c) 1992, 1993, 1994 by Hadmut Danisch (danisch@ira.uka.de).
*  Permission to use and distribute this software and its
*  documentation for noncommercial use and without fee is hereby granted,
*  provided that the above copyright notice appear in all copies and that
*  both that copyright notice and this permission notice appear in
*  supporting documentation. It is not allowed to sell this software in
*  any way. This software is not public domain.
*/

#include "hpcdtoppm.h"
#define X(a,b) ((a == b) ? "->" : "  ")

void eerror(enum ERRORS e,char *file,int line)
 {

  switch(e)
   {case E_NONE:   return;
    case E_IMP:    fprintf(stderr,"Sorry, Not yet implemented. [%s:%d]\n",file,line); break;
    case E_READ:   fprintf(stderr,"Error while reading.\n"); break;
    case E_WRITE:  fprintf(stderr,"Error while writing.\n"); break;
    case E_INTERN: fprintf(stderr,"Internal error. [%s:%d]\n",file,line); break;
    case E_ARG:    fprintf(stderr,"Error in Arguments !\n\n");
#ifdef SHORT_HELP
                   fprintf(stderr,"Usage: hpcdtoppm [options] pcd-file [ppm-file]\n");
                   fprintf(stderr,"       ( - means stdin )\n");
                   fprintf(stderr,"Opts:         [ -> = Default ] \n\n");
                   fprintf(stderr,"   [-x] [-s] [-d] [-i] [-m]\n");
                   fprintf(stderr,"   [-crop] [-pos] [-rep] [-vert] [-hori] [-S h v]\n");
                   fprintf(stderr,"   [-n] [-r] [-l] [-h] [-a]\n");
                   fprintf(stderr,"   [-ppm] [-pgm] [-ycc] [-ps] [-eps] [-psg] [-epsg] [-psd] [-epsd]\n");
                   fprintf(stderr,"   [-pl f] [-pb f] [-pw f] [-ph f] [-dpi f] [-fak f]\n");
                   fprintf(stderr,"   [-c0] [-c-] [-c+]\n");
                   fprintf(stderr,"   [-0] [-C d s] [-1] [-2] [-3] [-4] [-5] [-6 path]\n");

#endif
#ifdef LONG_HELP
                   fprintf(stdout,"Usage: hpcdtoppm [options] pcd-file [ppm-file]\n");
                   fprintf(stdout,"       ( - means stdin )\n");
                   fprintf(stdout,"Opts:         [ -> = Default ] \n\n");

                   fprintf(stdout,"     -x     Overskip mode (tries to improve color quality.)\n");
                   fprintf(stdout,"     -s     Apply simple sharpness-operator on the Luma-channel.\n");
                   fprintf(stdout,"     -d     Show differential picture only.\n");
                   fprintf(stdout,"     -i     Give some (buggy) informations from fileheader.\n");
                   fprintf(stdout,"     -m     Show the decoding steps to stdout.\n");
                   fprintf(stdout,"     -crop  Try to cut off the black frame.\n");
                   fprintf(stdout,"     -pos   Print file position of image to stdout.\n");
                   fprintf(stdout,"     -rep   Try to jump over defects in the Huffman Code.\n");
                   fprintf(stdout,"     -vert  Flip image vert.\n");
                   fprintf(stdout,"     -hori  Flip image horiz.\n");
                   fprintf(stdout,"     -S h v Decode subrectangle with hori. and vert. boundaries h,v,\n");
                   fprintf(stdout,"            h,v of the form a-b or a+b, a and b integer or float [0.0...1.0]\n");
                   fprintf(stdout,"\n");

                   fprintf(stdout," %s  -n     Don't rotate.\n",                                 X(T_DEFAULT,T_NONE));
                   fprintf(stdout," %s  -r     Rotate clockwise for portraits.\n" ,              X(T_DEFAULT,T_RIGHT));
                   fprintf(stdout," %s  -l     Rotate counter-clockwise for portraits.\n",       X(T_DEFAULT,T_LEFT));
                   fprintf(stdout," %s  -h     Rotate twice, turn on head.\n",                   X(T_DEFAULT,T_HEAD));
                   fprintf(stdout," %s  -a     Try to find out orientation automatically.\n",    X(T_DEFAULT,T_AUTO));
                   fprintf(stdout,"\n");

                   fprintf(stdout," %s  -ppm   output rgb  (ppm-format). \n",                    X(O_DEFAULT,O_PPM));
                   fprintf(stdout," %s  -pgm   output gray (pgm-format). \n",                    X(O_DEFAULT,O_PGM));
                   fprintf(stdout," %s  -ycc   output ycc  (ppm-format). \n",                    X(O_DEFAULT,O_YCC));
                   fprintf(stdout," %s  -ps    output postscript (rgb). \n",                     X(O_DEFAULT,O_PS));
                   fprintf(stdout," %s  -eps   output encapsulated postscript (rgb). \n",        X(O_DEFAULT,O_EPS));
                   fprintf(stdout," %s  -psg   output postscript (grayscale). \n",               X(O_DEFAULT,O_PSG));
                   fprintf(stdout," %s  -epsg  output encapsulated postscript (grayscale). \n",  X(O_DEFAULT,O_EPSG));
                   fprintf(stdout," %s  -psd   output postscript (b&w dithered). \n",            X(O_DEFAULT,O_PSG));
                   fprintf(stdout," %s  -epsd  output encapsulated postscript (b&w dithered).\n",X(O_DEFAULT,O_EPSG));
                   fprintf(stdout," %s  -etga  output TGA file (SD).\n",X(O_DEFAULT,O_TGA));

                   fprintf(stdout,"     -pl  f Postscript paper left position    [ Def:  %8.3f ]\n",DEF_PAPER_LEFT);
                   fprintf(stdout,"     -pb  f Postscript paper bottom position  [ Def:  %8.3f ]\n",DEF_PAPER_BOTTOM);
                   fprintf(stdout,"     -pw  f Postscript paper width            [ Def:  %8.3f ]\n",DEF_PAPER_WIDTH);
                   fprintf(stdout,"     -ph  f Postscript paper height           [ Def:  %8.3f ]\n",DEF_PAPER_HEIGHT);
                   fprintf(stdout,"     -dpi f Postscript resolution for dith.   [ Def:  %8.3f ]\n",DEF_DPI);
                   fprintf(stdout,"     -fak f Scaling factor for dith.          [ Def:     1.0   ]\n");
                   fprintf(stdout,"\n");

                   fprintf(stdout," %s  -c0    don't correct (linear).\n", X(C_DEFAULT,C_LINEAR));
                   fprintf(stdout," %s  -c-    correct darker.\n",         X(C_DEFAULT,C_DARK));
                   fprintf(stdout," %s  -c+    correct brighter.\n",       X(C_DEFAULT,C_BRIGHT));
                   fprintf(stdout,"\n");

                   fprintf(stdout," %s  -0     Extract thumbnails from Overview file.\n",        X(S_DEFAULT,S_Over));
                   fprintf(stdout," %s  -C d s Extract contact sheet from Overview file, d images width,\n",X(S_DEFAULT,S_Contact));
                   fprintf(stdout,"            with contact sheet orientation s ( one of n l r h).\n");
                   fprintf(stdout," %s  -1     Extract  128x192   from Image file.\n",           X(S_DEFAULT,S_Base16));
                   fprintf(stdout," %s  -2     Extract  256x384   from Image file.\n",           X(S_DEFAULT,S_Base4));
                   fprintf(stdout," %s  -3     Extract  512x768   from Image file.\n",           X(S_DEFAULT,S_Base));
                   fprintf(stdout," %s  -4     Extract 1024x1536  from Image file.\n",           X(S_DEFAULT,S_4Base));
                   fprintf(stdout," %s  -5     Extract 2048x3072  from Image file.\n",           X(S_DEFAULT,S_16Base));
                   fprintf(stdout," %s  -6 dir Extract 4096x6144  from Image file and 64Base-Directory dir.\n",           X(S_DEFAULT,S_64Base));
                   fprintf(stdout,"\n");
#endif
                   break;
    case E_OPT:    fprintf(stderr,"These Options are not allowed together.\n");break;
    case E_MEM:    fprintf(stderr,"Not enough memory !\n"); break;
    case E_HUFF:   fprintf(stderr,"Error in Huffman-Code-Table\n"); break;
    case E_SEQ:    fprintf(stderr,"Error in Huffman-Sequence, try option -rep\n"); break;
    case E_SEQ1:   fprintf(stderr,"Error1 in Huffman-Sequence, try option -rep\n"); break;
    case E_SEQ2:   fprintf(stderr,"Error2 in Huffman-Sequence, try option -rep\n"); break;
    case E_SEQ3:   fprintf(stderr,"Error3 in Huffman-Sequence, try option -rep\n"); break;
    case E_SEQ4:   fprintf(stderr,"Error4 in Huffman-Sequence, try option -rep\n"); break;
    case E_SEQ5:   fprintf(stderr,"Error5 in Huffman-Sequence, try option -rep\n"); break;
    case E_SEQ6:   fprintf(stderr,"Error6 in Huffman-Sequence, try option -rep\n"); break;
    case E_SEQ7:   fprintf(stderr,"Error7 in Huffman-Sequence, try option -rep\n"); break;
    case E_POS:    fprintf(stderr,"Error in file-position\n"); break;
    case E_OVSKIP: fprintf(stderr,"Can't read this resolution in overskip-mode\n"); break;
    case E_TAUTO:  fprintf(stderr,"Can't determine the orientation in overview mode\n");break;
    case E_SUBR:   fprintf(stderr,"Error in Subrectangle Parameters\n");break;
    case E_PRPAR:  fprintf(stderr,"Bad printing parameters\n");break;
    case E_CONFIG: fprintf(stderr,"Something is wrong with your configuration [see %s:%d]\n",file,line);
                   fprintf(stderr,"Edit the config.h and recompile...\n"); break;
    case E_TCANT:  fprintf(stderr,"Sorry, can't determine orientation for this file.\n");
                   fprintf(stderr,"Please give orientation parameters. \n");break;
    case E_FOPEN:  fprintf(stderr,"Can't open file\n"); break;
    default:       fprintf(stderr,"Unknown error %d ???  [%s:%d]\n",e,file,line);break;
   }
  close_all();
  exit(9);
 }


