/* hpcdtoppm (Hadmut's pcdtoppm) v0.6.beta
*  Copyright (c) 1992, 1993, 1994 by Hadmut Danisch (danisch@ira.uka.de).
*  Permission to use and distribute this software and its
*  documentation for noncommercial use and without fee is hereby granted,
*  provided that the above copyright notice appear in all copies and that
*  both that copyright notice and this permission notice appear in
*  supporting documentation. It is not allowed to sell this software in
*  any way. This software is not public domain.
*/

#include "hpcdtoppm.h"




static void flip_corr(dim w,dim h,uBYTE **ptr,sdim *ystep,sdim *xstep)
 {if(flvert)
   { (*ptr) += (h-1)* (*ystep);
     (*ystep) = -(*ystep);
   }

  if(flhori)
   {(*ptr) += (w-1)* (*xstep);
    (*xstep) = -(*xstep);
   }
 }




static void call_1plane(OUT1PL proc, FILE *fout,
                        dim w,    dim h,uBYTE * ptr,
                        sdim zeil, sdim pix)
 {
  flip_corr(w,h,&ptr,&zeil,&pix);
  (*proc)(fout,w,h,ptr,zeil,pix);
 }



static void do_1plane(OUT1PL proc, FILE *fout,
                      dim w,dim h,implane *g,enum TURNS t)
 {
   switch(t)
    {case T_NONE: call_1plane(proc,fout,w,h,g->im,g->mwidth,1);
                  break;
     case T_RIGHT:call_1plane(proc,fout,h,w,g->im + g->mwidth * ( g->iheight - 1) , 1 , -(g->mwidth));
                  break;
     case T_LEFT: call_1plane(proc,fout,h,w,g->im + g->iwidth - 1 , -1 , (g->mwidth));
                  break;
     case T_HEAD: call_1plane(proc,fout,w,h,g->im + g->iwidth - 1 + g->mwidth * ( g->iheight - 1)  , -(g->mwidth) , -1);
                  break;
     default:error(E_INTERN);
    }

 }







static void call_3plane(OUT3PL proc, FILE *fout,  dim w,dim h,
                        uBYTE *rptr,sdim rzeil,sdim rpix,
                        uBYTE *gptr,sdim gzeil,sdim gpix,
                        uBYTE *bptr,sdim bzeil,sdim bpix)
 {
  flip_corr(w,h,&rptr,&rzeil,&rpix);
  flip_corr(w,h,&gptr,&gzeil,&gpix);
  flip_corr(w,h,&bptr,&bzeil,&bpix);

  (*proc)(fout,w,h,rptr,rzeil,rpix,gptr,gzeil,gpix,bptr,bzeil,bpix );
 }


static void do_3plane(OUT3PL proc,FILE *fout,dim w,dim h,
                      implane *r,implane *g,implane *b,
                      enum TURNS t)
 {
   switch(t)
    {case T_NONE: call_3plane(proc,fout,w,h,r->im,r->mwidth,1,
                                            g->im,g->mwidth,1,
                                            b->im,b->mwidth,1);
                  break;
     case T_RIGHT:call_3plane(proc,fout,h,w,r->im + r->mwidth * ( r->iheight - 1) , 1 , -(r->mwidth),
                                            g->im + g->mwidth * ( g->iheight - 1) , 1 , -(g->mwidth),
                                            b->im + b->mwidth * ( b->iheight - 1) , 1 , -(b->mwidth));
                  break;
     case T_LEFT: call_3plane(proc,fout,h,w,r->im + r->iwidth - 1 , -1 , (r->mwidth),
                                            g->im + g->iwidth - 1 , -1 , (g->mwidth),
                                            b->im + b->iwidth - 1 , -1 , (b->mwidth));
                  break;
     case T_HEAD: call_3plane(proc,fout,w,h,r->im + r->iwidth - 1 + r->mwidth * ( r->iheight - 1)  , -(r->mwidth) , -1,
                                            g->im + g->iwidth - 1 + g->mwidth * ( g->iheight - 1)  , -(g->mwidth) , -1,
                                            b->im + b->iwidth - 1 + b->mwidth * ( b->iheight - 1)  , -(b->mwidth) , -1);
                  break;
     default:error(E_INTERN);
    }

 }











void writepicture(FILE *fout, sizeinfo *si,
                  implane *r,implane *g,implane *b,
                  enum TURNS t)
 {dim w,h;

  w=si->imhlen;
  h=si->imvlen;

  melde("writepicture\n");
     if((!r) || (r->iwidth != w ) || (r->iheight != h) || (!r->im)) error(E_INTERN);

  if(!monochrome)
   {
     if((!g) || (g->iwidth != w ) || (g->iheight != h) || (!g->im)) error(E_INTERN);
     if((!b) || (b->iwidth != w ) || (b->iheight != h) || (!b->im)) error(E_INTERN);
   }

  switch(outfor)
   {case O_YCC:
    case O_PPM:  do_3plane(write_ppm     ,fout,w,h,r,g,b,t); break;
    case O_PS:   do_3plane(write_psrgb   ,fout,w,h,r,g,b,t); break;
    case O_EPS:  do_3plane(write_epsrgb  ,fout,w,h,r,g,b,t); break;
    /* cas TGA */
    case O_TGA:  do_3plane(write_tga     ,fout,w,h,r,g,b,t); break;

    case O_PGM:  do_1plane(write_pgm     ,fout,w,h,r,t);     break;
    case O_PSG:  do_1plane(write_psgrey  ,fout,w,h,r,t);     break;
    case O_EPSG: do_1plane(write_epsgrey ,fout,w,h,r,t);     break;
    case O_PSD:  do_1plane(write_psdith  ,fout,w,h,r,t);     break;
    case O_EPSD: do_1plane(write_epsdith ,fout,w,h,r,t);     break;
    default: error(E_INTERN);
   }


 }









struct ph1
 {char  id1[8];
  uBYTE ww1[14];
  char  id2[20];
  char  id3[4*16+4];
  short ww2;
  char  id4[20];
  uBYTE ww3[2*16+1];
  char  id5[4*16];
  uBYTE idx[11*16];
 } ;


void druckeid(void)
{struct ph1 *d;
 char ss[100];

 d=(struct ph1 *)sbuffer;

#define dr(feld,kennung)   \
     strncpy(ss,feld,sizeof(feld));\
     ss[sizeof(feld)]=0;\
     fprintf(stderr,"%s: %s \n",kennung,ss);


dr(d->id1,"Id1")
dr(d->id2,"Id2")
dr(d->id3,"Id3")
dr(d->id4,"Id4")
dr(d->id5,"Id5")

#undef dr

}






