/* hpcdtoppm (Hadmut's pcdtoppm) v0.6.beta
*  Copyright (c) 1992, 1993, 1994 by Hadmut Danisch (danisch@ira.uka.de).
*  Permission to use and distribute this software and its
*  documentation for noncommercial use and without fee is hereby granted,
*  provided that the above copyright notice appear in all copies and that
*  both that copyright notice and this permission notice appear in
*  supporting documentation. It is not allowed to sell this software in
*  any way. This software is not public domain.
*/

/***********************************/
/*     Sortie sur fichiers TGA     */
/*   Par Serge Delbono 24/03/94    */
/*                                 */
/***********************************/

#include "hpcdtoppm.h"

static uBYTE BUF[own_BUsize];
#define BUinit {BUcount=0;BUptr=BUF;}

#define BUrgb_flush        {fwrite(BUF,BUcount*3,1,fout);BUinit; }
#define BUrgb_write(r,g,b) {if(BUcount>=own_BUsize/3) BUrgb_flush; *BUptr++ = r ; *BUptr++ = g ; *BUptr++ = b ; BUcount++;}

#define BUgreyflush        {fwrite(BUF,BUcount,1,fout);BUinit; }
#define BUgreywrite(g)     {if(BUcount>=own_BUsize) BUgreyflush;  *BUptr++ = g ;  BUcount++;}


void write_tga(FILE *fout,      /* fichier sortie */
               dim w,dim h,     /* largeur / hauteur */
               uBYTE *rptr,     /* */
               sdim rzeil,sdim rpix,
               uBYTE *gptr,sdim gzeil,sdim gpix,
               uBYTE *bptr,sdim bzeil,sdim bpix)

 {register uBYTE *pr,*pg,*pb;
  dim x,y;
  int i ;
  static uBYTE *BUptr;
  sINT   BUcount;
/* write the header */
/*  fprintf(fout,PPM_Header,w,h); */
  for (i = 0; i < 12; i++)    /* 00, 00, 02, then 7 00's... */
     if (i == 2)
       putc(i, fout);
     else
      putc(0, fout);

/*  putc(First_Line % 256, fout); */ /* y origin set to "First_Line" */
/*  putc(First_Line / 256, fout); */

    putc(w % 256, fout);  /* write width and height */
    putc(w / 256, fout);
    putc(h % 256, fout);
    putc(h / 256, fout);
    putc(24, fout);  /* 24 bits/pixel (16 million colors!) */
    putc(32, fout);  /* Bitmask, pertinent bit: top-down raster */
  BUinit;
  for(y=0;y<h;y++)
   {
     pr= rptr; rptr+=rzeil;
     pg= gptr; gptr+=gzeil;
     pb= bptr; bptr+=bzeil;
     for(x=0;x<w;x++)
      {BUrgb_write(*pr,*pg,*pb);
       pr+=rpix;  pg+=gpix;  pb+=bpix;
      }
   }
  BUrgb_flush;

 }

