//********************************************************************
//*                                                                  *
//*                           Hierlistbox                            *
//*                           Version 1.0                            *
//*              Copyright (c) 1993 Applied Visions, Inc.            *
//*                                                                  *
//********************************************************************
#ifndef __HIERLIST_H
#define __HIERLIST_H

#ifndef __CONTROL_H
#include <control.h>
#endif

#pragma option -Vo-
#if     defined(__BCOPT__) && !defined(_ALLOW_po)
#pragma option -po-
#endif


//--------------------------------------------------------------------
// Define structures
//--------------------------------------------------------------------
typedef struct{
  BYTE Level;                                               // level for entry
  LPSTR String;                                             // text for entry
  BYTE  Spare1;                                             
  int   Spare2;
} HIERENTRY, FAR * LPHIERENTRY;

//---------------------------------------------------------
// Define Window messages
//---------------------------------------------------------
#define HLB_ADDENTRY            (WM_USER + 0)
#define HLB_GETCURSEL           (WM_USER + 1)
#define HLB_SETTABSTOPS         (WM_USER + 2)
#define HLB_SETHORIZONTALEXTENT (WM_USER + 3)
#define HLB_GETTEXTLEN          (WM_USER + 4)
#define HLB_GETTEXT             (WM_USER + 5)
#define HLB_RESETCONTENT        (WM_USER + 6)

//---------------------------------------------------------
// Define notifications
//---------------------------------------------------------
#define HLBN_SELCHANGE       1
#define HLBN_DBLCLK          2

//---------------------------------------------------------
// Define Constants
//---------------------------------------------------------
#define HIER_SUCCESS   1
#define HIER_FAILURE   0

//---------------------------------------------------------
// Define constant for WM_CTLCOLOR message.  This control 
// sends the WM_CTLCOLOR message to its parent with the
// following indentifer in the HIWORD of lParam. The parent
// can use this messages to change the colors in the Hierarchical
// listbox.
//---------------------------------------------------------
#define CTLCOLOR_HIERLIST     (200)

//--------------------------------------------------------------------
// Hierlistbox class
//--------------------------------------------------------------------
_CLASSDEF(THierListBox)
class  THierListBox : public TControl
{
  static HINSTANCE hLib;
public:
  THierListBox(PTWindowsObject AParent, int AnId,
                 int X, int Y, int W, int H,
                 PTModule AModule = NULL);
  THierListBox(PTWindowsObject AParent, int ResourceId,
                 PTModule AModule = NULL);
  int AddString(LPSTR String, BYTE Level);
  int GetSelIndex();
  void SetTabs(WORD NumTabs, LPWORD Tabs);
  void SetHorizExtent(WORD Extent);
  int GetStringLen(int Index);
  int GetString(LPSTR AString, int Index);
  void ClearList();
  void Redraw(BOOL Redraw);
  static BOOL LoadLibrary();
  static void FreeLibrary();
protected:
  virtual LPSTR GetClassName()
          {return "HierList";}
  THierListBox(StreamableInit) : TControl(streamableInit) {};
private:
    virtual const Pchar streamableName() const
        { return "THierListBox"; }
};

inline Ripstream operator >> ( Ripstream is, RTHierListBox cl )
    { return is >> (RTStreamable )cl; }
inline Ripstream operator >> ( Ripstream is, RPTHierListBox cl )
    { return is >> (RPvoid)cl; }

inline Ropstream operator << ( Ropstream os, RTHierListBox cl )
    { return os << (RTStreamable )cl; }
inline Ropstream operator << ( Ropstream os, PTHierListBox cl )
    { return os << (PTStreamable )cl; }


#pragma option -Vo.
#if     defined(__BCOPT__) && !defined(_ALLOW_po)
#pragma option -po.
#endif

#endif			
