//********************************************************************
//*                                                                  *
//*                 Hierarchial Listbox test program                 *
//*                           Version 1.0                            *
//*                                                                  *
//*   Copyright (c) 1993 Applied Visions, Inc. All Rights Reserved   *
//*                                                                  *
//********************************************************************

#include <owl.h>
#pragma hdrstop
#include <bwcc.h>
#include "hierlist.h"
#include "hlbtest.h"


//------------------------------------------------------------------
// Define local prototypes
//------------------------------------------------------------------

void FillListBox(PTHierListBox HierListBox);

//------------------------------------------------------------------
// Define constants
//------------------------------------------------------------------

char *szTitle = "Hierarchical listbox demo";

//------------------------------------------------------------------
// Hierlistbox window constructor
//------------------------------------------------------------------

THierListBoxWindow::THierListBoxWindow(PTWindowsObject AParent, LPSTR ATitle) 
  : TWindow(AParent, ATitle)
{
  AssignMenu("MAINMENU");
}


//------------------------------------------------------------------
// Hierlistbox window destructor
//------------------------------------------------------------------

THierListBoxWindow::~THierListBoxWindow()
{
  THierListBox::FreeLibrary();
}
 

//------------------------------------------------------------------
// Hierlistbox setup window.
//------------------------------------------------------------------

void THierListBoxWindow::SetupWindow()
{
  // make sure BWCC is loaded
  (void) BWCCGetVersion();

 HierListBox = new THierListBox(this, ID_HIERLISTBOX, 20, 20, 340, 100);
 TWindow::SetupWindow();
 FillListBox(HierListBox);

 // set focus on listbox
 SetFocus(HierListBox->HWindow);
}


//------------------------------------------------------------------
// Responds to notication from the hierlistbox.
//------------------------------------------------------------------

void THierListBoxWindow::CNHierList(RTMessage Msg)
{
  if (Msg.LP.Hi == HLBN_DBLCLK)
  {
    int Index;
    char buf[100];

    Index = HierListBox->GetSelIndex();
    wsprintf(buf, "You have select entry number %d", Index);
    MessageBox(NULL, buf, szTitle, MB_OK);

    int StringLen = HierListBox->GetStringLen(Index);
    char *String;

    String = new char[StringLen+1];
    HierListBox->GetString(String, Index);
    delete []String;

    // set focus back on listbox
    SetFocus(HierListBox->HWindow);
  }
}


//------------------------------------------------------------------
// Displays the test dialog
//------------------------------------------------------------------

void THierListBoxWindow::CMDialog(RTMessage)
{
  GetApplication()->ExecDialog(new TTestDialog(this, "TESTDLG"));
}
 

//------------------------------------------------------------------
// Displays about dialog box
//------------------------------------------------------------------

void THierListBoxWindow::CMAbout(RTMessage)
{
  GetApplication()->ExecDialog(new TDialog(this, "ABOUT"));
}

 
//------------------------------------------------------------------
// Passes focus from the window to the listbox
//------------------------------------------------------------------

void THierListBoxWindow::WMSetFocus(RTMessage)
{
  SetFocus(HierListBox->HWindow);
}


//------------------------------------------------------------------
// Testdialog constructor
//------------------------------------------------------------------

TTestDialog::TTestDialog(PTWindowsObject AParent, LPSTR AName) : TDialog(AParent, AName)
{
  HierListBox = new THierListBox(this, IDD_LISTBOX);
}


//------------------------------------------------------------------
// Setup window method
//------------------------------------------------------------------

void TTestDialog::SetupWindow()
{
  HWND hWnd;

  TDialog::SetupWindow();

  // initially disable clear button
  hWnd = GetDlgItem(HWindow, IDD_CLEARLIST);
  EnableWindow(hWnd, FALSE);
}
 

//------------------------------------------------------------------
// Listbox response function
//------------------------------------------------------------------

void TTestDialog::CMListBox(RTMessage Msg)
{
  if ( Msg.LP.Hi == HLBN_DBLCLK)
  {
    int Index;
    char buf[100];

    Index = HierListBox->GetSelIndex();
    wsprintf(buf, "You have select entry number %d", Index);
    MessageBox(NULL, buf, szTitle, MB_OK);
  }
}


//------------------------------------------------------------------
// Fill listbox funtton response function
//------------------------------------------------------------------

void TTestDialog::CMFill(RTMessage)
{
  HWND hWnd;

  // disable fill and enable clear button
  hWnd = GetDlgItem(HWindow, IDD_FILLLIST);
  EnableWindow(hWnd, FALSE);

  hWnd = GetDlgItem(HWindow, IDD_CLEARLIST);
  EnableWindow(hWnd, TRUE);

  // Set focus to listbox
  SetFocus(HierListBox->HWindow);
  FillListBox(HierListBox);   
}


//------------------------------------------------------------------
// Clears listbox
//------------------------------------------------------------------

void TTestDialog::CMClear(RTMessage)
{
  HWND hWnd;

  // enable fill and disable clear button
  hWnd = GetDlgItem(HWindow, IDD_FILLLIST);
  EnableWindow(hWnd, TRUE);

  hWnd = GetDlgItem(HWindow, IDD_CLEARLIST);
  EnableWindow(hWnd, FALSE);

  // now clear listbox
  HierListBox->ClearList();

  // Set focus to listbox
  SetFocus(HierListBox->HWindow);
}


//------------------------------------------------------------------
// Fills up Hierlistbox with testdata
//------------------------------------------------------------------

void FillListBox(PTHierListBox HierListBox)
{
  int Index1, Index2, Index3;
  char buf[100];

  // turn redraw off while filling in the listbox 
  HierListBox->Redraw(FALSE);

  // setup horizontal scrollbar
  HierListBox->SetHorizExtent(500);

  for (Index1 = 0; Index1 < 5; Index1++)
  {
     wsprintf(buf, "This is String %d ", Index1);
     HierListBox->AddString(buf, 0);

     for (Index2 = 0; Index2 < 2; Index2++)
     {
       wsprintf(buf, "This is Level 1,  String %d ", Index2);
       HierListBox->AddString(buf, 1);
       for (Index3 = 0; Index3 < 2; Index3++)
       {
	 wsprintf(buf, "This is Level 2, String %d ", Index3);
	 HierListBox->AddString(buf, 2);
       }
     }
  }
  HierListBox->Redraw(TRUE);
}


//------------------------------------------------------------------
// Main window initialization procedure
//------------------------------------------------------------------

void TTestApp::InitMainWindow()
{
  MainWindow = new THierListBoxWindow(NULL, Name);
}


//------------------------------------------------------------------
// Windows entry point
//------------------------------------------------------------------

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  // First make sure we can load the DLL.  If we can't then don't continue.
  if (!THierListBox::LoadLibrary())
  {
    MessageBox(NULL, "Error loading Hierlist.DLL.  Cannot run application.", szTitle, MB_OK);
    return 0;
  }
 
  TTestApp TestApp(szTitle, hInstance, hPrevInstance,
    lpCmdLine, nCmdShow);
  TestApp.Run();
  return TestApp.Status;
}
