#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <iostream.h>
#include "titillat.h"
#include "plot3d.h"
#include "hp3d.h"

#ifndef TRUE
#define TRUE -1
#endif
#ifndef FALSE
#define FALSE 0
#endif

static int pattern [8] [8]
            = { { 0, 32,  8, 40,  2, 34, 10, 42},
                {48, 16, 56, 24, 50, 18, 58, 26},
                {12, 44,  4, 36, 14, 46,  6, 38},
                {60, 28, 52, 20, 62, 30, 54, 22},
                { 3, 35, 11, 43,  1, 33,  9, 41},
                {51, 19, 59, 27, 49, 17, 57, 25},
                {15, 47,  7, 39, 13, 45,  5, 37},
                {63, 31, 55, 23, 61, 29, 53, 21}
              }; // for dithering

static unsigned char black [8] = {128, 64, 32, 16, 8, 4, 2, 1};
static unsigned char white [8] = {127, 191, 223, 239, 247, 251, 253, 254};

hp3d::hp3d() : plot3d()
  {
    row_array_allocated=FALSE;
  }

hp3d::~hp3d()
  {
    if (row_array_allocated)
      delete row_array;
  }

int hp3d::display_initialized()
//      Allocate and clear the page of graphics to be sent to the printer.
    {
      row_rec initialized_row_rec;

      if (row_array_allocated)
        {
           delete row_array;
           row_array_allocated=FALSE;
        }
      for (int x_byte_num=0; x_byte_num < NUM_X_BYTES; x_byte_num++)
        initialized_row_rec.column[x_byte_num]=(unsigned char) '\0';
      row_array=new varray<row_rec>(initialized_row_rec,NUM_Y_PIXELS,2);
      row_array_allocated=(row_array->allocated());
      return row_array_allocated;
    }

void hp3d::pset(
  int x,
  int y,
  int shading)
    {
      int     bit_num;
      int     byte_num;
      int     on;
      row_rec *row;

      if (shading <= NUM_COLORS)
        {
          if (shading == NUM_COLORS)  // highlight
            if (pattern[x%8][y%8] < SOLUTION_GRAY)
              on=1;
            else
              on=0;
          else
            if (pattern[x%8][y%8] < shading)
              on=1;
            else
              on=0;
          byte_num=x/8;
          bit_num=x-8*byte_num;
          row=row_array->vm_ptr((long) y);
          if (on)
            row->column[byte_num]
             =(row->column[byte_num] & white[bit_num]);
          else
            row->column[byte_num]
             =(row->column[byte_num] | black[bit_num]);
        }
      return;
    }

int hp3d::write_outfile(
  char *file_name)
//      Write the page of graphics to a file where it can later be copied
// to the printer.  (The /B option *must* be used with the COPY command.)
    {
      unsigned char ascii_equivalent [6];
      int           cursor_x;
      char          cursor_x_prefix [3] = {'\033', '\052', '\160'};
      char          cursor_x_suffix = '\130';
      int           cursor_y;
      char          cursor_y_prefix [3] = {'\033', '\052', '\160'};
      char          cursor_y_suffix = '\131';
      char          dpi_prefix [3] = {'\033', '\052', '\164'};
      char          dpi_suffix = '\122';
      int           ending_column_num;
      char          formfeed = '\014';
      char          landscape [5]
                     = {'\033', '\046', '\154', '\061', '\117'};
      char          logical_mode [5]
                     = {'\033', '\052', '\162', '\060', '\106'};
      FILE          *maze;
      int           non_null_found;
      int           num_bytes;
      char          raster_prefix [5]
                     = {'\033', '\052', '\162', '\061', '\101'};
      char          raster_suffix [4]
                     = {'\033', '\052', '\162', '\102'};
      row_rec       *row;
      char          row_prefix [3] = {'\033', '\052', '\142'};
      char          row_suffix = '\127';
      int           starting_column_num;
      int           success;
      int           y;

      if ((maze=fopen(file_name,"wb")) == NULL)
        {
          success=FALSE;
          cerr << "Fatal error:  cannot open " << file_name << '\n';
        }
      else
        {
          success
           =(fwrite(landscape,1,sizeof(landscape),maze) == sizeof(landscape));
          if (success)
            success=(fwrite(dpi_prefix,1,sizeof(dpi_prefix),maze)
             == sizeof(dpi_prefix));
          if (success)
            {
              sprintf((char *) ascii_equivalent,"%d",PIXELS_PER_INCH);
              success=(fwrite(&(ascii_equivalent[0]),1,
               strlen((char *) ascii_equivalent),maze)
               == strlen((char *) ascii_equivalent));
            }
          if (success)
            success=(fwrite(&dpi_suffix,1,sizeof(dpi_suffix),maze)
             == sizeof(dpi_suffix));
          if (success)
            success=(fwrite(logical_mode,1,sizeof(logical_mode),maze)
             == sizeof(logical_mode));
          titillator_ptr=new titillator;
          for (y=0; ((success) && (y < NUM_Y_PIXELS)); y++)
            {
              titillator_ptr->titillate();
              row=row_array->vm_ptr((long) y);
              starting_column_num=0;
              non_null_found=FALSE;
              while ((starting_column_num <= X_BYTE_MAX)
              &&     (! non_null_found))
                if ((*row).column[starting_column_num]
                 == 0)
                  starting_column_num++;
                else
                  non_null_found=TRUE;
              if (non_null_found)
                {
                  non_null_found=FALSE;
                  ending_column_num=X_BYTE_MAX;
                  while ((ending_column_num >= 0)
                   && (! non_null_found))
                    if ((*row).column[ending_column_num]
                     == 0)
                      ending_column_num--;
                    else
                      non_null_found=TRUE;
                  success
                   =(fwrite(cursor_x_prefix,1,sizeof(cursor_x_prefix),maze)
                   == sizeof(cursor_x_prefix));
                  if (success)
                    {
                      cursor_x=PIXELS_PER_STROKE*8*starting_column_num;
                      sprintf((char *) ascii_equivalent,"%d",cursor_x);
                      success=(fwrite(&(ascii_equivalent[0]),1,
                       strlen(ascii_equivalent),maze)
                       == strlen(ascii_equivalent));
                    }
                  if (success)
                    success=(fwrite(&cursor_x_suffix,1,
                     sizeof(cursor_x_suffix),maze) == sizeof(cursor_x_suffix));
                  if (success)
                    success=(fwrite(cursor_y_prefix,1,
                     sizeof(cursor_y_prefix),maze) == sizeof(cursor_y_prefix));
                  if (success)
                    {
                      cursor_y=PIXELS_PER_STROKE*y;
                      sprintf(ascii_equivalent,"%d",cursor_y);
                      success=(fwrite(&(ascii_equivalent[0]),1,
                       strlen(ascii_equivalent),maze)
                       == strlen(ascii_equivalent));
                    }
                  if (success)
                    success=(fwrite(&cursor_y_suffix,1,
                     sizeof(cursor_y_suffix),maze) == sizeof(cursor_y_suffix));
                  if (success)
                    success=(fwrite(raster_prefix,1,sizeof(raster_prefix),
                     maze) == sizeof(raster_prefix));
                  if (success)
                    success=(fwrite(row_prefix,1,sizeof(row_prefix),maze)
                     == sizeof(row_prefix));
                  if (success)
                    {
                      num_bytes=ending_column_num-starting_column_num+1;
                      sprintf(ascii_equivalent,"%d",num_bytes);
                      success=(fwrite(&(ascii_equivalent[0]),1,
                       strlen(ascii_equivalent),maze)
                       == strlen(ascii_equivalent));
                    }
                  if (success)
                    success=(fwrite(&row_suffix,1,sizeof(row_suffix),maze)
                     == sizeof(row_suffix));
                  if (success)
                    success=(fwrite(&((*row).column[starting_column_num]),
                     1,num_bytes,maze) == (unsigned int) num_bytes);
                  if (success)
                    success=(fwrite(raster_suffix,1,sizeof(raster_suffix),
                     maze) == sizeof(raster_suffix));
                }
            }
          delete titillator_ptr;
          success=(fwrite(&formfeed,1,sizeof(formfeed),maze)
           == sizeof(formfeed));
          if (! success)
            cerr << "Fatal error:  not enough disk space." << '\n';
          fclose(maze);
        }
      return success;
    }
