#include <complex.h>
#include <string.h>
#include <graphics.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include <fstream.h>

static complex c;
static int newcolor, quickdraw, boxmode;
static int bailout;
static int maxiter;
static int vmode;
static float ofx, ofy, fakx, faky;
static char bgidrvname[20];
static char palname[30];
static int treiber;

float iterate (complex op)
{
	unsigned int itercount=0;
	for (;;) {
		itercount++;
		op=op*op+c;
		if ((abs(op) >= bailout) && newcolor ) return (arg (op)/(2 * 3.14));
		if ((itercount>maxiter)  && newcolor ) return (arg (op)/(2 * 3.14));
		if (abs(op) >= bailout) return (float) itercount/(float) maxiter;
		if (itercount>maxiter) return (float) 0;

	}
}

void initparams (void)
{
  bailout=4;
  maxiter=100;
  quickdraw=(1==1);
  ofy=-1.5;
  faky=3.0 / (float) getmaxy();
  ofx=-0.8;
  fakx=2.56 / (float) getmaxx();
  boxmode=newcolor=(1==0);
}

void load_palette ()
{
  int i,r,g,b;
  ifstream *infile= new ifstream (palname);
  for (i=0; i<=255; i++) {
	(*infile) >> r >> g >> b;
	if (infile->good()) setrgbpalette (i,r>>2, g>>2, b>>2); else setrgbpalette (i, i>>2, i>>2, i>>2);
  }
  delete infile;
}

void grafik_an (void)
{
	treiber=installuserdriver(bgidrvname, 0);
	initgraph (&treiber, &vmode, "");
	load_palette();
}

void select_graphmode (void)
{
  clrscr();
  printf ("     * Cheap Fractal Generator Video Setup *\n");
  printf ("     \n\n");
  printf ("      0.    Standard VGA    ( 320200256)\n");
  printf ("      1.    Detect Supervga ( 640350256)\n");
  printf ("      2.    Detect Supervga ( 640400256)\n");
  printf ("      3.    Detect Supervga ( 640480256)\n");
  printf ("      4.    Detect Supervga ( 800600256)\n");
  printf ("      5.    Detect Supervga (1024768256)\n");
  printf ("      6..10 Tseng ET3000    (same as 1..4)\n");
  printf ("     11..15 Tseng ET4000    (same as 1..5)\n");
  printf ("     16..20 Paradise/Cirrus (same as 1..3)\n");
  printf ("     21..25 Video Seven     (same as 1..3)\n");
  printf ("     26..30 Trident/Poach51 (same as 1..4)\n");
  printf ("\n\n	Enter a Video-Mode: ");
  fscanf(stdin, "%d", &vmode);
}

char edit_parameters (void)
{
  char ch;
  do {
	clrscr();
	printf ("     * Cheap Fractal Generator Parameter Setup *\n");
	printf ("     \n\n");
	printf ("      b.    Bailout Value            = %d\n", bailout);
	printf ("      i.    Maximum Iterations       = %d\n", maxiter);
	printf ("      c.    Argument Coloring Method = %d\n", newcolor);
	printf ("      q.    Quickdraw Mode           = %d\n", quickdraw);
	printf ("      o.    Boxdraw(debug)-Mode      = %d\n", boxmode);
	printf ("      v.    Select Videomode\n");
	printf ("      r.    Reset to standard-parameters\n");
	printf ("      p.    Fractint .MAP-Filename   = %s\n",palname);
	printf ("      <CR>  Calculate new Picture\n");
	printf ("      x.    Exit Program\n");
	ch=(char)getch();
	switch (ch) {
	  case 'b': { gotoxy (40,4); clreol; fscanf(stdin, "%d", &bailout); } break;
	  case 'i': { gotoxy (40,5); clreol; fscanf(stdin, "%d", &maxiter); } break;
	  case 'c': { newcolor= !newcolor;} break;
	  case 'q': { quickdraw=quickdraw; } break;
	  case 'o': { boxmode=!boxmode; } break;
	  case 'v': { select_graphmode(); }; break;
	  case 'r': { grafik_an(); initparams (); closegraph();} break;
	  case 'p': { gotoxy (40,11); clreol; fscanf(stdin, "%s", &palname); } break;
	  case 13 : { grafik_an(); }; break;
	}
  } while (!((ch=='x') || (ch==13)));
  return ch;
}

void berechnepunkt (int x, int y)
{
  float im,re;
  int color;
  im=ofy+faky*(float) (y);
  re=ofx+fakx*(float) (x);
  c=complex (-re, -im);
  if (getpixel (x,y)==0) {
	color=(255-iterate (complex (re, im))*255);
	if (color>255) color&=255;
	if (color<=0) color=1;
	putpixel(x,y,color);
 }
}

void Berechneblock (int x, int y, int s)
{
  int t1, t2, t3, t4;
  if (kbhit()) return;
  berechnepunkt (x,y);
  berechnepunkt (x+s, y);
  berechnepunkt (x, y+s);
  berechnepunkt (x+s, y+s);
  if (s==1) return; 
  t1=getpixel (x,y);
  t2=getpixel (x+s, y);
  t3=getpixel (x, y+s);
  t4=getpixel (x+s, y+s);
  if ((t1==t2) && (t3==t4) && (t1==t3)) {
	if (s!=31) {
	  if (boxmode) {
		setcolor (t1);
		rectangle (x,y,x+s,y+s);
		return;
	  } else {
		setfillstyle (SOLID_FILL, t1);
		bar (x,y,x+s,y+s);
		return;
	  }
	}
	berechnepunkt (x+16,y+16);
	if (t1==getpixel (x+16,y+16)) {
	  if (boxmode) {
		setcolor (t1);
		rectangle (x,y,x+s,y+s);
		return;
	  } else {
		setfillstyle (SOLID_FILL, t1);
		bar (x,y,x+s,y+s);
		return;
	  }
	}
  }
  // rekrusive Sprnge
  if (s==31) {Berechneblock (x,y,15);
			  Berechneblock (x+16,y,15);
			  Berechneblock (x,y+16,15);
			  Berechneblock (x+16,y+16,15);
			  return; // exit here
  }
  if (s==15) {Berechneblock (x,y,7);
			  Berechneblock (x+8,y,7);
			  Berechneblock (x,y+8,7);
			  Berechneblock (x+8,y+8,7);
			  return; // exit here
  }
  if (s==7) { Berechneblock (x,y,3);
			  Berechneblock (x+4,y,3);
			  Berechneblock (x,y+4,3);
			  Berechneblock (x+4,y+4,3);
			  return; // exit here
  }
  if (s==3) { Berechneblock (x,y,1);
			  Berechneblock (x+2,y,1);
			  Berechneblock (x,y+2,1);
			  Berechneblock (x+2,y+2,1);
			  return; // exit here
  }
}

void guess (void)
{
  int x,y;
	if (quickdraw) {
	  for (x=0; x<getmaxx(); x+=32) {
		for (y=0; y<getmaxy(); y+=32) {if (kbhit()) break;Berechneblock (x,y,31);}
		if (kbhit()) break;
	  }
	} else {
	  for (x=0; x<getmaxx(); x+=15) {
		for (y=0; y<getmaxy(); y+=15) {
		  if (kbhit()) break;
		  Berechneblock (x,y,15);
		  }
		if (kbhit()) break;
	  }
	}
}


void main (void)
{
  int dx,dy,x,y;
  int ch,c;
  float zoom, x1,y1,x2,y2, deltax, deltay;
  vmode=0;
  strcpy (bgidrvname, "SUPERVGA");
  strcpy (palname, "GAMMA1.MAP");
  grafik_an();
  initparams();
  closegraph ();
  ch=edit_parameters();
  if (ch!='x') {
	do {
	  guess();
	  zoom=3;
	  dx=(float)getmaxx()/zoom;
	  dy=(float)getmaxy()/zoom;
	  x=getmaxx()/2-dx/2;
	  y=getmaxy()/2-dy/2;
	  setwritemode (1);
	  setrgbpalette (0,33,33,63);
	  do {
		rectangle (x,y,x+dx, y+dy);
		ch=(char) getch();
		rectangle (x,y,x+dx, y+dy);
		if (ch== '+') { zoom*=1.1;}
		if (ch== '-') { zoom/=1.1;}
		if (ch== '6') x+=2;
		if (ch== '4') x-=2;
		if (ch== '2') y+=2;
		if (ch== '8') y-=2;
		 dx=(float)getmaxx()/zoom;
		 dy=(float)getmaxy()/zoom;
		 x1= ofx+ (float) x * fakx;
		 y1= ofy+ (float) y * faky;
		 x2= ofx+ (float) (x+dx) * fakx;
		 y2= ofy+ (float) (y+dy) * faky;
		 gotoxy (1,1); printf ("im= [%f, %f]",x1,x2);
		 gotoxy (1,2); printf ("re= [%f, %f]",y1,y2);
		} while (!((ch==13) || (ch == 'x') || (ch==27)));
	  closegraph();
	  if (ch!='x') c=edit_parameters();
	  grafik_an();
	  if (ch!=27) {
		deltax= (float) (x2-x1);
		deltay= (float) (y2-y1);
		ofx=x1;
		ofy=y1;
		fakx= (float) deltax/(float) getmaxx();
		faky= (float) deltay/(float) getmaxy();
		if (maxiter<0) maxiter=10;
	  }
	} while (c !='x');
  }
  closegraph();
  printf ("Bye!\n");
}

