// ddemdi.h

#include <owl.h>
#include <mdi.h>
#include <string.h>
#include <stdio.h>
#include <shellapi.h>

#include "ddemgr.h"
#include "ddemdirc.h"

#define CHAR_LENGTH 81
#define NUM_LENGTH	16

_CLASSDEF(TMDIDDETestApp)
_CLASSDEF(TMDIFrameDDETest)
_CLASSDEF(TConnectWindow)

// Forward declaration
void AdviseProc(char * Data, void * This);

// Define a TApplication descendant 
class TMDIDDETestApp : public TApplication
{
public:
	TMDIDDETestApp(LPSTR name, HANDLE hInstance,
		  HANDLE hPrevInstance, LPSTR lpCmd,
		  int nCmdShow)
	        : TApplication(name, hInstance,
			       hPrevInstance, lpCmd, nCmdShow) {};
    virtual void InitMainWindow();
};

// TMDIFrame descendant for managing connection windows
class TMDIFrameDDETest : public TMDIFrame
{
public:
  	// Constructor & Destructor
  	TMDIFrameDDETest(LPSTR ATitle, LPSTR MenuName);
  	virtual ~TMDIFrameDDETest();

  	// Menu Response Items
	virtual void MConnectA() = [CM_FIRST + CM_CONNECT_A];
	virtual void MConnectB() = [CM_FIRST + CM_CONNECT_B];

    // Pointers to Child windows
  	PTConnectWindow	ConnectAWindow, ConnectBWindow;

protected:
	char 		ChildName[CHAR_LENGTH];

  	// Helper Functions
  	virtual PTWindowsObject InitChild();
};

// TWindow descendent for managing a DDE Connection
class TConnectWindow : public TWindow
{
public:
	// Constructor & Destructor
	TConnectWindow(PTWindowsObject WType, LPSTR WTitle, char *service);
	virtual ~TConnectWindow();

    // Re-draw available data string
	virtual void Paint(HDC, PAINTSTRUCT&);

    // pointer to data allocated by DDEManager
    char * Data;

protected:
	PTMDIFrameDDETest Parent;
	DDEManager * DDEConv;
	char Service[CHAR_LENGTH];
};

