// ddetest.cpp

#include "ddetest.h"

TDMLClApp::TDMLClApp( LPSTR lpszNam, HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpszCmdLn, int nCmdShw )
    : TApplication( lpszNam, hInst, hPrevInst, lpszCmdLn, nCmdShw )
{
}

TDMLClApp::~TDMLClApp()
{
}

void TDMLClApp::InitMainWindow()
{
	MainWindow = new TDMLClWnd( NULL, "DDETEST (A DDE Client)" );
}

TDMLClWnd::TDMLClWnd( PTWindowsObject AParent, LPSTR ATitle )
    : TWindow( AParent, ATitle )
{
	DDEConv1 = NULL;
    tfLoop = FALSE;

	strcpy(sService, "ServerA");
	strcpy(sTopic, "Topic");
	strcpy(sItem, "Item");
	strcpy(sPoke, "PokeData");
	strcpy(sExec, "ExecCommand");
	sData = NULL;

	memset(&ItemBuffer, 0x0, sizeof(ItemBuffer));
	strcpy(ItemBuffer.Service, "MSAccess");
	strcpy(ItemBuffer.Topic, "<database>;SQL <sqltext> ;");
	strcpy(ItemBuffer.Item, "Data");

	Attr.Style |= WS_VSCROLL | WS_HSCROLL;
	Scroller = new TScroller(this, 20, 20, 100, 500);
}

TDMLClWnd::~TDMLClWnd()
{
	if( DDEConv1 )
		delete DDEConv1;
	if( sData )
		delete [] sData;
}

void TDMLClWnd::SetupWindow()
{
	AssignMenu( TDMLClWnd_MENU );
}

void TDMLClWnd::Paint( HDC hdc, PAINTSTRUCT _FAR & )
{
    RECT rTemp;
	static char szTemp[] = "This example of the Dynamic Data Exchange Management.\
To get started, select the \"Connect!\" menu item.";

	// Draw text in very large rectangle, allow scrolling
	rTemp.left = rTemp.top = 0;
	rTemp.right = 2000;
	rTemp.bottom = 5000;

    if( sData )
    {
		// The sData string is obtained from the DDE Server.
		DrawText( hdc, sData, strlen( sData ), &rTemp, DT_WORDBREAK | DT_EXPANDTABS);
	}
	else
	{
        DrawText( hdc, szTemp, strlen( szTemp ), &rTemp, DT_WORDBREAK );
    }
}

void TDMLClWnd::CMExit( RTMessage Msg )
{
    TWindow::CMExit( Msg );
}

// Update menu to indicate available selections
void TDMLClWnd::WMInitMenu( RTMessage Msg )
{
	BOOL Conv1 = FALSE;
	if( DDEConv1 )
		Conv1 = DDEConv1->IsConnected();

	HMENU hmTemp = (HMENU)Msg.WParam;

	EnableMenuItem( hmTemp, CM_U_CONNECT, ( Conv1 == FALSE )? MF_ENABLED : MF_GRAYED );
    EnableMenuItem( hmTemp, CM_U_REQUEST, ( Conv1 == TRUE )? MF_ENABLED : MF_GRAYED );
	EnableMenuItem( hmTemp, CM_U_POKE, ( Conv1 == TRUE )? MF_ENABLED : MF_GRAYED );
	EnableMenuItem( hmTemp, CM_U_EXECUTE, ( Conv1 == TRUE )? MF_ENABLED : MF_GRAYED );
	EnableMenuItem( hmTemp, CM_U_DISCONNECT, ( Conv1 == TRUE )? MF_ENABLED : MF_GRAYED );
	EnableMenuItem( hmTemp, CM_U_ADVISE, ( Conv1 == TRUE )? MF_ENABLED : MF_GRAYED );
	CheckMenuItem( hmTemp, CM_U_ADVISE, MF_BYCOMMAND | ( tfLoop == TRUE )? MF_CHECKED : MF_UNCHECKED );

	DrawMenuBar(HWindow);
	InvalidateRect(HWindow, NULL, TRUE);
}

// The following functions are used to communicate with DDE Server.

void TDMLClWnd::CMUConnect( RTMessage )
{
	if( GetApplication()->ExecDialog( new TInputDialog( this, Title, "Service : ",
		sService, sizeof( sService ) ) ) == IDOK &&
		GetApplication()->ExecDialog( new TInputDialog( this, Title, "Topic : ",
		sTopic, sizeof( sTopic ) ) ) == IDOK )
	{
		if( !(DDEConv1 = new DDEManager(GetApplication()->hInstance, this)) )
    	{
			MessageBox(NULL, "new DDEManager failed", Title, MB_OK);
			return;
		}

		if( DDEConv1->Connect(sService, sTopic) )
		{
			PostMessage( HWindow, WM_INITMENU, (WPARAM)GetMenu( HWindow ), 0 );
		}
		else
		{
			MessageBox(NULL, DDEConv1->GetErrorText(), "Connect Failed", MB_OK);
			delete DDEConv1;
			DDEConv1 = NULL;
		}
    }
}

void TDMLClWnd::CMURequest( RTMessage )
{
	if( sData )
		delete [] sData;
	sData = NULL;

	if( GetApplication()->ExecDialog( new TInputDialog( this, Title, "Item: ",
		sItem, sizeof( sItem ) ) ) == IDOK )
	{
		if( (sData = DDEConv1->Request(sItem)) )
		{
			InvalidateRect(HWindow, NULL, TRUE);
    	}
		else
			MessageBox(NULL, DDEConv1->GetErrorText(), "Request Failed", MB_OK);
    }
}

void TDMLClWnd::CMUPoke( RTMessage )
{
	if( GetApplication()->ExecDialog( new TInputDialog( this, Title, "Poke string : ",
		sPoke, sizeof( sPoke ) ) ) == IDOK )
	{
		if( !DDEConv1->Poke(sItem, sPoke) )
			MessageBox(NULL, DDEConv1->GetErrorText(), "Poke Failed", MB_OK);
	}
	else
		InvalidateRect(HWindow, NULL, TRUE);
}

void TDMLClWnd::CMUExecute( RTMessage )
{
	if( GetApplication()->ExecDialog( new TInputDialog( this, Title, "Execute string : ",
		sExec, sizeof( sExec ) ) ) == IDOK )
    {
		if( !DDEConv1->Execute(sExec) )
			MessageBox(NULL, DDEConv1->GetErrorText(), "Execute Failed", MB_OK);
	}
	else
		InvalidateRect(HWindow, NULL, TRUE);
}

void TDMLClWnd::CMUAdvise( RTMessage Msg )
{
	HMENU hTempMenu = GetMenu( HWindow );

    if( GetMenuState( hTempMenu, Msg.WParam, MF_BYCOMMAND ) == MF_UNCHECKED )
	{
		if( GetApplication()->ExecDialog( new TInputDialog( this, Title, "Item : ",
				sItem, sizeof( sItem ) ) ) == IDOK )
		{
			if( DDEConv1->RegisterAdviseProc((adviseproc *)&(AdviseProc), sItem) )
        	{
            	CheckMenuItem( hTempMenu, Msg.WParam, MF_BYCOMMAND | MF_CHECKED );
				tfLoop = TRUE;
			}
			else
				MessageBox(NULL, DDEConv1->GetErrorText(), "Begin Advise Failed", MB_OK);
        }
    } else {
		if( DDEConv1->EndAdvise() )
       	{
           	CheckMenuItem( hTempMenu, Msg.WParam, MF_BYCOMMAND | MF_UNCHECKED );
           	tfLoop = FALSE;
		}
		else
			MessageBox(NULL, DDEConv1->GetErrorText(), "End Advise Failed", MB_OK);
	}

	DrawMenuBar( HWindow );
	InvalidateRect(HWindow, NULL, TRUE);
}

void TDMLClWnd::CMUDisconnect( RTMessage )
{
	delete DDEConv1;
	DDEConv1 = NULL;
	tfLoop = FALSE;

	if( sData )
		delete [] sData;
	sData = NULL;

	PostMessage( HWindow, WM_INITMENU, (WPARAM)GetMenu( HWindow ), 0 );
}


// This callback function is actually a part of TDMLClWnd, but it
// cannot have a "this" pointer, so DDEManager passes it back to me.
void AdviseProc( char * data, void * This )
{
	PTDMLClWnd AdvThis = (PTDMLClWnd) This;

	if( AdvThis->sData )
		delete [] AdvThis->sData;
	AdvThis->sData = data;

	InvalidateRect(AdvThis->HWindow, NULL, TRUE);
}


void TDMLClWnd::CMUGetItem( RTMessage )
{
	DDEManager DDEConv2;

	if( sData )
		delete [] sData;
	sData = NULL;

	if( GetApplication()->ExecDialog( new DDEItemDialog( this,
		sizeof(ItemBuffer.Service), sizeof(ItemBuffer.Topic),
		sizeof(ItemBuffer.Item) ) ) == IDOK )
	{
		if( !(sData = DDEConv2.GetDDEItem(ItemBuffer.Service, ItemBuffer.Topic, ItemBuffer.Item,
						NULL, 0, GetApplication()->hInstance)) )
			MessageBox(NULL, DDEConv2.GetErrorText(), "GetItem Failed", MB_OK);
	}

	InvalidateRect(HWindow, NULL, TRUE);
}


void TDMLClWnd::CMUHelpAbout( RTMessage )
{
	MessageBox( HWindow, "DDETEST.EXE - Nov. 1993\nWritten using ObjectWindows",
				"About DDETEST", MB_ICONINFORMATION );
}


DDEItemDialog::DDEItemDialog(PTWindowsObject AParent,
				int lenservice, int lentopic, int lenitem ) :
				TDialog(AParent, "DDEITEM")
{
	// Create grey background brush for dialog box
	BKColor = RGB(192,192,192);
	hBkBrush = CreateSolidBrush(BKColor);

	EditService = new TEdit(this, IDD_SERVICE, lenservice);
	EditTopic = new TEdit(this, IDD_TOPIC, lentopic);
	EditItem = new TEdit(this, IDD_ITEM, lenitem);
	
    TransferBuffer = (void *)&(((TDMLClWnd *)AParent)->ItemBuffer);
}


DDEItemDialog::~DDEItemDialog()
{
	delete EditService;
	delete EditTopic;
	delete EditItem;

	DeleteObject(hBkBrush);
}


// Set Background color for dialog box
void DDEItemDialog::WMCtlColor(RTMessage Msg)
{
	if( Msg.LP.Hi == CTLCOLOR_DLG )
		Msg.Result = (long)hBkBrush;
	if( Msg.LP.Hi == CTLCOLOR_STATIC ||
		Msg.LP.Hi == CTLCOLOR_BTN)
    {
		SetBkColor((HDC)Msg.WParam, BKColor);
		Msg.Result = (long)hBkBrush;
    }
}


int PASCAL WinMain( HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpszCmdLn, int nCmdShw )
{
    TDMLClApp App( "DDETEST Application", hInst, hPrevInst, lpszCmdLn, nCmdShw );

    App.Run();
    return App.Status;
}

