/*
 * dfbits.h - union to define flags for drives to check
 *            (and for setting and clearing en masse)
 *
 *	      (Some more of the tech writer's demented hacking)
 *
 *	drive_bits contains an array of 26 flags, used to determine
 * 	whether we want to check a certain drive.  Bit 0 (LSB) is the
 *	flag for drive A:, bit 1 for drive B:, and so on.  A few defines
 *	here make the main code a bit more readable.
 */

static long drive_bits;

/* need to set or clear 26 bits at once */
#define SET_ALL(db)   db = 0x03FFFFFF
#define CLEAR_ALL(db) db =          0

/* also need to set or clear one at a time */
#define SET_BIT(db, bn)   db |=  (1 << bn)
#define CLEAR_BIT(db, bn) db &= ~(1 << bn)

/* don't forget to read a bit */
#define GET_BIT(db, bn)   (db & (1 << bn))
