/* Original 05/13/88 Robert S Wagoner
   Updated  01/31/89    "       "

   This file contains examples of the following ( TECH.DOC ) calls:


   5E00H  Get Machine Name
   5F02H  Get Redirected Device Entry
   5F03H  Redirect device
   5F04H  Cancel Device Redirection
   5F80H  Get Login Entry
   5F81H  Login to a Server
   5F82H  Logout of a Server


   For the additional Artisoft NOS LAN calls contact:

   LANware Inc.

   Robert S Wagoner
   V.P. Development

   Voice: 416-479-5022
     BBS: 416-479-8066


*/


#include <dos.h>
#include <stdio.h>
#include <dir.h>
#include <conio.h>

static union REGS rg;
struct SREGS sg;

static server[17];

main()
{
int key;

	for(;;) {

		clrscr();

		cprintf("   [ Using Artisoft NOS calls in 'C'  ]\n");
		cprintf("   [  by Robert S Wagoner LANware Inc.]\n\n");
		cprintf("   (1.) Login\n");
		cprintf("   (2.) Logoff\n\n");
		cprintf("   (3.) Show Available Redirections\n");
		cprintf("   (4.) Show Current Redirections\n\n");
		cprintf("   (5.) Create Redirection\n");
		cprintf("   (6.) Remove Redirection\n\n");
		cprintf("   Press ENTER to exit.\n\n");

		key=getch();

		switch (key) {

			case '1': login();
					break;

			case '2': logoff();
					break;

			case '3': show_a();
					break;

			case '4': show_r();
					break;

			case '5': create_r();
					break;

			case '6': cancel_r();
					break;

			case  13:
			case  27:
	  			    exit(0);
					break;
		}
		cprintf("\n\nPRESS any key to continue...");
		getch();
        }
}




login()
{
char user[17];
char pswrd[17];
char login[52];
int pos,pos1;

		cprintf("    server: %s",server);
		input_server();
		cprintf("\n      user: ");
		scanf("%s",user);
		cprintf("  password: ");
		scanf("%s",pswrd);

		strcpy(login,"\\\\");
		 strcat(login,server);
		  strcat(login,"\\");
		   strcat(login,user);

		     pos=strlen(login);
		      login[pos]='*';
		       login[pos+1]='\0';
	                strcat(login,pswrd);
			 pos1=strlen(login);
			  login[pos]=0;
			   login[pos1+1]=0;

		rg.x.ax=0x5f81;
		rg.x.di=login;
		rg.h.bl=0;
		sg.ds=_DS;
		sg.es=_DS;
		intdosx(&rg,&rg,&sg);

	if (!rg.x.cflag) {
		cprintf("\n%-s logged on\n\n",login);
			} else cprintf("\n%-s  login error %d",login,rg.x.ax);

}



logoff()
{
char logoff[17];

		cprintf("    server: %s",server);
		input_server();

		strcpy(logoff,"\\\\");
		 strcat(logoff,server);

		cprintf("\n%s\n",logoff);

		rg.x.ax=0x5f82;
		rg.x.di=logoff;
		sg.ds=_DS;
		sg.es=_DS;
		intdosx(&rg,&rg,&sg);

	if (!rg.x.cflag) {
		cprintf("%s logged off\n\n",server);
			} else cprintf("logoff error %d",rg.x.ax);

}



show_a()
{
struct ffblk ffblk;
int done;
char serv_list[17];

	cprintf("       server: %s",server);
	input_server();
		strcpy(serv_list,"\\\\");
		 strcat(serv_list,server);
		  strcat(serv_list,"\\*.*");

		done=findfirst(serv_list,&ffblk,16);

		if (done) cprintf("\nYour not logged in  or  Server unavailable\n");
        		else cprintf("\n\nRoot\n");

		while(!done) {

		    if (ffblk.ff_name[0] != '.')
					 cprintf("%s\n",ffblk.ff_name);

			done=findnext(&ffblk);
			}

}




show_r()
{
char *type []= { "0","0","0","printer","drive",NULL };

char machine[17];
char local[17];
char network[129];
char c;
int i;

	rg.x.ax=0x5e00;
	rg.x.dx=machine;
	sg.ds=_DS;
	intdosx(&rg,&rg,&sg);
	if (!rg.x.cflag) {
		cprintf("\n\nmachine name [ %s ]\n\n",machine);
                } else cprintf("machine name error %d\n\n",rg.x.ax);

	for (i=0;i<31;i++) {

		rg.x.ax=0x5f80;
		rg.x.bx=i;
		rg.x.di=local;
		sg.ds=_DS;
		sg.es=_DS;
		intdosx(&rg,&rg,&sg);

	if (!rg.x.cflag) {
		cprintf("  user index %d  user logged to server %s \n\n",i,local);
			}
	}


	for (i=0;i<31;i++) {

		rg.x.ax=0x5f02;
		rg.x.bx=i;
		rg.x.si=local;
		rg.x.di=network;
		sg.ds=_DS;
		sg.es=_DS;
		intdosx(&rg,&rg,&sg);

	if (!rg.x.cflag) {
		cprintf("device index %d  local %s -> network %s  type %s\n\n",
			i,local,network,type[rg.h.bl]);
			}
	}

}



create_r()
{
char local[17];
char network[129];
char locname[17],netname[129];
char c;
int i,typ;

		cprintf("        server: %s",server);
		input_server();
		cprintf("\n    local name: ");
		scanf("%s",local);
		cprintf("  network name: ");
		scanf("%s",network);

		strcpy(locname,local);
		 strcpy(netname,"\\\\");
		  strcat(netname,server);

		   if (strnicmp(network,"Root",4) != 0) {
					 strcat(netname,"\\");
		    			   strcat(netname,network);
                                           }

	if (strnicmp(locname,"prn",3)==0 || strnicmp(locname,"lpt",3)==0)
		typ=3;
		  else typ=4;

	rg.x.ax=0x5f03;
	rg.h.bl=typ;
	rg.x.cx=0;
	rg.x.si=locname;
	rg.x.di=netname;
	sg.ds=_DS;
	sg.es=_DS;
	intdosx(&rg,&rg,&sg);

	if (!rg.x.cflag) {
		cprintf("redirect local %s -> network %s\n\n",
			locname,netname);
		} else cprintf("redirect error %d\n\n",rg.x.ax);

}



cancel_r()
{
char local[17];

		cprintf("    local name: ");
		scanf("%s",local);

		rg.x.ax=0x5f04;
		rg.x.si=local;
		sg.ds=_DS;
		intdosx(&rg,&rg,&sg);

	if (!rg.x.cflag) {
		cprintf("\ncancel local %s  status: %d %d\n\n",
			local,rg.x.cflag,rg.x.ax);
              } else cprintf("cancel error %d\n\n",rg.x.ax);
}




input_server()
{
char *ptr,chr;

	ptr=&server;

	do {} while (!kbhit());
                  chr=getch();
	if (chr != 13) {
			 if (*ptr != 0) cprintf("\n       server: %c",chr);
				else cprintf("%c",chr);

			  do { *ptr++=chr;
				chr=getche();
				} while (chr != 13);
					*ptr=0;
			}
}