/* 
   Cx, CXSUB example program.
   Copyright (c) 1990-1994 Eugene Nelson, Four Lakes Computing.
*/

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <conio.h>

/*
   Uncomment the following CXANSI define when using CXF/CXSUB with
   with CX.C.  Or, if you are using Cx with a C compiler exclusively,
   you may add #define CXANSI to the beginning of CX.H.
*/

/* #define CXANSI */

#include "cx.h"
#include "cxsub.c"

#ifndef TRUE
   #define TRUE   1
   #define FALSE  0
#endif

#define NAME      "cxf"

/*-------------------------------------------------------------------------*/
void  USAGE(void)
{
   printf("usage: %s [options] infile [outfile]\n", NAME);
   printf("   -1    compress infile to outfile using CX_METHOD1\n");
   printf("   -2    compress infile to outfile using CX_METHOD2\n");
   printf("   -3    compress infile to outfile using CX_METHOD3\n");
   printf("   -c    compress infile to outfile using CX_METHODC\n");
   printf("   -d    compress infile to outfile using CX_METHODD\n");
   printf("   -x    decompress (extract) infile to outfile\n");
   printf("   -i    test integrity of infile\n");
   printf("   -b[n] buffer size (in K) when compressing (default CX_MAX_BUFFER)\n");
   printf("   -t[n] temporary size (in K) when compressing (default CX_C_MAXTEMP)\n");
   printf("   -q    quiet, no progress information\n");
   printf("\n");
   printf("   Examples:\n");
   printf("      %s -1 -b63 -t63 cx.doc cfile.dat\n", NAME);
   printf("      %s -i cfile.dat\n", NAME);
   printf("      %s -x cfile.dat dfile.dat\n", NAME);
   exit (0);
}

typedef struct {
   int   quiet;
   int   interrupted;
} ARECORD;

/*-------------------------------------------------------------------------*/
int   callback(void *p)
{
   ARECORD  *a = (ARECORD *)p;

   if (!a->quiet)
   {
      printf(".");
      flushall();    /* This line is not ANSI, and is only used for  */
                     /* timely console progress.  It may be removed. */
   }

#ifndef NOKBHIT
   if (kbhit())
   {
      a->interrupted = TRUE;
      return (-1);            /* any non-zero return will work */
   }
#endif

   return (0);
}

/*-------------------------------------------------------------------------*/
int   main(int argc, char *argv[])
{
   CXINT ret;
   CXINT method = 0;
   CXINT buffsize = CX_MAX_BUFFER;
   CXINT tempsize = CX_C_MAXTEMP;

   ARECORD  arecord;
   int   extract = FALSE;
   int   test = FALSE;
   int   j;
   char  *iname = NULL;
   char  *oname = NULL;

   printf("Cx Test Program, Copyright (c) 1990-1994 Four Lakes Computing\n");
   printf("   Ŀ\n");
   printf("   The evaluation object code runs MUCH slower than the object code\n");
   printf("   that may be purchased.  Run TEST.EXE for EXACT speed and size   \n");
   printf("   measurements.                                                   \n");
   printf("   \n");

   arecord.interrupted = FALSE;
   arecord.quiet = FALSE;

   for (j=1; j<argc; ++j)
   {
      if (argv[j][0] == '-')
         switch (toupper(argv[j][1]))
         {
            case '1':   method = CX_METHOD1;    break;
            case '2':   method = CX_METHOD2;    break;
            case '3':   method = CX_METHOD3;    break;
            case 'C':   method = CX_METHODC;    break;
            case 'D':   method = CX_METHODD;    break;

            case 'I':   test = TRUE;            break;
            case 'X':   extract = TRUE;         break;
            case 'Q':   arecord.quiet = TRUE;   break;

            case 'T':   tempsize = atoi(&argv[j][2]) * 1024;   break;

            case 'B':   
               buffsize = atoi(&argv[j][2]) * 1024;
               if (buffsize == 0)
                  USAGE ();
               break;

            default:
               USAGE ();
         }
      else
      {
         if (iname == NULL)
            iname = argv[j];
         else
            oname = argv[j];
      }
   }

   if (iname == NULL)
      USAGE ();

   if ((method != 0) && (oname == NULL))
      USAGE ();

   if (extract && (oname == NULL))
      USAGE ();

   if (!test && !extract && (method == 0))
      USAGE ();

#ifndef NOKBHIT
   printf("Press any key to stop.\n");
#endif

   if (test)
      ret = cx_decompress_file(NULL, iname, callback, &arecord);
   else if (extract)
      ret = cx_decompress_file(oname, iname, callback, &arecord);
   else if (method != 0)
      ret = cx_compress_file(oname, iname, method, buffsize, tempsize, 
                              callback, &arecord);

   printf("\n");

   if (arecord.interrupted)
      printf("Interrupted.\n");
   else if (ret == 0)
      printf("Ok.\n");
   else
      printf("Error: %s\n", cx_error_message(ret));

   return (0);
}
