// read/write data registers
#define HDC_DATA    0x1F0
#define HDC_ERROR   0x1F1
#define HDC_SECCOU  0x1F2
#define HDC_SECNUM  0x1F3
#define HDC_CYLLOW  0x1F4
#define HDC_CYLHIGH 0x1F5
#define HDC_SDH     0x1F6

// read ports
#define HDC_STATUS  0x1F7
#define HDC_ALTSTA  0x3F6

// write ports
#define HDC_COMMAND 0x1F7
#define HDC_FIXED   0x3F6

// read/write commands
#define HDC_COMMAND_RESTORE 0x10
#define HDC_COMMAND_SEEK    0x70
#define HDC_COMMAND_READ    0x20
#define HDC_COMMAND_WRITE   0x30
#define HDC_COMMAND_FORMAT  0x50
#define HDC_COMMAND_READVER 0x90
#define HDC_COMMAND_DIAG    0x90
#define HDC_COMMAND_SETPAR  0x91
#define HDC_COMMAND_WRSTACK 0xE8
#define HDC_COMMAND_RDSTACK 0xE4
#define HDC_COMMAND_READPAR 0xEC
#define HDC_COMMAND_POWER   0xE0

// irqs
#define HDC_FIXED_IRQ	    0x02
#define HDC_FIXED_RESET     0x04

// drive status flags
#define HDC_STATUS_ERROR    0x01
#define HDC_STATUS_INDEX    0x02
#define HDC_STATUS_ECC	    0x04
#define HDC_STATUS_DRQ	    0x08
#define HDC_STATUS_COMPLETE 0x10
#define HDC_STATUS_WRFAULT  0x20
#define HDC_STATUS_READY    0x40
#define HDC_STATUS_BUSY     0x80

const int DRIVE_0 = 0;
const int DRIVE_1 = 1;

struct ideinfo {
	 unsigned genconf,	// drive id
		  fixcyls,			// number of cylinders
		  remcyls,			// number of removable cylinders
		  heads,				// number of heads
		  bytetrack,     	// bytes per track
		  bytesector,    	// bytes per sector
		  sectors,       	// sectors per track
		  bytegap,       	// bytes intesector gap
		  bytesync,      	// bytes in sync
		  wordunique;    	// words unique status
	 char serial[20];		// serial number
	 unsigned contype,   // controller type
		  bufsiz,        	// buffer size in 512 byte blocks
		  byteecc;       	// ECC bytes transferred in read/write long
	 char firmware[8],   // firmware revision
	 model[40];         	// model ID
	 unsigned secsint,   // number of sectors transferred per interrupt
		  dblword,       	// double word transfer flag
		  writepro;      	// write protect
	 double capacity;		// capacity of drive in Mb

								// EXTENTION TO NORMAL DATA STRUCTURE
	 unsigned bestcyls,	// calculated best cylinders
		  bestheads,		// calculated best heads
		  bestsecs;			// calculated best sectors
	 double bioscapacity;
	 unsigned bioscyls,
		  biosheads,
		  biossecs;
	};

