/*
// XMODEM.H
//
// Header file for Xmodem file transfer protocol
//
// Copyright (c) 1993 Bri Productions
//
*/


#ifndef  _XMODEM_H_
#define  _XMODEM_H_

/*
//-------------------------------------
//
// additional callback() error codes 
//
// ( lower 12 bits == ComError() )
//
//-------------------------------------
*/
#define  XE_BADBLOCK    0x1000   /* Bad block            */
#define  XE_BADCHECK    0x2000   /* Bad block check      */
#define  XE_TIMEOUT     0x3000   /* Timeout              */
#define  XE_CANCEL      0x4000   /* Canceled             */


/*
//-------------------------------------
//
// Return codes
//
//-------------------------------------
*/
enum  {  
         XR_NOERR,         /* No error                   */
         XR_FILEERR,       /* File error                 */
         XR_CANCEL,        /* Transfer canceled          */
         XR_ALLOC,         /* Memory allocation          */
         XR_USER           /* Start of user return codes */
      };

/* 
//-------------------------------------
//
// callback messages
//
//-------------------------------------
*/
enum  {  
         XM_IDLE,          /* Idle time               */
         XM_START,         /* Starting transfer       */
         XM_BLOCKCHECK,    /* Type of block check     */
         XM_BLOCK,         /* New block               */
         XM_EOT,           /* End of transmission     */
         XM_DONE,          /* Transmission complete   */
         XM_ERROR          /* Error                   */
      };

/*
//-------------------------------------
//
// callback messages parameter
//
//-------------------------------------
*/
typedef unsigned XPARAM;




/*
//-------------------------------------
//
// Function prototypes
//
//-------------------------------------
*/

#ifdef __cplusplus
extern "C" {
#endif

int _Cdecl XmodemTx(COM com, const char* file, int (*cb)(int msg, XPARAM param));
int _Cdecl XmodemRx(COM com, const char* file, int (*cb)(int msg, XPARAM param));
int _Cdecl Xcallback(int msg, XPARAM param);

#ifdef __cplusplus
}
#endif

#endif   /* XMODEM.H */

