// This cyberman interface code is written by Joseph D. Gradecki of
// PCVR Magazine.  Give us a call at 608-877-0909 or our BBS at
// 608-877-1017

#include <stdio.h>
#include <dos.h>
#include "cyberman.h"
#include "rend386.h"
#include "intmath.h"

#define to_rad(a) ((a) * 3.14159262 / 180.0)
#define sine(x)   sin(to_rad(x/65536L))
#define cosine(x) cos(to_rad(x/65536L))


extern cyberman_info cyberman_data;
extern VIEW *current_view;
extern int redraw;
extern SEGMENT *body_seg;

int cyberman_step = 50;
long cyberman_angle = 2*65536L;

int get_SWIFT_static ( cyberman_static_data *data)
{
  struct REGPACK r;

  r.r_ax = 0x53C1;
  r.r_es = FP_SEG(data);
  r.r_dx = FP_OFF(data);		// This is DX not DI -- 12-14-93 Joe
  intr(0x33, &r);

  if (r.r_ax == 1) return 1;
  else return 0;
}

int cyberman_available()
{
  cyberman_static_data data;

  get_SWIFT_static (&data);
  if ( data.device_type == 1 ) return 1;
  else return 0;
}



void get_SWIFT_dynamic(unsigned *data)
{
  union REGS r;

  r.x.ax = 0x53C2;
  int86(0x33, &r, &r);
  printf ( "%d\n", r.x.ax );
  *data = r.x.ax;
}


void get_cyberman_data (cyberman_info *data)
{
  struct REGPACK r;

  r.r_ax = 0x5301;
  r.r_es = FP_SEG(data);
  r.r_dx = FP_OFF(data);		// This is DX not DI -- 12-14-93 Joe
  intr(0x33, &r);

}


void set_cyberman_event(void *routine)
{

  cyberman_static_data data;
  struct REGPACK r;

  get_SWIFT_static (&data);

  r.r_ax = 0xC0;
  r.r_cx = 0xFFFF;
  r.r_es = FP_SEG(routine);
  r.r_dx = FP_OFF(routine);		// This is DX not DI -- 12-14-93
  intr(0x33, &r);

/* Upon a call from the interrupt, the registers in the routine passed above
   will have the following values:

   AX= Event bits	0 - Mouse cursor changed
			1 - left button pressed
			2 - left button released
			3 - right button pressed
			4 - right button released
			5 - middle button pressed
			6 - middle button released
			7 - other button pressed
			8 - other button released
			9 - X coordinate changed
			10 - Y coordinate changed
			11 - Z coordinate changed
			12 - pitch changed
			13 - roll changed
			14 - yaw changed
			15 - 'other' condition

   BX = button status
   CX = Horizontal cursor position
   DX = Vertical cursor position
   SI = Address of extended information block which contains following data:

			Word 0 = X coordinate value
			Word 1 = Y coordinate value
			Word 2 = Z coordinate value
			Word 3 = Pitch value
			Word 4 = Roll value
			Word 5 = Yaw value
			Word 6 = Button Status
			Word 7 = Dynamic Device Data word

   SS:SP = stack pointer
   DS = data segment of mouse driver - Save and load appropriately
*/
}


void remove_cyberman_event()
{
  struct REGPACK r;

  r.r_ax = 0xC0;
  r.r_cx = 0;
  intr(0x33, &r);
}

/*
void main()
{
  cyberman_info  cyberman_data;

  printf ( "Cyberman %d\n", cyberman_available());

  while (!kbhit())
  {
    get_cyberman_data (&cyberman_data);
    printf ( "%d %d %d  %d %d %d %d\n", cyberman_data.x,
					cyberman_data.y,
					cyberman_data.z,
					cyberman_data.yaw,
					cyberman_data.pitch,
					cyberman_data.roll,
					cyberman_data.button );

  }

}
*/

void check_cyberman(cyberman_info *data)
{
  if (!cyberman_available())
  {
    printf ( "\nCyberman was not found!\n");
    delay (2000);
  }

  get_cyberman_data (data);
  data->center_x = data->x;
  data->center_y = data->y;
}


void get_cyberman(cyberman_info *data)
{
  long x,y,z;
  MATRIX n;

  get_cyberman_data (data);

  //Pitch
  if (data->pitch > 0)
  {
    current_view->tilt -= cyberman_angle;
  }
  else if (data->pitch < 0)
  {
    current_view->tilt += cyberman_angle;
  }

  //Roll
  if (data->roll > 0)
  {
    current_view->roll += cyberman_angle;
  }
  else if (data->roll < 0)
  {
    current_view->roll -= cyberman_angle;
  }


  //Yaw
  if (data->yaw > 0)
  {
    current_view->pan -= cyberman_angle;
  }
  else if (data->yaw < 0)
  {
    current_view->pan += cyberman_angle;
  }


  //Z
  if (data->z < 0)
    current_view->ey -= cyberman_step;
  else if (data->z > 0)
    current_view->ey += cyberman_step;

  //X
  if (data->y > data->center_y+1500)
  {
    x = y = 0;
    z = cyberman_step;

    std_matrix(n, 0, current_view->pan, 0, 0, 0, 0);
    matrix_point(n, &x, &y, &z);
    current_view->ex += x;
    current_view->ez += z;
  }
  else if (data->y < (data->center_y-1000))
  {
    x = y = 0;
    z = cyberman_step;

    std_matrix(n, 0, current_view->pan, 0, 0, 0, 0);
    matrix_point(n, &x, &y, &z);
    current_view->ez -= z;
  }


  if (data->x > (data->center_x+1000))
  {
    x = cyberman_step;
    y = z = 0;

    std_matrix(n, 0, current_view->pan, 0, 0, 0, 0);
    matrix_point(n, &x, &y, &z);
    current_view->ex += x;
  }
  else if (data->x < (data->center_x-1000))
  {
    x = -cyberman_step;
    y = z = 0;

    std_matrix(n, 0, current_view->pan, 0, 0, 0, 0);
    matrix_point(n, &x, &y, &z);
    current_view->ex += x;
  }

  redraw = 1;
}

