//GLOBAL.CPP
// part of JDHEAP class by John M. Dlugosz
// This is posted for academic pursuits, and may
// be used freely, with attribution.

// this provides for a heap object with global lifetime, and uses
// compiler-specific techniques to insure it is initialized first.
// Also, it has to provide extra work so that it _can_ be initialized first
// without messing up other code.

// This also has definitions for global free-store management functions
// for C and C++, replacing the ones in the library.

     #pragma initialize before library

#include "usual.h"
#include "jdheap.h"
#include <malloc.h>

static int foo()
{
_nheapgrow();             //get this executed first!
return 0;
}

static int xxxy= foo();

////////////////////////////////////////////////////////////////

extern unsigned check_size();
#pragma aux check_size= \
   "mov AH,48h" \
   "mov BX,0ffffh" \
   "int 21h" \
   value [BX] modify [AX BX CX DX]

extern void* get_memory (unsigned);
#pragma aux get_memory= \
   "mov AH,48h" \
   "int 21h" \
   "mov DX,AX" \
   "xor AX,AX" \
   parm [BX] \
   value [DX AX] \
   modify [ax bx cx dx]

unsigned paras= check_size();
//unsigned paras= 8192;

////////////////////////////////////////////////////////////////

const listsize= 500;
static jdheap::record List[listsize];

global_heap::global_heap()
: jdheap (List, ::listsize, get_memory(paras), paras*16L)
{}


global_heap global_heap::it;


////////////////////////////////////////////////////////////////

// useless!!!!! #pragma aux reload_DS parm loadds
//#pragma aux reload_DS LOADDS


extern void pushDS();
extern void popDS();
#pragma aux pushDS= "push DS"
#pragma aux popDS= "pop DS"


void* malloc (size_t size)
{
void* retval;
pushDS();
if (size == 0)  retval= 0;
retval= global_heap::it.alloc (size);
global_heap::it.mark (retval, "old-style malloc()");
popDS();
return retval;
}


void free (void* p)
{
static bool recursive= FALSE;
if (recursive)  return;
recursive= TRUE;
pushDS();
try {  //cover up bug in standard library
   global_heap::it.free(p);
   }
catch (...) {}
popDS();
recursive= FALSE;
}

void* _fmalloc (size_t size)
{
return malloc (size);
}


void _ffree (void* p)
{
free (p);
}


////////////////////////////////////////////////////////////////

void* operator new (size_t size)
{
return global_heap::it.alloc (size);
}

void operator delete (void* p)
{
global_heap::it.free (p);
}

void* operator new (size_t size, const char* tag)
{
void* retval= global_heap::it.alloc (size);
global_heap::it.mark (retval, tag);
return retval;

}
