//HEAP1.CPP
// part of JDHEAP class by John M. Dlugosz
// This is posted for academic pursuits, and may
// be used freely, with attribution.

// the first test program to check the JDHEAP class.

#include "usual.h"
#include "except.h"
#include "jdheap.h"
#include "filename.h"
#include "lngfile.h"
#include "int1b.h"
#include "extras\random.h"
#include "crc.h"
#include <stdio.h>
#include <malloc.h>  //need halloc()

const Listsize= 30;
jdheap::record List[Listsize];


void banner (const except_base& e)
{
printf ("error report:  program location %s(%d)\n", e.filename, e.line);
}

void set_error_mess()
{
filename_t file= "..\\errors.lng";   //enhance later to look this up
static ref_language_file error_messages (except_base::translate, file, "English");
}

const asize= 15;
void* array[asize];
ulong checks[asize];
int sizes[asize];

void check_block (int x)
{
if (ComputeCRC(array[x], sizes[x]) != checks[x])
   throw gerror ("CRC does not match in check_block()", __FILE__, __LINE__);
}

void fill_block (int x, int size)
{
byte* region= (byte*)(array[x]);
for (int loop= 0;  loop < size;  loop++)
   region[loop]= r250();
checks[x]= ComputeCRC (array[x], size);
sizes[x]= size;
}


void pound (jdheap& heap)
{
volatile long count= 0;
try {
   while (!break_code()) {
      if (!(count&127)) {
         printf ("\nafter %ld iterations\n", count);
         heap.debug_dump();
         }
      int index= r250()%asize;  //pick a random block
//    check_block (index);
      heap.free (array[index]);
      int size= 1+r250()%1000;
      array[index]= heap.alloc (size);
      if (size > heap.size (array[index]))  throw gerror ("problem", __FILE__,__LINE__);
      fill_block (index, size);
      // check to make sure I've not clobbered any others
      for (int loop= 0;  loop < asize;  loop++)
         check_block (loop);
      if (r250()%15 == 0)  heap.mark(array[index], "this is a use comment");
      count++;
      }
   }
catch (...) {
   printf ("snapshot at point of error:  %ld iterations\n", count);
   heap.debug_dump();
   throw;
   }
}


int main()
{
r250_init();
try {
   hook1b dummy_;
   set_error_mess();
   const long blocksize= 100000L;
   void* mem= halloc (blocksize, 1);
   if (!mem) return 2;
   jdheap heap (List, Listsize, mem, blocksize);
   heap.debug_dump();
   for (int loop= 0;  loop < asize;  loop++) {
      int size= r250()%1000;
      array[loop]= heap.alloc(size);
      if (size > heap.size (array[loop]))  throw gerror ("problem", __FILE__,__LINE__);
      fill_block (loop, size);
      heap.mark (array[loop], "original");
      }
   pound (heap);
   }
catch (except_base& e) {
   banner (e);
   printf ("error caught in text block\n%s\n", e.message());
   }
catch (...) {
   // other error.  just eat it
   printf ("undiagnosed error\n");
   }
return 0;
}
