//HEAP2.CPP
// part of JDHEAP class by John M. Dlugosz
// This is posted for academic pursuits, and may
// be used freely, with attribution.

// this is the second test of the heap, modified several times.
// it is testing the global heap replacement.

#include "usual.h"
#include "except.h"
#include "jdheap.h"
#include "filename.h"
#include "lngfile.h"
#include "int1b.h"
#include "extras\random.h"
#include <stdio.h>

void banner (const except_base& e)
{
printf ("error report:  program location %s(%d)\n", e.filename, e.line);
}

void set_error_mess()
{
filename_t file= "errors.lng";   //enhance later to look this up
static ref_language_file error_messages (except_base::translate, file, "English");
}

const asize= 300;
void* array[asize];


void pound (jdheap& heap)
{
volatile long count= 0;
try {
   while (!break_code()) {
      if (!(count&0x3ff)) {
         printf ("\nafter %ld iterations\n", count);
         heap.debug_dump();
         }
      int index= r250()%asize;  //pick a random block
      heap.free (array[index]);
      array[index]= heap.alloc (r250()%200);
      if (r250()%15 == 0)  heap.mark(array[index], "this is a use comment");
      count++;
      }
   }
catch (...) {
   printf ("snapshot at point of error:  %ld iterations\n", count);
   global_heap::it.debug_dump();
   throw;
   }
}


int main()
{
r250_init();
try {
   hook1b dummy_;
   set_error_mess();
   global_heap::it.debug_dump();
   for (int loop= 0;  loop < asize;  loop++) {
      array[loop]= global_heap::it.alloc (r250()%100);
      global_heap::it.mark (array[loop], "original");
      }
   pound (global_heap::it);
   for (loop= 0;  loop < asize;  loop++) {
      global_heap::it.free (array[loop]);
      }
   global_heap::it.debug_dump();
   }

catch (except_base& e) {
   banner (e);
   printf ("error caught in test block\n%s\n", e.message());
   }
catch (...) {
   // other error.  just eat it
   printf ("undiagnosed error\n");
   }
return 0;
}

