/*===========================================================================
 |  P r o g r a m   L I G H T _ I
 |--------------------------------------------------------------------------
 |  Mark Meier, CIS: 76330,3402
 |  Begun: 04/94
 |  Last Change: 04/94
 *=========================================================================*/
/*===========================================================================
 |  I n c l u d e   F i l e s
 *=========================================================================*/
#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "pxp.h"
#include "trig.h"
#include "dialog.h"
#include "keys.h"

/*===========================================================================
 |  P r o t o t y p e s
 *=========================================================================*/
int rect_lt_array(char *sname, int sindex);
double mm_convert_str(char *s);
double twod_dist(double x1, double y1, double x2, double y2);
void mm_atof(char *s, double *result, int *status, char *errmsg);

/*===========================================================================
 |  D e f i n e s
 *=========================================================================*/
#define VERSION                    0x0001
#define TRUE                            1
#define FALSE                           0
#define CANCEL                          1
#define OK                              2
#define ESC_KEY                       283

#define MM_STATUS_OKAY                  1
#define MM_STATUS_ERROR                 0

#define PXP_LOAD_ERROR                 -1

#define MM_INCH_SYM           ((char) 34)
#define MM_FEET_SYM           ((char) 39)
#define MM_FRAC_DELIM         ((char) 45)
#define MM_FRAC_SYM           ((char) 47)
#define MM_STR_TERM            ((char) 0)

#define UC_PROCESS_REQUESTS         0x204

#define M_B_CANCEL                      1
#define M_F_TITLE                       2
#define M_T_T2                          3
#define M_T_T1                          4
#define M_F_FUNCTION                    5
#define M_B_ABOUT                       6
#define M_B_DELETE                      7
#define M_B_ARRAY                       8
#define M_B_UPDATE                      9
#define M_T_T3                         10
#define M_B_OK                         11

#define P_F_TITL                        1
#define P_TITLE                         2
#define P_FRAME                         3
#define P_PTITLE                        4
#define P_ON                            5
#define P_COLOR                         6
#define P_EXCL                          7
#define P_RANGE                         8
#define P_SOURCE                        9
#define P_MULT                          10
#define P_SHAD                          11
#define P_TARGET                        12
#define P_SHAPE                         13
#define P_CONE                          14
#define P_BANK                          15
#define P_OV                            16
#define P_PROJ                          17
#define P_ALL                           18
#define P_NONE                          19
#define P_OK                            20
#define P_CANCEL                        21

#define O_F_TITL                        1
#define O_TITLE                         2
#define O_FRAME                         3
#define O_PTITLE                        4
#define O_ON                            5
#define O_COLOR                         6
#define O_EXCL                          7
#define O_RANGE                         8
#define O_SOURCE                        9
#define O_MULT                          10
#define O_ALL                           11
#define O_NONE                          12
#define O_OK                            13
#define O_CANCEL                        14

#define S_F_TITLE                       1
#define S_T_TITLE                       2
#define S_F_FRAME                       3
#define S_X_LIST                        4
#define S_B_SCRUP                       5
#define S_X_SCRSL                       6
#define S_B_SCRDN                       7
#define S_B_FILLIN                      8
#define S_F_QF                          9
#define S_T_QF                          10
#define S_T_QSCROLL                     11
#define S_B_OK                          12
#define S_B_CANCEL                      13
#define S_B_HELP                        14

#define A_F_TITLE                       1
#define A_T_TITLE                       2
#define A_F_1                           3
#define A_RECRAD                        4
#define A_F_3                           5
#define A_W_TL1                         6
#define A_W_NUM                         7
#define A_W_T1                          8
#define A_W_SPAC                        9
#define A_F_4                           10
#define A_D_NUM                         12
#define A_D_SPAC                        14
#define A_F_5                           15
#define A_H_NUM                         17
#define A_H_SPAC                        19
#define A_F_2                           20
#define A_POLRAD                        21
#define A_F_6                           22
#define A_CR_TL                         23
#define A_TOPRAD                        24
#define A_FRTRAD                        25
#define A_SIDRAD                        26
#define A_P_T5                          27
#define A_PL_NUM                        28
#define A_P_T3                          29
#define A_ST_ANG                        30
#define A_RAD_T                         31
#define A_RADIUS                        32
#define A_ANGLE                         34
#define A_B_RTSL                        35
#define A_PRE_T                         36
#define A_PREFIX                        37
#define A_B_OK                          38
#define A_B_CANCEL                      39

#define W_F_TITLE                        1
#define W_T_TITLE                        2
#define W_F_SALL                        3
#define W_X_LIST                        4
#define W_B_SCUP                        5
#define W_X_SCSL                        6
#define W_B_SCDN                        7
#define W_F_TALL                        8
#define W_B_ALL                         9
#define W_B_NONE                        10
#define W_E_WC                          11
#define W_B_TAG                         12
#define W_B_UNTG                        13
#define W_B_INV                         14
#define W_T_TTOT                        15
#define W_T_TOT                         16
#define W_F_QTAG                        17
#define W_T_QSCROLL                     19
#define W_B_OK                          20
#define W_B_CANC                        21
#define W_B_HELP                        22

/*===========================================================================
 |  D e c l a r a t i o n s
 *=========================================================================*/
typedef struct {
   ulong version;
} State;

typedef struct pt {
   float x, y, z;
} mm_pt;

typedef struct light_parms {
   int on, color, mult, excl, atten_range, source, // OMNI properties
      shadow, shape, ov, proj, target, cone, bank, // SPOT props
      spot_flag, rot_spot_flag, use_alt_excl_list;
   Name_list *alt_excl_list;
} lparms;

typedef struct array_parms {
   int wc, dc, hc, pc;
   double ws, ds, hs, st_ang, angle, radius;
} aparms;
aparms array_data; // Light array user entered converted data

typedef struct tag_list {
   int length, tagged;
} tlist;
tlist taglist;
tlist alt_excl_taglist;

static lparms lt_opts = { // Light update option flags (omit source/target)
   1, 1, 1, 1, 1, 0,
   1, 1, 1, 1, 0, 1, 1,
   0, 0, 0, 
   NULL
};

static State init_state = {VERSION};
static State state = {VERSION};

static int dialog_cancel = 0;

static sel_lt_init = 0; // Flag to indicate if the source light dlg is inited
static main_dlg_init = 0; // Main dlg init flag
static wc_init = 0; // Wildcard dlg init flag
static char source_lt[11]; // Name of the source light selected

static float master_scale;
static int master_type;

Name_list *select_list = NULL;
int *select_index_list = NULL;
Name_list *obj_list = NULL;

/*===========================================================================
 |  D i a l o g   D a t a
 *=========================================================================*/
Dialog main_dlg[]=
{
{ -1, 1, -1, -1, 0, 5, 5, 194, 226, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, -1, 2, 1, 99, 194, 66, 18, 
   "Cancel", NULL, 0, 0, 27, 0, FNULL, FNULL, 0 },
{ 0, 3, 1, 5, 2, 4, 4, 186, 42, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 2, -1, -1, 4, 4, 20, 20, 146, 18, 
   "by Mark Meier", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 2, -1, 3, -1, 4, 22, 4, 146, 18, 
   "Lighting Utilities", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, 6, 2, 11, 2, 4, 48, 186, 136, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 5, -1, -1, 7, 1, 64, 100, 66, 20, 
   "About", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 5, -1, 6, 8, 1, 64, 78, 66, 20, 
   "Delete", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 5, -1, 7, 9, 1, 64, 56, 66, 20, 
   "Array", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 5, -1, 8, 10, 1, 64, 34, 66, 20, 
   "Update", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 5, -1, 9, -1, 4, 24, 8, 138, 18, 
   "Choose a Function", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 5, -1, 1, 29, 194, 66, 18, 
   "Next", NULL, 0, 0, 13, 0, FNULL, FNULL, 0 },
};

Dialog spot_dlg[]=
{
{ -1, 1, -1, -1, 0, 5, 5, 332, 246, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, 2, -1, 3, 2, 4, 4, 324, 30, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 1, -1, -1, -1, 4, 92, 6, 146, 18, 
   "Update Lights", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, 4, 1, 20, 2, 4, 36, 324, 170, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, -1, 5, 4, 40, 8, 242, 18, 
   "Parameters to Copy from the Prototype", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 4, 6, 1, 12, 32, 98, 18, 
   "On/Off", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 5, 7, 1, 112, 32, 98, 18, 
   "Color", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 6, 8, 1, 212, 32, 98, 18, 
   "Exclude", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 7, 9, 1, 12, 52, 98, 18, 
   "Atten/Range", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 8, 10, 1, 112, 52, 98, 18, 
   "Location", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 9, 11, 1, 212, 52, 98, 18, 
   "Multiplier", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 10, 12, 1, 12, 72, 98, 18, 
   "Shadow", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 11, 13, 1, 112, 72, 98, 18, 
   "Target Pt", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 12, 14, 1, 212, 72, 98, 18, 
   "Rect/Circ", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 13, 15, 1, 12, 92, 98, 18, 
   "Cone/Hs/Fo", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 14, 16, 1, 112, 92, 98, 18, 
   "Roll/Aspect", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 15, 17, 1, 212, 92, 98, 18, 
   "Overshoot", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 16, 18, 1, 112, 112, 98, 18, 
   "Projector", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 17, 19, 1, 94, 140, 66, 18, 
   "Most", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 18, -1, 1, 162, 140, 66, 18, 
   "None", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 3, 21, 1, 98, 216, 66, 18, 
   "OK", NULL, 0, 0, 13, 0, FNULL, FNULL, 0 },
{ 0, -1, 20, -1, 1, 168, 216, 66, 18, 
   "Cancel", NULL, 0, 0, 27, 0, FNULL, FNULL, 0 },
};

Dialog omni_dlg[]=
{
{ -1, 1, -1, -1, 0, 5, 5, 332, 186, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, 2, -1, 3, 2, 4, 4, 324, 30, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 1, -1, -1, -1, 4, 92, 6, 146, 18, 
   "Update Lights", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, 4, 1, 13, 2, 4, 36, 324, 110, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, -1, 5, 4, 40, 8, 242, 18, 
   "Parameters to Copy from the Prototype", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 4, 6, 1, 12, 32, 98, 18, 
   "On/Off", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 5, 7, 1, 112, 32, 98, 18, 
   "Color", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 6, 8, 1, 212, 32, 98, 18, 
   "Exclude", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 7, 9, 1, 12, 52, 98, 18, 
   "Atten/Range", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 8, 10, 1, 112, 52, 98, 18, 
   "Location", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 9, 11, 1, 212, 52, 98, 18, 
   "Multiplier", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 10, 12, 1, 92, 80, 66, 18, 
   "Most", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 11, -1, 1, 160, 80, 66, 18, 
   "None", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 3, 14, 1, 95, 156, 66, 18, 
   "OK", NULL, 0, 0, 13, 0, FNULL, FNULL, 0 },
{ 0, -1, 13, -1, 1, 165, 156, 66, 18, 
   "Cancel", NULL, 0, 0, 27, 0, FNULL, FNULL, 0 },
};

char s_b_fillin[11], s_t_qscroll[11];
Dialog sel_lt_dlg[]=
{
{ -1, 1, -1, -1, 0, 5, 5, 250, 188, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, 2, -1, 3, 0, 4, 4, 242, 28, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 1, -1, -1, -1, 4, 74, 6, 98, 18, 
   "Prototype for Light Update", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, 4, 1, 9, 2, 4, 34, 122, 150, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, -1, 5, 0, 4, 4, 90, 120, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 4, 6, 1, 98, 4, 20, 18, 
   "", NULL, 0, 0, 24, 0, FNULL, FNULL, 0 },
{ 3, -1, 5, 7, 0, 98, 24, 20, 80, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 6, 8, 1, 98, 106, 20, 18, 
   "", NULL, 0, 0, 25, 0, FNULL, FNULL, 0 },
{ 3, -1, 7, -1, 1, 4, 126, 114, 20, // S_B_FILLIN
   s_b_fillin, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, 10, 3, 12, 2, 130, 34, 116, 46, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 9, -1, -1, 11, 4, 18, 26, 82, 18, 
   "Quick Find", NULL, 0, 0, 96, 0, FNULL, FNULL, 0 },
{ 9, -1, 10, -1, 4, 4, 4, 108, 18, // S_T_QSCROLL
   s_t_qscroll, NULL, 0, 0, ((short) '~'), 0, FNULL, FNULL, 0 },
{ 0, -1, 9, 13, 1, 156, 98, 64, 18, 
   "Next", NULL, 0, 0, 13, 0, FNULL, FNULL, 0 },
{ 0, -1, 12, 14, 1, 156, 124, 64, 18, 
   "Cancel", NULL, 0, 0, 27, 0, FNULL, FNULL, 0 },
{ 0, -1, 13, -1, 1, 156, 150, 64, 18, 
   "Help", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
};

Dialog array_dlg[]=
{
{ -1, 1, -1, -1, 0, 5, 5, 384, 372, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, 2, -1, 3, 2, 4, 4, 376, 26, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 1, -1, -1, -1, 4, 88, 4, 202, 18, 
   "Light Array", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, 4, 1, 20, 2, 4, 32, 376, 128, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, -1, 5, 1, 138, 4, 106, 18, 
   " Rectangular ", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, 6, 4, 10, 2, 4, 24, 368, 32, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 5, -1, -1, 7, 4, 24, 8, 98, 20, 
   "Width Count:", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 5, -1, 6, 8, 5, 128, 8, 43, 18, 
   (void *)0, NULL, 0, 0, 0, 3, FNULL, FNULL, 0 },
{ 5, -1, 7, 9, 4, 202, 8, 72, 18, 
   "Spacing:", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 5, -1, 8, -1, 5, 276, 8, 75, 18, 
   (void *)1, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, 11, 5, 15, 2, 4, 58, 368, 32, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 10, -1, -1, 12, 4, 24, 6, 98, 20, 
   "Depth Count:", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 10, -1, 11, 13, 5, 128, 6, 43, 18, 
   (void *)2, NULL, 0, 0, 0, 3, FNULL, FNULL, 0 },
{ 10, -1, 12, 14, 4, 202, 8, 72, 18, 
   "Spacing:", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 10, -1, 13, -1, 5, 276, 8, 75, 18, 
   (void *)3, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, 16, 10, -1, 2, 4, 92, 368, 32, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 15, -1, -1, 17, 4, 16, 8, 106, 18, 
   "Height Count:", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 15, -1, 16, 18, 5, 128, 8, 43, 18, 
   (void *)4, NULL, 0, 0, 0, 3, FNULL, FNULL, 0 },
{ 15, -1, 17, 19, 4, 202, 8, 72, 18, 
   "Spacing:", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 15, -1, 18, -1, 5, 276, 8, 75, 18, 
   (void *)5, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, 21, 3, 36, 2, 4, 162, 376, 146, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 20, -1, -1, 22, 1, 142, 4, 106, 18, 
   "Polar", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 20, 23, 21, 27, 2, 4, 24, 368, 32, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 22, -1, -1, 24, 4, 18, 8, 122, 18, 
   "Creation Plane:", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 22, -1, 23, 25, 1, 144, 8, 66, 18, 
   "Top", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 22, -1, 24, 26, 1, 212, 8, 66, 18, 
   "Front", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 22, -1, 25, -1, 1, 280, 8, 66, 18, 
   "Side", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 20, -1, 22, 28, 4, 48, 68, 54, 18, 
   "Count:", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 20, -1, 27, 29, 5, 106, 68, 43, 18, 
   (void *)6, NULL, 0, 0, 0, 3, FNULL, FNULL, 0 },
{ 20, -1, 28, 30, 4, 186, 68, 102, 18, 
   "Start Angle:", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 20, -1, 29, 31, 5, 294, 68, 75, 18, 
   (void *)7, NULL, 0, 0, 0, 2, FNULL, FNULL, 0 },
{ 20, -1, 30, 32, 4, 10, 94, 62, 18, 
   "Radius:", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 20, -1, 31, 33, 5, 74, 94, 75, 18, 
   (void *)8, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 20, -1, 32, 34, 4, 176, 94, 114, 20, 
   "Angle to Fill:", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 20, -1, 33, 35, 5, 294, 94, 75, 18, 
   (void *)9, NULL, 0, 0, 0, 2, FNULL, FNULL, 0 },
{ 20, -1, 34, -1, 1, 120, 120, 154, 20, 
   " Rotate Spotlights ", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 20, 37, 4, 96, 316, 98, 20, 
   "Name Prefix:", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 36, 38, 5, 200, 316, 75, 18, 
   (void *)10, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 37, 39, 1, 126, 344, 66, 18, 
   "OK", NULL, 0, 0, 13, 0, FNULL, FNULL, 0 },
{ 0, -1, 38, -1, 1, 200, 344, 66, 18, 
   "Cancel", NULL, 0, 0, 27, 0, FNULL, FNULL, 0 },
};

Dialog wc_dlg[]=
{
{ -1, 1, -1, -1, 0, 5, 5, 266, 292, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, 2, -1, 3, 2, 4, 4, 258, 30, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 1, -1, -1, -1, 4, 42, 6, 178, 18, 
   "Choose the Lights to Update", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, 4, 1, 8, 2, 4, 36, 138, 252, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, -1, 5, 0, 4, 4, 106, 244, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 4, 6, 1, 114, 4, 20, 20, 
   "", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 5, 7, 0, 114, 28, 20, 196, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 3, -1, 6, -1, 1, 114, 228, 20, 20,
   "", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, 9, 3, 17, 2, 146, 36, 116, 132, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 8, -1, -1, 10, 1, 4, 4, 52, 20, "All", 
   NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 8, -1, 9, 11, 1, 58, 4, 54, 20, "None", 
   NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 8, -1, 10, 12, 5, 4, 28, 107, 18, 
   (void *)0, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 8, -1, 11, 13, 1, 4, 50, 52, 20, 
   "Tag", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 8, -1, 12, 14, 1, 58, 50, 54, 20, 
   "Untag", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 8, -1, 13, 15, 1, 4, 72, 108, 20, 
   "Invert", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 8, -1, 14, 16, 4, 14, 94, 90, 18, 
   "Tagged: 100", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 8, -1, 15, -1, 4, 14, 112, 90, 18, 
   "Total:  100", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, 18, 8, 20, 2, 146, 170, 116, 48, 
   NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 17, -1, -1, 19, 4, 10, 26, 98, 18, 
   "Quick Find", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 17, -1, 18, -1, 4, 4, 4, 108, 18, 
   "          ", NULL, 0, 0, ((short) '~'), 0, FNULL, FNULL, 0 },
{ 0, -1, 17, 21, 1, 170, 225, 66, 18, 
   "OK", NULL, 0, 0, 13, 0, FNULL, FNULL, 0 },
{ 0, -1, 20, 22, 1, 170, 247, 66, 18, 
   "Cancel", NULL, 0, 0, 27, 0, FNULL, FNULL, 0 },
{ 0, -1, 21, -1, 1, 170, 267, 66, 18, 
   "Help", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
};

/*===========================================================================
 |  D i a l o g   F u n c t i o n s
 *=========================================================================*/
/*
 * Main dialog selections */
int main_rad_num = 0;
extern feel_main_cancel(), feel_main_next(), feel_main_update(), 
   feel_main_array(), feel_main_delete(), feel_main_about();
static RadSub main_rad[] = {
   M_B_UPDATE, feel_main_update, &main_rad_num, 0,
   M_B_ARRAY, feel_main_array, &main_rad_num, 1,
   M_B_DELETE, feel_main_delete, &main_rad_num, 2,
   M_B_ABOUT, feel_main_about, &main_rad_num, 3,
   -1, FNULL, NULL, -1
};

static FeelSub main_feel[] = {
   M_B_UPDATE, feel_main_update,
   M_B_ARRAY, feel_main_array,
   M_B_DELETE, feel_main_delete,
   M_B_ABOUT, feel_main_about, 
   M_B_CANCEL, feel_main_cancel,
   M_B_OK, feel_main_next,   // Next button
   -1, FNULL
};

extern see_frame(), see_title_frame(), see_title_text();
static SeeSub main_see[] = {
   M_T_T1, see_title_text,
   M_T_T2, see_title_text,
   M_F_TITLE, see_title_frame,
   M_F_FUNCTION, see_frame,
   -1, FNULL
};

/*
 * Spot light parameter selector */
extern feel_lt_cancel(), feel_lt_ok(), feel_lt_all(), feel_lt_none(),
   feel_lt_proj(), feel_lt_ov(),feel_lt_bank(), feel_lt_cone(),
   feel_lt_shape(), feel_lt_target(), feel_lt_shadow(),
   feel_lt_excl(), feel_lt_source(), feel_lt_range(),
   feel_lt_mult(), feel_lt_color(), feel_lt_on(), feel_lt_frame();
static FeelSub spot_lt_feel[] = {
   P_CANCEL, feel_lt_cancel,
   P_OK, feel_lt_ok, 
   P_ALL, feel_lt_all,
   P_NONE, feel_lt_none,
   P_PROJ, feel_lt_proj,
   P_OV, feel_lt_ov,
   P_BANK, feel_lt_bank,
   P_CONE, feel_lt_cone,
   P_SHAPE, feel_lt_shape,
   P_TARGET, feel_lt_target,
   P_SHAD, feel_lt_shadow,
   P_EXCL, feel_lt_excl,
   P_SOURCE, feel_lt_source,
   P_RANGE, feel_lt_range,
   P_MULT, feel_lt_mult,
   P_COLOR, feel_lt_color,
   P_ON, feel_lt_on, 
   -1, FNULL
};

extern see_lt_proj(), see_lt_ov(),see_lt_bank(), see_lt_cone(),
   see_lt_shape(), see_lt_target(), see_lt_shadow(),
   see_lt_excl(), see_lt_source(), see_lt_range(),
   see_lt_mult(), see_lt_color(), see_lt_on(), see_frame();
static SeeSub spot_lt_see[] = {
   P_FRAME, see_frame,
   P_F_TITL, see_title_frame,
   P_TITLE, see_title_text,
   P_PROJ, see_lt_proj,
   P_OV, see_lt_ov,
   P_BANK, see_lt_bank,
   P_CONE, see_lt_cone,
   P_SHAPE, see_lt_shape,
   P_TARGET, see_lt_target,
   P_SHAD, see_lt_shadow,
   P_EXCL, see_lt_excl,
   P_SOURCE, see_lt_source,
   P_RANGE, see_lt_range,
   P_MULT, see_lt_mult,
   P_COLOR, see_lt_color,
   P_ON, see_lt_on, 
   -1, FNULL
};

/*
 * Omni light parameter selector */
extern feel_lt_cancel(), feel_lt_ok(), feel_lt_all(), feel_lt_none(),
   feel_lt_excl(), feel_lt_source(), feel_lt_range(),
   feel_lt_mult(), feel_lt_color(), feel_lt_on(), feel_lt_frame();
static FeelSub omni_lt_feel[] = {
   O_CANCEL, feel_lt_cancel,
   O_OK, feel_lt_ok, 
   O_ALL, feel_lt_all,
   O_NONE, feel_lt_none,
   O_EXCL, feel_lt_excl,
   O_SOURCE, feel_lt_source,
   O_RANGE, feel_lt_range,
   O_MULT, feel_lt_mult,
   O_COLOR, feel_lt_color,
   O_ON, feel_lt_on, 
   -1, FNULL
};

extern see_lt_proj(), 
   see_lt_shape(), see_lt_excl(), see_lt_source(), see_lt_range(),
   see_lt_mult(), see_lt_color(), see_lt_on(), see_frame();
static SeeSub omni_lt_see[] = {
   O_FRAME, see_frame,
   O_F_TITL, see_title_frame,
   O_TITLE, see_title_text,
   O_EXCL, see_lt_excl,
   O_SOURCE, see_lt_source,
   O_RANGE, see_lt_range,
   O_MULT, see_lt_mult,
   O_COLOR, see_lt_color,
   O_ON, see_lt_on, 
   -1, FNULL
};

/*
 * Selector for Source Light */
static have_lt_selected = 0;
extern see_sel_lt_frame(), see_sel_lt_fillin(),
   see_sel_lt_help(), see_qscroll(), see_list();
static SeeSub sel_lt_see[] = {
   S_F_TITLE, see_title_frame,
   S_T_TITLE, see_title_text,
   S_F_FRAME, see_sel_lt_frame,
   S_B_FILLIN, see_sel_lt_fillin,
   S_B_HELP, see_sel_lt_help,
   S_X_LIST, see_list,
   S_T_QSCROLL, see_qscroll,
   S_F_QF, see_frame,
   -1, FNULL
};

extern feel_sel_lt_cancel(), feel_sel_lt_ok(), feel_sel_lt_box(),
   feel_sel_lt_fillin(), feel_sel_lt_qscroll(), feel_sel_lt_help();
static FeelSub sel_lt_feel[] = {
   S_B_CANCEL, feel_sel_lt_cancel,
   S_B_OK, feel_sel_lt_ok,
   S_X_LIST, feel_sel_lt_box,
   S_B_FILLIN, feel_sel_lt_fillin,
   S_T_QSCROLL, feel_sel_lt_qscroll, 
   S_B_HELP, feel_sel_lt_help, 
   -1, FNULL
};

Scroller lt_scroller = {
   0, 0, 0, 0, 0, NULL, NULL, NULL
};

static ScrSub sel_lt_scroll[] = {
   S_B_SCRUP, S_B_SCRDN, S_X_SCRSL, S_X_LIST, feel_sel_lt_box, &lt_scroller,
   -1, -1, -1, -1, FNULL, NULL
};

/*
 * Array Dialog */
int array_rad_num = 0;
int array_plane_num = 0;
static RadSub array_rad[] = {
   A_RECRAD, feel_radio, &array_rad_num, 0,
   A_POLRAD, feel_radio, &array_rad_num, 1,
   A_TOPRAD, feel_radio, &array_plane_num, 0,
   A_FRTRAD, feel_radio, &array_plane_num, 1,
   A_SIDRAD, feel_radio, &array_plane_num, 2,
   -1, FNULL, NULL, -1
};

char array_prefix[9], array_h_spac[15], array_h_num[3], array_d_spac[15], 
   array_d_num[3], array_w_spac[15], array_w_num[3], array_st_ang[11], 
   array_radius[15], array_angle[11], array_pl_num[4];

Editable array_edit[] = {
   {  2,  2, 0, array_w_num,  3, 0, 0, NULL, NULL }, // A_W_NUM
   {  8, 14, 0, array_w_spac, 0, 0, 0, NULL, NULL }, // A_W_SPAC
   {  2,  2, 0, array_d_num,  3, 0, 0, NULL, NULL }, // A_D_NUM
   {  8, 14, 0, array_d_spac, 0, 0, 0, NULL, NULL }, // A_D_SPAC
   {  2,  2, 0, array_h_num,  3, 0, 0, NULL, NULL }, // A_H_NUM
   {  8, 14, 0, array_h_spac, 0, 0, 0, NULL, NULL }, // A_H_SPAC
   {  3,  3, 0, array_pl_num, 3, 0, 0, NULL, NULL }, // A_PL_NUM
   {  8, 10, 0, array_st_ang, 2, 0, 0, NULL, NULL }, // A_ST_ANG
   {  8, 14, 0, array_radius, 0, 0, 0, NULL, NULL }, // A_RADIUS
   {  8, 10, 0, array_angle,  2, 0, 0, NULL, NULL }, // A_ANGLE
   {  8,  8, 0, array_prefix, 0, 0, 0, NULL, NULL }, // A_PREFIX
};

static SeeSub array_see[] = {
   A_F_TITLE, see_title_frame,
   A_T_TITLE, see_title_text,
   A_F_1, see_frame,
   A_F_2, see_frame,
   A_F_3, see_frame,
   A_F_4, see_frame,
   A_F_5, see_frame,
   A_F_6, see_frame,
   -1, FNULL
};

extern feel_array_cancel(), feel_array_ok(), feel_array_rotspot();
static FeelSub array_feel[] = {
   A_B_CANCEL, feel_array_cancel,
   A_B_OK, feel_array_ok,
   A_B_RTSL, feel_array_rotspot,
   -1, FNULL
};

/*
 * Wildcard Dialog */
static have_wc_selected = 0;
extern see_wc_list(), see_wc_all(), see_wc_none(), see_wc_tag(), 
   see_wc_untag(), see_wc_invert(), see_wc_total(), 
   see_wc_tagtotal(), see_wc_help();
static SeeSub wc_see[] = {
   W_F_TITLE, see_title_frame,
   W_T_TITLE, see_title_text,
   W_X_LIST, see_list,
   W_F_SALL, see_frame,
   W_F_TALL, see_frame,
   W_F_QTAG, see_frame,
   W_F_TITLE, see_title_frame,
   W_B_ALL, see_wc_all,
   W_B_NONE, see_wc_none,
   W_B_TAG, see_wc_tag,
   W_B_UNTG, see_wc_untag,
   W_B_INV, see_wc_invert,
   W_T_TOT, see_wc_total,
   W_T_TTOT, see_wc_tagtotal,
   W_T_QSCROLL, see_qscroll,
   W_B_HELP, see_wc_help,
   -1, FNULL
};

extern feel_wc_cancel(), feel_wc_ok(), feel_wc_list(),
   feel_wc_qscroll(), feel_wc_all(), feel_wc_none(), feel_wc_tag(), 
   feel_wc_untag(), feel_wc_invert(), feel_wc_help();
static FeelSub wc_feel[] = {
   W_B_CANC, feel_wc_cancel,
   W_B_OK, feel_wc_ok,
   W_X_LIST, feel_wc_list,
   W_T_QSCROLL, feel_wc_qscroll,
   W_B_ALL, feel_wc_all,
   W_B_NONE, feel_wc_none,
   W_B_TAG, feel_wc_tag,
   W_B_UNTG, feel_wc_untag,
   W_B_INV, feel_wc_invert,
   W_B_HELP, feel_wc_help,
   -1, FNULL
};

Scroller wc_scroller = {
   0, 0, 0, 0, 0, NULL, NULL, NULL
};

static ScrSub wc_scroll[] = {
   W_B_SCUP, W_B_SCDN, W_X_SCSL, W_X_LIST, feel_wc_list, &wc_scroller,
   -1, -1, -1, -1, FNULL, NULL
};

char wildcard_spec[11];
char qscroll[12];
Editable wc_edit[]=
{
   { 10, 10, 0, wildcard_spec, 0, 0, 0, NULL, NULL }
};
 
/*
 * Alternate Exclusion List Dialog */
extern see_alt_excl_total(), see_alt_excl_tagtotal();
static SeeSub alt_excl_see[] = {
   W_F_TITLE, see_title_frame,
   W_T_TITLE, see_title_text,
   W_X_LIST, see_list,
   W_F_SALL, see_frame,
   W_F_TALL, see_frame,
   W_F_QTAG, see_frame,
   W_F_TITLE, see_title_frame,
   W_B_ALL, see_wc_all,
   W_B_NONE, see_wc_none,
   W_B_TAG, see_wc_tag,
   W_B_UNTG, see_wc_untag,
   W_B_INV, see_wc_invert,
   W_T_TOT, see_alt_excl_total,
   W_T_TTOT, see_alt_excl_tagtotal,
   W_T_QSCROLL, see_qscroll,
   W_B_HELP, see_wc_help,
   -1, FNULL
};

extern feel_alt_excl_cancel(), feel_alt_excl_ok(), feel_alt_excl_list(),
   feel_alt_excl_qscroll(), feel_alt_excl_all(), feel_alt_excl_none(), feel_alt_excl_tag(), 
   feel_alt_excl_untag(), feel_alt_excl_invert(), feel_alt_excl_help();
static FeelSub alt_excl_feel[] = {
   W_B_CANC, feel_alt_excl_cancel,
   W_B_OK, feel_alt_excl_ok,
   W_X_LIST, feel_alt_excl_list,
   W_T_QSCROLL, feel_alt_excl_qscroll,
   W_B_ALL, feel_alt_excl_all,
   W_B_NONE, feel_alt_excl_none,
   W_B_TAG, feel_alt_excl_tag,
   W_B_UNTG, feel_alt_excl_untag,
   W_B_INV, feel_alt_excl_invert,
   W_B_HELP, feel_alt_excl_help,
   -1, FNULL
};
 
Scroller alt_excl_scroller = {
   0, 0, 0, 0, 0, NULL, NULL, NULL
};

static ScrSub alt_excl_scroll[] = {
   W_B_SCUP, W_B_SCDN, W_X_SCSL, W_X_LIST, feel_alt_excl_list, 
   &alt_excl_scroller, 
   -1, -1, -1, -1, FNULL, NULL
};

/*===========================================================================
 |  C l i e n t   F u n c t i o n s
 *=========================================================================*/
int ClientUsesInitDialog(void)
{
   return(0);
}

void ClientSetStateVar(int id, void *ptr)
{
   OVL o;
   ulong *ul;
   char *s;
   
   ul=(ulong *)ptr;
   s=(char *)ptr;
   o.ul = *ul;
}

ulong ClientGetStateVar(int id)
{
   OVL o;
   return(o.ul);
}

int ClientVarSize(int id)
{
   return(1);
}

char  *ClientGetState(int *size)
{
   *size = sizeof(State);
   return((char *)&state);
}

void ClientResetState()
{
   state = init_state;
}

void ClientTerminate(void)
{
   free_name_list(&select_list);
}

DlgEntry *ClientDialog(int n)
{
   return(NULL);
}

int ClientIsUniversal(void)
{
   return(0);
}

/*===========================================================================
 | Function: ClientStartup
 |  Purpose: To begin execution!
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
void ClientStartup(EXPbuf *b)
{
   int version;
  /*   
   * Assure its 3DS3 or greater, abort if not */
   version = studio_version();
   if(version < 300) {
      b->opcode = b->usercode = EXP_TERMINATE;
   }
   else {
      if (version == 300) {
         patch_light_shadow_flags(); // Bug fix for shadow update
      }
      b->opcode = EXP_MASTER_SCALE;
      b->usercode = UC_PROCESS_REQUESTS;
   }
}

/*===========================================================================
 | Function: ClientUserCode
 |  Purpose: To store the master scale information, and initiate menu 
 |           selections.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
void ClientUserCode(EXPbuf *b)
{
   switch(b->usercode) {
      case UC_PROCESS_REQUESTS:
        /*
         * Store the master scale information */
         master_scale = b->data.msc.master_scale;
         master_type = b->data.msc.type;
        /*
         * Process any user requests */
         process_user_requests();
         b->opcode = b->usercode = EXP_TERMINATE;
         break;
      default:
         b->opcode = b->usercode = EXP_TERMINATE;
         break;
   };
}

/*===========================================================================
 | Function: process_user_requests
 |  Purpose: To bring up the main menu and process user requests.  The 
 |           routine will loop as long as the user executes About, otherwise
 |           its one time and back to 3ds.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
process_user_requests()
{
   int again; // Process requests until again == FALSE;

   again = TRUE;
   while (again) {
     /*
      * Prompt the user for the function to execute */
      do_main_interaction();
      if (dialog_cancel) {
         again = FALSE;
      }
      else {
        /*
         * Execute the function the user requested */
         switch (main_rad_num) {
            case 0: // Update
               process_update();
               if (lt_opts.alt_excl_list)
                  free_name_list(&lt_opts.alt_excl_list);
               again = FALSE;
               break;
            case 1: // Array
               process_array();
               again = FALSE;
               break;
            case 2: // Delete
               process_delete();
               again = FALSE;
               break;
            case 3: // About
               process_about();
               break;
         }
      }
   }
}

/*===========================================================================
 | Function: process_array
 |  Purpose: To handle the Array command interaction.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
process_array()
{
   int sindex, status, count, have_lt;
   char dispmsg[32];

   gfx_prompt("Choose the Light to Array");
   strcpy(sel_lt_dlg[S_T_TITLE].text, "Prototype for Light Array ");
   have_lt = do_sel_lt_interaction();
   if (dialog_cancel) {
      return;
   }
   if (! have_lt) {
      gfx_continu_2line("At least one light is required",
                        "      to create an array");
      return;
   }
  /*
   * Prompt for the array data */
   do_array_interaction();
  /*
   * If the user has not cancelled, create the light arrays */
   if (! dialog_cancel) {
      gfx_prompt("Choose Rectangular or Polar and enter the Array parameters");
      if (array_rad_num == 0) { // Rectangular array
         pxp_get_index_from_name(source_lt, &sindex);
         count = rect_lt_array(source_lt, sindex);
      }
      else { // Polar array
         pxp_get_index_from_name(source_lt, &sindex);
         count = polar_lt_array(source_lt, sindex);
      }
      if (count)
         gfx_redraw();
      sprintf(dispmsg, "%d light(s) created", count);
      gfx_continu_line(dispmsg);
   }
}

/*===========================================================================
 | Function: process_update
 |  Purpose: To handle the Update interaction.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
process_update()
{
   int have_lt, count, ok, yn;
   char dispmsg[32];

   gfx_prompt("Choose the Prototype light whose properties you wish to copy to other lights");
   strcpy(sel_lt_dlg[S_T_TITLE].text, "Prototype for Light Update");
   have_lt = do_sel_lt_interaction();
   if (dialog_cancel) {
      return;
   }
   if (! have_lt) {
      gfx_continu_2line("At least two lights (of the same type)",
                        "are required for an Update");
      return;
   }
  /*
   * Get the indicies of the lights the user wishes to alter */
   gfx_prompt("Select the Lights whose properties you wish to Update");
   strcpy(wc_dlg[W_T_TITLE].text, "Choose the Lights to Update");
   ok = do_wc_interaction(TRUE); // Saved into global select_index_list
   if (dialog_cancel) {
      if (select_index_list)
         free(select_index_list);
      return;
   }
   if (ok) {
     /*
      * Determine if we should call an omni or spot dlg box ...*/
      if (lt_opts.spot_flag)
         do_spot_interaction();
      else 
         do_omni_interaction();
      if (! dialog_cancel) {
         sprintf(dispmsg, "Really Update %d light(s)?", taglist.tagged);
         gfx_yes_no_line(dispmsg, yn);
         if (yn) {
            count = update_lights();
            sprintf(dispmsg, "%d light(s) updated", count);
            gfx_continu_line(dispmsg);
         }
      }
   }
   else {
      gfx_continu_2line("At least two lights (of the same type)",
                        "are required for an Update");
   }
  /*
   * Free the memory allocated by the tagged list */
   if (select_index_list)
      free(select_index_list);
}

/*===========================================================================
 | Function: process_delete
 |  Purpose: To handle the Delete function.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
process_delete()
{
   int have_lt, count, ok;
   char dispmsg[32];

   gfx_prompt("Choose the Lights to Delete");
  /*
   * Get the indicies of the lights the user wishes to alter */
   source_lt[0] = '\0'; // Ensures all lights will load into select_list
   strcpy(wc_dlg[W_T_TITLE].text, "Choose the Lights to Delete");
   ok = do_wc_interaction(FALSE); // Saved into global select_index_list
   if (! dialog_cancel) {
      if (! have_wc_selected) {
         gfx_continu_line("At least one light is required to delete");
      }
      else {
        /*
         * If the user selected any lights, delete 'em (d_l will confirm) */
         if (ok) {
            count = delete_lights();
            if (count)
               gfx_redraw(); // Redraw all viewports
            sprintf(dispmsg, "%d light(s) Deleted", count);
            gfx_continu_line(dispmsg);
         }
      }
   }
  /*
   * Free the memory allocated by the tagged list */
   if (select_index_list)
      free(select_index_list);
}

/*===========================================================================
 | Function: process_about
 |  Purpose: To handle the About function.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
void process_about()
{
   int def, button;
   def = 0;
   gfx_alert(def,
"[Lighting Utilities - Shareware Version 1.0a|\
If you find this program useful please register|\
your copy by sending a check for $35.00 to|\
Mark Meier|\
650 Hidden Valley #212 - Ann Arbor, MI. 48104]\
[  Thanks  ]", button);
   main_rad_num = 0; // Back to update
}

/*===========================================================================
 | Function: do_main_interaction
 |  Purpose: This function initialized the main dialog and brings it up
 |           on the screen.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
void do_main_interaction()
{
  /*
   * Initialize and draw the dialog */
   if (! main_dlg_init) {
      init_dialog(main_dlg, NULL, NULL);
      main_dlg_init = 1;
   }
   ready_dialog(main_dlg, NULL, main_see, main_feel, main_rad, NULL, NULL);
   center_dialog(main_dlg);
   save_under_dialog(main_dlg);
   draw_dialog(main_dlg);
  /*
   * Process the users actions */
   do_dialog(main_dlg, -1);
  /*
   * User is done */
   restore_under_dialog();
}

/*===========================================================================
 | Function: do_spot_interaction
 |  Purpose: This function handles the spotlight parameter selection dialog
 |           initialization and execution.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
void do_spot_interaction()
{
   int anyset;

  /*
   * Initialize and draw the dialog */
   init_dialog(spot_dlg, NULL, NULL);
   ready_dialog(spot_dlg, NULL, spot_lt_see, spot_lt_feel, NULL, NULL, NULL);
   center_dialog(spot_dlg);
   save_under_dialog(spot_dlg);
   gfx_prompt("Choose the properties you wish to update");
   draw_dialog(spot_dlg);
  /*
   * Process the users actions */
   do_dialog(spot_dlg, -1);
  /*
   * User is done */
   restore_under_dialog();
   anyset = lt_opts.on+lt_opts.color+lt_opts.mult+lt_opts.excl+
      lt_opts.atten_range+lt_opts.source+lt_opts.shadow+lt_opts.shape+
      lt_opts.ov+lt_opts.proj+lt_opts.target+lt_opts.cone+lt_opts.bank;
   if ((! dialog_cancel) && (anyset == 0)) {
      dialog_cancel = 1; // User selected no parameters, don't process
      gfx_prompt("No properties selected to update");
   }
}

/*===========================================================================
 | Function: do_omni_interaction
 |  Purpose: This function initializes the omni parameter selection dialog
 |           and executes the dialog.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
void do_omni_interaction()
{
   int anyset;

  /*
   * Initialize and draw the dialog */
   init_dialog(omni_dlg, NULL, NULL);
   ready_dialog(omni_dlg, NULL, omni_lt_see, omni_lt_feel, NULL, NULL, NULL);
   center_dialog(omni_dlg);
   save_under_dialog(omni_dlg);
   gfx_prompt("Choose the properties you wish to update");
   draw_dialog(omni_dlg);
  /*
   * Process the users actions */
   do_dialog(omni_dlg, -1);
  /*
   * User is done */
   restore_under_dialog();
   anyset = lt_opts.on+lt_opts.color+lt_opts.mult+lt_opts.excl+
      lt_opts.atten_range+lt_opts.source;
   if ((! dialog_cancel) && (anyset == 0)) {
      dialog_cancel = 1; // User selected no parameters, don't process
      gfx_prompt("No properties selected to update");
   }
}

/*===========================================================================
 | Function: do_sel_lt_interaction
 |  Purpose: This function initializes the prototype selection dialog and
 |           executes it.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
int do_sel_lt_interaction()
{
   int count, source_index, status;
   ItemData sdata;
  /*
   * Initialize the dialog */
   have_lt_selected = 0; // Indicate user has not choosen yet
   if (! sel_lt_init) {
       init_dialog(sel_lt_dlg, NULL, NULL);
       sel_lt_init = 1;
   }
   ready_dialog(sel_lt_dlg, NULL, sel_lt_see, sel_lt_feel, NULL, 
      sel_lt_scroll, NULL);
   center_dialog(sel_lt_dlg);
   save_under_dialog(sel_lt_dlg);
  /*
   * Load the dialog scroll list with light names */
   count = pxp_sel_lt_load();
   if (! count) 
      return(0); // No light objects to build a list
   if (count == 1) { // If only 1, select it as a default
      strcpy(sel_lt_dlg[S_B_FILLIN].text, select_list->name);
      have_lt_selected = TRUE;
   }
  /*
   * Draw the dialog */
   init_scroller(&lt_scroller, select_list);
   draw_dialog(sel_lt_dlg);
  /*
   * Process the users actions */
   do_dialog(sel_lt_dlg, -1);
   restore_under_dialog();
  /*
   * Store the source name and set the spot light flag */
   if ((! dialog_cancel) && have_lt_selected) {
      strcpy(source_lt, sel_lt_dlg[S_B_FILLIN].text);
      pxp_get_index_from_name(source_lt, &source_index);
      pxp_get_item(source_index, &sdata, status);
      lt_opts.spot_flag = (sdata.item.l.hotsize < 360) ? 1 : 0; // Spot?
   }
   return(have_lt_selected);
}

/*===========================================================================
 | Function: do_wc_interaction
 |  Purpose: This function intializes and executes the 'tag lights' dialog
 |           and executes it.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
int do_wc_interaction(int alike_lt_filter)
{
   int count;

  /*
   * Initialize the dialog */
   have_wc_selected = 0; // Indicate user has not choosen yet
   if (! wc_init) {
       init_dialog(wc_dlg, wc_edit, NULL);
       wc_init = 1;
   }
   ready_dialog(wc_dlg, wc_edit, wc_see, wc_feel, NULL, wc_scroll, NULL);
   center_dialog(wc_dlg);
   save_under_dialog(wc_dlg);
  /*
   * Load the dialog scroll list with light names (load only lights 
   * matching lt_opts.spot_flag if alike_lt_filter is set) */
   count = wc_list_load(alike_lt_filter);
   if (! count) 
      return(0); // No light objects to build a list
  /*
   * Draw the dialog */
   taglist.length = count;
   init_scroller(&wc_scroller, select_list);
   draw_dialog(wc_dlg);
  /*
   * Process the users actions */
   do_dialog(wc_dlg, -1);
  /*
   * User is done */
   restore_under_dialog();
   return(1); // Return ok
}

/*===========================================================================
 | Function: do_alt_excl_interaction
 |  Purpose: This function intializes and executes the alternage object
 |           selection dialog
 |           and executes it.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
int do_alt_excl_interaction()
{
   int count;
Name_list *nlist;

  /*
   * Initialize the dialog */
   if (! wc_init) {
       init_dialog(wc_dlg, wc_edit, NULL);
       wc_init = 1;
   }
   ready_dialog(wc_dlg, wc_edit, alt_excl_see, alt_excl_feel, NULL, 
      alt_excl_scroll, NULL);
   center_dialog(wc_dlg);
   save_under_dialog(wc_dlg);
  /*
   * Load the dialog scroll list with light names (load only lights 
   * matching lt_opts.spot_flag if alike_lt_filter is set) */
   count = pxp_load_item_names(PXPMESH, &lt_opts.alt_excl_list, 1);
   if (count == PXP_LOAD_ERROR) {
      gfx_continu_line("Error loading object list...Command cancelled");
      return(0);
   }
   if (! count) 
      return(0); // No mesh objects to build a list
  /*
   * Draw the dialog */
   strcpy(wc_dlg[W_T_TITLE].text, "Additional Objs to Exclude ");
   alt_excl_taglist.length = count;
   init_scroller(&alt_excl_scroller, lt_opts.alt_excl_list);

   draw_dialog(wc_dlg);
  /*
   * Process the users actions */
   do_dialog(wc_dlg, -1);
  /*
   * User is done */
   restore_under_dialog();
   return(1); // Return ok
}

/*===========================================================================
 | Function: do_array_interaction
 |  Purpose: This function initializes and executes the array dialog.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
void do_array_interaction()
{
   char newname[11];

  /*
   * Initialize and draw the dialog */
   init_dialog(array_dlg, array_edit, NULL);
   ready_dialog(array_dlg, array_edit, array_see, array_feel, 
      array_rad, NULL, NULL);
   init_editable(&array_dlg[A_W_NUM], "2");
   init_editable(&array_dlg[A_W_SPAC], "");
   init_editable(&array_dlg[A_D_NUM], "2");
   init_editable(&array_dlg[A_D_SPAC], "");
   init_editable(&array_dlg[A_H_NUM], "2");
   init_editable(&array_dlg[A_H_SPAC], "");
   init_editable(&array_dlg[A_PL_NUM], "");
   init_editable(&array_dlg[A_ST_ANG], "0.0");
   init_editable(&array_dlg[A_RADIUS], "");
   init_editable(&array_dlg[A_ANGLE], "360.0");
   if (lt_opts.spot_flag)
      init_editable(&array_dlg[A_PREFIX], "Lt-Sp-");
   else 
      init_editable(&array_dlg[A_PREFIX], "Lt-Om-");
   center_dialog(array_dlg);
   save_under_dialog(array_dlg);
   draw_dialog(array_dlg);
  /*
   * Process the users actions */
   do_dialog(array_dlg, -1);
  /*
   * User is done */
   restore_under_dialog();
}

/*===========================================================================
 | Function: validate_array_data
 |  Purpose: This function is called when the user has selected OK from the
 |           array parameters dialog.  It is used to verify if all the 
 |           data was entered correctly.  If so, dialog_done is set to 
 |           TRUE, and the dialog will terminate.  Otherwise an error
 |           message is displayed and control is returned to the dialog.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: What a pain.
 *=========================================================================*/
void validate_array_data()
{
   int status, doit;
   double dtemp;
   float fx, fy, fz;
   char sname[11], errmsg[128], dispmsg[128];

   if (array_rad_num == 0) { // Rectangular array
      if (array_w_num[0]) {
         array_data.wc = (int) mm_convert_str(array_w_num);
         if (array_data.wc == 0) {
            gfx_continu_line("Cannot use a 0 for the Width Count - Use 1");
            return;
         }
      }
      else {
         gfx_continu_2line("No value entered for Width Count", 
            "(For a Polar array, select the Polar radio button)");
         return;
      }
      if (array_d_num[0]) {
         array_data.dc = (int) mm_convert_str(array_d_num);
         if (array_data.dc == 0) {
            gfx_continu_line("Cannot use a 0 for the Depth Count - Use 1");
            return;
         }
      }
      else {
         gfx_continu_line("No value entered for Depth Count");
         return;
      }
      if (array_h_num[0]) {
         array_data.hc = (int) mm_convert_str(array_h_num);
         if (array_data.hc == 0) {
            gfx_continu_line("Cannot use a 0 for the Height Count - Use 1");
            return;
         }
      }
      else {
         gfx_continu_line("No value entered for Height Count");
         return;
      }
      if (array_data.wc <= 1 && array_data.dc <= 1 && array_data.hc <= 1) {
         gfx_continu_line("Indicate at least one dimension for the array > 1");
         return;
      }
      if (array_w_spac[0]) {
         mm_atof(array_w_spac, &dtemp, &status, errmsg);
         if (status == MM_STATUS_ERROR) {
            sprintf(dispmsg, "Error in Width Spacing: %s", errmsg);
            gfx_continu_line(dispmsg);
            return;
         }
         else {
           array_data.ws = dtemp;
           if (array_data.wc > 1 && array_data.ws == 0.0) {
              gfx_continu_line("Zero not allowed for Width Spacing");
              return;
           }
         }
      }
      else {
         gfx_continu_line("No value entered for Width Spacing");
         return;
      }
      if (array_d_spac[0]) {
         mm_atof(array_d_spac, &dtemp, &status, errmsg);
         if (status == MM_STATUS_ERROR) {
            sprintf(dispmsg, "Error in Depth Spacing: %s", errmsg);
            gfx_continu_line(dispmsg);
            return;
         }
         else {
            array_data.ds = dtemp;
            if (array_data.dc > 1 && array_data.ds == 0.0) {
               gfx_continu_line("Zero not allowed for Depth Spacing");
               return;
           }
         }
      }
      else {
         gfx_continu_line("No value entered for Depth Spacing");
         return;
      }
      if (array_h_spac[0]) {
         mm_atof(array_h_spac, &dtemp, &status, errmsg);
         if (status == MM_STATUS_ERROR) {
            sprintf(dispmsg, "Error in Height Spacing: %s", errmsg);
            gfx_continu_line(dispmsg);
            return;
         }
         else {
            array_data.hs = dtemp;
            if (array_data.hc > 1 && array_data.hs == 0.0) {
               gfx_continu_line("Zero not allowed for Height Spacing");
               return;
           }
         }
      }
      else {
         gfx_continu_line("No value entered for Height Spacing");
         return;
      }
      if (! array_prefix[0]) {
         gfx_yes_no_line("Name Prefix not entered: Use Prototype name?", doit);
         if (doit) 
            strcpy(array_prefix, source_lt); // Prefix not entered
         else
            return;
      }
   }
   else { // Polar array
      if (array_pl_num[0]) {
         array_data.pc = (int) mm_convert_str(array_pl_num);
         if (array_data.pc == 0.0) {
            gfx_continu_line("Cannot create a Polar Array with 0 items");
            return;
         }
      }
      else {
         gfx_continu_2line("No value entered for Number of Items",
            "For a Rectangular array, select the Rectangular radio button");
         return;
      }
      if (array_st_ang[0]) {
         array_data.st_ang = mm_convert_str(array_st_ang);
      }
      else {
         gfx_continu_line("No value entered for Start Angle");
         return;
      }
      if (array_radius[0]) {
         mm_atof(array_radius, &dtemp, &status, errmsg);
         if (status == MM_STATUS_ERROR) {
            sprintf(dispmsg, "Error in Radius: %s", errmsg);
            gfx_continu_line(dispmsg);
            return;
         }
         else {
            array_data.radius = dtemp;
            if (array_data.radius == 0.0) {
               gfx_continu_line("Cannot create a Polar Array of Radius 0");
               return;
            }
         }
      }
      else {
         gfx_continu_line("No value entered for Radius");
         return;
      }
      if (array_angle[0]) {
         array_data.angle = mm_convert_str(array_angle);
      }
      else {
         gfx_continu_line("No value entered for Angle to Fill");
         return;
      }
      if (! array_prefix[0]) {
         gfx_yes_no_line("Name Prefix not entered: Use Prototype name?", doit);
         if (doit) 
            strcpy(array_prefix, source_lt); // Prefix not entered
         else
            return;
      }
   }
  /*
   * If all data was okay */
   dialog_done = 1;
   dialog_cancel = 0;
}

/*===========================================================================
 | Function: update_lights
 |  Purpose: This function loops thru the lights in the scene and changes
 |           those that require it.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
int update_lights()
{
   int i, index, status, source_index, count, src_spot_flag, dst_spot_flag,
      update_count;
   char dname[11];
   ItemData ddata, sdata;

  /*
   * Get the source object data */
   pxp_get_index_from_name(source_lt, &source_index);
   pxp_get_item(source_index, &sdata, status);
   src_spot_flag = lt_opts.spot_flag;
  /*
   * Figure out which lights to change and do it! */
   update_count = 0;
   pxp_get_item_count(count);
   for (i = 1; i < count; i++) {
      pxp_get_item(i, &ddata, status);
      if ((ddata.type == PXPLIGHT) && (source_index != i)) {
         dst_spot_flag = (ddata.item.l.hotsize < 360) ? 1 : 0;
         strcpy(dname, ddata.name);
         if ((src_spot_flag == dst_spot_flag) && index_match(i)) {
           /*
            * Update the light */
            update_light(&sdata, source_lt, &ddata, dname, &lt_opts);
            update_count++;
         }
      }
   }
   return(update_count);
}

/*===========================================================================
 | Function: update_light
 |  Purpose: This function actually modifies the light in the 3ds database.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
void update_light(ItemData *sdata, char *sname, ItemData *ddata, char *dname,
   lparms *u)
{
   ItemLight *s, *d;
   int status, i, lcount, ok;
   char ename[11];
   Name_list *alt_list;

   s = &(sdata->item.l);
   d = &(ddata->item.l);

   if (u->spot_flag) {
      if (u->target) {
         d->tx = s->tx;
         d->ty = s->ty;
         d->tz = s->tz;
      }
      if (u->shadow) { // bias, shadfilter, shadsize, shad flag, raytr flag
         d->shadsize = s->shadsize;
         d->bias = s->bias;
         d->shadfilter = s->shadfilter;
         d->ray_bias = s->ray_bias;
         d->flags = (s->flags & LIGHT_SHAD) ? 
            d->flags | LIGHT_SHAD : d->flags & ~LIGHT_SHAD;
         d->flags = (s->flags & LIGHT_RAYTR) ? 
            d->flags | LIGHT_RAYTR : d->flags & ~LIGHT_RAYTR;
      }
      if (u->shape) {
         d->flags = (s->flags & LIGHT_RECT) ? 
            d->flags | LIGHT_RECT : d->flags & ~LIGHT_RECT;
      }
      if (u->ov) {
         d->flags = (s->flags & LIGHT_OVER) ? 
            d->flags | LIGHT_OVER : d->flags & ~LIGHT_OVER;
      }
      if (u->proj) {
         d->flags = (s->flags & LIGHT_PROJ) ? 
            d->flags | LIGHT_PROJ : d->flags & ~LIGHT_PROJ;
         if (s->flags & LIGHT_PROJ)
            strcpy(d->imgfile, s->imgfile);
      }
      if (u->cone) {
         d->hotsize = s->hotsize;
         d->fallsize = s->fallsize;
         d->flags = (s->flags & LIGHT_CONE) ? 
            d->flags | LIGHT_CONE : d->flags & ~LIGHT_CONE;
      }
      if (u->bank) {
         d->bank = s->bank;
         d->aspect = s->aspect;
      }
   }
   if (u->on) {
      d->flags = d->flags | (s->flags & ~LIGHT_ON);
      d->flags = (s->flags & LIGHT_ON) ? 
         d->flags | LIGHT_ON : d->flags & ~LIGHT_ON;
   }
   if (u->color) {
      d->color = s->color;
   }
   if (u->mult) {
      d->mult = s->mult;
   }
   if (u->excl) {
      if (lt_opts.use_alt_excl_list) {
        /*
         * Add the tagged names to the existing exclusion list */
         alt_list = lt_opts.alt_excl_list;
         while (alt_list) {
            if (alt_list->name[0] == '*')
               pxp_add_excluded(dname, &alt_list->name[1], status);
            alt_list = alt_list->next;
         }
      }
      else {
         pxp_clear_excluded(dname, status);
         pxp_get_exclude_count(sname, lcount);
         for (i = 0; i < lcount; i++) {
            pxp_get_excluded(sname, i, ename, status);
            pxp_add_excluded(dname, ename, status);
         }
      }
   }
   if (u->atten_range) {
      d->in_range = s->in_range;
      d->out_range = s->out_range;
      d->flags = (s->flags & LIGHT_ATTEN) ? 
         d->flags | LIGHT_ATTEN : d->flags & ~LIGHT_ATTEN;
   }
   if (u->source) {
      d->x = s->x;
      d->y = s->y;
      d->z = s->z;
   }
  /*
   * Now change and post the revised light */
   pxp_erase_item(dname); // Erase from screen (not deleted)
   pxp_change_item(ddata, status);
   pxp_draw_item(dname);
}

/*===========================================================================
 | Function: pxp_sel_lt_load
 |  Purpose: This function loads a list of light names into the global
 |           select_list.  The list is sorted after being loaded.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
int pxp_sel_lt_load()
{
   int i, index, status, count, lt_count;
   ItemData data;

  /*
   * Free up the name list to begin */
   free_name_list(&select_list);
  /*
   * Figure out which lights to use and build a list */
   lt_count = 0;
   pxp_get_item_count(count);
   for (i = 0; i < count; i++) {
      pxp_get_item(i, &data, status);
      if (data.type == PXPLIGHT) {
         add_to_name_list(&select_list, data.name);
         lt_count++;
      }
   }
   sort_name_list(select_list);
   return(lt_count);
}

/*===========================================================================
 | Function: wc_list_load
 |  Purpose: This function creates a list of lights in the scene which 
 |           match the type of the prototype (source) light.  The source
 |           light itself is not included in the list.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
int wc_list_load(int alike_lt_filter)
{
   int i, index, status, cnt, count, lt_count, dst_spot_flag, okay_to_add;
   ItemData data;
   Name_list *nlist;
   char temp[12], name[11];

  /*
   * Free up the name list to begin */
   free_name_list(&select_list);
  /*
   * Build a list of lights - use a ' ' as the first char */
   lt_count = 0;
   pxp_get_item_count(count);
   for (i = 0; i < count; i++) {
      pxp_get_item(i, &data, status);
      if (data.type == PXPLIGHT) {
         if (alike_lt_filter) {
            dst_spot_flag = (data.item.l.hotsize < 360) ? 1 : 0;
            if (lt_opts.spot_flag == dst_spot_flag) {
               okay_to_add = TRUE;
            }
            else {
               okay_to_add = FALSE;
            }
         }
         else {
            okay_to_add = TRUE;
         }
         if (okay_to_add) {
            if (strcmp(data.name, source_lt)) { // Don't show source_lt
               sprintf(temp, " %s", data.name);
               add_to_name_list(&select_list, temp);
               lt_count++;
            }
         }
      }
   }
   sort_name_list(select_list);
  /*
   * Build an array of indicies corresponding to the select_list names */
   if (NULL == (select_index_list = (int *)malloc(lt_count*sizeof(int)+1))) {
   if (NULL == (select_index_list = (int *)malloc(lt_count*sizeof(int)+1))) {
      gfx_continu_line("Error: No RAM available");
      return(0);
   } // Tried twice because of a bug in Watcom - malloc may fail first attempt
   }
   nlist = select_list; cnt = 0;
   while (nlist) {
      strcpy(name, &nlist->name[1]);
      pxp_get_light_index(name, &index);
      select_index_list[cnt++] = index;
      nlist = nlist->next;
   }
   return(lt_count);
}

/*===========================================================================
 | Function: pxp_load_obj_names
 |  Purpose: This function is used to create a list of EVERY object/light/
 |           and camera in the scene.  It is used by the name check code
 |           to ensure only new names are added to the database.  The global
 |           obj_names is loaded and sorted.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
int pxp_load_obj_names()
{
   int i, index, status, count, obj_count;
   ItemData data;

  /*
   * Free up the name list to begin */
   free_name_list(&obj_list);
  /*
   * Figure out which lights to use and build a list */
   obj_count = 0;
   pxp_get_item_count(count);
   for (i = 0; i < count; i++) {
      pxp_get_item(i, &data, status);
      if (status) {
         add_to_name_list(&obj_list, data.name);
         obj_count++;
      }
   }
   sort_name_list(obj_list);
   return(obj_count);
}

/*===========================================================================
 | Function: pxp_load_item_names
 |  Purpose: This function is used to create a list of the specified
 |           item type (PXPMESH, PXPAMBIENT, PXPLIGHT, PXPCAMERA).  If the 
 |           type passed is -1, all objects will be loaded.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: If an error occurs, PXP_LOAD_ERROR is returned.
 *=========================================================================*/
int pxp_load_item_names(int type, Name_list **nlist, int sort_flag)
{
   int i, index, status, count, item_count;
   char name[12];
   ItemData data;

  /*
   * Free up the name list to begin */
   free_name_list(nlist);
  /*
   * Figure out which lights to use and build a list */
   item_count = 0;
   pxp_get_item_count(count);
   for (i = 1; i < count; i++) {
      pxp_get_item(i, &data, status);
      if (status) {
         if ((data.type == -1) || (data.type == type)) {
            sprintf(name, " %s", data.name);
            add_to_name_list(nlist, name);
            item_count++;
         }
      }
      else {
         free_name_list(nlist);
         return(PXP_LOAD_ERROR);
      }
   }
   if (sort_flag)
      sort_name_list(*nlist);
   return(item_count);
}

/*===========================================================================
 | Function: index_match
 |  Purpose: 
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
int index_match(int lt_index)
{
   int i, list_index;
   Name_list *nlist;

   list_index = 0;
   nlist = select_list;
  /*
   * Check every tagged item in the select_list to see if its 
   * index matches the one passed */
   while (nlist) {
      if (nlist->name[0] == '*') {
        /*
         * This name is tagged, check for an index match */
         if (select_index_list[list_index] == lt_index)
            return(1);
      }
      nlist = nlist->next;
      list_index++;
   }
   return(0); // Not in the list
}

/*===========================================================================
 | Function: rect_lt_array
 |  Purpose: This function creates the rectangular light array.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
int rect_lt_array(char *sname, int sindex)
{
   ItemData idata, ndata;
   char nname[10], ename[11];
   int i, lcount, ncount, ix, iy, iz, status, key, created;
   float x_off, y_off, z_off;
   ncount = pxp_load_obj_names(); // load into obj_list;
  /*
   * Get the source light data */
   pxp_get_item(sindex, &idata, status);
  /*
   * Clear any keys from the keyboard buffer before we loop so the user
   * may interupt by pressing ESC */
   gfx_key_hit(key);
   while (key) {
      gfx_get_key(key);
      gfx_key_hit(key);
   }
   gfx_stand_by("Creating Array - Press ESC to Abort")
  /*
   * Create the 3d rectangular array */
   created = 0;
   z_off = 0;
   for (iz = 0; iz < array_data.hc; iz++) {
      y_off = 0;
      for (iy = 0; iy < array_data.dc; iy++) {
         x_off = 0;
         for (ix = 0; ix < array_data.wc; ix++) {
            gfx_key_hit(key); // Check if the user wants to quit
            if (key) {
               gfx_get_key(key);
               if (key == ESC_KEY) {
                  gfx_put_hole(); // Remove Stand by message...
                  gfx_continu_line("Array halted - Interupted by user");
                  return(created);
               }
            }
            if (! ((iz == 0) && (iy == 0) && (ix == 0))) { // Skip 'overlap' lt
               ndata = idata;
               ndata.item.l.x += x_off;
               ndata.item.l.y += y_off;
               ndata.item.l.z += z_off;
               if (lt_opts.spot_flag) {
                  ndata.item.l.tx += x_off;
                  ndata.item.l.ty += y_off;
                  ndata.item.l.tz += z_off;
               }
               pxp_get_new_name(nname, array_prefix, obj_list);
               strcpy(ndata.name, nname);
               pxp_create_item(&ndata, status);
               if (status) { // Created okay
                  add_to_name_list(&obj_list, nname);
                 /*
                  * Copy the exclusion list of the original */
                  pxp_clear_excluded(nname, status);
                  pxp_get_exclude_count(sname, lcount);
                  for (i = 0; i < lcount; i++) {
                     pxp_get_excluded(sname, i, ename, status);
                     pxp_add_excluded(nname, ename, status);
                  }
                  created++;
                  pxp_draw_item(nname);
               }
               else { // Error creating light  
                  free_name_list(&obj_list);
                  gfx_put_hole(); // Remove Stand by message...
                  gfx_continu_line("Error creating array - Process aborted");
                  return(created);
               }
            }
            x_off += array_data.ws;
         }
         y_off += array_data.ds;
      }
      z_off += array_data.hs;
   }
   gfx_put_hole(); // Remove Stand by message...
   free_name_list(&obj_list);
   return(created);
}

/*===========================================================================
 | Function: polar_lt_array
 |  Purpose: This function creates the polar light arrays.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
int polar_lt_array(char *sname, int sindex)
{
   ItemData idata, ndata;
   char nname[10], ename[11];
   int lt, i, lcount, ncount, status, key, created;
   double a, ang_inc, x, y, z, tx, ty, tz, lt_len;
  /*
   * Get the source light data */
   ncount = pxp_load_obj_names(); // load into obj_list;
   pxp_get_item(sindex, &idata, status);
  /*
   * Clear any keys from the keyboard buffer before we loop so the user
   * may interupt by pressing ESC */
   gfx_key_hit(key);
   while (key) {
      gfx_get_key(key);
      gfx_key_hit(key);
   }
   created = 0;
   gfx_stand_by("Creating Array - Press ESC to Abort")
   a = DegToRad(array_data.st_ang);
   ang_inc = DegToRad(array_data.angle/array_data.pc);
   for (lt = 0; lt < array_data.pc; lt++) {
      gfx_key_hit(key); // Check if the user wants to quit
      if (key) {
         gfx_get_key(key);
         if (key == ESC_KEY) {
            gfx_put_hole(); // Remove Stand by message...
            gfx_continu_line("Array halted - Interupted by user");
            return(created);
         }
      }
      switch(array_plane_num) {
         case 0: // Top Plane
            x = array_data.radius*cos(a);
            y = array_data.radius*sin(a);
            z = 0.0;
            break;
         case 1: // Front Plane
            x = array_data.radius*cos(a);
            y = 0.0;
            z = array_data.radius*sin(a);
            break;
         case 2: // Side Plane
            x = 0.0;
            y = array_data.radius*cos(a);
            z = array_data.radius*sin(a);
            break;
      };
      if (lt_opts.spot_flag) {
         switch(array_plane_num) {
            case 0: // Top Plane
               lt_len = twod_dist(idata.item.l.x, idata.item.l.y, 
                  idata.item.l.tx, idata.item.l.ty);
               tx = idata.item.l.x+((array_data.radius-lt_len)*cos(a));
               ty = idata.item.l.y+((array_data.radius-lt_len)*sin(a));
               tz = idata.item.l.tz;
               break;
            case 1: // Front Plane
               lt_len = twod_dist(idata.item.l.x, idata.item.l.z, 
                  idata.item.l.tx, idata.item.l.tz);
               tx = idata.item.l.x+((array_data.radius-lt_len)*cos(a)); 
               ty = idata.item.l.ty;
               tz = idata.item.l.z+((array_data.radius-lt_len)*sin(a));
               break;
            case 2: // Side Plane
               lt_len = twod_dist(idata.item.l.y, idata.item.l.z, 
                  idata.item.l.ty, idata.item.l.tz);
               tx = idata.item.l.tx;
               ty = idata.item.l.y+((array_data.radius-lt_len)*cos(a));
               tz = idata.item.l.z+((array_data.radius-lt_len)*sin(a));
               break;
         }
      }
     /*
      * Create the new light */
      ndata = idata;
      ndata.item.l.x += (float) x;
      ndata.item.l.y += (float) y;
      ndata.item.l.z += (float) z;
      if (lt_opts.spot_flag) { // Adjust the target if a spot light
         if (lt_opts.rot_spot_flag) { // Rotate the target
            ndata.item.l.tx = (float) tx;
            ndata.item.l.ty = (float) ty;
            ndata.item.l.tz = (float) tz; 
         }
         else { // Translate the target
            ndata.item.l.tx += (float) x;
            ndata.item.l.ty += (float) y;
            ndata.item.l.tz += (float) z;
         }
      }
      pxp_get_new_name(nname, array_prefix, obj_list);
      strcpy(ndata.name, nname);
      pxp_create_item(&ndata, status);
      if (status) { // Created okay
         add_to_name_list(&obj_list, nname);
        /*
         * Copy the exclusion list of the original */
         pxp_clear_excluded(nname, status);
         pxp_get_exclude_count(sname, lcount);
         for (i = 0; i < lcount; i++) {
            pxp_get_excluded(sname, i, ename, status);
            pxp_add_excluded(nname, ename, status);
         }
         created++;
         pxp_draw_item(nname);
      }
      else { // Error creating light  
         free_name_list(&obj_list);
         gfx_put_hole(); // Remove Stand by message...
         gfx_continu_line("Error creating array - Process aborted");
         return(created);
      }
     /*
      * Increment the angle of rotation */
      a += ang_inc;
   }
   gfx_put_hole(); // Remove Stand by message...
   free_name_list(&obj_list);
   return(created);
}

double twod_dist(double x1, double y1, double x2, double y2)
{
   double dx, dy;
   dx = x1-x2; dy = y1-y2;
   return (sqrt((dx*dx)+(dy*dy)));
}

/*===========================================================================
 | Function: delete_lights
 |  Purpose: This function deletes the tagged lights
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: It has to do a rather exhaustive search as the indicies move
 |           around as items are deleted.
 *=========================================================================*/
int delete_lights()
{
   int count, i, status, yn, total;
   char dispmsg[32];
   ItemData data;
   Name_list *nlist;

   sprintf(dispmsg, "Really Delete %d light(s)?", taglist.tagged);
   gfx_yes_no_line(dispmsg, yn);
   if (yn) {
      nlist = select_list;
      while (nlist) {
         if (nlist->name[0] == '*') {
            pxp_get_item_count(count);
            for (i = 1; i < count; i++) {
               pxp_get_item(i, &data, status);
               if (strcmp(&nlist->name[1], data.name) == 0) {
                  pxp_erase_item(data.name);
                  pxp_delete_item(data.name, status);
                  break; // Exit the for loop
               }
            }
         }
         nlist = nlist->next;
      } 
      total = taglist.tagged;
   }
   else {
      total = 0; // User wimped out
   }
   return(total);
}

/*===========================================================================
 | Function: pxp_get_new_name
 |  Purpose: This function returns a unused new name based on the old name
 |           passed.
 |  History: Written by Douglas Holt 14 March 1994.
 |           MM, Changed the final isalpha call to a (! isdigit).
 |  Remarks: Thanks Doug!
 *=========================================================================*/
void pxp_get_new_name(char *newname, char *oldname, Name_list *objectnames)
{
   int plus = 0;
   int nlen;

   nlen = strlen(oldname);
   if(nlen == 10) {
      oldname[8] = '\0';
   }
   else if(nlen > 2 && isdigit(oldname[nlen-1]) && 
      isdigit(oldname[nlen-2]) && (! isdigit(oldname[nlen-3]))) {
      oldname[nlen-2] = '\0';
   }
   do {
      sprintf(newname, "%02d", ++plus);
      nlen = 10 - strlen(newname);
      oldname[nlen] = '\0';
      sprintf(newname, "%s%02d", oldname, plus);
   } while(pxp_object_exist(newname, objectnames));
}

/*===========================================================================
 | Function: pxp_object_exist
 |  Purpose: To return 1 is the object name passed exists, and 0 otherwise.
 |  History: Written by Douglas Holt 14 March 1994.
 |           MM, Changed it trivially to support unsorted list slowing
 |           it down considerably <g>.
 *=========================================================================*/
int pxp_object_exist(char *objname, Name_list *objectnames)
{
   Name_list *names;
   int cmpval;

   names = objectnames;
   while (names) {
      cmpval = strcmp(objname, names->name);
      if (! cmpval) {
          return(1);
      }
      names = names->next;
    }
    return(0);
}

/*===========================================================================
 | Function: pxp_get_index_from_name
 |  Purpose: This function returns the index of the named object passed and
 |           returns -1 if the object does not exist.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
void pxp_get_index_from_name(char *n, int *index)
{
   int count, i, status;
   ItemData data;

   pxp_get_item_count(count);
   for (i = 1; i < count; i++) {
      pxp_get_item(i, &data, status);
      if (strcmp(data.name, n) == 0) {
         *index = i;
         return;
      }
   }
   *index = -1;
}

/*===========================================================================
 |  F e e l   F u n c t i o n s
 *=========================================================================*/
/*
 * Main (main) Feel Functions */
void feel_main_cancel(Dialog *d, int mouse)
{
   if (mouse)
      if (! press_button(d))
         return;
   dialog_done = 1;
   dialog_cancel = 1;
}

void feel_main_next(Dialog *d, int mouse)
{
   if (mouse)
      if (! press_button(d))
         return;
   dialog_done = 1;
   dialog_cancel = 0;
}

void feel_main_update(Dialog *d, int mouse)
{
   int key;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         gfx_continu_2line("Update copies selected properties of a prototype",
                            "light to other choosen lights in the scene");
      }
      else if (press_button(d)) {
         main_rad_num = 0;
         draw_radio_group(main_dlg, &main_rad_num, 0);
      }
   }
}

void feel_main_array(Dialog *d, int mouse)
{
   int key;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         gfx_continu_2line("Array creates multiple copies of a selected light",
                             "in a rectangular or polar (circular) pattern");
      }
      else if (press_button(d)) {
         main_rad_num = 1;
         draw_radio_group(main_dlg, &main_rad_num, 0);
      }
   }
}

void feel_main_delete(Dialog *d, int mouse)
{
   int key;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         gfx_continu_2line("Delete allows you to specify lights you",
                           "want permanently removed from the scene");
      }
      else if (press_button(d)) {
         main_rad_num = 2;
         draw_radio_group(main_dlg, &main_rad_num, 0);
      }
   }
}

void feel_main_about(Dialog *d, int mouse)
{
   int key;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         gfx_continu_2line("About displays a message concerning how you",
                           "may register your copy of this shareware");
      }
      else if (press_button(d)) {
         main_rad_num = 3;
         draw_radio_group(main_dlg, &main_rad_num, 0);
      }
   }
}

/*
 * Select Light (sel_lt) (Prototype) Feel Functions */
void feel_sel_lt_cancel(Dialog *d, int mouse)
{
   if (mouse)
      if (! press_button(d))
         return;
   dialog_done = 1;
   dialog_cancel = 1;
}

void feel_sel_lt_ok(Dialog *d, int mouse)
{
   if (mouse)
      if (! press_button(d))
         return;
   if (! have_lt_selected) {
      gfx_continu_line("Please Choose a Light");
   }
   else {
      dialog_done = 1;
      dialog_cancel = 0;
   }
}

void feel_sel_lt_box(Dialog *d, int mouse)
{
   Name_list *nlist;

   if ((nlist = which_sel(d)) != NULL) {
      strcpy(sel_lt_dlg[S_B_FILLIN].text, nlist->name);
      draw_item_number(sel_lt_dlg, S_B_FILLIN);
      have_lt_selected = 1; // User has made a choice
   }
}

void feel_sel_lt_fillin(Dialog *d, int mouse)
{
   // Only here to ignore all events on this
}

void feel_sel_lt_help(Dialog *d, int mouse)
{
   int b, x;

   b = 0;
   if (mouse)
      if (! press_button(d))
         return;
   gfx_alert(b, "[Choose the Help Topic][Prototype|Quick Find|Continue]", x);
   switch(x) { 
      case 0: // General
         gfx_alert(b, 
"[Choose a single light to use as the Prototype|\
for the Array or Update operation.  This light|\
should be set with the properties you want to|\
include in the updated or newly created lights.]\
[Continue]", x);
         break;
      case 1: // Quick Find
         gfx_alert(b, 
"[The Quick Find function (~) allows you to select an item in the|\
scroll list by typing characters which uniquely identify the name.|\
The name choosen is the first one which matches the entire sequence|\
entered.  Press the Spacebar or Enter to select, or press the ESC|\
key to quit quick find.]\
[Continue]", x);
         break;
      default: // Continue
         break;
   };
}

void feel_sel_lt_qscroll(Dialog *d, int mouse)
{
   int i, l, again, key, index, prev_index, tag_flag;
   float scroll_inc;
   char charlist[12];
   Name_list *nlist;

   gfx_kstate(key);
   if (mouse && (key & 0x0008)) { // If Alt key is press - offer help
       gfx_continu_2line("Type characters to uniquely identify an item in the list.",
                         "Press Space to Select or press ESC to cancel");
   }
   else {
     /*
      * Scroll the list box to the first entry which matches what the user
      * types in here */
      gfx_prompt("Type Unique letters of the name to find. Space=Select or ESC=Cancel");
      strcpy(sel_lt_dlg[S_T_QSCROLL].text, "----------");
      button_in(&sel_lt_dlg[S_T_QSCROLL], WHITE, CYAN);
      again = TRUE; index = -1; l = 0; prev_index = -1; tag_flag = FALSE;
      while (again) {
         gfx_key_wait(key);
         if (key == ESC) {
            again = FALSE; tag_flag = FALSE;
         }
         else if ((key == SPACE) || (key == CARRIAGERETURN)) {
            again = FALSE; 
            if (index != -1)
               tag_flag = TRUE;
         }
         else if (l < 10) { 
            charlist[l++] = (char) key;
            charlist[l] = '\0';
            prev_index = index;
            index = search_namelist(charlist, index, select_list, qscroll);
            if (index != -1) {
              /*
               * Show the temporarily selected name */
               strcpy(sel_lt_dlg[S_T_QSCROLL].text, qscroll);
               button_in(&sel_lt_dlg[S_T_QSCROLL], WHITE, CYAN);
               update_scroll_box(index, &lt_scroller, sel_lt_dlg, 
                  S_X_LIST, S_X_SCRSL);
            }
            else { // Key not in list, skip it
               index = prev_index;
               if (l) l--; 
            }
         }
      }
      if (tag_flag) {
         nlist = select_list;
         for (i = 0; i < index; i++) {
            nlist = nlist->next;
         }
         strcpy(sel_lt_dlg[S_B_FILLIN].text, nlist->name);
         have_lt_selected = TRUE; // At least one tagged
         if (index != -1)
            update_scroll_box(index, &lt_scroller, sel_lt_dlg, 
               S_X_LIST, S_X_SCRSL);
         draw_item_number(sel_lt_dlg, S_B_FILLIN);
      }
     /*
      * Erase the selected name from the Quick find box */
      draw_inbox(&sel_lt_dlg[S_T_QSCROLL], CYAN);
      draw_inbox(&sel_lt_dlg[S_X_LIST], CYAN);
      prt_list(&sel_lt_dlg[S_X_LIST]);
   }
}

/*
 * Select Tagged List (wc) Feel Functions */
void feel_wc_cancel(Dialog *d, int mouse)
{
   if (mouse)
      if (! press_button(d))
         return;
   dialog_done = 1;
   dialog_cancel = 1;
}

void feel_wc_ok(Dialog *d, int mouse)
{
   if (mouse)
      if (! press_button(d))
         return;
   if (! have_wc_selected) {
//      gfx_continu_line("Please select some Lights");
        dialog_done = 1;
        dialog_cancel = 1;
   }
   else {
      dialog_done = 1;
      dialog_cancel = 0;
   }
}

void feel_wc_help(Dialog *d, int mouse)
{
   int b, x;

   b = 0;
   if (mouse)
      if (! press_button(d))
         return;
   gfx_alert(b, "[Choose the Help Topic][Choose Lts|Quick Find|Wildcards|Continue]", x);
   switch(x) { 
      case 0: // General
         gfx_alert(b, 
"[The Choose Lights dialog allows you to select the group of|\
lights that the Update or Delete command will operate upon.]\
[Continue]", x);
         break;
      case 1: // Quick Find
         gfx_alert(b, 
"[The Quick Find function (~) allows you to select an item in the|\
scroll list by typing characters which uniquely identify the name.|\
The name choosen is the first one which matches the entire sequence|\
entered.  Press the Spacebar or Enter to Tag or Untag your|\
selection, or press the ESC key to quit quick find.]\
[Continue]", x);
         break;
      case 2: // Wildcards
         gfx_alert(b, 
"[The Tag/Untag buttons operate on the wild card pattern entered|\
in the field above the buttons.  The * character matches all|\
characters to the end of the string.  The ? character matches|\
any single character.]\
[Continue]", x);
         break;
      default: // Continue
         break;
   };
}

void feel_wc_list(Dialog *d, int mouse)
{
   Name_list *nlist;

   if ((nlist = which_sel(d)) != NULL) {
      if (nlist->name[0] == ' ') {
         nlist->name[0] = '*';
         taglist.tagged += 1;
      }
      else {
         nlist->name[0] = ' ';
         taglist.tagged -= 1;
      }
      prt_list(&wc_dlg[W_X_LIST]);
      if (taglist.tagged)
         have_wc_selected = 1; // User has selected at least one
      else
         have_wc_selected = 0; // User has not selected at least one
      draw_item_number(wc_dlg, W_T_TTOT);
   }
}

void feel_wc_qscroll(Dialog *d, int mouse)
{
   int i, l, again, key, index, prev_index, tag_flag;
   float scroll_inc;
   char charlist[12];
   Name_list *nlist;

   gfx_kstate(key);
   if (mouse && (key & 0x0008)) { // If Alt key is press - offer help
       gfx_continu_2line("Type characters to uniquely identify an item in the list.",
                         "Press Space to Tag/Untag or press ESC to cancel");
   }
   else {
     /*
      * Scroll the list box to the first entry which matches what the user
      * types in here */
      gfx_prompt("Type Unique letters of the name to find. Space=Tag/Untag or ESC=Cancel");
      strcpy(wc_dlg[W_T_QSCROLL].text, "----------");
      button_in(&wc_dlg[W_T_QSCROLL], WHITE, CYAN);
      again = TRUE; index = -1; l = 0; prev_index = -1; tag_flag = FALSE;
      while (again) {
         gfx_key_wait(key);
         if (key == ESC) {
            again = FALSE; tag_flag = FALSE;
         }
         else if ((key == SPACE) || (key == CARRIAGERETURN)) {
            again = FALSE; 
            if (index != -1)
               tag_flag = TRUE;
         }
         else if (l < 10) { 
            charlist[l++] = (char) key;
            charlist[l] = '\0';
            prev_index = index;
            index = search_namelist(charlist, index, select_list, qscroll);
            if (index != -1) {
              /*
               * Show the temporarily selected name */
               strcpy(wc_dlg[W_T_QSCROLL].text, &qscroll[1]);
               button_in(&wc_dlg[W_T_QSCROLL], WHITE, CYAN);
               update_scroll_box(index, &wc_scroller, wc_dlg, 
                  W_X_LIST, W_X_SCSL);
            }
            else { // Key not in list, skip it
               index = prev_index;
               if (l) l--; 
            }
         }
      }
      if (tag_flag) {
         nlist = select_list;
         for (i = 0; i < index; i++) {
            nlist = nlist->next;
         }
         strcpy(qscroll, nlist->name);
         if (qscroll[0] == '*') {
            taglist.tagged--;
            nlist->name[0] = ' ';
            if (taglist.tagged == 0)
               have_wc_selected = FALSE;
            draw_item_number(wc_dlg, W_T_TTOT);
         }
         else {
            taglist.tagged++;
            nlist->name[0] = '*';
            have_wc_selected = TRUE; // At least one tagged
            if (index != -1)
               update_scroll_box(index, &wc_scroller, wc_dlg, 
                  W_X_LIST, W_X_SCSL);
            draw_item_number(wc_dlg, W_T_TTOT);
         }
      }
     /*
      * Erase the selected name from the Quick find box */
      draw_inbox(&wc_dlg[W_T_QSCROLL], CYAN);
      draw_inbox(&wc_dlg[W_X_LIST], CYAN);
      prt_list(&wc_dlg[W_X_LIST]);
   }
}

void feel_wc_all(Dialog *d, int mouse)
{
   Name_list *nlist;
   if (mouse)
      if (! press_button(d))
         return;
   nlist = select_list;
   while(nlist) {
      nlist->name[0] = '*';
      nlist = nlist->next;
   }
   prt_list(&wc_dlg[W_X_LIST]);
   taglist.tagged = taglist.length;
   draw_item_number(wc_dlg, W_T_TTOT);
   have_wc_selected = 1; // User has selected at least one
}

void feel_wc_none(Dialog *d, int mouse)
{
   Name_list *nlist;
   if (mouse)
      if (! press_button(d))
         return;
   nlist = select_list;
   while(nlist) {
      nlist->name[0] = ' ';
      nlist = nlist->next;
   }
   prt_list(&wc_dlg[W_X_LIST]);
   taglist.tagged = 0;
   draw_item_number(wc_dlg, W_T_TTOT);
   have_wc_selected = 0; // User has not selected at least one
}

void feel_wc_invert(Dialog *d, int mouse)
{
   Name_list *nlist;
   if (mouse)
      if (! press_button(d))
         return;
   nlist = select_list;
   while(nlist) {
      if (nlist->name[0] == '*')
         nlist->name[0] = ' ';
      else
         nlist->name[0] = '*';
      nlist = nlist->next;
   }
   prt_list(&wc_dlg[W_X_LIST]);
   taglist.tagged = taglist.length-taglist.tagged;
   draw_item_number(wc_dlg, W_T_TTOT);
   if (taglist.tagged)
      have_wc_selected = 1; // User has selected at least one
   else
      have_wc_selected = 0; // User has not selected at least one
}

void feel_wc_tag(Dialog *d, int mouse)
{
   int match, found_offset;
   char *wc_ptr, *n_ptr, next_wc_char;
   Name_list *nlist;

   nlist = select_list;
   wc_ptr = wildcard_spec;
   n_ptr = nlist->name;
   n_ptr++; // Point past initial ' ' or '*' tag indicator
   match = TRUE; // Innocent until proven guilty
  /* 
   * Loop thru all the names in the 'select_list' */
   while (nlist) {

      next_wc_check:
      while (*wc_ptr) {
         if (*n_ptr) {
            if (*wc_ptr == '?') {
               wc_ptr++; 
               n_ptr++;
               goto next_wc_check;
            }
            else if (*wc_ptr == '*') {
               goto match;
            }
            else { // Any other character
               if (*wc_ptr != *n_ptr) {
                  goto next_name; // Not a match
               }
               else { // Okay so far, check next characters
                  n_ptr++;
                  wc_ptr++;
               }
            }
         }
         else { // End of name
            // If any non ? or * chars exist in the rest of the
            // wildcard spec, this is not a match, otherwise it is
            if (check_for_non_wc_chars(wc_ptr)) {
               goto next_name;
            }
            wc_ptr++;
         }
      }

      if ((*wc_ptr == 0) && (*n_ptr != 0)) {
         match = FALSE; // Name exceeds pattern spec (wc didn't end on ? or *)
      }
      match:
      if (match) { // This is a match, tag it
         if (nlist->name[0] != '*') {
            taglist.tagged++;
            nlist->name[0] = '*'; // Indicates its taggeds
         }
         have_wc_selected = 1; // User has selected at least one
      }

      next_name:
      nlist = nlist->next;
      n_ptr = nlist->name;
      n_ptr++; // Point past initial ' ' or '*'
      wc_ptr = wildcard_spec;
   }
   prt_list(&wc_dlg[W_X_LIST]);
   button_out(d, WHITE, MDGRAY);
   draw_item_number(wc_dlg, W_T_TTOT);
}

void feel_wc_untag(Dialog *d, int mouse)
{
   int match, found_offset;
   char *wc_ptr, *n_ptr, next_wc_char;
   Name_list *nlist;

   nlist = select_list;
   wc_ptr = wildcard_spec;
   n_ptr = nlist->name;
   n_ptr++; // Point past initial ' ' or '*' tag indicator
   match = TRUE; // Innocent until proven guilty
  /* 
   * Loop thru all the names in the 'select_list' */
   while (nlist) {

      next_wc_check:
      while (*wc_ptr) {
         if (*n_ptr) {
            if (*wc_ptr == '?') {
               wc_ptr++; 
               n_ptr++;
               goto next_wc_check;
            }
            else if (*wc_ptr == '*') {
               goto match;
            }
            else { // Any other character
               if (*wc_ptr != *n_ptr) {
                  goto next_name; // Not a match
               }
               else { // Okay so far, check next characters
                  n_ptr++;
                  wc_ptr++;
               }
            }
         }
         else { // End of name
            // If any non ? or * chars exist in the rest of the
            // wildcard spec, this is not a match, otherwise it is
            if (check_for_non_wc_chars(wc_ptr)) {
               goto next_name;
            }
            wc_ptr++;
         }
      }

      if ((*wc_ptr == 0) && (*n_ptr != 0)) {
         match = FALSE; // Name exceeds pattern spec (wc didn't end on ? or *)
      }
      match:
      if (match) { // This is a match, untag it
         if (nlist->name[0] != ' ') {
            taglist.tagged--;
            if (taglist.tagged == 0)
               have_wc_selected = 0; // None selected
            nlist->name[0] = ' '; // Indicates its un-tagged
         }
      }

      next_name:
      nlist = nlist->next;
      n_ptr = nlist->name;
      n_ptr++; // Point past initial ' ' or '*'
      wc_ptr = wildcard_spec;
   }
   prt_list(&wc_dlg[W_X_LIST]);
   button_out(d, WHITE, MDGRAY);
   draw_item_number(wc_dlg, W_T_TTOT);
}

/*
 * Select Alternate Tagged List Feel Functions */
void feel_alt_excl_cancel(Dialog *d, int mouse)
{
   if (mouse)
      if (! press_button(d))
         return;
   dialog_done = 1;
   dialog_cancel = 1;
}

void feel_alt_excl_ok(Dialog *d, int mouse)
{
   if (mouse)
      if (! press_button(d))
         return;
   if (! alt_excl_taglist.tagged) {
        dialog_done = 1;
        dialog_cancel = 1;
   }
   else {
      dialog_done = 1;
      dialog_cancel = 0;
   }
}

void feel_alt_excl_help(Dialog *d, int mouse)
{
   int b, x;

   b = 0;
   if (mouse)
      if (! press_button(d))
         return;
   gfx_alert(b, "[Choose the Help Topic][Choose Objects|Quick Find|Wildcards|Continue]", x);
   switch(x) { 
      case 0: // General
         gfx_alert(b, 
"[The Additional Objs to Exclude dialog allows you to select|\
the group of objects which will be added to each tagged lights|\
exclusion list.  The remainder of the list remains unchanged.]\
[Continue]", x);
         break;
      case 1: // Quick Find
         gfx_alert(b, 
"[The Quick Find function (~) allows you to select an item in the|\
scroll list by typing characters which uniquely identify the name.|\
The name choosen is the first one which matches the entire sequence|\
entered.  Press the Spacebar or Enter to Tag or Untag your|\
selection, or press the ESC key to quit quick find.]\
[Continue]", x);
         break;
      case 2: // Wildcards
         gfx_alert(b, 
"[The Tag/Untag buttons operate on the wild card pattern entered|\
in the field above the buttons.  The * character matches all|\
characters to the end of the string.  The ? character matches|\
any single character.]\
[Continue]", x);
         break;
      default: // Continue
         break;
   };
}

void feel_alt_excl_list(Dialog *d, int mouse)
{
   Name_list *nlist;

   if ((nlist = which_sel(d)) != NULL) {
      if (nlist->name[0] == ' ') {
         nlist->name[0] = '*';
         alt_excl_taglist.tagged += 1;
      }
      else {
         nlist->name[0] = ' ';
         alt_excl_taglist.tagged -= 1;
      }
      prt_list(&wc_dlg[W_X_LIST]);
      draw_item_number(wc_dlg, W_T_TTOT);
   }
}

void feel_alt_excl_qscroll(Dialog *d, int mouse)
{
   int i, l, again, key, index, prev_index, tag_flag;
   float scroll_inc;
   char charlist[12];
   Name_list *nlist;

   gfx_kstate(key);
   if (mouse && (key & 0x0008)) { // If Alt key is press - offer help
       gfx_continu_2line("Type characters to uniquely identify an item in the list.",
                         "Press Space to Tag/Untag or press ESC to cancel");
   }
   else {
     /*
      * Scroll the list box to the first entry which matches what the user
      * types in here */
      gfx_prompt("Type Unique letters of the name to find. Space=Tag/Untag or ESC=Cancel");
      strcpy(wc_dlg[W_T_QSCROLL].text, "----------");
      button_in(&wc_dlg[W_T_QSCROLL], WHITE, CYAN);
      again = TRUE; index = -1; l = 0; prev_index = -1; tag_flag = FALSE;
      while (again) {
         gfx_key_wait(key);
         if (key == ESC) {
            again = FALSE; tag_flag = FALSE;
         }
         else if ((key == SPACE) || (key == CARRIAGERETURN)) {
            again = FALSE; 
            if (index != -1)
               tag_flag = TRUE;
         }
         else if (l < 10) { 
            charlist[l++] = (char) key;
            charlist[l] = '\0';
            prev_index = index;
            index = search_namelist(charlist, index, select_list, qscroll);
            if (index != -1) {
              /*
               * Show the temporarily selected name */
               strcpy(wc_dlg[W_T_QSCROLL].text, &qscroll[1]);
               button_in(&wc_dlg[W_T_QSCROLL], WHITE, CYAN);
               update_scroll_box(index, &wc_scroller, wc_dlg, 
                  W_X_LIST, W_X_SCSL);
            }
            else { // Key not in list, skip it
               index = prev_index;
               if (l) l--; 
            }
         }
      }
      if (tag_flag) {
         nlist = lt_opts.alt_excl_list;
         for (i = 0; i < index; i++) {
            nlist = nlist->next;
         }
         strcpy(qscroll, nlist->name);
         if (qscroll[0] == '*') {
            alt_excl_taglist.tagged--;
            nlist->name[0] = ' ';
            draw_item_number(wc_dlg, W_T_TTOT);
         }
         else {
            alt_excl_taglist.tagged++;
            nlist->name[0] = '*';
            if (index != -1)
               update_scroll_box(index, &wc_scroller, wc_dlg, 
                  W_X_LIST, W_X_SCSL);
            draw_item_number(wc_dlg, W_T_TTOT);
         }
      }
     /*
      * Erase the selected name from the Quick find box */
      draw_inbox(&wc_dlg[W_T_QSCROLL], CYAN);
      draw_inbox(&wc_dlg[W_X_LIST], CYAN);
      prt_list(&wc_dlg[W_X_LIST]);
   }
}

void feel_alt_excl_all(Dialog *d, int mouse)
{
   Name_list *nlist;
   if (mouse)
      if (! press_button(d))
         return;
   nlist = lt_opts.alt_excl_list;
   while(nlist) {
      nlist->name[0] = '*';
      nlist = nlist->next;
   }
   prt_list(&wc_dlg[W_X_LIST]);
   alt_excl_taglist.tagged = alt_excl_taglist.length;
   draw_item_number(wc_dlg, W_T_TTOT);
}

void feel_alt_excl_none(Dialog *d, int mouse)
{
   Name_list *nlist;
   if (mouse)
      if (! press_button(d))
         return;
   nlist = lt_opts.alt_excl_list;
   while(nlist) {
      nlist->name[0] = ' ';
      nlist = nlist->next;
   }
   prt_list(&wc_dlg[W_X_LIST]);
   alt_excl_taglist.tagged = 0;
   draw_item_number(wc_dlg, W_T_TTOT);
}

void feel_alt_excl_invert(Dialog *d, int mouse)
{
   Name_list *nlist;
   if (mouse)
      if (! press_button(d))
         return;
   nlist = lt_opts.alt_excl_list;
   while(nlist) {
      if (nlist->name[0] == '*')
         nlist->name[0] = ' ';
      else
         nlist->name[0] = '*';
      nlist = nlist->next;
   }
   prt_list(&wc_dlg[W_X_LIST]);
   alt_excl_taglist.tagged = alt_excl_taglist.length-alt_excl_taglist.tagged;
   draw_item_number(wc_dlg, W_T_TTOT);
}

void feel_alt_excl_tag(Dialog *d, int mouse)
{
   int match, found_offset;
   char *wc_ptr, *n_ptr, next_wc_char;
   Name_list *nlist;

   nlist = lt_opts.alt_excl_list;
   wc_ptr = wildcard_spec;
   n_ptr = nlist->name;
   n_ptr++; // Point past initial ' ' or '*' tag indicator
   match = TRUE; // Innocent until proven guilty
  /* 
   * Loop thru all the names in the 'lt_opts.alt_excl_list' */
   while (nlist) {

      next_wc_check:
      while (*wc_ptr) {
         if (*n_ptr) {
            if (*wc_ptr == '?') {
               wc_ptr++; 
               n_ptr++;
               goto next_wc_check;
            }
            else if (*wc_ptr == '*') {
               goto match;
            }
            else { // Any other character
               if (*wc_ptr != *n_ptr) {
                  goto next_name; // Not a match
               }
               else { // Okay so far, check next characters
                  n_ptr++;
                  wc_ptr++;
               }
            }
         }
         else { // End of name
            // If any non ? or * chars exist in the rest of the
            // wildcard spec, this is not a match, otherwise it is
            if (check_for_non_wc_chars(wc_ptr)) {
               goto next_name;
            }
            wc_ptr++;
         }
      }

      if ((*wc_ptr == 0) && (*n_ptr != 0)) {
         match = FALSE; // Name exceeds pattern spec (wc didn't end on ? or *)
      }
      match:
      if (match) { // This is a match, tag it
         if (nlist->name[0] != '*') {
            alt_excl_taglist.tagged++;
            nlist->name[0] = '*'; // Indicates its taggeds
         }
      }

      next_name:
      nlist = nlist->next;
      n_ptr = nlist->name;
      n_ptr++; // Point past initial ' ' or '*'
      wc_ptr = wildcard_spec;
   }
   prt_list(&wc_dlg[W_X_LIST]);
   button_out(d, WHITE, MDGRAY);
   draw_item_number(wc_dlg, W_T_TTOT);
}

void feel_alt_excl_untag(Dialog *d, int mouse)
{
   int match, found_offset;
   char *wc_ptr, *n_ptr, next_wc_char;
   Name_list *nlist;

   nlist = lt_opts.alt_excl_list;
   wc_ptr = wildcard_spec;
   n_ptr = nlist->name;
   n_ptr++; // Point past initial ' ' or '*' tag indicator
   match = TRUE; // Innocent until proven guilty
  /* 
   * Loop thru all the names in the 'lt_opts.alt_excl_list' */
   while (nlist) {

      next_wc_check:
      while (*wc_ptr) {
         if (*n_ptr) {
            if (*wc_ptr == '?') {
               wc_ptr++; 
               n_ptr++;
               goto next_wc_check;
            }
            else if (*wc_ptr == '*') {
               goto match;
            }
            else { // Any other character
               if (*wc_ptr != *n_ptr) {
                  goto next_name; // Not a match
               }
               else { // Okay so far, check next characters
                  n_ptr++;
                  wc_ptr++;
               }
            }
         }
         else { // End of name
            // If any non ? or * chars exist in the rest of the
            // wildcard spec, this is not a match, otherwise it is
            if (check_for_non_wc_chars(wc_ptr)) {
               goto next_name;
            }
            wc_ptr++;
         }
      }

      if ((*wc_ptr == 0) && (*n_ptr != 0)) {
         match = FALSE; // Name exceeds pattern spec (wc didn't end on ? or *)
      }
      match:
      if (match) { // This is a match, untag it
         if (nlist->name[0] != ' ') {
            alt_excl_taglist.tagged--;
            nlist->name[0] = ' '; // Indicates its un-tagged
         }
      }

      next_name:
      nlist = nlist->next;
      n_ptr = nlist->name;
      n_ptr++; // Point past initial ' ' or '*'
      wc_ptr = wildcard_spec;
   }
   prt_list(&wc_dlg[W_X_LIST]);
   button_out(d, WHITE, MDGRAY);
   draw_item_number(wc_dlg, W_T_TTOT);
}

/*
 * Omni/Spot (lt) Feel Functions */
void feel_lt_cancel(Dialog *d, int mouse)
{
   if (mouse)
      if (! press_button(d))
         return;
   dialog_done = 1;
   dialog_cancel = 1;
}

void feel_lt_ok(Dialog *d, int mouse)
{
   if (mouse)
      if (! press_button(d))
         return;
   dialog_done = 1;
   dialog_cancel = 0;
}

void feel_lt_all(Dialog *d, int mouse)
{
   if (mouse)
      if (! press_button(d))
         return;
  /*
   * Currently I tag all but the Source Pt and Target Pt */
   lt_opts.on = 1; lt_opts.color = 1; lt_opts.mult = 1; lt_opts.excl = 1; 
   lt_opts.atten_range = 1; lt_opts.source = 0; lt_opts.shadow = 1; 
   lt_opts.shape = 1; lt_opts.ov = 1; lt_opts.proj = 1; lt_opts.target = 0;
   lt_opts.cone = 1; lt_opts.bank = 1; lt_opts.shape = 1;
   if (lt_opts.spot_flag)
      draw_dialog(spot_dlg);
   else
      draw_dialog(omni_dlg);
}

void feel_lt_none(Dialog *d, int mouse)
{
   if (mouse)
      if (! press_button(d))
         return;
   lt_opts.on = 0; lt_opts.color = 0; lt_opts.mult = 0; lt_opts.excl = 0; 
   lt_opts.atten_range = 0; lt_opts.source = 0; lt_opts.shadow = 0; 
   lt_opts.shape = 0; lt_opts.ov = 0; lt_opts.proj = 0; lt_opts.target = 0;
   lt_opts.cone = 0; lt_opts.bank = 0; lt_opts.shape = 0;
   if (lt_opts.spot_flag)
      draw_dialog(spot_dlg);
   else
      draw_dialog(omni_dlg);
}

void feel_lt_proj(Dialog *d, int mouse)
{
   int key;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         gfx_continu_2line("Copy the Projector status of the Prototype",
                           "(On-Off/Projector Image File)");
      }
      else if (press_button(d)) {
         if (lt_opts.proj) {
            button_out(d, WHITE, MDGRAY);
            lt_opts.proj = 0;
         }
         else {
            button_out(d, WHITE, RED);
            lt_opts.proj = 1;
         }
      }
   }
}

void feel_lt_on(Dialog *d, int mouse)
{
   int key;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         gfx_continu_line("Copy the On/Off state of the Prototype");
      }
      else if (press_button(d)) {
         if (lt_opts.on) {
            button_out(d, WHITE, MDGRAY);
            lt_opts.on = 0;
         }
         else {
            button_out(d, WHITE, RED);
            lt_opts.on = 1;
         }
      }
   }
}

void feel_lt_color(Dialog *d, int mouse)
{
   int key;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         gfx_continu_2line("Copy the Color of the Prototype",
                           "(Color Sliders)");
      }
      else if (press_button(d)) {
         if (lt_opts.color) {
            button_out(d, WHITE, MDGRAY);
            lt_opts.color = 0;
         }
         else {
            button_out(d, WHITE, RED);
            lt_opts.color = 1;
         }
      }
   }
}

void feel_lt_mult(Dialog *d, int mouse)
{
   int key;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         gfx_continu_line("Copy the Multiplier of the Prototype");
      }
      else if (press_button(d)) {
         if (lt_opts.mult) {
            button_out(d, WHITE, MDGRAY);
            lt_opts.mult = 0;
         }
         else {
            button_out(d, WHITE, RED);
            lt_opts.mult = 1;
         }
      }
   }
}

void feel_lt_excl(Dialog *d, int mouse)
{
   int key, b, x;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         b = 0;
         gfx_alert(b, 
"[Copy the Object Exclusion List of the Prototype.  Or if this|\
button is selected with the Ctrl key, you will be presented with|\
the Additional Objects to Exclude dialog.  From the list, choose|\
any objects you want to add to each lights existing exclusion list.]\
[Continue]", x);
      }
      else if (key & 0x0004) { // If Ctrl key is pressed - Object list...
         do_alt_excl_interaction();
         if (! dialog_cancel) {
            lt_opts.use_alt_excl_list = TRUE;
            lt_opts.excl = 1;
            dialog_done = 0;
            button_out(d, WHITE, RED);
         }
         else {
            lt_opts.use_alt_excl_list = FALSE;
            dialog_done = 0;
         }
      }
      else if (press_button(d)) {
         lt_opts.use_alt_excl_list = FALSE;
         if (lt_opts.excl) {
            button_out(d, WHITE, MDGRAY);
            lt_opts.excl = 0;
         }
         else {
            button_out(d, WHITE, RED);
            lt_opts.excl = 1;
         }
      }
   }
}

void feel_lt_range(Dialog *d, int mouse)
{
   int key;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         gfx_continu_line("Copy the Attenuation and Range settings from the Prototype");
      }
      else if (press_button(d)) {
         if (lt_opts.atten_range) {
            button_out(d, WHITE, MDGRAY);
            lt_opts.atten_range = 0;
         }
         else {
            button_out(d, WHITE, RED);
            lt_opts.atten_range = 1;
         }
      }
   }
}

void feel_lt_shadow(Dialog *d, int mouse)
{
   int key;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         gfx_continu_2line("Copy the Shadow Settings from the Prototype",
                           "(Cast Shadow/Map-Raytr state/Bias/Map size/Sample Range)");
      }
      else if (press_button(d)) {
         if (lt_opts.shadow) {
            button_out(d, WHITE, MDGRAY);
            lt_opts.shadow = 0;
         }
         else {
            button_out(d, WHITE, RED);
            lt_opts.shadow = 1;
         }
      }
   }
}

void feel_lt_ov(Dialog *d, int mouse)
{
   int key;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         gfx_continu_line("Copy the Overshoot On/Off state from the Prototype");
      }
      else if (press_button(d)) {
         if (lt_opts.ov) {
            button_out(d, WHITE, MDGRAY);
            lt_opts.ov = 0;
         }
         else {
            button_out(d, WHITE, RED);
            lt_opts.ov = 1;
         }
      }
   }
}

void feel_lt_cone(Dialog *d, int mouse)
{
   int key;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         gfx_continu_2line("Copy the cone visibility and angles from the Prototype",
                           "(Show Cone/Hotspot/Falloff)");
      }
      else if (press_button(d)) {
         if (lt_opts.cone) {
            button_out(d, WHITE, MDGRAY);
            lt_opts.cone = 0;
         }
         else {
            button_out(d, WHITE, RED);
            lt_opts.cone = 1;
         }
      }
   }
}

void feel_lt_bank(Dialog *d, int mouse)
{
   int key;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         gfx_continu_line("Copy the Roll and Aspect Ratio from the Prototype");
      }
      else if (press_button(d)) {
         if (lt_opts.bank) {
            button_out(d, WHITE, MDGRAY);
            lt_opts.bank = 0;
         }
         else {
            button_out(d, WHITE, RED);
            lt_opts.bank = 1;
         }
      }
   }
}

void feel_lt_shape(Dialog *d, int mouse)
{
   int key;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         gfx_continu_2line("Copy the Shape of the hotspot and falloff areas",
                           "(Rectangle/Circle)");
      }
      else if (press_button(d)) {
         if (lt_opts.shape) {
            button_out(d, WHITE, MDGRAY);
            lt_opts.shape = 0;
         }
         else {
            button_out(d, WHITE, RED);
            lt_opts.shape = 1;
         }
      }
   }
}

void feel_lt_source(Dialog *d, int mouse)
{
   int key, yn;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         gfx_continu_2line("Copy the Location in space of the Prototype",
                           "(X/Y/Z coordinates)");
      }
      else if (press_button(d)) {
         if (lt_opts.source) {
            button_out(d, WHITE, MDGRAY);
            lt_opts.source = 0;
         }
         else {
            gfx_yes_no_line("Really move all Lights Sources to same Location?", yn);
            if (yn) {
               button_out(d, WHITE, RED);
               lt_opts.source = 1;
            }
         }
      }
   }
}

void feel_lt_target(Dialog *d, int mouse)
{
   int key, yn;

   if (mouse) {
      gfx_kstate(key);
      if (key & 0x0008) { // If Alt key is press - offer help
         gfx_continu_2line("Copy the Location in space of the spotlight Target",
                           "(X/Y/Z coordinates of Target)");
      }
      else if (press_button(d)) {
         if (lt_opts.target) {
            button_out(d, WHITE, MDGRAY);
            lt_opts.target = 0;
         }
         else {
            gfx_yes_no_line("Really move all Spotlight Targets to same Location?", yn);
            if (yn) {
               button_out(d, WHITE, RED);
               lt_opts.target = 1;
            }
         }
      }
   }
}

/*
 * Array (array) Feel Functions */
void feel_array_ok(Dialog *d, int mouse)
{
   if (mouse)
      if (! press_button(d))
         return;
  /*
   * User has selected OK, make sure all the data entered is valid before
   * leaving the dialog box */
   validate_array_data(); // This function will set dialog_done=1 if okay
}

void feel_array_cancel(Dialog *d, int mouse)
{
   if (mouse)
      if (! press_button(d))
         return;
   dialog_done = 1;
   dialog_cancel = 1;
}

void feel_array_rotspot(Dialog *d, int mouse)
{
   if (mouse)
      if (! press_button(d))
         return;
   if (lt_opts.rot_spot_flag) {
      button_out(d, WHITE, MDGRAY);
      lt_opts.rot_spot_flag = 0;
   }
   else {
      button_out(d, WHITE, RED);
      lt_opts.rot_spot_flag = 1;
   }
}

/*===========================================================================
 |  S e e   F u n c t i o n s
 *=========================================================================*/
/*
 * Main See Functions */
/*
 * Select Light (Prototype) See Functions */
void see_sel_lt_frame(Dialog *d, int mouse)
{
   out_frame(d);
}

void see_sel_lt_fillin(Dialog *d, int mouse)
{
   draw_outbox(d, MDGRAY);
   centered_text(d, WHITE, MDGRAY, 0);
}

void see_sel_lt_help(Dialog *d, int mouse)
{
   button_out(d, WHITE, MDGRAY);
}

/*
 * Select Tagged List (wc) See Functions */
void see_wc_help(Dialog *d, int mouse)
{
   button_out(d, WHITE, MDGRAY);
}

/*
 * Omni/Spot (lt) See Functions */
void see_lt_ok(Dialog *d, int mouse)
{
   draw_outbox(d, 5);
}

void see_lt_proj(Dialog *d, int mouse)
{
   if (lt_opts.proj) {
      button_out(d, WHITE, RED);
   }
   else {
      button_out(d, WHITE, MDGRAY);
   }
}

void see_lt_on(Dialog *d, int mouse)
{
   if (lt_opts.on) {
      button_out(d, WHITE, RED);
   }
   else {
      button_out(d, WHITE, MDGRAY);
   }
}

void see_lt_color(Dialog *d, int mouse)
{
   if (lt_opts.color) {
      button_out(d, WHITE, RED);
   }
   else {
      button_out(d, WHITE, MDGRAY);
   }
}

void see_lt_mult(Dialog *d, int mouse)
{
   if (lt_opts.mult) {
      button_out(d, WHITE, RED);
   }
   else {
      button_out(d, WHITE, MDGRAY);
   }
}

void see_lt_excl(Dialog *d, int mouse)
{
   if (lt_opts.excl) {
      button_out(d, WHITE, RED);
   }
   else {
      button_out(d, WHITE, MDGRAY);
   }
}

void see_lt_range(Dialog *d, int mouse)
{
   if (lt_opts.atten_range) {
      button_out(d, WHITE, RED);
   }
   else {
      button_out(d, WHITE, MDGRAY);
   }
}

void see_lt_source(Dialog *d, int mouse)
{
   if (lt_opts.source) {
      button_out(d, WHITE, RED);
   }
   else {
      button_out(d, WHITE, MDGRAY);
   }
}

void see_lt_shadow(Dialog *d, int mouse)
{
   if (lt_opts.shadow) {
      button_out(d, WHITE, RED);
   }
   else {
      button_out(d, WHITE, MDGRAY);
   }
}

void see_lt_rect(Dialog *d, int mouse)
{
   if (lt_opts.shape) {
      button_out(d, WHITE, RED);
   }
   else {
      button_out(d, WHITE, MDGRAY);
   }
}

void see_lt_ov(Dialog *d, int mouse)
{
   if (lt_opts.ov) {
      button_out(d, WHITE, RED);
   }
   else {
      button_out(d, WHITE, MDGRAY);
   }
}

void see_lt_target(Dialog *d, int mouse)
{
   if (lt_opts.target) {
      button_out(d, WHITE, RED);
   }
   else {
      button_out(d, WHITE, MDGRAY);
   }
}

void see_lt_cone(Dialog *d, int mouse)
{
   if (lt_opts.cone) {
      button_out(d, WHITE, RED);
   }
   else {
      button_out(d, WHITE, MDGRAY);
   }
}

void see_lt_bank(Dialog *d, int mouse)
{
   if (lt_opts.bank) {
      button_out(d, WHITE, RED);
   }
   else {
      button_out(d, WHITE, MDGRAY);
   }
}

void see_lt_shape(Dialog *d, int mouse)
{
   if (lt_opts.shape) {
      button_out(d, WHITE, RED);
   }
   else {
      button_out(d, WHITE, MDGRAY);
   }
}

/*
 * Tagged List See Functions */
void see_wc_all(Dialog *d, int mouse)
{
   button_out(d, WHITE, MDGRAY);
}

void see_wc_none(Dialog *d, int mouse)
{
   button_out(d, WHITE, MDGRAY);
}

void see_wc_tag(Dialog *d, int mouse)
{
   button_out(d, WHITE, MDGRAY);
}

void see_wc_untag(Dialog *d, int mouse)
{
   button_out(d, WHITE, MDGRAY);
}

void see_wc_invert(Dialog *d, int mouse)
{
   button_out(d, WHITE, MDGRAY);
}

void see_wc_total(Dialog *d, int mouse)
{
   sprintf(wc_dlg[W_T_TOT].text, "Total:  %3d", taglist.length);
   centered_text(d, WHITE, DKGRAY, 1);
}

void see_wc_tagtotal(Dialog *d, int mouse)
{
   sprintf(wc_dlg[W_T_TTOT].text, "Tagged: %3d", taglist.tagged);
   centered_text(d, WHITE, DKGRAY, 1);
}

/*
 * Alternate Exclude taglist functions */
void see_alt_excl_total(Dialog *d, int mouse)
{
   sprintf(wc_dlg[W_T_TOT].text, "Total:  %3d", alt_excl_taglist.length);
   centered_text(d, WHITE, DKGRAY, 1);
}

void see_alt_excl_tagtotal(Dialog *d, int mouse)
{
   sprintf(wc_dlg[W_T_TTOT].text, "Tagged: %3d", alt_excl_taglist.tagged);
   centered_text(d, WHITE, DKGRAY, 1);
}

/*
 * Array See Functions */
/*
 * Misc See Functions */
void see_title_frame(Dialog *d, int mouse)
{
//   draw_outbox(d, BLUE);
   draw_outbox(d, DKGRAY);
}

void see_title_text(Dialog *d, int mouse)
{
//   centered_text(d, YELLOW, BLUE, 1);
   centered_text(d, WHITE, DKGRAY, 1);
}

void see_frame(Dialog *d, int mouse)
{
   out_frame(d);
}

void see_qscroll(Dialog *d, int mouse)
{
   draw_inbox(d, CYAN);
}

void see_list(Dialog *d, int mouse)
{
   draw_inbox(d, CYAN);
   prt_list(d);
}

/*===========================================================================
 | Function: search_namelist
 |  Purpose: This function searches the Name_list passed for the first 
 |           occurance of a name which contains the entire charlist
 |           passed.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
int search_namelist(char *charlist, int index, Name_list *slist, char *s)
{

   int i, nlindex, chindex, okay, prev_index, new_offset;
   Name_list *nlist;

  /*
   * Skip the parts of the list before 'index' */
   nlist = slist;
   for (i = 0; i < index; i++)
      nlist = nlist->next;
   nlindex = (index == -1) ? 0 : index; 
   chindex = 0; prev_index = 0; okay = FALSE;
   while (nlist) {
      while (charlist[chindex]) {
         new_offset = findchar(&nlist->name[prev_index], charlist[chindex]);
         if (new_offset != -1) {
            if (new_offset)
               prev_index += new_offset+1;
            else 
               prev_index++;
            chindex++;
            okay = TRUE;
         }
         else {
            prev_index = 0;
            chindex = 0;
            nlist = nlist->next;
            nlindex++;
            okay = FALSE;
            break;
         }
      }
      if (okay) {
         strcpy(s, nlist->name);
         return(nlindex);
      }
   }
  /*
   * All names exhausted */
   return(-1);
}

/*===========================================================================
 | Function: findchar
 |  Purpose: This function returns the index of character ch in string s
 |           or -1 if the char is not found.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
int findchar(char *s, char ch)
{
   int i;
   i = 0;
   while (*s) {
      if (*s++ == ch) return(i);
      i++;
   }
   return(-1);
}

/*===========================================================================
 | Function: update_scroll_box
 |  Purpose: This function is called by the Quick Find function to scroll
 |           the list box to show the item whose index is passed.  The list
 |           will not be scrolled, if the index item is already visible.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
update_scroll_box(int index, Scroller *scroller, Dialog *dlg, 
   int list_num, int scr_num)
{
   int scrolls_reqd, top;
   float scroll_inc;

   if ((scroller->top_name > index) || 
      (index >= scroller->top_name+scroller->ycount)) {
     /*
      * Gotta scroll, update the scroller position based on the index */
      top = (index > (scroller->name_count-scroller->ycount)) ?
         (scroller->name_count-scroller->ycount) : index;
      scroller->top_name = top; 
      scrolls_reqd = scroller->name_count-scroller->ycount;
      scroll_inc = (float) (((dlg[scr_num].height)-(scroller->knob_height))/
         ((float) scrolls_reqd));
      scroller->yoff = (int) ((((float) scroller->top_name)*scroll_inc)+0.5);
      if (scroller->yoff == 0) 
         scroller->yoff = 1;
      draw_inbox(&dlg[list_num], CYAN);
      prt_list(&dlg[list_num]);
      see_scroll_slider(&dlg[scr_num]);
   }
}

/*===========================================================================
 | Function: mm_atof
 |  Purpose: To convert a series of character representing a distance 
 |           expressed in feet and inches and return a result as a decimal
 |           number of inches.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
void mm_atof(char *s, double *result, int *status, char *errmsg)
{
   int l, have_feet, have_inch;
   char output[128], *o;
   double value, sign, feet, inch, conv_factor;
  /*
   * Initialize */
   feet = inch = 0.0;
   *status = MM_STATUS_OKAY; /* Innocent until proven guilty */
  /*
   * Perform a valid character check */
   if (mm_valid_str(s, ".0123456789+-/'\"") == 0) {
      *result = 0.0;
      *status = MM_STATUS_ERROR;
      strcpy(errmsg, "Invalid character in string");
      return;
   }
  /*
   * Handle the sign if present */
   if (s[0] == MM_FRAC_DELIM) {
      sign = -1.0;
      s++;
   }
   else if (s[0] == '+') {
      sign = 1.0;
      s++;
   }
   else {
      sign = 1.0;
   }
  /*
   * Scan up to the feet sign */
   o = output;
   if (mm_instr(s, MM_FEET_SYM)) {
      while (*s != MM_FEET_SYM)
	 *o++ = *s++;
      *o = '\0';
      s++; // Point past the ' sign
      have_feet = 1;
     /*
      * Convert and store this portion */
      mm_process_chunk(output, &feet, status, errmsg);
      if (*status == MM_STATUS_ERROR) {
	 return;
      }
   }
  /*
   * Check if there is any more of the string to process */
   if (strlen(s)) {
     /*
      * Scan up to the inch sign or end */
      o = output;
      if (mm_instr(s, MM_INCH_SYM)) have_inch = 1;
      while ((*s != MM_INCH_SYM) && (*s != MM_STR_TERM))
	 *o++ = *s++;
      *o = MM_STR_TERM;
     /*
      * Convert and store this portion */
      mm_process_chunk(output, &inch, status, errmsg);
      if (*status == MM_STATUS_ERROR) {
	 return;
      }
   }
  /*
   * If the number was entered as feet and inches, convert it if we
   * are in metric */
   if (have_feet || have_inch) {
      switch(master_type) {
         case 1: // '
            conv_factor = (1.0/12.0)*master_scale;
            break;
         case 2: // CM
            conv_factor = 2.54*master_scale;
            break;
         case 3: // M
            conv_factor = 0.0254*master_scale;
            break;
         default: // "
            conv_factor = 1.0*master_scale;
            break;
      }
   }
   else {
      conv_factor = 1.0;
   }
  /*
   * Compute and return the result */
   *status = MM_STATUS_OKAY;
   *result = (sign*(feet*12.0+inch))*conv_factor;
}

/*===========================================================================
 | Function: mm_process_chunk
 | Purpose:  To process the portion of the string passed (which was
 |           up to the feet or inches sign).  This function will break the
 |           string down further into numerator and denominator.
 |  History: Mark Meier, 03/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
void mm_process_chunk(char *s, double *result, int *status, char *errmsg)
{
   double value, whole, frac, num, den;
   char output[128], *o;
  /*
   * Initialize */
   whole = num = frac = 0.0; den = 1.0;
  /*
   * If this is a zero length string, return a value of 0.0 */
   if (strlen(s) == 0) {
      *result = 0.0;
      *status = MM_STATUS_OKAY;
      return;
   }
  /*
   * Determine if there is a whole number */
   if ((mm_instr(s, MM_FRAC_DELIM)  && mm_instr(s, MM_FRAC_SYM)) ||
       (mm_instr(s, MM_FRAC_SYM) == 0)) {
     /*
      * Process the whole number */
      o = output;
      while ((*s != MM_FRAC_DELIM) && (*s != MM_STR_TERM))
	 *o++ = *s++;
      *o = MM_STR_TERM;
      if (strlen(s))
	 s++; // Skip the delimeter
      whole = mm_convert_str(output); // Convert whole number portion
   }
  /*
   * Process any fraction */
   if (strlen(s)) {
      if ((mm_instr(s, MM_FRAC_SYM))) {
	 o = output;
	 while (*s != MM_FRAC_SYM)
	    *o++ = *s++;
	 *o = MM_STR_TERM;
	 s++; // Skip / sign
	 num = mm_convert_str(output); // Convert numerator
	 if (num == 0.0) {
	    strcpy(errmsg, "Fraction specified w/o a numerator");
	    *status = MM_STATUS_ERROR;
	    return;
	 }
	 o = output;
	 while (*s) // Put the remainder of the string in the denominator
	    *o++ = *s++;
	 *o = MM_STR_TERM;
	 if (strlen(output)) {
	    den = mm_convert_str(output); // Convert denominator
	    if (den != 0.0) {
	       frac = num/den;
	       *result = whole+frac;
	       *status = MM_STATUS_OKAY;
	       return; // Done, and all is well :)
	    }
	    else {
	       strcpy(errmsg, "Zero denominator in fraction");
	       *status = MM_STATUS_ERROR;
	       return;
	    }
	 }
	 else {
	    strcpy(errmsg, "Fraction specified w/o a denominator");
	    *status = MM_STATUS_ERROR;
	    return;
	 }
      }
      else {
	 strcpy(errmsg, "Fractional seperator specified w/o '/' delimiter");
	 *status = MM_STATUS_ERROR;
	 return;
      }
   }
   *result = whole;
   *status = MM_STATUS_OKAY;
}

/*===========================================================================
 | Function: mm_convert_str
 |  Purpose: The final step, convert a simple ASCII string to a double.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
double mm_convert_str(char *s)
{
   double value;
   sscanf(s, "%lf", &value);
   return (value);
}

/*===========================================================================
 | Function: mm_instr
 |  Purpose: To check if the character ch is contained in the string 's'.
 |           If so, 1 is returned, 0 otherwise.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
int mm_instr(char *s, char ch)
{
   int i;
   while (*s)
      if (*s++ == ch) return(1);
   return(0);
}

/*===========================================================================
 | Function: mm_valid_str
 |  Purpose: To verify if every character in 's' is in the list 'valid'.
 |           If so, 1 is returned, 0 otherwise.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
int mm_valid_str(char *s, char *valid)
{
   while (*s) {
      if (mm_instr(valid, s[0]) == 0) return(0);
      s++;
   }
   return(1);
}

/*===========================================================================
 | Function: pxp_get_light_index
 |  Purpose: This function searches the entire 3ds database for the index
 |           of the light whose name is passed.  If the index is not found
 |           0 is stored into index.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
void pxp_get_light_index(char *objname, int *index)
{
   ItemData itemdata;
   int i, status, icount;

   pxp_get_item_count(icount);
   for(i = 1; i < icount; i++) {
      pxp_get_item(i, &itemdata, status);
      if(status && itemdata.type == PXPLIGHT) {
         if(! (strcmp(objname, itemdata.name))) {
            *index = i;
            return;
         }
      }
   }
   *index = 0;
}

/*===========================================================================
 | Function: check_for_non_wc_chars
 |  Purpose: Returns TRUE if a character other than ? or * is contained in 
 |           the string passed.
 |  History: Mark Meier, 04/94, Wrote and documented routine.
 |  Remarks: None.
 *=========================================================================*/
check_for_non_wc_chars(char *s)
{
   while (*s) {
      if (! ((*s == '?') || (*s == '*'))) {
         return(TRUE); // A Non-wildcard char was found
      }
      else {
         s++;
      }
   }
   return(FALSE); // No Non-wildcard chars found
}

/* Shadow parameter update patch by Tom Hudson */
/************************************************************************/
/************************************************************************/
/************************************************************************/

/*
        Register Structure
*/

#define ULONG unsigned long
#define USHORT unsigned short
typedef struct
{
    ULONG eax;
    ULONG ebx;
    ULONG ecx;
    ULONG edx;
    ULONG esi;
    ULONG edi;
    ULONG ebp;
    ULONG esp;
    USHORT cs;
    USHORT ds;
    USHORT es;
    USHORT fs;
    USHORT gs;
    USHORT ss;
    ULONG eip;
    ULONG eflags;
} REGS;

struct overlay { int offset; short seg; };

patch_light_shadow_flags()
{
short _far *flag1;
short _far *flag2;
short _far *flag3;
((struct overlay *)&flag1)->seg=((REGS _far *)GI->regs)->ds;
((struct overlay *)&flag1)->offset=0x13c091;
((struct overlay *)&flag2)->seg=((REGS _far *)GI->regs)->ds;
((struct overlay *)&flag2)->offset=0x13c476;
((struct overlay *)&flag3)->seg=((REGS _far *)GI->regs)->ds;
((struct overlay *)&flag3)->offset=0x13c7a5;
*flag1= *flag2= *flag3=
   (LIGHT_ON|LIGHT_SHAD|LIGHT_LOCAL|LIGHT_CONE|LIGHT_RECT|LIGHT_PROJ|LIGHT_OVER|LIGHT_ATTEN|LIGHT_RAYTR);
}

/************************************************************************/
/************************************************************************/
/************************************************************************/
