@echo off
rem Compiles example routine "light.pxp" using the C/C++32 optimizing compiler.

rem Uses one optional command parameter "debug" which sets the
rem environment variables to create a "debugging" executible

rem The "ipaswc95.bat" file should be customized to reflect the location
rem of the executibles.

IF EXIST light_I.PXP DEL light_I.PXP
IF EXIST ERR.TXT DEL ERR.TXT
call ..\..\ipaswc95.bat %1
if not %ipaserr%.==. goto error

:compile
echo Compiling light.obj
@echo on
wcc386p %cflags% /i=%watcom%\h /i=..\..\..\inc light.c /fo=light.obj >>err.txt
@if errorlevel 1 goto error
@echo off

rem If the main routine "pxp.obj" doesn't exist, compile it
if exist ..\pxp.obj goto link
echo Compiling pxp.obj
@echo on
wcc386p %cflags% /i=%watcom%\h /i=..\..\..\inc ..\pxp.c /fo=..\pxp.obj
@if errorlevel 1 goto error
@echo off

:link
if exist %linkcmd% goto dolink

echo Creating %linkcmd%
echo Option Maxdata=0 >%linkcmd%
echo Libpath %watcom%\lib386;%watcom%\lib386\dos >>%linkcmd%
echo Library %libname% >>%linkcmd%
echo Library clib3s.lib >>%linkcmd%
echo Library math387s.lib >>%linkcmd%
echo Format Pharlap >>%linkcmd%
echo Option Dosseg >>%linkcmd%

:dolink
echo Linking light.pxp
if %xpdebug%.==1. goto linkdbg
 @echo on
wlink FILE light.obj FILE ..\pxp.obj @%linkcmd% NAME light_i.pxp
@if errorlevel 1 goto error
@echo off

goto end

:linkdbg
@echo on
wlink Debug All FILE light.obj FILE ..\pxp.obj @%linkcmd% NAME light_i.pxp
@if errorlevel 1 goto error
@echo off
goto end
:error
@echo off
echo Error Abort
set ipaserr=1

:end 

IF EXIST light_I.PXP COPY light_I.PXP C:\3DS3\PROCESS

rem Clear out the environment settings
call ..\..\usetwc95.bat
echo off
