/********************************************************/
/* Compile whith large memory model on Borland C or C++ */
/* compiler and link with lsdemo.def and lsdemo.res     */
/********************************************************/

#define EXTERN exter
/* IMG_DEMO by Davor, AiM 1993 */

#include <windows.h>
#include <commdlg.h>
#include <string.h>
#include <stdio.h>
#include <io.h>

#include "SYSPIC.H"
#include "IMAGE_LS.H"
#include "IMAGE_EF.H"

#include "IMG_DEMO.H"

#define MAX_NUM_PIC                        20
/* Maximum number of opened windows is limited only with your system
   resources and free RAM */

PICTURE         DemoPic[MAX_NUM_PIC];
BOOL            fRemap=TRUE,fPaintEnd=TRUE;
LPFRAME AniFrames[MAX_NUM_PIC];
/* array AniFrames is used for loading FLI/FLC animation frames */
short   	nPicNum=0,  	// Number of opened pictures
		nActivePic=-1, // Number of active picture
		nAniFrames=0, iStartFrame, iEndFrame; // Variables used for FLI/FLC load

/* Folowing variables and strings are used for FileSelect common dialog */
OPENFILENAME ofn;
char    szFileTitle[256], szFile[256];
char    szFilterOpen[]="BMP (*.BMP)\0*.BMP\0GIF (*.GIF)\0*.GIF\0PCX (*.PCX)\0*.PCX\0Truevision TGA (*.TGA)\0*.TGA\0Color TIFF (*.TIF)\0*.TIF\0FLI (*.FLI)\0*.FLI\0FLC (*.FLC)\0*.FLC\0JPEG (*.JPG)\0*.JPG\0";
char    szFilterSave[]="BMP (*.BMP)\0*.BMP\0GIF (*.GIF)\0*.GIF\0PCX (*.PCX)\0*.PCX\0Truevision TGA (*.TGA)\0*.TGA\0Color TIFF (*.TIF)\0*.TIF\0FLI (*.FLI)\0*.FLI\0FLC (*.FLC)\0*.FLC\0JPEG (*.JPG)\0*.JPG\0";
char    *szFileExt[]={".XXX", ".BMP", ".GIF", ".PCX", ".TGA", ".TIF", ".FLI", ".FLC", ".JPG"};
char    szDirName[256];


int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
 /***********************************************************************/
 /* HANDLE hInstance;       handle for this instance                    */
 /* HANDLE hPrevInstance;   handle for possible previous instances      */
 /* LPSTR  lpszCmdLine;     long pointer to exec command line           */
 /* short    nCmdShow;        Show code for main window display         */
 /***********************************************************************/

 MSG        msg;           /* MSG structure to store your messages      */
 short        nRc;           /* return value from Register Classes        */
 DLGPROC    lpfnDlgProc;

 strcpy(szAppName, "ITDEMO");
 hInst = hInstance;
 if(!hPrevInstance)
   {
    /* register window classes if first instance of application         */
    if ((nRc = nCwRegisterClasses()) == -1)
      {
       /* registering one of the windows failed                         */       
       LoadString(hInst, IDS_ERR_REGISTER_CLASS, szString, sizeof(szString));
	  MessageBox(NULL, szString, NULL, MB_ICONEXCLAMATION);
       return nRc;    
	 }
   }

 LoadString(hInst, IDS_MAINWND_TITLE, szString, sizeof(szString));
 /* create application's Main window                                    */
 hWndMain = CreateWindow(
          szAppName,               /* Window class name           */
          szString, 			/* Window's title           */
          WS_CAPTION      |        /* Title and Min/Max           */
          WS_SYSMENU      |        /* Add system menu box         */
          WS_MINIMIZEBOX  |        /* Add minimize box            */
          WS_MAXIMIZEBOX  |        /* Add maximize box            */
          WS_THICKFRAME   |        /* thick sizeable frame        */
          WS_CLIPCHILDREN |         /* don't draw in child windows areas */
          WS_OVERLAPPED,
          CW_USEDEFAULT, 0,        /* Use default X, Y            */
          CW_USEDEFAULT, 0,        /* Use default X, Y            */
          NULL,                    /* Parent window's handle      */
          NULL,                    /* Default to Class Menu       */
          hInst,                   /* Instance of window          */
          NULL);                   /* Create struct for WM_CREATE */

 
 if(hWndMain == NULL)
   {
    LoadString(hInst, IDS_ERR_CREATE_WND, szString, sizeof(szString));
    MessageBox(NULL, szString, NULL, MB_ICONEXCLAMATION);
    return IDS_ERR_CREATE_WND;
   }

 ShowWindow(hWndMain, nCmdShow);            /* display main window      */

 hAccel = LoadAccelerators(hInst, szAppName);   /* load accelerators */
 hCursorNormal = LoadCursor(NULL, IDC_ARROW);   /* and two cursor types */
 hCursorBusy = LoadCursor(NULL, IDC_WAIT);
 hMenu=GetMenu(hWndMain);
 memset(&ofn, 0, sizeof(OPENFILENAME));         /* File ofn structure for
										 common dialog...*/
 ofn.lStructSize = sizeof(OPENFILENAME);
 ofn.hwndOwner = hWndMain;
 ofn.lpstrFile= szFile;
 ofn.nMaxFile = sizeof(szFile);
 ofn.lpstrFileTitle = szFileTitle;
 ofn.nMaxFileTitle = sizeof(szFileTitle);
 ofn.lpstrInitialDir = szDirName;

 CheckActiveWindow();					   /* Check menu visibility */

 while(GetMessage(&msg, NULL, 0, 0)) {       /* Until WM_QUIT message    */
          if(TranslateAccelerator(hWndMain, hAccel, &msg))
               continue;
          TranslateMessage(&msg);
          DispatchMessage(&msg);
     }

 /* Do clean up before exiting from the application                     */
 CwUnRegisterClasses();
 return msg.wParam;
} /*  End of WinMain                                                    */

/************************************************************************/
/*                                                                      */
/* Main Window Procedure                                                */
/*                                                                      */
/* This procedure provides service routines for the Windows events      */
/* (messages) that Windows sends to the window, as well as the user     */
/* initiated events (messages) that are generated when the user selects */
/* the action bar and pulldown menu controls or the corresponding       */
/* keyboard accelerators.                                               */
/*                                                                      */
/************************************************************************/

LONG FAR PASCAL WndProc(HWND hWnd, WORD Message, WORD wParam, LONG lParam)
{
 HDC            hDC;                /* handle for the display device       */
 PAINTSTRUCT    ps;                /* holds PAINT information             */
 FARPROC        lpfnDlgProc;
 LPHBYTE        lpNewPic;
 HANDLE         hNewPic;
 RECT		 Rect;
 FRAME		 Frame;
 short          ret;

 switch (Message)
   {
    case WM_COMMAND:
      /* The Windows messages for action bar and pulldown menu items */
      /* are processed here.                                         */
         hCursorNormal=SetCursor(hCursorBusy); // Show busy cursor
         /* fill temporary frame structure with active frame data */
	    memcpy(&Frame, &DemoPic[nActivePic].Frame, sizeof(FRAME));
         switch (wParam)
         {
            case IDM_CLOSE:
               SendMessage(hActive, WM_SYSCOMMAND, IDM_CLOSE, 0L);
          	break;
            case IDM_F_OPENPICTURE:
               LoadSaveData(1);
               CheckActiveWindow();
               break;

         	  case IDM_F_SAVEPICTURE:
            	LoadSaveData(3);
            break; 

            case IDM_F_EXIT:
          SendMessage(hWndMain,WM_CLOSE,0,0L);
            break; 
		  /* Effect demo routines */
		  /* In every effect-function call second line consists of
            	variable parameters */
		  case IDM_E_BLURE:
			if(AllocFrame(Frame))
				ret=EffBlure(&(DemoPic[nActivePic].Frame), &Frame,
                         10);        // Blure value = 10
			goto EFFECT_EXIT;
            case IDM_E_BRIGHTNESSU:
			if(AllocFrame(Frame))
				ret=EffBrightness(&(DemoPic[nActivePic].Frame), &Frame,
					40);        // Brighten amount = 40
               goto EFFECT_EXIT;
            case IDM_E_BRIGHTNESSD:
			if(AllocFrame(Frame))
				ret=EffBrightness(&(DemoPic[nActivePic].Frame), &Frame,
					-40);       // Darken amount = 40
               goto EFFECT_EXIT;
            case IDM_E_CONTRASTU:
			if(AllocFrame(Frame))
				ret=EffContrast(&(DemoPic[nActivePic].Frame), &Frame,
					300);       // Contrast is modified to 300% of previous amount
               goto EFFECT_EXIT;
            case IDM_E_CONTRASTD:
			if(AllocFrame(Frame))
				ret=EffContrast(&(DemoPic[nActivePic].Frame), &Frame,
					33);        // Contrast is modified to 33% of previous amount
			goto EFFECT_EXIT;
            case IDM_E_CROP:
			if(AllocFrame(Frame))
				/* Cutoff the middle of the picture */
				ret=EffCrop(&(DemoPic[nActivePic].Frame), &Frame,
					DemoPic[nActivePic].Frame.iWidth/3,DemoPic[nActivePic].Frame.iHeight/3,DemoPic[nActivePic].Frame.iWidth*2/3,DemoPic[nActivePic].Frame.iHeight*2/3);
			goto EFFECT_EXIT;
		  case IDM_E_EDGEDETECTION:
			if(AllocFrame(Frame))
				/* Find the edges. Treshold is 30, and colours are white and black*/
				ret=EffEdgeDetection(&(DemoPic[nActivePic].Frame), &Frame,
					30, (DWORD)0x00FFFFFF /*white*/, (DWORD)0x00000000)/* black*/;
			goto EFFECT_EXIT;
            case IDM_E_FLIPH:
			if(AllocFrame(Frame))
				ret=EffFlip(&(DemoPic[nActivePic].Frame), &Frame,
                         0, 1);  // flip only horizontal
               goto EFFECT_EXIT;
            case IDM_E_FLIPV:
			if(AllocFrame(Frame))
				ret=EffFlip(&(DemoPic[nActivePic].Frame), &Frame,
                         1, 0);  // flip only vertical
               goto EFFECT_EXIT;
		  /* four following calls move the picture for the half of its size */
		  case IDM_E_MOVEL:
               /* left */
			if(AllocFrame(Frame))
				ret=EffMove(&(DemoPic[nActivePic].Frame), &Frame,
					-(short)(DemoPic[nActivePic].Frame.iWidth/2), 0);
               goto EFFECT_EXIT;
            case IDM_E_MOVER:
			/* right */
			if(AllocFrame(Frame))
				ret=EffMove(&(DemoPic[nActivePic].Frame), &Frame,
					DemoPic[nActivePic].Frame.iWidth/2, 0);
               goto EFFECT_EXIT;
            case IDM_E_MOVEU:
			/* up */
			if(AllocFrame(Frame)) 
				ret=EffMove(&(DemoPic[nActivePic].Frame), &Frame,
					0, DemoPic[nActivePic].Frame.iHeight/2);
               goto EFFECT_EXIT;
            case IDM_E_MOVED:
			/* down */
			if(AllocFrame(Frame))
				ret=EffMove(&(DemoPic[nActivePic].Frame), &Frame,
					0, -(short)(DemoPic[nActivePic].Frame.iHeight/2));
               goto EFFECT_EXIT;
		  case IDM_E_ROTATE45:
            	/* rotate the picture for 45 degrees whith rotation center in the middle */
			if(AllocFrame(Frame))
				ret=EffRotate(&(DemoPic[nActivePic].Frame), &Frame,
					DemoPic[nActivePic].Frame.iWidth/2, DemoPic[nActivePic].Frame.iHeight/2, 45);
               goto EFFECT_EXIT;
		  case IDM_E_ROTATE90:
			/* same, but the rotation angle is 90 degrees */
			if(AllocFrame(Frame))
				ret=EffRotate(&(DemoPic[nActivePic].Frame), &Frame,
					DemoPic[nActivePic].Frame.iWidth/2, DemoPic[nActivePic].Frame.iHeight/2, 90);
               goto EFFECT_EXIT;
		  case IDM_E_SCALE:
               /* scale the window to fit the new size */
			GetClientRect(hActive, &Rect);
			Frame.iWidth=Rect.right-Rect.left;
			Frame.iHeight=Rect.bottom-Rect.top;
			if(AllocFrame(Frame))
				ret=EffScale(&(DemoPic[nActivePic].Frame), &Frame,
                         TRUE);
			goto EFFECT_EXIT;
		  case IDM_E_ZOOM:
			/* zoom in the middle of the window */
			if(AllocFrame(Frame))
				ret=EffZoom(&(DemoPic[nActivePic].Frame), &Frame,
					DemoPic[nActivePic].Frame.iWidth/3,DemoPic[nActivePic].Frame.iHeight/3,DemoPic[nActivePic].Frame.iWidth*2/3,DemoPic[nActivePic].Frame.iHeight*2/3);
               goto EFFECT_EXIT;
		  case IDM_E_SHARPEN:
               /* sharpen the picture (opposit of blure) */
			if(AllocFrame(Frame))
				ret=EffSharpen(&(DemoPic[nActivePic].Frame), &Frame,
                         300);
EFFECT_EXIT:
               if(ret) {
                    /* An error occured or attempting to use demo DLL twice */
                    MessageBox(hWndMain,"Could not perform requested operation or using demo DLL twice","ERROR OCCURED",MB_OK);
               	GlobalFree(Frame.hPicture);
			}
               else {
				/* free the old FRAME and copy the temporary Frame to old FRAME */
				FreeFrame(DemoPic[nActivePic].Frame);
				memcpy(&DemoPic[nActivePic].Frame, &Frame, sizeof(FRAME));
				if(fRemap) BuildPalette(&DemoPic[nActivePic].Frame);
				/* force the repaint */
				InvalidateRect(DemoPic[nActivePic].hWndPic,NULL,TRUE);
               }
			break;
		  case IDM_O_PICINFO:
            /* Create Dialog Box for picture information */
               lpfnDlgProc=MakeProcInstance(PicInfoDlgProc, hInst);
               DialogBox(hInst, "PICINFOBOX", hWndMain, lpfnDlgProc);
               FreeProcInstance(lpfnDlgProc);
            break; 
		  case IDM_O_REMAP:
		  /* Enable remap on load */
               fRemap=!fRemap;
               CheckActiveWindow();
               break;
		  case IDM_O_CONVERT256NONE:
               /* convert picture from true color (24 bits) to 256 colors (8 bits) */
			if(nActivePic>=0) {
                    /* Convert frame from PICTURE structure to temporary FRAME Frame */
				if(MapTo8Bit(&DemoPic[nActivePic].Frame, &Frame)) goto DITHER_ERR;
                    /* free the old FRAME and copy the temporary Frame to old FRAME */
				GlobalFree(DemoPic[nActivePic].Frame.hPicture);
				memcpy(&DemoPic[nActivePic].Frame, &Frame, sizeof(FRAME));
				/* force the repaint */
				InvalidateRect(DemoPic[nActivePic].hWndPic,NULL,TRUE);
			}
			SetCursor(hCursorNormal);
               return 0L;
DITHER_ERR:
               if(DemoPic[nActivePic].Frame.hPalette) GlobalUnlock(DemoPic[nActivePic].Frame.hPalette);
			MessageBox(hWndMain,"Could not convert image!","ERROR OCCURED",MB_OK);
			SetCursor(hCursorNormal);
               return 0L;

            case IDM_H_ABOUT:
               /* Create About Dialog Box */
               lpfnDlgProc=MakeProcInstance(AboutDlgProc, hInst);
               DialogBox(hInst, "ABOUTBOX", hWndMain, lpfnDlgProc);
			FreeProcInstance(lpfnDlgProc);
			break;

         default:
                SetCursor(hCursorNormal);
                return DefWindowProc(hWnd, Message, wParam, lParam);
           }
          SetCursor(hCursorNormal);
         break;        /* End of WM_COMMAND                             */

    case WM_CREATE:


      break;       /*  End of WM_CREATE                              */

    case WM_MOVE:     /*  code for moving the window                    */
      break;
    
    case WM_SIZE:     /*  code for sizing client area                   */
      break;       /* End of WM_SIZE                                 */

    case WM_PAINT:    /* code for the window's client area              */
      /* Obtain a handle to the device context                       */
      /* BeginPaint will sends WM_ERASEBKGND if appropriate          */
      memset(&ps, 0x00, sizeof(PAINTSTRUCT));
      hDC = BeginPaint(hWnd, &ps);

      /* Included in case the background is not a pure color         */
      SetBkMode(hDC, TRANSPARENT);

      /* Inform Windows painting is complete                         */
      EndPaint(hWnd, &ps);
      break;       /*  End of WM_PAINT                               */

    case WM_CLOSE:  /* close the window                                 */
      /* Destroy child windows, modeless dialogs, then, this window  */
      DestroyWindow(hWnd);
	 if (hWnd == hWndMain)
      PostQuitMessage(0);  /* Quit the application                 */
     break;

    default:
      /* For any message for which you don't specifically provide a  */
      /* service routine, you should return the message to Windows   */
      /* for default message processing.                             */
      return DefWindowProc(hWnd, Message, wParam, lParam);
   }
 return 0L;
}     /* End of WndProc
                           */
/* This procedure is service routine for one picture window */
LONG FAR PASCAL PicWndProc(HWND hWnd, WORD Message, WORD wParam, LONG lParam)
{
 HDC        hDC;                /* handle for the display device       */
 PAINTSTRUCT ps;                /* holds PAINT information             */
 RECT     rec;
 short      index,nPos,scroller,nWidth,nHeight;
 short    delta,scrr,scr0,scrx,scry, *dim;

 GetClientRect(hWnd,&rec);
 index=1000-GetDlgCtrlID(hWnd);
 nPos=LOWORD(lParam);
 /* Folowing code handles the scroll boxes */
 if((Message==WM_HSCROLL) || (Message==WM_VSCROLL)) {
	scroller=(Message==WM_HSCROLL)?SB_HORZ:SB_VERT;
	dim=(Message==WM_HSCROLL)?&(DemoPic[nActivePic].Frame.iWidth):&(DemoPic[nActivePic].Frame.iHeight);
     GetScrollRange(hWnd,SB_HORZ,&scr0,&scrr);
     switch (wParam) {
     case SB_BOTTOM:
          nPos=0;
       break;
     case SB_TOP:
          nPos=scrr;
       break;
     case SB_LINEDOWN:
		nPos=(GetScrollPos(hWnd, scroller)+(*dim)/10);
       break;
     case SB_PAGEDOWN:
		nPos=(GetScrollPos(hWnd, scroller)+(*dim)/2);
       break;
     case SB_LINEUP:
		nPos=(GetScrollPos(hWnd, scroller)-(*dim)/10);
	  break;
     case SB_PAGEUP:
		nPos=(GetScrollPos(hWnd, scroller)-(*dim)/2);
       break;
     }
     if(nPos<0) nPos=0;
     else if(nPos>scrr) nPos=scrr;
 }
 switch (Message)
   {
    case WM_SYSCOMMAND:
          switch(wParam) {
          case IDM_CLOSE:
          case SC_CLOSE:
	    	/* close the main window */
			SendMessage(hWnd, WM_CLOSE, 0, 0L);
               break;
          default:
               return DefWindowProc(hWnd, Message, wParam, lParam);
          }
       break;
    case WM_HSCROLL:
          if((wParam!=SB_ENDSCROLL) && (wParam!=SB_THUMBTRACK)) {
               delta=DemoPic[index].Frame.iWidth-(rec.right-rec.left);
            if(delta<0) nPos=0;
               SetScrollPos(hWnd, SB_HORZ, nPos, TRUE);
               DemoPic[index].offx=delta*nPos/(scrr+1);
               InvalidateRect(hWnd, NULL, TRUE);
       }
          break;
    case WM_VSCROLL:
          if((wParam!=SB_ENDSCROLL) && (wParam!=SB_THUMBTRACK)) {
               delta=DemoPic[index].Frame.iHeight-(rec.bottom-rec.top);
               if(delta<0) nPos=0;
               SetScrollPos(hWnd, SB_VERT, nPos, TRUE);
               DemoPic[index].offy=delta*nPos/(scrr+1);
               InvalidateRect(hWnd, NULL, TRUE);
       }
          break;
    case WM_CREATE:


         break;       /*  End of WM_CREATE                              */

    case WM_MOVE:     /*  code for moving the window                    */
         break;

    case WM_ACTIVATE:
         if(hActive) SendMessage(hActive,WM_NCACTIVATE,FALSE,0);
         hActive=hWnd;
         nActivePic=index;
         SendMessage(hActive,WM_NCACTIVATE,TRUE,0);
         return DefWindowProc(hWnd, Message, wParam, lParam);

    case WM_SIZE:     /*  code for sizing client area                   */
         if(wParam==SIZE_RESTORED) {
               nWidth=LOWORD(lParam);
               nHeight=HIWORD(lParam);
               if(nWidth>DemoPic[index].Frame.iWidth)
                    nWidth=DemoPic[index].Frame.iWidth;
               if(nHeight>DemoPic[index].Frame.iHeight)
                    nHeight=DemoPic[index].Frame.iHeight;
               scrx=DemoPic[index].Frame.iWidth-nWidth;
               scry=DemoPic[index].Frame.iHeight-nHeight;
            	SetScrollRange(hWnd,SB_HORZ,0,scrx,TRUE);
               SetScrollRange(hWnd,SB_VERT,0,scry,TRUE);
               DemoPic[index].offx=DemoPic[index].offy=0;
//                      MoveWindow(hWnd, 0, 0, nWidth, nHeight, TRUE);
//                      SetWindowPos(hWnd, 0, 0, 0, nWidth, nHeight, SWP_NOMOVE | SWP_NOZORDER);
         }
         break;       /* End of WM_SIZE                                 */

    case WM_LBUTTONDOWN:
    	    SetWindowPos(hWnd,HWND_TOP, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW);
//          SendMessage(hWnd,WM_NCLBUTTONDOWN,0,0L);
	    SendMessage(hActive,WM_ACTIVATE,TRUE,0);
	    break;

    case WM_NCLBUTTONDOWN:
         SendMessage(hWnd,WM_ACTIVATE,0,0L);
         return DefWindowProc(hWnd, Message, wParam, lParam);

    case WM_PAINT:    /* code for the window's client area              */
      /* Obtain a handle to the device context                       */
      /* BeginPaint will sends WM_ERASEBKGND if appropriate          */
      memset(&ps, 0x00, sizeof(PAINTSTRUCT));
      hDC = BeginPaint(hWnd, &ps);
         /* Included in case the background is not a pure color         */
         SetBkMode(hDC, TRANSPARENT);
         DisplayPicture(index,hDC);

      /* Inform Windows painting is complete                         */
      EndPaint(hWnd, &ps);
      break;       /*  End of WM_PAINT                               */

    case WM_CLOSE:  /* close the picture window                                 */
         DemoPic[index].hWndPic=0;
         FreeFrame(DemoPic[index].Frame);
         hActive=0;nActivePic=-1;
         DestroyWindow(hWnd);
         CheckActiveWindow();
         break;

    default:
      return DefWindowProc(hWnd, Message, wParam, lParam);
   }
 return 0L;
}

/* Service routine for About dialog */
BOOL FAR PASCAL AboutDlgProc (HWND hDlg, WORD Message, WORD wParam, LONG lParam) {
     switch(Message) {
          case WM_INITDIALOG:
               return TRUE;
          case WM_COMMAND:
            if(wParam==IDOK) {
                    EndDialog(hDlg,0);
                    return TRUE;
               }
     }
     return FALSE;
}

/* Service routine for Picture info dialog */
BOOL FAR PASCAL PicInfoDlgProc (HWND hDlg, WORD Message, WORD wParam, LONG lParam) {
     char buf[256];
     switch(Message) {
          case WM_INITDIALOG:
               GetWindowText(DemoPic[nActivePic].hWndPic, buf, 15);
               SetDlgItemText(hDlg, IDD_PI_FILENAME, buf);
			sprintf(buf, "%d x %d", DemoPic[nActivePic].Frame.iWidth, DemoPic[nActivePic].Frame.iHeight);
               SetDlgItemText(hDlg, IDD_PI_DIMENSION, buf);
               SetDlgItemInt(hDlg, IDD_PI_BITCOUNT,DemoPic[nActivePic].Frame.iNumBits,FALSE);
               if(DemoPic[nActivePic].Frame.iNumBits==8)
				SetDlgItemInt(hDlg, IDD_PI_PICSIZE, ((long)DemoPic[nActivePic].Frame.iWidth*(long)DemoPic[nActivePic].Frame.iHeight+256L)/1000,FALSE);
               else
                    SetDlgItemInt(hDlg, IDD_PI_PICSIZE, (long)DemoPic[nActivePic].Frame.iWidth*(long)DemoPic[nActivePic].Frame.iHeight*3L/1000,FALSE);
			if(DemoPic[nActivePic].Frame.hPalette)
				SetDlgItemInt(hDlg, IDD_PI_PALENTRIES, DemoPic[nActivePic].Frame.nPalEntries,FALSE);
			else
				EnableWindow(GetDlgItem(hDlg, IDD_PI_PALENTRIES), FALSE);
			if(IS_ANIMATION_TYPE(DemoPic[nActivePic].FileInfo.wFileType))
				SetDlgItemInt(hDlg, IDD_PI_NFRAMES, DemoPic[nActivePic].FileInfo.nFrames,FALSE);
			else
				EnableWindow(GetDlgItem(hDlg, IDD_PI_NFRAMES), FALSE);
			SetDlgItemText(hDlg, IDD_PI_TYPE, szFileExt[DemoPic[nActivePic].FileInfo.wFileType]+1);
			return TRUE;
          case WM_COMMAND:
            	if(wParam==IDOK) {
                    EndDialog(hDlg,0);
                    return TRUE;
               }
	}
     return FALSE;
}

/* Service routine for Frame select dialog */
BOOL FAR PASCAL FrameSelectDlgProc (HWND hDlg, WORD Message, WORD wParam, LONG lParam) {
     switch(Message) {
          case WM_INITDIALOG:
			SetDlgItemInt(hDlg, IDD_FS_START, 1, FALSE);
			SetDlgItemInt(hDlg, IDD_FS_END, nAniFrames, FALSE);
			SetDlgItemInt(hDlg, IDD_FS_MAX, nAniFrames, FALSE);
			return TRUE;
		case WM_COMMAND:
			switch(wParam) {
			case IDOK:
				iStartFrame=GetDlgItemInt(hDlg, IDD_FS_START,NULL,FALSE);
				iEndFrame=GetDlgItemInt(hDlg, IDD_FS_END,NULL,FALSE);
				if(iStartFrame<1 || iStartFrame>iEndFrame || iEndFrame>nAniFrames) {
					MessageBox(hWndMain,"Illegal values !!", "Input ERROR", MB_ICONEXCLAMATION | MB_OK);
					SetDlgItemInt(hDlg, IDD_FS_END, nAniFrames, FALSE);
					SetDlgItemInt(hDlg, IDD_FS_MAX, nAniFrames, FALSE);
			    }
                    else
                    	EndDialog(hDlg,1);
				return TRUE;
			case IDCANCEL:
				EndDialog(hDlg,0);
				return FALSE;
			}
     }
	return FALSE;
}

/************************************************************************/
/*                                                                      */
/* nCwRegisterClasses Function                                          */
/*                                                                      */
/* The following function registers all the classes of all the windows  */
/* associated with this application. The function returns an error code */
/* if unsuccessful, otherwise it returns 0.                             */
/*                                                                      */
/************************************************************************/

short nCwRegisterClasses(void)
{
 WNDCLASS   wndclass;    /* struct to define a window class             */
 memset(&wndclass, 0x00, sizeof(WNDCLASS));


 /* load WNDCLASS with window's characteristics                         */
 wndclass.style = CS_HREDRAW | CS_VREDRAW | CS_BYTEALIGNWINDOW;
 wndclass.lpfnWndProc = WndProc;
 /* Extra storage for Class and Window objects                          */
 wndclass.cbClsExtra = 0;
 wndclass.cbWndExtra = 0;
 wndclass.hInstance = hInst;
 wndclass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
 wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
 /* Create brush for erasing background                                 */
 wndclass.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
 wndclass.lpszMenuName = szAppName;   /* Menu Name is App Name */
 wndclass.lpszClassName = szAppName; /* Class Name is App Name */
 if(!RegisterClass(&wndclass))
   return -1;
 wndclass.lpfnWndProc = PicWndProc;
 wndclass.lpszMenuName = NULL;   /* Menu Name is App Name */
 wndclass.lpszClassName = "PICTURE"; /* Class Name is App Name */
 if(!RegisterClass(&wndclass))
   return -1;


 return(0);
} /* End of nCwRegisterClasses                                          */

/************************************************************************/
/*  CwUnRegisterClasses Function                                        */
/*                                                                      */
/*  Deletes any refrences to windows resources created for this         */
/*  application, frees memory, deletes instance, handles and does       */
/*  clean up prior to exiting the window                                */
/*                                                                      */
/************************************************************************/

void CwUnRegisterClasses(void)
{
 WNDCLASS   wndclass;    /* struct to define a window class             */
 memset(&wndclass, 0x00, sizeof(WNDCLASS));

 UnregisterClass("PICTURE", hInst);
 UnregisterClass(szAppName, hInst);
}    /* End of CwUnRegisterClasses                                      */


/* Folowing function performs loading (mode==1) and saving (mode==3) of
   pictures */
void LoadSaveData(short mode) {
	ERR_RETURN ret=0,ret1;
	short i,nPN,n;
     char  buf[64],buf1[64];
	FARPROC lpfnDlgProc=NULL;
	LPFRAME lpFrame;
     LPFILEINFO lpFileInfo;
     szFile[0] = '\0';
     szFileTitle[0] = '\0';

     switch (mode) {
     case 3:
		/* Fill common dialog OPENFILENAME structure */
		ofn.Flags = OFN_SHOWHELP | OFN_OVERWRITEPROMPT;
          ofn.lpstrFilter = szFilterSave;
          ofn.nFilterIndex= DemoPic[nActivePic].FileInfo.wFileType;
		GetWindowText(DemoPic[nActivePic].hWndPic, szFile, 9);
          strcat(szFile, szFileExt[DemoPic[nActivePic].FileInfo.wFileType]);

		/* Prepare calling parametars */
		lpFrame=&DemoPic[nActivePic].Frame;
          lpFileInfo=&DemoPic[nActivePic].FileInfo;
		if (GetSaveFileName(&ofn) && ofn.nFilterIndex) {
               SetCursor(hCursorBusy);
               /* Fill FileInfo structure...*/
               _fstrncpy(lpFileInfo->szFileName, szFile, MAX_FILE_NAME);
               lpFileInfo->wFileType=ofn.nFilterIndex;
			lpFileInfo->wCompression=0;
			lpFileInfo->nFrames=1;

			if(lpFileInfo->wFileType==JPG_FILE)
				lpFileInfo->wCompression=20; //JPEG save-quality
			/* Save picture...*/
               /* If user selected FLC or FLI type ...*/
			if(IS_ANIMATION_TYPE(lpFileInfo->wFileType)) {
				if(access(szFile,0)==-1)
                    	/* If animation doesn't exist, create one */
                         ret=ImageSave(lpFileInfo, lpFrame);
				else
                    	/* Else append at the end */
                         ret=FLXAppend(lpFileInfo, &lpFrame, 1);
			}
               /* or for all other image types ...*/
			else
                    ret=ImageSave(lpFileInfo, lpFrame);
          }
          break;
     case 1:
          if((nPN=FindEmptySlot())==-1) 
			goto ERR_LABEL;
          /* Fill common dialog OPENFILENAME structure */
		ofn.Flags = OFN_SHOWHELP | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
		ofn.lpstrFilter = szFilterOpen;
          /* Prepare calling parametars */
		lpFrame=&DemoPic[nPN].Frame;
		lpFileInfo=&DemoPic[nPN].FileInfo;
          if (GetOpenFileName(&ofn) && ofn.nFilterIndex) {
               SetCursor(hCursorBusy);
               /* Fill FileInfo structure...*/
               _fstrncpy(lpFileInfo->szFileName, szFile, MAX_FILE_NAME);
               lpFileInfo->wFileType=ofn.nFilterIndex;
               /* Load picture...*/
               /* If animation type is called (FLI or FLC) */
			if(IS_ANIMATION_TYPE(lpFileInfo->wFileType)) {
				DemoPic[nPN].hWndPic=1;
				if(ret=FLXGetInfo(lpFileInfo, lpFrame)) goto ERR_LABEL;
				nAniFrames=lpFileInfo->nFrames;
				lpfnDlgProc=MakeProcInstance(FrameSelectDlgProc, hInst);
				if(DialogBox(hInst, "FRAMESELBOX", hWndMain, lpfnDlgProc)==0) goto ERR_LABEL;
				File2Name(buf, szFileTitle);
				nAniFrames=iEndFrame-iStartFrame+1;
				/* Copy all PICTURE data to each animation FRAME (width and height) */
                    /* and fill AniFrames array with LPFRAME pointers */
				for(i=0;i<nAniFrames;i++) {
                         /* Find the place for the new picture...*/
					if((n=FindEmptySlot())==-1)
						goto ERR_LABEL;
					AniFrames[i]=&DemoPic[n].Frame;
					memcpy(&DemoPic[n],&DemoPic[nPN],sizeof(PICTURE));
                         /* Put new window name */
					sprintf(buf1,"%8s#%d",buf,iStartFrame+i);
                         /* Create new picture window */
					NewPicture(n, buf1);
				}
				if(ret=FLXLoad(lpFileInfo, AniFrames, iStartFrame-1, iEndFrame-1)) goto ERR_LABEL;
				DemoPic[nPN].hWndPic=0;
				break;
			}
               /* Load image into *lpFrame */
			else if(ret=ImageLoad(lpFileInfo, lpFrame, 0)) goto ERR_LABEL;
			if(fRemap) BuildPalette(&DemoPic[nPN].Frame);
               File2Name(buf, szFileTitle);
               NewPicture(nPN, buf);
		}
          break;
     }
ERR_LABEL:
	if(ret) {
     	if(ret==0xFFFF)
			MessageBox(hWndMain,"...but this is only demo version.","Sorry...",MB_OK | MB_ICONEXCLAMATION);
		else
			for(i=0;i<16;i++)
               	if(ret1=ret&(1<<i))
                    	if(LoadString(hInst, ret1, buf, 64))
                         	MessageBox(hWndMain,buf,"Return Value",MB_OK);
	                    else
     	                    MessageBox(hWndMain,"Unexpectable error","Return Value",MB_OK);
	}
	if(lpfnDlgProc) FreeProcInstance(lpfnDlgProc);
	return;
}

/* This function creates a window for the new picture */
void NewPicture(short nPN, LPSTR szTitle) {
     BOOL vs,hs;
     HMENU hSysMenu;
     short off,bordx,bordy,WW,WH,i;
     RECT    rec;
     DemoPic[nPN].offx= DemoPic[nPN].offy=0;
     GetClientRect(hWndMain, &rec);
     WW=rec.right-rec.left;
     WH=rec.bottom-rec.top;
     bordy=GetSystemMetrics(SM_CYFRAME);
     bordx=GetSystemMetrics(SM_CXFRAME);
     off=GetSystemMetrics(SM_CYCAPTION);
     hs=DemoPic[nPN].Frame.iWidth+off*nPN+bordx > WW;
     vs=DemoPic[nPN].Frame.iHeight+off*(nPN+1)+bordy > WH;
     DemoPic[nPN].hWndPic=CreateWindow(
          "PICTURE", szTitle,
          WS_CHILD | WS_VISIBLE | WS_SYSMENU | WS_CLIPSIBLINGS | WS_CAPTION | WS_THICKFRAME,
          off*nPN,off*nPN,
          hs?(WW-off*nPN):DemoPic[nPN].Frame.iWidth+bordx*2,
          vs?(WH-off*nPN):DemoPic[nPN].Frame.iHeight+off+bordy*2,
          hWndMain, 1000-nPN, hInst, NULL);
     hSysMenu=GetSystemMenu(DemoPic[nPN].hWndPic, FALSE);
     DeleteMenu(hSysMenu, 0, MF_BYPOSITION);
     for(i=0;i<6;i++) DeleteMenu(hSysMenu, 2, MF_BYPOSITION);
     AppendMenu(hSysMenu, MF_SEPARATOR, 0, NULL);
     AppendMenu(hSysMenu, MF_STRING, IDM_CLOSE, "&Close  Ctrl+F4");
     nActivePic=nPN;
     SetWindowPos(DemoPic[nPN].hWndPic,HWND_TOP,
          0 , 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW);
     SendMessage(DemoPic[nPN].hWndPic,WM_ACTIVATE,TRUE,0L);
}

/* This function handles Paint message for picture window */
void DisplayPicture(short i, HDC hDC) {
     LPHBYTE         lpBitmap;
     PBITMAPINFO     pbmi;
     HANDLE          hloc;
     BYTE            tmp;
     PALETTEENTRY FAR *lpPal;
     short           j;

     if(lpBitmap = GlobalLock(DemoPic[i].Frame.hPicture)) {
          hDC=GetDC(DemoPic[i].hWndPic);
          if(DemoPic[i].Frame.hPalette) SelectPalette(hDC,DemoPic[i].Frame.hPalette,FALSE);
		RealizePalette(hDC);
          /* if the picture is 8 bit */
		if(DemoPic[i].Frame.iNumBits==8) {
               if((hloc = LocalAlloc(LMEM_ZEROINIT | LMEM_FIXED,DemoPic[i].Frame.nPalEntries*sizeof(PALETTEENTRY)+sizeof(BITMAPINFOHEADER)))==NULL)
          goto ERR_LABEL;
               if((pbmi = (PBITMAPINFO) LocalLock(hloc))==NULL)
                    goto ERR_LABEL;
               lpPal=(PALETTEENTRY FAR*)pbmi->bmiColors;
			GetPaletteEntries(DemoPic[i].Frame.hPalette,0,DemoPic[i].Frame.nPalEntries,lpPal);
               for(j=0;j<DemoPic[i].Frame.nPalEntries;j++) {
                    tmp=lpPal[j].peBlue;                    
                    lpPal[j].peBlue=lpPal[j].peRed;
                    lpPal[j].peRed=tmp;
            }
               pbmi->bmiHeader.biBitCount =8;
               pbmi->bmiHeader.biClrImportant = 0;
               pbmi->bmiHeader.biClrUsed = DemoPic[i].Frame.nPalEntries;

          }       
          else {
		/* if the picture is 24 bit */
			if((hloc = LocalAlloc(LMEM_ZEROINIT | LMEM_MOVEABLE,sizeof(BITMAPINFOHEADER)))==NULL)
          goto ERR_LABEL;
               if((pbmi = (PBITMAPINFO) LocalLock(hloc))==NULL)
                    goto ERR_LABEL;
               pbmi->bmiHeader.biBitCount = 24; 
               pbmi->bmiHeader.biClrUsed = 0;
		}
		/* Fill the BITMAPINFOHEADER structure */
		pbmi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
          pbmi->bmiHeader.biWidth = DemoPic[i].Frame.iWidth;
          pbmi->bmiHeader.biHeight = DemoPic[i].Frame.iHeight;
          pbmi->bmiHeader.biPlanes = 1;
		pbmi->bmiHeader.biCompression = BI_RGB;
          /* Draw the picture */
          SetDIBitsToDevice(hDC, -DemoPic[i].offx, -DemoPic[i].offy, ROUND2LONG(DemoPic[i].Frame.iWidth), DemoPic[i].Frame.iHeight,
                    0, 0, 0, DemoPic[i].Frame.iHeight, lpBitmap, pbmi, DIB_RGB_COLORS);
          GlobalUnlock(DemoPic[i].Frame.hPicture);
     }
ERR_LABEL:
     if(hloc) {
		LocalUnlock(hloc);
          LocalFree(hloc);
     }
     ReleaseDC(DemoPic[i].hWndPic, hDC);
     fPaintEnd=TRUE;
}

/* Cut off the extension */
void File2Name(LPSTR dest, LPSTR source) {
     for(;*source && *source!='.';*(dest++)=*(source++));
     *dest='\0';
}

/* Check the menu visibility */
void CheckActiveWindow() {
     short i;
     HMENU hSubMenu;
     hSubMenu=GetSubMenu(hMenu,1);
     if(nActivePic==-1) {
          EnableMenuItem(hMenu, IDM_F_SAVEPICTURE, MF_BYCOMMAND | MF_GRAYED);
          EnableMenuItem(hMenu, 2, MF_BYPOSITION | MF_GRAYED);
          EnableMenuItem(hSubMenu, 0, MF_BYPOSITION | MF_GRAYED);
          EnableMenuItem(hSubMenu, 2, MF_BYPOSITION | MF_GRAYED);
		if(hActive=GetWindow(hWndMain, GW_CHILD))
               for(i=0;i<MAX_NUM_PIC;i++)
                    if(hActive==DemoPic[i].hWndPic) {
               		nActivePic=i;
                         SendMessage(DemoPic[i].hWndPic,WM_ACTIVATE,TRUE,0L);
                         goto LAB01;
                    } 
     }
     else {
LAB01:
     if(DemoPic[nActivePic].Frame.iNumBits==24)
               EnableMenuItem(hMenu, 2, MF_BYPOSITION | MF_ENABLED);
          else
               EnableMenuItem(hMenu, 2, MF_BYPOSITION | MF_GRAYED);
          EnableMenuItem(hMenu, IDM_F_SAVEPICTURE, MF_BYCOMMAND | MF_ENABLED);
          EnableMenuItem(hSubMenu, 0, MF_BYPOSITION | MF_ENABLED);
          EnableMenuItem(hSubMenu, 2, MF_BYPOSITION | MF_ENABLED);
     }
     CheckMenuItem(hMenu, IDM_O_REMAP, fRemap?MF_CHECKED:MF_UNCHECKED);

     DrawMenuBar(hWndMain);
}

/* Place the new picture in the DemoPic array if possible */
short FindEmptySlot() {
     short i;
     for(i=0;i<nPicNum;i++) 
          if(DemoPic[i].hWndPic==0) {
			memset(&(DemoPic[i]),0,sizeof(PICTURE));
			return i;
          }
     if(nPicNum+1>=MAX_NUM_PIC) {
          MessageBox(hWndMain,"Too many windows opened","ERROR",MB_OK | MB_ICONEXCLAMATION);
          return -1;
     }
     memset(&(DemoPic[nPicNum++]),0,sizeof(PICTURE));
     return nPicNum-1;
}
