#ifndef _IMAGE_H_
#       define _IMAGE_H_
/* image.h                      Image definition.
 * Portability: ANSI
 *                                      (c) erdy 1992
 */
/* Image formats: */
#define ZCompact 0x10
#define Z4Planes 0x20
#define ZPacked  0x40
/* Submodes: */
#define IMG_SUBFRAMED 0x80
#define IMG_FILLBACK  0x100
#define IMG_HEADER    0x1000

typedef union Image {
        struct {
                int            width, height;  /* Sizes of encoded image (subframe) */
                unsigned int   format;         /* Format of image */
                void     far  *data;           /* Encoded data */
                long           size;           /* Size of data */
                int            x, y;           /* Relative coordinates of subframe */
                int            twidth, theight;/* Total sizes (full frame) */
                unsigned char  bg;             /* Background color */
                unsigned char  ncolormaps;     /* Count of colormaps */
                unsigned char  counter;        /* delay counter */
                unsigned char  unused;         /* unused */
                union Image far *next;         /* Pointer to next image */
        } d;
        char align[0x20];
} Image;
#if (sizeof(Image) % 0x10) != 0
#       error Bad size of Image
#endif
#define SIZE_YIMAGE (sizeof(int)*4+sizeof(void far *)+sizeof(long))
#define ZC_SIGN 0x11
#define ZC_VERS 1               /* Ylib image */
#define SC_VERS 0x11            /* screen lib image */
typedef union {
        char far *data;
        struct {
                char           manuf;           /* ᥣ ZC_SIGN                */
                char           hard;            /* ଠ  ᨨ           */
        } vers;
} data_vers;
#define _manuf(p) ((data_vers far *)&(p))->vers.manuf
#define _hard(p) ((data_vers far *)&(p))->vers.hard

#endif  _IMAGE_H_