#include "touch.h"

/******************************************************************\
*                                                                  *
*		   w       w                oooo                           *
*		   w       w  iii  n   n   o    o   n   n  eeee            *
*		   w       w   i   nn  n  o      o  nn  n  e               *
*		   w   w   w   i   n n n  o      o  n n n  eee             *
*	  	    w w w w    i   n  nn   o    o   n  nn  e               *
*	 	     w   w    iii  n   n    oooo    n   n  eeee            *
*								   								   *
*     C o m m a n d   L a n g u a g e   I n t e r p r e t e r      *
*								   								   *
*								   								   *
*	Written by Lucien Cinc                                         *
*	Copyright (c) 1992, 1993                                       *
*                                                                  *
\******************************************************************/

DOS_FILE_DATE fdate;
DOS_FILE_TIME ftime;

int count = 0;

void touch(char *p);
int getuser(char *s, struct dosdate_t *date, struct dostime_t *time);
void summary(void);

int main(void)
{
	int n, i;
	struct dosdate_t date;
    struct dostime_t time;
	char *sp;

	sp = args();                // parse command line switches
    while(*sp)
        switch(*sp++) {
            case 'v' :          // show version information
                       printf("%cVersion %c%d.%01d\n", WHITE, YELLOW, VERSION / 10, VERSION % 10);
                       return 0;
            default:            // invalid switch
                       perror("Invalid switch");
                       return 1;
        }

	if (argnstr() != 0) {           // no command line string's allowed
		perror("Invalid argument");
		return 1;
	}

	_dos_getdate(&date);			// get system date and time
	_dos_gettime(&time);

	switch(argc()) {			   // parse command line arguments
		case 1:
				break;
		case 2:
				if (getuser(argv(2), &date, &time))
                	return 1;		// invalid date or time
				break;
		case 3:
        		if (getuser(argv(2), &date, &time) ||
					getuser(argv(3), &date, &time))
						return 1;	// invalid date or time
                break;
		default:
				perror("Too many or few arguments");
				return 2;
    }

	fdate.b.Day = date.day;				// date to set
	fdate.b.Month = date.month;
	fdate.b.Year = date.year - 1980;

	ftime.b.Hour = time.hour;			// time to set
	ftime.b.Minute = time.minute;
	ftime.b.Second = time.second;

	if ((n = fillfile(argpath(1), ATT_RHSA)) > 0) {		// some files to touch

		limit(n);	// status bar upper limit

		for (i = 0;i < n;i++, inc(1)) {
			if (isbreak())
				break;

			touch(getfilepath(i));		// file to be touched
		}

        summary();

		empty();	// finished with status bar

	} else {											// a file to create and touch

		// no need to check for wildcards in argabs() because
		// touch() will fail after trying to create the file

		touch(argabs(1));	
		summary();

    }

	return 0;
}

int stoi(char **str)
{
	char *tstr = (char *)*str;
	int n = 0;

	while (isdigit(*tstr))
	  	n = n * 10 + (*tstr++ - '0');

	*str = (char *)tstr;

	return n;
}

int getdate(char *s, struct dosdate_t *date)
{
	int mon, day, year;
	int days[13] = { 0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
	int okflag = FALSE;

    if (isdigit(*s)) {
		day = stoi(&s);					// parse day

	    if (*s++ == '-' && isdigit(*s)) {
			mon = stoi(&s);				// parse month

        	if (*s++  == '-' && isdigit(*s)) {
				year = stoi(&s);		// parse year

				if (year % 4 == 0 && year % 100 != 0 || year & 400 == 0)
					days[2] = 29;      		// adjust for leap year

				if (*s == '\0')
					okflag = TRUE;
			}
		}
	}

	if (okflag &&
	   (mon > 0 && mon < 13) &&
	   (day > 0 && day <= days[mon]) &&
	   (year > 1979 && year < 2101)) {	// correctly parsed date

			date->day = day;
			date->month = mon;
            date->year = year;

	} else {
    	perror("Invalid date");
		return 1;	// Invalid Date
	}

	return 0;
}

int gettime(char *s, struct dostime_t *time)
{
	int hour, min, sec = 0;
	BOOL okflag = FALSE;
	
	if (isdigit(*s)) {
		hour = stoi(&s);			// parse hour

    	if (*s++ == ':' && isdigit(*s)) {
	  		min = stoi(&s);			// parse minute

			if (*s == '\0')
				okflag = TRUE;		// done
            else if (*s++ == ':' && isdigit(*s)) {
	    		sec = stoi (&s); 	// parse optional seconds

				if (*s == '\0')
					okflag = TRUE;	// done
			}
        }
	}

    if (okflag &&
	   (hour >= 0 && hour < 24) &&
	   (min >= 0 && min < 60) &&
	   (sec >= 0 && sec < 60)) {	// correctly parsed time

			time->hour = hour;
	  		time->minute = min;
	  		time->second = sec;

	} else {
    	perror("Invalid time");
		return 1;		// Invalid Time
	}

	return 0;
}

int getuser(char *s, struct dosdate_t *date, struct dostime_t *time)
{
	if (strchr(s, ':'))				// assume a time
		return gettime(s, time);
	else							// assume a date
    	return getdate(s, date);
}

void touch(char *p)
{
	int handle;

	// touch only works for files, since there is no function
	// to set the date and time for a directory
	 
	if (_dos_open(p, O_RDONLY, &handle) && _dos_creat(p, 0, &handle)) {
    	perror("Invalid path or file name");
		return;
	}

	_dos_setftime(handle, fdate.u, ftime.u);	// at last
	_dos_close(handle);

	count++;									// increment counter

	printf("%c%s\n", GREEN, unixpath(padfilename(p)));
}

void summary(void)
{
    if (count)
		printf("\n%c%5d %cfile(s) touched\n", YELLOW, count, WHITE);
}
