_TEXT   SEGMENT byte    public  'CODE'
	ASSUME	cs:_TEXT

;The speaker is controlled modifying the bits 0 and 1 of the port 61h.
; bit 0:        Controls transmission of the timer's chip output
;               signal to the speaker.
; bit 1:        Controls the pulsing of the speaker.
        PUBLIC  _beep
_beep	PROC	near
	sti
	push    bp
	mov     bp,sp
	mov	al,0B6h		;Programming timer for pulses.
	out	43h,al
	jmp	short $+2       ;wait a few cycles
	mov	al,0		;Send 8 bits of 16 bits (low byte)
	out	42h,al		;  to determine the frequency.
	jmp	short $+2	;wait a few cycles
	mov	al,7		;Send the last 8 bits.
	out	42h,al
	jmp	short $+2       ;wait a few cycles
	in	al,61h		;SPEAKER ON
	jmp	short $+2       ;wait a few cycles
	or	al,3            ;Turn on bits 0 and 1.
	out	61h,al          ;Turn the speaker on.
	push	cx
	mov	cx,2000h	;Delay
delay:	loop	delay
	pop	cx
	in	al,61h		;Speaker off
	jmp	short $+2       ;wait a few cycles
	and	al,0FCh         ;Turn off bits 0 and 1.
	out	61h,al          ;Turn off speaker.
	pop     bp
	ret
_beep  ENDP

        PUBLIC  _fds_inport
_fds_inport	PROC	near
	sti
	push    bp
	mov     bp,sp
	mov     ax,[bp+4]
	mov     dx,ax
	in	al,dx
	xor     ah,ah
	pop     bp
	ret
_fds_inport  ENDP

_TEXT	ENDS
        end
