// DSP.CPP (Visual C++ 1.00) -- Plays sound on DSP in "direct 8 bit DAC mode"
// Needs Soundblaster-compatible card at 0220h
// original code of dsp.cpp is: go midi, sight and sound, library programer stuff


#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <process.h>
#include <io.h>
#include <malloc.h>

typedef unsigned char BYTE;
typedef unsigned int  WORD;
typedef unsigned long DWORD;

char huge *buf;

void write(BYTE output)
{
	asm mov dx,0x220;
	asm add dx,0xc;
loop:
	asm in al,dx;
	asm test al,0x80;
	asm jnz loop

	asm mov dx,0x220;
	asm add dx,0xc;
	asm mov al,output
	asm out dx,al;
}

void rate(DWORD rate)
{ DWORD val;

//      if(rate<4000) return;
	val=256-1000000/rate;
	write(0x40);
	write((BYTE)val);
}


void play(int n)
{ //play voc routine

    while ( inp(0x022C) & 0x80);  // ready to recieve command?
    outp(0x022C, 0x10);          // direct 8 bit DAC mode 0x10
    while ( inp(0x022C) & 0x80);  // ready to recieve data?
     outp(0x022C, n);             // send data

    bdos(0x0C, 0, 0);              // throw away the key
}


void ini()
{ int i;

   bdos(0x0D, 0, 0);              // SOS (save our source)
   outp(0x0226, 1);               // reset = 1

  for (i = 0; i < 3 * 2; i++)  inp(0x61);   // wait 3 us
  outp(0x0226, 0);               // reset = 0

  while ( inp(0x022C) & 0x80);    // ready to recieve command?
  outp(0x022C, 0xD1);            // speaker on

  for (i = 0; i < 100; i++) {
    if (inp(0x022E) & 0x80) if(inp(0x022A)==0xAA) return;
      else { printf("DSP reset error\n"); exit(1);    }
  }

  printf("DSP not found at 0220h\n");
  exit(1);
}


int main() { FILE *fp;
	     char na[60];
	     char i;
	     unsigned long lent,l;
	     int rat=0;



   printf("VOC Files name ? :");   gets(na);

   printf("rate:");scanf("%d",&rat);




   if((fp=fopen(na,"rb"))==0) exit(0);

   lent = filelength(fileno(fp)) - 0x1a;
   if(lent>64000l) lent=64000l;

   buf=(char huge * ) malloc(lent)-0x1a;

   fseek(fp,0x1a,SEEK_SET);
   fread(buf,1,(unsigned long) lent,fp);
   fclose(fp);

   fseek(fp,0x1a,1);


   ini();
   rate(rat);

   for(l=0;l<lent;l++) play(buf[l]);



free(buf);
return 0;
}
