// ===================================================================
// BALLS.CPP
//	Illustrate the SphereFlake.
// Copyright (C) 1993 by Nicholas Wilt.  All rights reserved.
// ===================================================================

#include "oort.h"
#include "world.h"
#include "colors.h"
#include "utils.h"

void
PopulateWorld(World& world)
{
    world.SetDepthLimit(3);
    world.SetOutputFile("balls.raw");

    world.SetViewerParameters(Vector3D(0), Vector3D(0, 0, 1000), Vector3D(0, 1, 0));
    world.SetScreenWidth(4000);
    world.SetScreenHeight(3000);
    world.SetScreenDistance(1000);

    world.SetBackgroundColor(RGBColor(0));

    world.AddLight(new PointLight(Vector3D(500, 500, 1000), RGBColor(0.5), 1, 0, 0));
    world.AddLight(new PointLight(Vector3D(0, 500, 2000), RGBColor(0.5), 1, 0, 0));

    HallSurface *surf = new HallSurface;
    surf->SetDiffuse(new PureColor(Blue));

    world.AddObject(new SphereFlake(Vector3D(0), 300.0, Vector3D(0, 1, 0), 4, surf));

    Texture *ChessBoard = new Checkerboard(500, 500,
    					   new PureColor(White),
					   new PureColor(LightBlue),
					   IdentityMatrix());

    HallSurface *checks = new HallSurface;
    checks->SetDiffuse(ChessBoard);
    world.AddObject(new Plane(Vector3D(0, 0, 1), 0.0, checks));
    HallSurface *glass = new HallSurface;
    glass->SetDiffuse(new PureColor(RGBColor(0.08)));
    glass->SetSpecular(new PureColor(RGBColor(0.6)), 100);
    glass->SetReflect(new PureColor(RGBColor(0.2)));
    glass->SetTransmit(new PureColor(RGBColor(0.8)), 1.3);

    world.AddObject(new Sphere(Vector3D(0), 750, glass));
}

int
main(int argc, char *argv[])
{
    World TheWorld;

    // Say hello
    cout << "OORT: The Object-Oriented Ray Tracer  Version 1.0\n";
    cout << "Copyright (C) 1992 by Nicholas Wilt.  All rights reserved.\n\n";

    // Allocate global noise sources.
    if (! GlobalNoise::Noise)
	GlobalNoise::Noise = new PerlinNoise;
    if (! GlobalNoise::Waves)
    	GlobalNoise::Waves = new WaveSource(10, GlobalNoise::Noise);
    if (! GlobalNoise::Freqs)
    	GlobalNoise::Freqs = new FreqSource(10, GlobalNoise::Noise);

    PopulateWorld(TheWorld);

    // Parse the command line; options given on the command line subsume
    // stuff specified in the input file.
    TheWorld.ParseCommandLine(argc, argv);

    // Write RAW output file.
    TheWorld.RayTrace();

    // Report on statistics gathered.
    Report(cout);
    if (Statistics::AppendTo) {
    	ofstream app(Statistics::AppendTo, ios::ate);
    	if (! (! app)) {
    	    Report(app);
    	    app.close();
    	}
    }

    // Delete global noise sources.
    delete GlobalNoise::Noise;
    delete GlobalNoise::Waves;
    delete GlobalNoise::Freqs;

    return 0;
}
