// ===================================================================
// matrix.h
//	Header file for Matrix class in OORT.
//
//	     The Object-Oriented Ray Tracer (OORT)
//            Copyright (C) 1993 by Nicholas Wilt.
//
// This software product may be freely copied and distributed in
// unmodified form but may not be sold.  A nominal distribution
// fee may be charged for media and handling by freeware and
// shareware distributors.  The software product may not be
// included in whole or in part into any commercial package
// without the express written consent of the author.
// 
// This software product is provided as is without warranty of
// any kind, express or implied, including but not limited to
// the implied warranties of merchantability and fitness for a
// particular purpose.  The author assumes no liability for any
// alleged or actual damages arising from the use of this
// software.  The author is under no obligation to provide 
// service, corrections or upgrades to the software.
//
// ------------------------------------------------------------
//
// Please contact me with questions, comments, suggestions or
// other input about OORT.  My Compuserve account number is
// [75210,2455] (Internet sites can reach me at 
// 75210.2455@compuserve.com).
//					--Nicholas Wilt
// ===================================================================

#ifndef __MATRIX__

#define __MATRIX__

// Forward-declare some other classes
class Vector3D;
class ostream;

class Matrix {

public:
    float x[4][4];

    Matrix() { }

    // Assignment operators
    Matrix& operator+= (const Matrix& A); 	// add-to
    Matrix& operator-= (const Matrix& A); 	// subtract-from
    Matrix& operator*= (const Matrix& A); 	// multiply by matrix
    Matrix& operator*= (float A); 		// scale by scalar

    // Fundamental operations
    void Invert();				// Invert the matrix
    void Transpose();				// Transpose the matrix
    friend Matrix Invert(const Matrix& M);	// Invert a given matrix
    friend Matrix Transpose(const Matrix& M);	// Transpose a given matrix

    // Create various types of matrix.
    friend Matrix IdentityMatrix();
    friend Matrix ZeroMatrix();
    friend Matrix TranslationMatrix(const Vector3D& Location);
    friend Matrix RotationXMatrix(float Angle);
    friend Matrix RotationYMatrix(float Angle);
    friend Matrix RotationZMatrix(float Angle);
    friend Matrix RotationYPRMatrix(float Yaw, float Pitch, float Roll);
    friend Matrix RotationAxisMatrix(const Vector3D& axis, float Angle);

    friend Matrix ScaleMatrix(float X, float Y, float Z);
    friend Matrix GenRotation(const Vector3D& x, const Vector3D& y, const Vector3D& z);
    friend Matrix ViewMatrix(const Vector3D& LookAt, const Vector3D& Viewer, const Vector3D& Up);
    friend Matrix QuadricMatrix(float a, float b, float c, float d, float e,
                    	        float f, float g, float h, float j, float k);
    friend Matrix MirrorX();
    friend Matrix MirrorY();
    friend Matrix MirrorZ();
    friend Matrix RotationOnly(const Matrix& x);

    // Binary operators
    friend Matrix operator+ (const Matrix& A, const Matrix& B);
    friend Matrix operator- (const Matrix& A, const Matrix& B);
    friend Matrix operator* (const Matrix& A, float B);
    friend Matrix operator* (const Matrix& A, const Matrix& B);
    friend class Vector3D operator* (const Matrix& M, const Vector3D& v);
    friend class Vector3D RotateOnly(const Matrix& M, const Vector3D& v);

    // Overloaded output operator.
    friend ostream& operator<< (ostream& s, const Matrix& M);
};

#endif

