// ===================================================================
// stack.h
//	Header file for SimpleStack class template.
//
//	     The Object-Oriented Ray Tracer (OORT)
//            Copyright (C) 1993 by Nicholas Wilt.
//
// This software product may be freely copied and distributed in
// unmodified form but may not be sold.  A nominal distribution
// fee may be charged for media and handling by freeware and
// shareware distributors.  The software product may not be
// included in whole or in part into any commercial package
// without the express written consent of the author.
// 
// This software product is provided as is without warranty of
// any kind, express or implied, including but not limited to
// the implied warranties of merchantability and fitness for a
// particular purpose.  The author assumes no liability for any
// alleged or actual damages arising from the use of this
// software.  The author is under no obligation to provide 
// service, corrections or upgrades to the software.
//
// ------------------------------------------------------------
//
// Please contact me with questions, comments, suggestions or
// other input about OORT.  My Compuserve account number is
// [75210,2455] (Internet sites can reach me at 
// 75210.2455@compuserve.com).
//					--Nicholas Wilt
// ===================================================================


// ---------------------------------------------------------
// SimpleStack
//	Class template for a stack of T's.  The fundamental 
//	operations are Push, Pop, and Empty (which just 
//	tells you whether the stack is currently empty).
// ---------------------------------------------------------

template<class T>
class SimpleStack {
protected:
    class SimpleStackNode {
    public:
    	T contents;
    	SimpleStackNode *next;
    	SimpleStackNode(const T& x, SimpleStackNode *Next):
    		contents(x), next(Next) { }
    };
    SimpleStackNode *top;
public:
    SimpleStack() { top = 0; }
    SimpleStack(const SimpleStack<T>&);
    SimpleStack<T>& operator=(const SimpleStack<T>&);
    virtual ~SimpleStack();

    virtual void Push(const T& x);
    virtual int Empty() const;
    virtual T Pop();
    virtual int PopPassbk(T *passbk);
    virtual T Top();
    SimpleStackNode *TOS() const { return top; }

    class Iterator {
    protected:
	SimpleStackNode *ptr;
    public:
	Iterator(const SimpleStack<T>& x) { ptr = x.TOS(); }
	T Contents() const {
	    return (ptr) ? ptr->contents : 0;
	}
	int Valid() const {
	    return ptr != 0;
	}
	void GotoNext() {
	    if (ptr)
		ptr = ptr->next;
	}
    };
};


template<class T>
SimpleStack<T>::SimpleStack(const SimpleStack<T>& x) 
{
    SimpleStack<T> temp;
    for (SimpleStackNode *sc = x.top; sc; sc = sc->next)
	temp.Push(sc->contents);
    top = 0;
    while (! temp.Empty())
	Push(temp.Pop());
}

template<class T>
SimpleStack<T>&
SimpleStack<T>::operator=(const SimpleStack<T>& x)
{
    SimpleStackNode *sc = top;
    while (sc) {
	SimpleStackNode *next = sc->next;
	delete sc;
	sc = next;
    }
    return *this = x;
}

template<class T>
SimpleStack<T>::~SimpleStack() 
{
    SimpleStackNode *sc = top;
    while (sc) {
	SimpleStackNode *next = sc->next;
	delete sc;
	sc = next;
    }
}

template<class T>
void
SimpleStack<T>::Push(const T& x)
{
    top = new SimpleStackNode(x, top);
}

template<class T>
int
SimpleStack<T>::Empty() const 
{
    return top == 0;
}


template<class T>
T
SimpleStack<T>::Pop()
{
    if (top) {
	T ret = top->contents;
	SimpleStackNode *next = top->next;
	delete top;
	top = next;
	return ret;
    }
    return 0;
}

template<class T>
int
SimpleStack<T>::PopPassbk(T *passbk)
{
    if (top) {
    	*passbk = top->contents;
    	SimpleStackNode *next = top->next;
    	delete top;
    	top = next;
    	return 0;
    }
    else
	return -1;
}

template<class T>
T
SimpleStack<T>::Top()
{
    return (top) ? top->contents : 0;
}

