// ===================================================================
// stats.h
//      Header for classes that encapsulate statistics and limits
//      for the ray tracer.
//
//	     The Object-Oriented Ray Tracer (OORT)
//            Copyright (C) 1993 by Nicholas Wilt.
//
// This software product may be freely copied and distributed in
// unmodified form but may not be sold.  A nominal distribution
// fee may be charged for media and handling by freeware and
// shareware distributors.  The software product may not be
// included in whole or in part into any commercial package
// without the express written consent of the author.
// 
// This software product is provided as is without warranty of
// any kind, express or implied, including but not limited to
// the implied warranties of merchantability and fitness for a
// particular purpose.  The author assumes no liability for any
// alleged or actual damages arising from the use of this
// software.  The author is under no obligation to provide 
// service, corrections or upgrades to the software.
//
// ------------------------------------------------------------
//
// Please contact me with questions, comments, suggestions or
// other input about OORT.  My Compuserve account number is
// [75210,2455] (Internet sites can reach me at 
// 75210.2455@compuserve.com).
//					--Nicholas Wilt
// ===================================================================


// -------------------------------------------------------------------
// Statistics.
//	This class has all the statistics for the 'trace.
//	Most are intended to give an indication of how successful
//	certain optimizations are.
// -------------------------------------------------------------------

class Statistics {
public:
    // Stream to append statistics report to
    static char *AppendTo;	    // Append statistics to this file

    // Ray statistics
    static long PrimaryRays;	    // Number of primary rays cast
    static long ShadowRays;	    // Number of shadow rays cast
    static long ReflectedRays;	    // Number of reflected rays spawned
    static long TransmittedRays;    // Number of transmitted rays spawned

    // Timing statistics
    static long PrepTime;	    // Preprocessing time (seconds)
    static long RenderTime;	    // Rendering time (seconds)

    // Ray bounding box statistics
    static float TotalVolume;	    // Total volume of ray bbox's without
	                	    // nearest-object in bounding box
                		    // optimization for bbox minimization
    static float RestrictedVolume;  // Total volume of ray bbox's with
                		    // optimization turned on.

    // Shadow caching statistics
    static long ShadowTotal;	    // Total number of shadow cache tests
    static long ShadowHits;	    // Number of successful ones

    // Statistics for last-nearest per object optimization
    static long NearestTotal;	    // Total number of intersection
				    // attempts with nearest object
				    // cached in objects
    static long NearestHits;	    // Number of successful hits

    // LessThanEpsilon statistics--to evaluate how much of a performance
    // hit introducing an epsilon into the comparison adds.
    static long EpsilonTotal;	    // Total number of comparisons
    static long EpsilonNeeded;	    // Number that required a comparison
				    // against epsilon

    static float HierarchyHeuristic;// Heuristic of the hierarchy's
				    // effectiveness

    static unsigned long RayPixHist[16];

    // Intersection count statistics
    class Intersections {
    public:
    	static long BBox;
    	static long Plane;
    	static long Polygon;
    	static long Quadric;
    	static long Sphere;
	static long Ellipsoid;
 	static long Ring;
	static long Algebraic;
	static long Triangle;
	static long CSGUnion;
	static long CSGIntersection;
	static long CSGDifference;
    };

    // Object count statistics
    class Objects {
    public:
	static long BBox;
    	static long Plane;
    	static long Polygon;
    	static long Quadric;
    	static long Sphere;
	static long Ellipsoid;
 	static long Ring;
	static long Algebraic;
	static long Triangle;
	static long CSGUnion;
	static long CSGIntersection;
	static long CSGDifference;
    };
};

// -------------------------------------------------------------------
// Limits.
//	This class encapsulates all the concessions to floating-point
//	error made by ray tracers.
// -------------------------------------------------------------------

class Limits {
public:
    // This is the number used to reject too-close intersections.
    // The default value is 1.0.
    static float Threshold;

    // This is a "small" number.  Less than this number is assumed to
    // be 0, when such things matter.
    // The default value is 0.1.
    static float Small;

    // This is an impractically "large" number, used for intersection
    // parameters out to infinity (e.g. the span resulting from an
    // FindAllIntersections operation on a plane).
    // The default value is 100000.
    static float Infinity;
};


