// ===================================================================
// aggreg.cpp
//	Implementation of Aggregate objects--lists of objects that
//	are associated with each other, e.g. the polygons that a
//	model imported from an OFF file is made of.
//
//	     The Object-Oriented Ray Tracer (OORT)
//            Copyright (C) 1993 by Nicholas Wilt.
//
// This software product may be freely copied and distributed in
// unmodified form but may not be sold.  A nominal distribution
// fee may be charged for media and handling by freeware and
// shareware distributors.  The software product may not be
// included in whole or in part into any commercial package
// without the express written consent of the author.
// 
// This software product is provided as is without warranty of
// any kind, express or implied, including but not limited to
// the implied warranties of merchantability and fitness for a
// particular purpose.  The author assumes no liability for any
// alleged or actual damages arising from the use of this
// software.  The author is under no obligation to provide 
// service, corrections or upgrades to the software.
//
// ------------------------------------------------------------
//
// Please contact me with questions, comments, suggestions or
// other input about OORT.  My Compuserve account number is
// [75210,2455] (Internet sites can reach me at 
// 75210.2455@compuserve.com).
//					--Nicholas Wilt
// ===================================================================

#include "oort.h"

Aggregate::Aggregate(const ObjectList& List): Object3D(AGGREGATE)
{
    list = ObjectList(List);
}

int
Aggregate::NearestInt(Ray& ray, float& t, float maxt)
{
    cerr << "Aggregate::NearestInt called\n";
    exit(1);
    return 0;
}

SpanList *
Aggregate::FindAllIntersections(Ray& ray)
{
    cerr << "Aggregate::FindAllIntersections called\n";
    exit(1);
    return 0;
}

Vector3D
Aggregate::FindNormal(const Vector3D& x)
{
    cerr << "Error: Aggregate::FindNormal called\n";
    exit(1);
    return 0;
}

void
Aggregate::ApplyTransform(const Matrix& tform)
{
    list.TransformList(tform);
}

void
Aggregate::TransformSurface(SurfaceList& clist, const Matrix& tform)
{
    for (ObjectList::Iterator sc(list); sc.Valid(); sc.GotoNext())
	sc.Contents()->TransformSurface(clist, tform);
}

Object3D *
Aggregate::Dup() const
{
    return new Aggregate(list);
}

float
Aggregate::PtDistance(Vector3D& x)
{
    cerr << "Error: Aggregate::PtDistance called\n";
    exit(1);
    return 0;
}

void
Aggregate::Describe(int ind) const
{
    indent(ind);
    cout << "Aggregate object:\n";
    for (ObjectList::Iterator sc(list); sc.Valid(); sc.GotoNext())
	sc.Contents()->Describe(ind + 2);
}

AxisAlignedBox
Aggregate::BBox() const
{
    cerr << "Error: Aggregate::BBox() called\n";
    exit(0);
    return AxisAlignedBox(Vector3D(0), Vector3D(0));
}

void
Aggregate::AddObject(Object3D *newobj)
{
    list.AddToList(newobj);
}

void
Aggregate::AddObject(const Object3D& newobj)
{
    list.AddToList(newobj.Dup());
}

void
Aggregate::CountMe() const
{
    cerr << "Error: Aggregate::CountMe called\n";
    exit(0);
}

void
Aggregate::NewSurface(Surface *newsurf)
{
    for (ObjectList::Iterator sc(list); sc.Valid(); sc.GotoNext())
	sc.Contents()->OverrideColor(newsurf);
}
