; **********************************************************
; bboxa.asm
;	386-specific assembler for bounding box intersection.
; Copyright (C) 1993 by Nicholas Wilt.	All rights reserved.
; **********************************************************

.MODEL	LARGE,C

.386

.CODE

; Given the min and max vectors for an axis-aligned bounding
; box, and the direction and location of a ray, compute the
; two intersections of the ray with the bounding box.
; If the ray misses the bounding box, the function returns 0.
; Otherwise the function returns 1 and the two parameters
; of intersection are written to tmin and tmax.

; int bboxint(Vector *min, Vector *max,
;	      Vector *dir, Vector *loc,
;	      float *tmin, float *tmax);

	PUBLIC	bboxint

LARGENUM	DD	100000.0

bboxint PROC	USES DS SI DI
ARG	MINMAX:DWORD,LOCDIR:DWORD,TMIN:DWORD,TMAX:DWORD
	lds	si,MINMAX	; DS:SI <- min
	les	di,LOCDIR	; ES:DI <- max
	mov	cx,3		; Three times we do this
@@Do3:	fld	dword ptr es:[di+12] ; Get dir element
	fld	st		; dir.x dir.x
	fabs			; abs(dir.x) dir.x
	ftst			; Compare abs to zero
	fstsw	ax		;
	fstp	st		; dir.x
	sahf			;
	jne	@@NotZero	; dir.x not zero
	fstp	st		; Clear dir.x from stack
	fld	dword ptr es:[di]
	fcom	dword ptr [si] ; Compare to min.x
	fstsw	ax		;
	sahf			;
	jb	@@NoInt 	; Hope still alive for -MAX to MAX
	fcomp	dword ptr [si+12] ; Compare to max.x
	fstsw	ax		;
	sahf			;
	ja	@@LoopRet0	;
	fld	LARGENUM	; Load maxt (LARGENUM)
	fld	st		;
	fchs			; Load mint (-LARGENUM)
	fxch			; Exchange them so max is TOS
	jmp	short @@Loop3
@@NoInt:
	fstp	st		; Clear TOS
@@LoopRet0:
	xor	ax,ax		; Return zero.
	sub	cx,3		; Subtract cx from 3
	neg	cx		;
	and	cx,3		;
	shl	cx,1		;
	jz	@@Done		; Jump if stack already clear
@@ClearStack:
	fstp	st		; Clear stack
	loop	@@ClearStack	;   (loop until done)
@@Done: jmp	@@Return	; Long jump to return
@@NotZero:			; dir.x on TOS
	fld	dword ptr [si+12] ; max.x dir.x
	fsub	dword ptr es:[di] ; (max.x - loc.x) dir.x
	fdiv	st,st(1)	; t2 dir.x
	fld	dword ptr [si]	; min.x t2 dir.x
	fsub	dword ptr es:[di] ; (min.x - loc.x) (max.x - loc.x) dir.x
	fdivrp	st(2),st	; t1 t2
	fcom	st(1)		; If ST < ST(1), swap
	fstsw	ax		;
	sahf			;
	ja	@@Max		; Jump if greater
	fxch			; ST <- max(ST, ST(1))
@@Max:	ftst			; If max is less than zero, no intersection.
	fstsw	ax		;
	sahf			;
	jae	@@Loop3 	;
	dec	cx		;
	jmp	short @@LoopRet0
@@Loop3:
	add	si,4		; Increment pointers properly
	add	di,4		;
	add	bx,4		;
	add	dx,4		;
	dec	cx		; Loop until done
	jnz	@@Do3		;
; At this point the coprocessor stack has six max/min pairs.
; ST(0) max.z
; ST(1) min.z
; ST(2) max.y
; ST(3) min.y
; ST(4) max.x
; ST(5) min.x
	; Find min of max's and max of min's.
	fcom	st(2)		; Compare max.z to max.y
	fstsw	ax		;
	sahf			;
	jb	@@MaxZMaxY	;
	fxch	st(2)		;
@@MaxZMaxY:
	fcom	st(4)		; Compare min(max.z, max.y) to max.x
	fstsw	ax		;
	sahf			;
	jb	@@MaxMaxX	;
	fxch	st(4)		;
@@MaxMaxX:			; ST is now min(min(max.z, max.y), max.x)
	fxch			; ST is now min.z
	fcom	st(3)		; Compare min.z to min.y
	fstsw	ax		;
	sahf			;
	ja	@@MinZMinY	;
	fxch	st(3)		;
@@MinZMinY:
	fcom	st(5)		; Compare max(min.z, min.y) to min.x
	fstsw	ax		;
	sahf			;
	ja	@@MinMinX	;
	fxch	st(5)		;
@@MinMinX:			; ST now max of mins, ST(1) min of max's
	fxch	st(5)		; ST(5) is now max of mins
	fxch			; ST now min of maxs
	fxch	st(4)		; ST(4) now min of maxs
	fstp	st		; Clear coprocessor stack
	fstp	st		;
	fstp	st		;
	fstp	st		;
	lds	si,TMAX 	; Pass back tmin
	fstp	dword ptr [si]	;
	lds	si,TMIN 	;
	fstp	dword ptr [si]	;
	mov	ax,1		;
@@Return:
	ret
bboxint ENDP

	END
