// ===================================================================
// surfs.cpp
//	Functions to creates different types of surface.
//
//	     The Object-Oriented Ray Tracer (OORT)
//            Copyright (C) 1993 by Nicholas Wilt.
//
// This software product may be freely copied and distributed in
// unmodified form but may not be sold.  A nominal distribution
// fee may be charged for media and handling by freeware and
// shareware distributors.  The software product may not be
// included in whole or in part into any commercial package
// without the express written consent of the author.
// 
// This software product is provided as is without warranty of
// any kind, express or implied, including but not limited to
// the implied warranties of merchantability and fitness for a
// particular purpose.  The author assumes no liability for any
// alleged or actual damages arising from the use of this
// software.  The author is under no obligation to provide 
// service, corrections or upgrades to the software.
//
// ------------------------------------------------------------
//
// Please contact me with questions, comments, suggestions or
// other input about OORT.  My Compuserve account number is
// [75210,2455] (Internet sites can reach me at 
// 75210.2455@compuserve.com).
//					--Nicholas Wilt
// ===================================================================

#include "oort.h"
#include "utils.h"

Surface *
MakeClear()
{
    HallSurface *ret = new HallSurface;
    ret->SetTransmit(new PureColor(RGBColor(1)), 1);
    return ret;
}

Surface *
MakeShiny(Texture *ambient, Texture *diffuse, Texture *specular, float specularity)
{
    HallSurface *ret = new HallSurface;

    if (! ambient)
	ambient = new PureColor(RGBColor(0.3));
    if (! diffuse)
	diffuse = new PureColor(RGBColor(0.7));
    if (! specular) {
	specular = new PureColor(RGBColor(1));
	specularity = 20;
    }
    ret->SetAmbient(ambient);
    ret->SetDiffuse(diffuse);
    ret->SetSpecular(specular, specularity);
    return ret;
}

Surface *
MakeReflective(Texture *reflect)
{
    HallSurface *ret = new HallSurface;
    if (! reflect)
	reflect = new PureColor(1);
    ret->SetReflect(reflect);
    return ret;
}

Surface *
MakeGlass(Texture *transmit, Texture *reflect, Texture *specular, 
      float specularity, Texture *diffuse)
{
    HallSurface *ret = new HallSurface;
    if (! transmit)
	transmit = new PureColor(RGBColor(0.8));
    if (! reflect)
	reflect = new PureColor(RGBColor(0.2));
    if (! specular) {
	specular = new PureColor(RGBColor(0.6));
	specularity = 100;
    }
    if (! diffuse)
	diffuse = new PureColor(RGBColor(0.08));
    ret->SetDiffuse(diffuse);
    ret->SetSpecular(specular, specularity);
    ret->SetReflect(reflect);
    ret->SetTransmit(transmit, 1.3);
    return ret;
}

Surface *
MakeGranite(const Matrix& reference, const RGBColor& Ka, const RGBColor& Kd)
{
    HallSurface *ret = new HallSurface;
    ret->SetAmbient(new Granite(Ka, reference));
    ret->SetDiffuse(new Granite(Kd, reference));
    return ret;
}

