#include <stdlib.h>
#include <iostream.h>
#include "hist.h"
#include "lsearch.h"
#include "colorbox.h"

ColorBox::ColorBox()
{
}

ColorBox::ColorBox(ColorVector& NewMin, ColorVector& NewMax, Histogram *NewHist)
{
  min = NewMin;
  max = NewMax;
  repr = repg = repb = avg_by = 0L;
  volume = (long) (max.r - min.r) *
	   (long) (max.g - min.g) *
	   (long) (max.b - min.b);
  hist = NewHist;
  Shrink();
  if (min.r >= max.r || min.g >= max.g || min.b >= max.b) {
    cerr << "Fatal error: instantiated invalid ColorBox\n";
    exit(-1);
  }
  CountMembers();
  if (! num_members) {
    cerr << "Fatal error: instantiated invalid ColorBox\n";
    exit(-1);
  }
}

void ColorBox::Shrink()
{
  ColorVector newmin = max;
  ColorVector newmax = min;
  int i, j, k;

  for (i = min.r; i < max.r; i++)
    for (j = min.g; j < max.g; j++)
      for (k = min.b; k < max.b; k++) {
	if (hist->GetElement(i, j, k)) {
	  if (i < newmin.r)
	    newmin.r = i;
	  if (i > newmax.r)
	    newmax.r = i;
	  if (j < newmin.g)
	    newmin.g = j;
	  if (j > newmax.g)
	    newmax.g = j;
	  if (k < newmin.b)
	    newmin.b = k;
	  if (k > newmax.b)
	    newmax.b = k;
	}
      }
  newmax.r++;
  newmax.g++;
  newmax.b++;
  min = newmin;
  max = newmax;
  volume = (long) (max.r - min.r) *
	   (long) (max.g - min.g) *
	   (long) (max.b - min.b);
}

void ColorBox::CountMembers()
{
  int i, j, k;
  long subt = 0L;

  for (i = min.r; i < max.r; i++)
    for (j = min.g; j < max.g; j++)
      for (k = min.b; k < max.b; k++)
	subt += hist->GetElement(i, j, k);
  num_members = subt;
}

int
ColorBox::Split(ColorBox **new1, ColorBox **new2)
{
  int maxaxis, maxlen;
  int i, j, k;
  long half = 0L;
  ColorVector newmin = min, newmax = max;
  ColorBox *first, *second;

  if (volume == 1)
    return -1;
  maxlen = max.r - min.r;
  maxaxis = 0;
  if ( (max.g - min.g) > maxlen) {
    maxlen = max.g - min.g;
    maxaxis = 1;
  }
  if ( (max.b - min.b) > maxlen) {
    maxlen = max.b - min.b;
    maxaxis = 2;
  }
  switch (maxaxis) {
    case 0:	// red
      for (i = min.r; i < (max.r - 1); i++) {
	for (j = min.g; j < max.g; j++)
	  for (k = min.b; k < max.b; k++)
	    half += hist->GetElement(i, j, k);
	if (half > (num_members >> 1))
	  break;
      }
      if (half <= (num_members >> 1))
	i = max.r - 2;
      newmax.r = i+1;
      *new1 = new ColorBox(newmin, newmax, hist);
      newmax.r = max.r;
      newmin.r = i+1;
      *new2 = new ColorBox(newmin, newmax, hist);
      break;
    case 1:
      for (j = min.g; j < (max.g - 1); j++) {
	for (i = min.r; i < max.r; i++)
	  for (k = min.b; k < max.b; k++)
	    half += hist->GetElement(i, j, k);
	if (half > (num_members >> 1))
	  break;
      }
      if (half <= (num_members >> 1))
	j = max.g - 2;
      newmax.g = j+1;
      *new1 = new ColorBox(newmin, newmax, hist);
      newmax.g = max.g;
      newmin.g = j+1;
      *new2 = new ColorBox(newmin, newmax, hist);
      break;
    case 2:
      for (k = min.b; k < (max.b - 1); k++) {
	for (i = min.r; i < max.r; i++)
	  for (j = min.g; j < max.g; j++)
	    half += hist->GetElement(i, j, k);
	if (half > (num_members >> 1))
	  break;
      }
      if (half <= (num_members >> 1))
	k = max.b - 2;
      newmax.b = k+1;
      *new1 = new ColorBox(newmin, newmax, hist);
      newmax.b = max.b;
      newmin.b = k+1;
      *new2 = new ColorBox(newmin, newmax, hist);
      break;
  }
  return 0;
}

int
ColorBox::IsInside(int r, int g, int b)
{
  r >>= 3;	// 8-bit colors to 5-bit colors
  g >>= 3;
  b >>= 3;
  if (r < min.r || r >= max.r ||
      g < min.g || g >= max.g ||
      b < min.b || b >= max.b)
    return 0;
  return 1;
}

int
comp_cboxes(void *a, void *b)
{
  long comp = ((ColorBox *) b)->num_members -
	      ((ColorBox *) a)->num_members;
  if (comp < 0)
    return(-1);
  else if (comp > 0)
    return(1);
  else
    return(0);
}
